/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.syncml.client;

import com.funambol.syncml.protocol.SyncFilter;
import com.funambol.syncml.spds.SourceConfig;
import com.funambol.syncml.spds.SyncException;
import com.funambol.syncml.spds.SyncItem;
import com.funambol.syncml.spds.SyncSource;
import com.funambol.util.Log;
import com.funambol.util.SyncListener;

public abstract class BaseSyncSource
implements SyncSource {
    protected SourceConfig config;
    protected SyncFilter filter;
    protected int syncMode;
    protected SyncItem[] allItems;
    protected SyncItem[] newItems;
    protected SyncItem[] updItems;
    protected SyncItem[] delItems;
    protected int allIndex;
    protected int newIndex;
    protected int updIndex;
    protected int delIndex;
    private int clientItemsNumber;
    private int serverItemsNumber;
    private int clientAddItemsNumber;
    private int clientReplaceItemsNumber;
    private int clientDeleteItemsNumber;
    protected int globalStatus;
    private SyncListener listener;

    public BaseSyncSource(SourceConfig sourceConfig) {
        this.config = sourceConfig;
        this.syncMode = 0;
        this.allItems = null;
        this.newItems = null;
        this.updItems = null;
        this.delItems = null;
        this.delIndex = 0;
        this.updIndex = 0;
        this.newIndex = 0;
        this.allIndex = 0;
        this.serverItemsNumber = -1;
        this.clientItemsNumber = -1;
        this.clientAddItemsNumber = -1;
        this.clientReplaceItemsNumber = -1;
        this.clientDeleteItemsNumber = -1;
        this.filter = null;
    }

    public SourceConfig getConfig() {
        return this.config;
    }

    public void setConfig(SourceConfig sourceConfig) {
        this.config = sourceConfig;
    }

    public String getName() {
        return this.config.getName();
    }

    public String getSourceUri() {
        return this.config.getRemoteUri();
    }

    public String getType() {
        return this.config.getType();
    }

    public String getEncoding() {
        return this.config.getEncoding();
    }

    public int getSyncMode() {
        return this.config.getSyncMode();
    }

    public SyncFilter getFilter() {
        return this.filter;
    }

    public void setFilter(SyncFilter syncFilter) {
        this.filter = syncFilter;
    }

    public abstract int addItem(SyncItem var1) throws SyncException;

    public abstract int updateItem(SyncItem var1) throws SyncException;

    public abstract int deleteItem(String var1) throws SyncException;

    public SyncItem getNextItem() throws SyncException {
        if (this.allItems == null) {
            Log.info("Source " + this.getName() + ": no items to send for slow sync");
            return null;
        }
        if (this.allIndex < this.allItems.length) {
            Log.info("Source " + this.getName() + ": sending item " + this.allItems[this.allIndex].getKey());
            return this.getItemContent(this.allItems[this.allIndex++]);
        }
        Log.info("Source " + this.getName() + ": no more items to send for slow sync");
        this.allItems = null;
        this.allIndex = 0;
        return null;
    }

    public SyncItem getNextNewItem() throws SyncException {
        if (this.newItems == null) {
            Log.info("Source " + this.getName() + ": no new items to send");
            return null;
        }
        if (this.newIndex < this.newItems.length) {
            Log.info("Source " + this.getName() + ": sending item " + this.newItems[this.newIndex].getKey());
            return this.getItemContent(this.newItems[this.newIndex++]);
        }
        Log.info("Source " + this.getName() + ": no more new items to send");
        this.newItems = null;
        this.newIndex = 0;
        return null;
    }

    public SyncItem getNextUpdatedItem() throws SyncException {
        if (this.updItems == null) {
            Log.info("Source " + this.getName() + ": no updated items to send");
            return null;
        }
        if (this.updIndex < this.updItems.length) {
            Log.info("Source " + this.getName() + ": sending item " + this.updItems[this.updIndex].getKey());
            return this.getItemContent(this.updItems[this.updIndex++]);
        }
        Log.info("Source " + this.getName() + ": no more updated items to send");
        this.updItems = null;
        this.updIndex = 0;
        return null;
    }

    public SyncItem getNextDeletedItem() throws SyncException {
        if (this.delItems == null) {
            Log.info("Source " + this.getName() + ": no deleted items to send");
            return null;
        }
        if (this.delIndex < this.delItems.length) {
            Log.info("Source " + this.getName() + ": sending item " + this.delItems[this.delIndex].getKey());
            return this.delItems[this.delIndex++];
        }
        Log.info("Source " + this.getName() + ": no more deletetd items to send");
        this.delItems = null;
        this.delIndex = 0;
        return null;
    }

    public void setItemStatus(String string, int n) throws SyncException {
        Log.info("Status " + n + "for item " + string + "from server.");
    }

    public int getClientItemsNumber() {
        return this.clientItemsNumber;
    }

    public int getClientAddNumber() {
        return this.clientAddItemsNumber;
    }

    public int getClientReplaceNumber() {
        return this.clientReplaceItemsNumber;
    }

    public int getClientDeleteNumber() {
        return this.clientDeleteItemsNumber;
    }

    public int getServerItemsNumber() {
        return this.serverItemsNumber;
    }

    public void setServerItemsNumber(int n) {
        this.serverItemsNumber = n;
    }

    public void dataReceived(String string, int n) {
        Log.info("Received " + n + "bytes.");
    }

    public long getLastAnchor() {
        return this.config.getLastAnchor();
    }

    public void setLastAnchor(long l) {
        this.config.setLastAnchor(l);
    }

    public long getNextAnchor() {
        return this.config.getNextAnchor();
    }

    public void setNextAnchor(long l) {
        this.config.setNextAnchor(l);
    }

    public void beginSync(int n) throws SyncException {
        Log.info("Begin sync for source '" + this.getName() + "' with mode " + n);
        switch (n) {
            case 201: 
            case 203: {
                this.initAllItems();
                this.allIndex = 0;
                this.clientItemsNumber = this.allItems != null ? this.allItems.length : 0;
                this.clientAddItemsNumber = this.newItems != null ? this.newItems.length : 0;
                this.clientReplaceItemsNumber = this.updItems != null ? this.updItems.length : 0;
                this.clientDeleteItemsNumber = this.delItems != null ? this.delItems.length : 0;
                break;
            }
            case 200: 
            case 202: {
                this.initNewItems();
                this.initUpdItems();
                this.initDelItems();
                this.delIndex = 0;
                this.updIndex = 0;
                this.newIndex = 0;
                this.clientAddItemsNumber = this.newItems != null ? this.newItems.length : 0;
                this.clientReplaceItemsNumber = this.updItems != null ? this.updItems.length : 0;
                this.clientDeleteItemsNumber = this.delItems != null ? this.delItems.length : 0;
                this.clientItemsNumber = this.clientAddItemsNumber + this.clientReplaceItemsNumber + this.clientDeleteItemsNumber;
                break;
            }
            case 204: {
                this.newItems = null;
                this.updItems = null;
                this.delItems = null;
                this.delIndex = 0;
                this.updIndex = 0;
                this.newIndex = 0;
                this.clientItemsNumber = 0;
                this.clientAddItemsNumber = 0;
                this.clientReplaceItemsNumber = 0;
                this.clientDeleteItemsNumber = 0;
                break;
            }
            case 205: {
                this.newItems = null;
                this.updItems = null;
                this.delItems = null;
                this.delIndex = 0;
                this.updIndex = 0;
                this.newIndex = 0;
                this.clientItemsNumber = 0;
                this.clientAddItemsNumber = 0;
                this.clientReplaceItemsNumber = 0;
                this.clientDeleteItemsNumber = 0;
                break;
            }
            default: {
                throw new SyncException(500, "SyncSource " + this.getName() + ": invalid sync mode " + this.getSyncMode());
            }
        }
        this.syncMode = n;
    }

    public void endSync() throws SyncException {
        Log.info("End sync for source " + this.getName());
        this.delItems = null;
        this.updItems = null;
        this.newItems = null;
        this.allItems = null;
        this.delIndex = 0;
        this.updIndex = 0;
        this.newIndex = 0;
        this.allIndex = 0;
    }

    public void setListener(SyncListener syncListener) {
        this.listener = syncListener;
    }

    public SyncListener getListener() {
        return this.listener;
    }

    public int getStatus() {
        return this.globalStatus;
    }

    protected abstract void initAllItems() throws SyncException;

    protected abstract void initNewItems() throws SyncException;

    protected abstract void initUpdItems() throws SyncException;

    protected abstract void initDelItems() throws SyncException;

    protected abstract SyncItem getItemContent(SyncItem var1) throws SyncException;
}

