/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.syncml.protocol;

import com.funambol.util.ChunkedString;
import com.funambol.util.Log;
import com.funambol.util.XmlException;
import com.funambol.util.XmlUtil;
import java.util.Vector;

public class SyncMLStatus {
    public static final int SUCCESS = 200;
    public static final int ITEM_ADDED = 201;
    public static final int CONFLICT_MERGED = 207;
    public static final int CONFLICT_BY_CLIENT = 208;
    public static final int CONFLICT_DUPLICATED = 209;
    public static final int DELETED_WITHOUT_ARCHIVE = 210;
    public static final int ITEM_NOT_DELETED = 211;
    public static final int AUTHENTICATION_ACCEPTED = 212;
    public static final int INVALID_CREDENTIALS = 401;
    public static final int FORBIDDEN = 403;
    public static final int NOT_FOUND = 404;
    public static final int MISSING_CREDENTIALS = 407;
    public static final int CONFLICTED = 409;
    public static final int RETRY_LATER = 417;
    public static final int ALREADY_EXISTS = 418;
    public static final int CONFLICT_BY_SERVER = 419;
    public static final int GENERIC_ERROR = 500;
    public static final int SERVER_BUSY = 503;
    public static final int PROCESSING_ERROR = 506;
    public static final int REFRESH_REQUIRED = 508;
    public static final int BACKEND_AUTH_ERROR = 511;
    private String cmdId;
    private String msgRef;
    private String cmdRef;
    private String cmd;
    private String srcRef;
    private String tgtRef;
    private String[] items;
    private String challenge = null;
    private int status;
    private ChunkedString statusDataMessage;

    public SyncMLStatus() {
        this("", "", "", "", null, null, 200);
    }

    public SyncMLStatus(String string, String string2, String string3, String string4, String string5, String string6, int n) {
        this.setCmdId(string);
        this.setMsgRef(this.msgRef);
        this.setCmdRef(string3);
        this.setCmd(string4);
        this.setSrcRef(string5);
        this.setTgtRef(string6);
        this.items = null;
        this.status = n;
    }

    public SyncMLStatus(String string, String string2, String string3, String string4, String[] stringArray, int n) {
        this.setCmdId(string);
        this.setMsgRef(this.msgRef);
        this.setCmdRef(string3);
        this.setCmd(string4);
        this.srcRef = null;
        this.tgtRef = null;
        this.items = stringArray;
        this.status = n;
    }

    public String getCmdId() {
        return this.cmdId;
    }

    public void setCmdId(String string) {
        this.cmdId = string != null ? string : null;
    }

    public String getMsgRef() {
        return this.msgRef;
    }

    public void setMsgRef(String string) {
        this.msgRef = string != null ? string : null;
    }

    public String getCmdRef() {
        return this.cmdRef;
    }

    public void setCmdRef(String string) {
        this.cmdRef = string != null ? string : null;
    }

    public String getCmd() {
        return this.cmd;
    }

    public void setCmd(String string) {
        this.cmd = this.cmdRef != null ? string : null;
    }

    public void setChallenge(String string) {
        this.challenge = string;
    }

    public String getSrcRef() {
        return this.srcRef;
    }

    public void setSrcRef(String string) {
        this.srcRef = string != null ? new String(string) : null;
    }

    public String getTgtRef() {
        return this.tgtRef;
    }

    public void setTgtRef(String string) {
        this.tgtRef = string != null ? string : null;
    }

    public String getRef() {
        return this.tgtRef != null ? this.tgtRef : this.srcRef;
    }

    public String[] getItemKeys() {
        return this.items;
    }

    public void setItemKeys(String[] stringArray) {
        this.items = stringArray;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int n) {
        this.status = n;
    }

    public String getChallenge() {
        return this.challenge;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("<Status>");
        stringBuffer.append("<CmdID>").append(this.cmdId).append("</CmdID>\n").append("<MsgRef>").append(this.msgRef).append("</MsgRef>\n").append("<CmdRef>").append(this.cmdRef).append("</CmdRef>\n").append("<Cmd>").append(this.cmd).append("</Cmd>\n");
        if (this.srcRef != null) {
            stringBuffer.append("<SourceRef>").append(this.srcRef).append("</SourceRef>\n");
        }
        if (this.tgtRef != null) {
            stringBuffer.append("<TargetRef>").append(this.tgtRef).append("</TargetRef>\n");
        }
        if (this.items != null) {
            int n = this.items.length;
            for (int i = 0; i < n; ++i) {
                stringBuffer.append("<Item><Source><LocURI>").append(this.items[i]).append("</LogURI></Source></Item>");
            }
        }
        stringBuffer.append("<Data>").append(this.status).append("</Data>\n").append("</Status>\n");
        return stringBuffer.toString();
    }

    public static SyncMLStatus parse(ChunkedString chunkedString) {
        String string = null;
        try {
            int n;
            Object object;
            Vector<String> vector = new Vector<String>();
            SyncMLStatus syncMLStatus = new SyncMLStatus();
            syncMLStatus.setCmdId(XmlUtil.getTagValue(chunkedString, "CmdID").toString());
            syncMLStatus.setMsgRef(XmlUtil.getTagValue(chunkedString, "MsgRef").toString());
            syncMLStatus.setCmdRef(XmlUtil.getTagValue(chunkedString, "CmdRef").toString());
            syncMLStatus.setCmd(XmlUtil.getTagValue(chunkedString, "Cmd").toString());
            if (XmlUtil.getTag(chunkedString, "Chal") != -1) {
                syncMLStatus.setChallenge(XmlUtil.getTagValue(chunkedString, "Chal").toString());
            }
            if (XmlUtil.getTag(chunkedString, "TargetRef") != -1) {
                string = XmlUtil.getTagValue(chunkedString, "TargetRef").toString();
                syncMLStatus.setTgtRef(string);
            }
            if (XmlUtil.getTag(chunkedString, "SourceRef") != -1) {
                string = XmlUtil.getTagValue(chunkedString, "SourceRef").toString();
                syncMLStatus.setSrcRef(string);
            }
            if (XmlUtil.getTag(chunkedString, "Item") != -1) {
                object = XmlUtil.getTagValues(chunkedString, "Item");
                n = ((Vector)object).size();
                for (int i = 0; i < n; ++i) {
                    ChunkedString chunkedString2 = (ChunkedString)((Vector)object).elementAt(i);
                    if (XmlUtil.getTag(chunkedString2, "LocURI") != -1) {
                        string = XmlUtil.getTagValue(chunkedString2, "LocURI").toString();
                        vector.addElement(string);
                    }
                    if (XmlUtil.getTag(chunkedString2, "Data") == -1) continue;
                    syncMLStatus.setStatusDataMessage(XmlUtil.getTagValue(chunkedString2, "Data"));
                }
            }
            object = XmlUtil.getTagValue(chunkedString, "Data").toString();
            syncMLStatus.setStatus(Integer.parseInt((String)object));
            n = vector.size();
            if (n > 0) {
                String[] stringArray = new String[n];
                for (int i = 0; i < n; ++i) {
                    stringArray[i] = (String)vector.elementAt(i);
                }
                syncMLStatus.setItemKeys(stringArray);
            }
            return syncMLStatus;
        }
        catch (XmlException xmlException) {
            xmlException.printStackTrace();
            Log.error("[status.parse] Error parsing server status " + chunkedString);
            return null;
        }
    }

    public boolean isSuccess() {
        return this.status >= 200 && this.status < 300;
    }

    public static boolean isSuccess(int n) {
        return n >= 200 && n < 300;
    }

    public void setStatusDataMessage(ChunkedString chunkedString) {
        this.statusDataMessage = chunkedString;
    }

    public String getStatusDataMessage() {
        if (this.statusDataMessage == null) {
            return "";
        }
        return this.statusDataMessage.toString();
    }
}

