/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.syncml.spds;

import com.funambol.storage.AbstractRecordStore;
import com.funambol.storage.ObjectStore;
import com.funambol.syncml.spds.ItemMap;
import com.funambol.util.Log;
import java.util.Hashtable;
import javax.microedition.rms.RecordStoreException;

public class MappingManager {
    private static final String MAPPING_STORE = "SyncMLMappingStore";
    private ObjectStore ms = new ObjectStore();

    public Hashtable getMappings(String string) {
        ItemMap itemMap = new ItemMap();
        try {
            this.openMappingStore();
            for (int i = 1; i <= this.ms.size(); ++i) {
                itemMap = (ItemMap)this.ms.retrieve(i, new ItemMap());
                if (!itemMap.getSourceName().equals(string)) continue;
                Log.debug("[getMappings]Item Map Found");
                break;
            }
            this.ms.close();
            return itemMap.getMappings();
        }
        catch (Exception exception) {
            Log.error("[getMappings]Exception catched reading the mapping stores" + exception);
            Log.debug("[getMappings]ItemMap not found");
            return itemMap.getMappings();
        }
    }

    public void saveMappings(String string, Hashtable hashtable) {
        ItemMap itemMap = new ItemMap(string, hashtable);
        try {
            boolean bl = false;
            this.openMappingStore();
            for (int i = 1; i <= this.ms.size(); ++i) {
                ItemMap itemMap2 = (ItemMap)this.ms.retrieve(i, new ItemMap());
                if (!itemMap2.getSourceName().equals(itemMap.getSourceName())) continue;
                Log.debug("[saveMappings]Item map: " + itemMap2.getSourceName());
                Log.debug("[saveMappings]Required source: " + string);
                this.ms.store(i, itemMap);
                Log.debug("[saveMappings]Item map updated for source: " + itemMap2.getSourceName());
                bl = true;
                break;
            }
            if (!bl) {
                this.ms.store(itemMap);
                Log.debug("[saveMappings]New Item map stored for source: " + itemMap.getSourceName());
            }
            this.ms.close();
            itemMap = null;
        }
        catch (Exception exception) {
            Log.error("[saveMappings]Exception catched writing the mapping stores" + exception);
        }
    }

    public void resetMappings(String string) {
        this.saveMappings(string, new Hashtable());
    }

    private void openMappingStore() {
        if (this.ms == null) {
            this.ms = new ObjectStore();
        }
        if (this.isMappingStorageFound()) {
            try {
                Log.debug("[openMappingStore]Opening MApping storage");
                this.ms.open(MAPPING_STORE);
            }
            catch (RecordStoreException recordStoreException) {
                Log.error("[openMappingStore]Cannot open Mapping Storage" + (Object)((Object)recordStoreException));
            }
        } else {
            try {
                Log.debug("[openMappingStore]Creating Mapping storage");
                this.ms.create(MAPPING_STORE);
            }
            catch (RecordStoreException recordStoreException) {
                Log.error("[openMappingStore]Cannot create Mapping Storage" + (Object)((Object)recordStoreException));
            }
        }
    }

    private boolean isMappingStorageFound() {
        Log.debug("[isMappingStorageFound]Lookup for mapping RMS");
        String[] stringArray = AbstractRecordStore.listRecordStores();
        if (stringArray == null) {
            Log.debug("SyncMLMappingStore lookup gave an empty String[]");
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(MAPPING_STORE)) continue;
            Log.debug("[isMappingStorageFound]Mapping RMS Found");
            return true;
        }
        Log.debug("[isMappingStorageFound]Mapping RMS Not Found");
        return false;
    }
}

