/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.syncml.spds;

import com.funambol.syncml.spds.CmdId;
import com.funambol.syncml.spds.SyncException;
import com.funambol.syncml.spds.SyncItem;
import com.funambol.syncml.spds.SyncSource;
import com.funambol.util.Base64;
import com.funambol.util.Log;
import com.funambol.util.StringUtil;
import com.funambol.util.SyncListener;
import com.funambol.util.XmlUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class SyncSourceLOHandler {
    private SyncSource source;
    private int maxMsgSize;
    private SyncItem nextAddItem = null;
    private SyncItem nextReplaceItem = null;
    private SyncItem nextDeleteItem = null;
    private SyncItem nextItem = null;
    private ByteArrayOutputStream os = null;
    private SyncItem lo = null;

    public SyncSourceLOHandler(SyncSource syncSource, int n) {
        this.source = syncSource;
        this.maxMsgSize = n;
    }

    public int addItem(SyncItem syncItem) throws SyncException {
        Log.trace("[SyncSourceLOHanlder.addItem] " + syncItem.getKey());
        if (this.source.getConfig().getSupportsLO()) {
            return this.source.addItem(syncItem);
        }
        if (syncItem.hasMoreData()) {
            if (this.os == null) {
                this.os = new ByteArrayOutputStream();
                this.lo = syncItem;
            }
            try {
                this.updateItemContent(syncItem);
            }
            catch (Exception exception) {
                Log.error("Cannot write LO buffer");
                throw new SyncException(400, "Cannot write LO buffer " + exception.toString());
            }
            return 200;
        }
        if (this.os != null) {
            try {
                this.updateItemContent(syncItem);
            }
            catch (Exception exception) {
                Log.error("Cannot write LO buffer");
                throw new SyncException(400, "Cannot write LO buffer " + exception.toString());
            }
            syncItem = new SyncItem(this.lo);
            byte[] byArray = this.os.toByteArray();
            if ("b64".equals(this.source.getEncoding())) {
                byArray = Base64.encode(byArray);
            }
            syncItem.setContent(byArray);
            try {
                this.os.close();
            }
            catch (IOException iOException) {
                Log.error("Error closing output stream " + iOException.toString());
            }
            this.os = null;
        }
        return this.source.addItem(syncItem);
    }

    public int updateItem(SyncItem syncItem) {
        Log.trace("[SyncSourceLOHanlder.updateItem] " + syncItem.getKey());
        if (this.source.getConfig().getSupportsLO()) {
            return this.source.updateItem(syncItem);
        }
        if (syncItem.hasMoreData()) {
            if (this.os == null) {
                this.os = new ByteArrayOutputStream();
                this.lo = syncItem;
            }
            try {
                this.updateItemContent(syncItem);
            }
            catch (Exception exception) {
                Log.error("Cannot write LO buffer");
                throw new SyncException(400, "Cannot write LO buffer " + exception.toString());
            }
            return 200;
        }
        if (this.os != null) {
            try {
                this.updateItemContent(syncItem);
            }
            catch (Exception exception) {
                Log.error("Cannot write LO buffer");
                throw new SyncException(400, "Cannot write LO buffer " + exception.toString());
            }
            syncItem = new SyncItem(this.lo);
            byte[] byArray = this.os.toByteArray();
            if ("b64".equals(this.source.getEncoding())) {
                byArray = Base64.encode(byArray);
            }
            syncItem.setContent(byArray);
            try {
                this.os.close();
            }
            catch (IOException iOException) {
                Log.error("Error closing output stream " + iOException.toString());
            }
            this.os = null;
        }
        return this.source.updateItem(syncItem);
    }

    public boolean getAddCommand(int n, SyncListener syncListener, StringBuffer stringBuffer, CmdId cmdId) throws SyncException {
        String string;
        Log.trace("SyncSourceHandler.getAddCommand]");
        SyncItem syncItem = null;
        if (this.nextAddItem == null) {
            syncItem = this.source.getNextNewItem();
            if (syncItem == null) {
                return true;
            }
        } else {
            syncItem = this.nextAddItem;
            this.nextAddItem = null;
        }
        if (n + (string = this.getItemTag(syncItem)).length() < this.maxMsgSize) {
            stringBuffer.append("<Add>\n").append("<CmdID>" + cmdId.next() + "</CmdID>\n");
        } else {
            stringBuffer.append("<Add>\n").append("<CmdID>" + cmdId.next() + "</CmdID>\n");
            Log.error(this.source.getName() + " returned an item that exceeds max msg size and should be dropped");
        }
        boolean bl = false;
        do {
            stringBuffer.append(string);
            syncListener.itemAddSent(syncItem);
            syncItem = this.source.getNextNewItem();
            if (syncItem == null) {
                bl = true;
                break;
            }
            string = this.getItemTag(syncItem);
        } while (n + stringBuffer.length() + string.length() < this.maxMsgSize);
        if (syncItem != null) {
            this.nextAddItem = syncItem;
        }
        stringBuffer.append("</Add>\n");
        return bl;
    }

    public boolean getReplaceCommand(int n, SyncListener syncListener, StringBuffer stringBuffer, CmdId cmdId) throws SyncException {
        String string;
        Log.trace("SyncSourceHandler.getReplaceCommand]");
        SyncItem syncItem = null;
        if (this.nextReplaceItem == null) {
            syncItem = this.source.getNextUpdatedItem();
            if (syncItem == null) {
                return true;
            }
        } else {
            syncItem = this.nextReplaceItem;
            this.nextReplaceItem = null;
        }
        if (n + (string = this.getItemTag(syncItem)).length() < this.maxMsgSize) {
            stringBuffer.append("<Replace>\n").append("<CmdID>").append(cmdId.next()).append("</CmdID>\n");
        } else {
            stringBuffer.append("<Replace>\n").append("<CmdID>").append(cmdId.next()).append("</CmdID>\n");
            Log.error(this.source.getName() + " returned an item that exceeds max msg size and should be dropped");
        }
        boolean bl = false;
        do {
            stringBuffer.append(string);
            syncListener.itemReplaceSent(syncItem);
            syncItem = this.source.getNextUpdatedItem();
            if (syncItem == null) {
                bl = true;
                break;
            }
            string = this.getItemTag(syncItem);
        } while (n + stringBuffer.length() + string.length() < this.maxMsgSize);
        if (syncItem != null) {
            this.nextReplaceItem = syncItem;
        }
        stringBuffer.append("</Replace>\n");
        return bl;
    }

    public boolean getDeleteCommand(int n, SyncListener syncListener, StringBuffer stringBuffer, CmdId cmdId) throws SyncException {
        String string;
        Log.trace("SyncSourceHandler.getDeleteCommand]");
        SyncItem syncItem = null;
        if (this.nextDeleteItem == null) {
            syncItem = this.source.getNextDeletedItem();
            if (syncItem == null) {
                return true;
            }
        } else {
            syncItem = this.nextDeleteItem;
            this.nextDeleteItem = null;
        }
        if (n + (string = this.getItemTag(syncItem)).length() < this.maxMsgSize) {
            stringBuffer.append("<Delete>\n").append("<CmdID>").append(cmdId.next()).append("</CmdID>\n");
        } else {
            stringBuffer.append("<Delete>\n").append("<CmdID>").append(cmdId.next()).append("</CmdID>\n");
            Log.error(this.source.getName() + " returned an item that exceeds max msg size and should be dropped");
        }
        boolean bl = false;
        do {
            stringBuffer.append(string);
            syncListener.itemDeleteSent(syncItem);
            syncItem = this.source.getNextDeletedItem();
            if (syncItem == null) {
                bl = true;
                break;
            }
            string = this.getItemTag(syncItem);
        } while (n + stringBuffer.length() + string.length() < this.maxMsgSize);
        if (syncItem != null) {
            this.nextDeleteItem = syncItem;
        }
        stringBuffer.append("</Delete>\n");
        return bl;
    }

    public boolean getNextCommand(int n, SyncListener syncListener, StringBuffer stringBuffer, CmdId cmdId) throws SyncException {
        String string;
        SyncItem syncItem = null;
        if (this.nextItem == null) {
            syncItem = this.source.getNextItem();
            if (syncItem == null) {
                return true;
            }
        } else {
            syncItem = this.nextItem;
            this.nextItem = null;
        }
        if (n + (string = this.getItemTag(syncItem)).length() < this.maxMsgSize) {
            stringBuffer.append("<Replace>\n").append("<CmdID>").append(cmdId.next()).append("</CmdID>\n");
        } else {
            stringBuffer.append("<Replace>\n").append("<CmdID>").append(cmdId.next()).append("</CmdID>\n");
            Log.error(this.source.getName() + " returned an item that exceeds max msg size and should be dropped");
        }
        boolean bl = false;
        do {
            stringBuffer.append(string);
            syncListener.itemReplaceSent(syncItem);
            syncItem = this.source.getNextItem();
            if (syncItem == null) {
                bl = true;
                break;
            }
            string = this.getItemTag(syncItem);
        } while (n + stringBuffer.length() + string.length() < this.maxMsgSize);
        if (syncItem != null) {
            this.nextItem = syncItem;
        }
        stringBuffer.append("</Replace>\n");
        return bl;
    }

    private byte[] encodeItemData(String[] stringArray, byte[] byArray) {
        if (stringArray != null && byArray != null) {
            for (int i = stringArray.length - 1; i >= 0; --i) {
                String string = stringArray[i];
                if (!string.equals("b64")) continue;
                byArray = Base64.encode(byArray);
            }
        }
        return byArray;
    }

    private String getFormat() {
        if (!this.source.getEncoding().equals("none")) {
            return "<Format xmlns='syncml:metinf'>" + this.source.getEncoding() + "</Format>\n";
        }
        return "";
    }

    private void updateItemContent(SyncItem syncItem) throws IOException {
        byte[] byArray = syncItem.getContent();
        if ("b64".equals(this.source.getEncoding())) {
            byArray = Base64.decode(byArray);
        }
        this.os.write(byArray);
    }

    private String getItemTag(SyncItem syncItem) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<Item>\n");
        switch (syncItem.getState()) {
            case 'D': {
                return stringBuffer.append("<Source><LocURI>").append(syncItem.getKey()).append("</LocURI></Source>\n").append("</Item>\n").toString();
            }
            case 'N': 
            case 'U': {
                Object object;
                Log.info("The encoding method is [" + this.source.getEncoding() + "]");
                String string = null;
                if (syncItem.getContent() == null) {
                    Log.error("Empty content from SyncSource for item:" + syncItem.getKey());
                    string = "";
                } else if (!this.source.getEncoding().equals("none")) {
                    object = StringUtil.split(this.source.getEncoding(), ";");
                    byte[] byArray = this.encodeItemData((String[])object, syncItem.getContent());
                    string = new String(byArray);
                } else {
                    object = new String(syncItem.getContent());
                    string = XmlUtil.escapeXml((String)object);
                }
                object = syncItem.getType() == null ? this.source.getType() : syncItem.getType();
                stringBuffer.append("<Meta><Type xmlns=\"syncml:metinf\">").append((String)object).append("</Type>").append(this.getFormat());
                long l = syncItem.getLODeclaredSize();
                if (l != -1L) {
                    stringBuffer.append("<Size>").append(l).append("</Size>");
                }
                stringBuffer.append("</Meta>\n");
                stringBuffer.append("<Source><LocURI>" + syncItem.getKey() + "</LocURI></Source>\n");
                if (syncItem.getParent() != null) {
                    stringBuffer.append("<SourceParent><LocURI>").append(syncItem.getParent()).append("</LocURI></SourceParent>\n");
                }
                stringBuffer.append("<Data>").append(string).append("</Data>\n");
                if (syncItem.hasMoreData()) {
                    stringBuffer.append("<MoreData/>\n");
                }
                stringBuffer.append("</Item>\n");
                return stringBuffer.toString();
            }
        }
        Log.error("[getItemTag] Invalid item state: " + syncItem.getState());
        return "";
    }
}

