/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.tools;

import com.funambol.storage.AbstractRecordStore;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStoreException;

public class ListRecordStores
extends MIDlet
implements CommandListener {
    private RecordStoreList list;
    private StoreContentList scl;

    protected void startApp() throws MIDletStateChangeException {
        this.list = new RecordStoreList();
        this.list.setCommandListener(this);
        this.scl = new StoreContentList("");
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.list);
    }

    protected void pauseApp() {
    }

    protected void destroyApp(boolean arg0) {
    }

    public void exitMIDlet() {
        Display.getDisplay((MIDlet)this).setCurrent(null);
        this.destroyApp(true);
        this.notifyDestroyed();
    }

    public void commandAction(Command c, Displayable arg1) {
        if (c == this.list.getExitCommand()) {
            this.exitMIDlet();
        } else if (c == this.list.getViewCommand()) {
            int index = this.list.getSelectedIndex();
            String storeName = this.list.getString(index);
            this.scl = new StoreContentList(storeName);
            this.scl.showStoreContent(storeName);
            this.scl.setCommandListener(this);
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.scl);
        } else if (c == this.scl.getBackCommand()) {
            this.scl = null;
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.list);
        }
    }

    class StoreContentList
    extends List {
        Command backCommand;

        public StoreContentList(String name) {
            super(name + " content:", 3);
            this.addCommand(this.getBackCommand());
        }

        public void showStoreContent(String name) {
            if (!name.equals("")) {
                try {
                    this.addCommand(this.getBackCommand());
                    System.out.println("Opening ar");
                    AbstractRecordStore ar = AbstractRecordStore.openRecordStore(name, false);
                    System.out.println("Getting re");
                    RecordEnumeration re = ar.enumerateRecords(null, null, true);
                    this.setTitle(name + " " + ar.getNumRecords());
                    int recordId = 0;
                    if (re == null) {
                        System.out.println("re is null");
                        return;
                    }
                    if (ar.getNumRecords() == 0) {
                        System.out.println("ar is empty");
                        return;
                    }
                    while (re != null && re.hasNextElement()) {
                        recordId = re.nextRecordId();
                        byte[] record = ar.getRecord(recordId);
                        if (record != null) {
                            ListRecordStores.this.scl.append("ID: " + recordId + " Length: " + record.length, null);
                            continue;
                        }
                        ListRecordStores.this.scl.append("ID: " + recordId + " Null Record", null);
                    }
                    System.out.println("Closing ar");
                    ar.closeRecordStore();
                }
                catch (RecordStoreException ex) {
                    ex.printStackTrace();
                }
            }
        }

        public Command getBackCommand() {
            if (this.backCommand == null) {
                this.backCommand = new Command("Back", 2, 0);
            }
            return this.backCommand;
        }
    }

    class RecordStoreList
    extends List {
        Command exitCommand;
        Command viewCommand;

        public RecordStoreList() {
            super("Stores", 3);
            String[] store = this.getStoreNames();
            for (int i = 0; i < store.length; ++i) {
                this.append(store[i], null);
            }
            this.addCommand(this.getExitCommand());
            this.addCommand(this.getViewCommand());
        }

        public Command getExitCommand() {
            if (this.exitCommand == null) {
                this.exitCommand = new Command("Exit", 7, 0);
            }
            return this.exitCommand;
        }

        private String[] getStoreNames() {
            return AbstractRecordStore.listRecordStores();
        }

        public Command getViewCommand() {
            if (this.viewCommand == null) {
                this.viewCommand = new Command("View", 8, 0);
            }
            return this.viewCommand;
        }
    }
}

