/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.util;

import java.util.Vector;

public class ChunkedString {
    private final String buf;
    private int start;
    private int end;

    public ChunkedString(String s) {
        this.buf = s;
        this.start = 0;
        this.end = s.length();
    }

    public ChunkedString(String s, int a, int b) throws IndexOutOfBoundsException {
        this.buf = s;
        this.start = a;
        this.end = b;
        this.checkIndexes();
    }

    public ChunkedString(ChunkedString cs, int a, int b) {
        this.buf = cs.buf;
        this.start = cs.start + a;
        this.end = cs.start + b;
    }

    public ChunkedString(ChunkedString cs) {
        this.buf = cs.buf;
        this.start = cs.start;
        this.end = cs.end;
    }

    public String getNextString(String sep) {
        if (this.isEmpty()) {
            return null;
        }
        String ret = null;
        int idx = this.buf.indexOf(sep, this.start);
        if (idx == -1 || idx > this.end) {
            ret = this.buf.substring(this.start, this.end);
            this.start = this.end;
        } else {
            ret = this.buf.substring(this.start, idx);
            this.start = idx + sep.length();
        }
        return ret;
    }

    public String getNextString(String[] sep) {
        if (this.isEmpty()) {
            return null;
        }
        int idx = this.end;
        int sepLen = sep[0].length();
        int l = sep.length;
        for (int i = 0; i < l; ++i) {
            int localIdx = this.buf.indexOf(sep[i], this.start);
            if (localIdx == -1 || localIdx >= idx) continue;
            sepLen = sep[i].length();
            idx = localIdx;
        }
        String ret = null;
        if (idx == -1 || idx > this.end) {
            ret = this.buf.substring(this.start, this.end);
            this.start = this.end;
        } else {
            ret = this.buf.substring(this.start, idx);
            this.start = idx + sepLen;
        }
        return ret;
    }

    public ChunkedString getNextChunk(String[] sep) {
        if (this.isEmpty()) {
            return null;
        }
        int idx = this.end;
        int sepLen = sep[0].length();
        int l = sep.length;
        for (int i = 0; i < l; ++i) {
            int localIdx = this.buf.indexOf(sep[i], this.start);
            if (localIdx == -1 || localIdx >= idx) continue;
            sepLen = sep[i].length();
            idx = localIdx;
        }
        ChunkedString ret = null;
        if (idx == -1 || idx > this.end) {
            ret = new ChunkedString(this.buf, this.start, this.end);
            this.start = this.end;
        } else {
            ret = new ChunkedString(this.buf, this.start, idx);
            this.start = idx + sepLen;
        }
        return ret;
    }

    public ChunkedString getNextChunk(String sep) {
        if (this.isEmpty()) {
            return this;
        }
        int idx = this.buf.indexOf(sep, this.start);
        ChunkedString ret = null;
        if (idx == -1 || idx > this.end) {
            ret = new ChunkedString(this.buf, this.start, this.end);
            this.start = this.end;
        } else {
            ret = new ChunkedString(this.buf, this.start, idx);
            this.start = idx + sep.length();
        }
        return ret;
    }

    public char charAt(int index) throws IndexOutOfBoundsException {
        if (index < 0 || this.start + index > this.end) {
            throw new IndexOutOfBoundsException("charAt(" + index + ")");
        }
        return this.buf.charAt(this.start + index);
    }

    public ChunkedString[] split(String sep) {
        int i;
        Vector<Integer> tokenIndex = new Vector<Integer>(10);
        int len = this.length();
        for (i = 0; i < len; ++i) {
            if (sep.indexOf(this.charAt(i)) == -1) continue;
            tokenIndex.addElement(new Integer(i));
        }
        int size = tokenIndex.size();
        ChunkedString[] elements = new ChunkedString[size + 1];
        if (size == 0) {
            elements[0] = this;
        } else {
            int newStart = 0;
            int end = (Integer)tokenIndex.elementAt(0);
            elements[0] = this.substring(newStart, end);
            for (i = 1; i < size; ++i) {
                newStart = (Integer)tokenIndex.elementAt(i - 1) + 1;
                end = (Integer)tokenIndex.elementAt(i);
                elements[i] = this.substring(newStart, end);
            }
            newStart = (Integer)tokenIndex.elementAt(i - 1) + 1;
            elements[i] = newStart < this.length() ? this.substring(newStart, this.length()) : new ChunkedString("");
        }
        return elements;
    }

    public boolean equals(String s) {
        return this.equals(s, false);
    }

    public boolean equalsIgnoreCase(String s) {
        return this.equals(s, true);
    }

    private boolean equals(String s, boolean ignoreCase) {
        int len = s.length();
        if (len != this.length()) {
            return false;
        }
        return this.buf.regionMatches(ignoreCase, this.start, s, 0, len);
    }

    public boolean isEmpty() {
        return this.start >= this.end;
    }

    public int indexOf(String s) {
        int ret = this.buf.indexOf(s, this.start);
        if (ret != -1 && ret < this.end) {
            return ret - this.start;
        }
        return -1;
    }

    public int indexOf(String s, int newStartPoint) {
        int ret = this.buf.indexOf(s, this.start + newStartPoint);
        if (ret != -1 && ret < this.end) {
            return ret - this.start;
        }
        return -1;
    }

    public int indexOf(ChunkedString s) {
        int ret = this.buf.indexOf(s.toString(), this.start);
        if (ret != -1 && ret < this.end) {
            return ret - this.start;
        }
        return -1;
    }

    public ChunkedString substring(int newStart, int newEnd) {
        return new ChunkedString(this.buf, this.start + newStart, this.start + newEnd);
    }

    public ChunkedString substring(int newStart) {
        return new ChunkedString(this.buf, this.start + newStart, this.end);
    }

    public int length() {
        return this.end - this.start;
    }

    public boolean startsWith(String s) {
        return this.buf.regionMatches(false, this.start, s, 0, s.length());
    }

    public void reset() {
        this.start = 0;
        this.end = this.buf.length();
    }

    public boolean moveStart(int n) {
        this.start += n;
        if (this.start < 0) {
            this.start = 0;
            return false;
        }
        if (this.start > this.end) {
            this.start = this.end;
            return false;
        }
        return true;
    }

    public boolean moveEnd(int n) {
        this.end -= n;
        if (this.end > this.buf.length()) {
            this.end = this.buf.length();
            return false;
        }
        if (this.end < this.start) {
            this.end = this.start;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.buf.substring(this.start, this.end);
    }

    private void checkIndexes() throws IndexOutOfBoundsException {
        int l = this.buf.length();
        if (this.start < 0 || this.end > l || this.start > this.end) {
            throw new IndexOutOfBoundsException("ChunckedString(" + this.start + "," + this.end + ")");
        }
    }
}

