/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.util;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class DateUtil {
    private Calendar cal = Calendar.getInstance();

    public DateUtil() {
        this(new Date());
    }

    public DateUtil(Date d) {
        this.cal.setTime(d);
    }

    public void setTime(Date d) {
        this.cal.setTime(d);
    }

    public Date getTime() {
        return this.cal.getTime();
    }

    public String getTZ() {
        return this.cal.getTimeZone().getID();
    }

    public DateUtil toMidnight() {
        this.cal.set(11, 0);
        this.cal.set(12, 0);
        this.cal.set(13, 0);
        this.cal.set(14, 0);
        return this;
    }

    public DateUtil removeDays(int days) {
        Date d = this.cal.getTime();
        long time = d.getTime();
        d.setTime(time -= (long)(days * 24 * 3600 * 1000));
        this.cal.setTime(d);
        return this;
    }

    public DateUtil addMinutes(int minutes) {
        Date d = this.cal.getTime();
        long time = d.getTime();
        d.setTime(time += (long)(minutes * 60 * 1000));
        this.cal.setTime(d);
        return this;
    }

    public DateUtil toGMT() {
        return this.toTZ("GMT");
    }

    public DateUtil toTZ(String tz) {
        this.cal.setTimeZone(TimeZone.getTimeZone(tz));
        return this;
    }

    public int getDaysSince(Date date) {
        long millisecs = date.getTime();
        Date d = this.cal.getTime();
        long time = d.getTime();
        long daysMillisecs = time - millisecs;
        int days = (int)(daysMillisecs / 1000L / 60L / 60L / 24L);
        return days;
    }

    public boolean isAfter(Date date) {
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(date);
        return this.cal.after(cal2);
    }
}

