/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.util;

import java.util.Hashtable;

class Entities {
    private static final String[][] BASIC_ARRAY = new String[][]{{"quot", "34"}, {"amp", "38"}, {"lt", "60"}, {"gt", "62"}, {"apos", "39"}};
    public static final Entities XML = new Entities();
    EntityMap map = new LookupEntityMap();

    Entities() {
    }

    public void addEntities(String[][] entityArray) {
        for (int i = 0; i < entityArray.length; ++i) {
            this.addEntity(entityArray[i][0], Integer.parseInt(entityArray[i][1]));
        }
    }

    public void addEntity(String name, int value) {
        this.map.add(name, value);
    }

    public String entityName(int value) {
        return this.map.name(value);
    }

    public int entityValue(String name) {
        return this.map.value(name);
    }

    public String escape(String str) {
        char ch = ' ';
        String entityName = null;
        StringBuffer buf = null;
        char intValue = '\u0000';
        buf = new StringBuffer(str.length() * 2);
        int l = str.length();
        for (int i = 0; i < l; ++i) {
            ch = str.charAt(i);
            entityName = this.entityName(ch);
            if (entityName == null) {
                if (ch > '\u007f') {
                    intValue = ch;
                    buf.append("&#");
                    buf.append((int)intValue);
                    buf.append(';');
                    continue;
                }
                buf.append(ch);
                continue;
            }
            buf.append('&');
            buf.append(entityName);
            buf.append(';');
        }
        return buf.toString();
    }

    public String unescape(String str) {
        StringBuffer buf = null;
        String entityName = null;
        char ch = ' ';
        int charAt1 = 32;
        int entityValue = 0;
        buf = new StringBuffer(str.length());
        int l = str.length();
        for (int i = 0; i < l; ++i) {
            ch = str.charAt(i);
            if (ch == '&') {
                int semi = str.indexOf(59, i + 1);
                if (semi == -1) {
                    buf.append(ch);
                    continue;
                }
                entityName = str.substring(i + 1, semi);
                entityValue = entityName.charAt(0) == '#' ? ((charAt1 = (int)entityName.charAt(1)) == 120 || charAt1 == 88 ? Integer.valueOf(entityName.substring(2), 16) : Integer.parseInt(entityName.substring(1))) : this.entityValue(entityName);
                if (entityValue == -1) {
                    buf.append('&');
                    buf.append(entityName);
                    buf.append(';');
                } else {
                    buf.append((char)entityValue);
                }
                i = semi;
                continue;
            }
            buf.append(ch);
        }
        return buf.toString();
    }

    static {
        XML.addEntities(BASIC_ARRAY);
    }

    static class LookupEntityMap
    extends PrimitiveEntityMap {
        private String[] lookupTable;
        private int LOOKUP_TABLE_SIZE = 256;

        LookupEntityMap() {
        }

        public String name(int value) {
            if (value < this.LOOKUP_TABLE_SIZE) {
                return this.lookupTable()[value];
            }
            return super.name(value);
        }

        private String[] lookupTable() {
            if (this.lookupTable == null) {
                this.createLookupTable();
            }
            return this.lookupTable;
        }

        private void createLookupTable() {
            this.lookupTable = new String[this.LOOKUP_TABLE_SIZE];
            int l = this.LOOKUP_TABLE_SIZE;
            for (int i = 0; i < l; ++i) {
                this.lookupTable[i] = super.name(i);
            }
        }
    }

    static class PrimitiveEntityMap
    implements EntityMap {
        private Hashtable mapNameToValue = new Hashtable();
        private Hashtable mapValueToName = new Hashtable();

        PrimitiveEntityMap() {
        }

        public void add(String name, int value) {
            this.mapNameToValue.put(name, new Integer(value));
            this.mapValueToName.put(new Integer(value), name);
        }

        public String name(int value) {
            return (String)this.mapValueToName.get(new Integer(value));
        }

        public int value(String name) {
            Object value = this.mapNameToValue.get(name);
            if (value == null) {
                return -1;
            }
            return (Integer)value;
        }
    }

    static interface EntityMap {
        public void add(String var1, int var2);

        public String name(int var1);

        public int value(String var1);
    }
}

