/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.util;

import com.funambol.util.Appender;
import com.funambol.util.MailDateFormatter;
import java.io.OutputStream;
import java.util.Date;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;

public class FileAppender
implements Appender {
    private String fileUrl = "file:///root1/synclog.txt";
    private String fileName = "synclog.txt";
    private String oldSuffix = ".sav.txt";
    private OutputStream os;
    private FileConnection fc;
    private long maxFileSize = 524288L;

    public FileAppender(String path, String fileName) {
        if (path != null && fileName != null) {
            this.fileUrl = path.endsWith("/") ? path + fileName : path + "/" + fileName;
            this.fileName = fileName;
        }
        this.os = null;
    }

    public void setMaxFileSize(long maxFileSize) {
        if (maxFileSize > 1024L) {
            this.maxFileSize = maxFileSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void writeLogMessage(String level, String msg) {
        String levelMsg = " [" + level + "] ";
        try {
            if (this.os != null) {
                StringBuffer logMsg = new StringBuffer(MailDateFormatter.dateToUTC(new Date()));
                logMsg.append(levelMsg);
                logMsg.append(msg);
                logMsg.append("\r\n");
                this.os.write(logMsg.toString().getBytes());
                this.os.flush();
                if (this.fc.fileSize() > this.maxFileSize) {
                    try {
                        String oldFileName = this.fileUrl + this.oldSuffix;
                        FileConnection oldFile = (FileConnection)Connector.open((String)oldFileName, (int)3);
                        if (oldFile.exists()) {
                            oldFile.delete();
                        }
                        this.fc.rename(this.fileName + this.oldSuffix);
                        this.fc.close();
                        this.initLogFile();
                    }
                    catch (Exception ioe) {
                        System.out.println("Exception while renaming " + ioe);
                    }
                }
            }
        }
        catch (Exception e) {
            System.out.println("Exception while logging. " + e);
            e.printStackTrace();
            try {
                this.fc.close();
            }
            catch (Exception e1) {
            }
            finally {
                this.initLogFile();
            }
        }
    }

    public void initLogFile() {
        try {
            this.fc = (FileConnection)Connector.open((String)this.fileUrl, (int)3);
            if (!this.fc.exists()) {
                this.fc.create();
                this.os = this.fc.openOutputStream();
            } else {
                this.os = this.fc.openOutputStream(this.fc.fileSize());
            }
        }
        catch (Exception e) {
            System.out.println("Cannot open or create file at: " + this.fileUrl);
            e.printStackTrace();
        }
    }

    public void openLogFile() {
    }

    public void closeLogFile() {
        try {
            if (this.os != null) {
                this.os.close();
            }
            if (this.fc != null) {
                this.fc.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteLogFile() {
        try {
            this.fc = (FileConnection)Connector.open((String)this.fileUrl, (int)3);
            if (this.fc.exists()) {
                this.fc.delete();
            }
        }
        catch (Exception e) {
            System.out.println("Cannot open or create file at: " + this.fileUrl);
            e.printStackTrace();
        }
    }
}

