/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.util;

import com.funambol.storage.AbstractRecordStore;
import com.funambol.storage.DataAccessException;
import com.funambol.util.Appender;
import com.funambol.util.MailDateFormatter;
import java.util.Date;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotFoundException;
import javax.microedition.rms.RecordStoreNotOpenException;

public class RMSAppender
implements Appender {
    public static final String LOGDBNAME = "funambol.log";
    public static final int DEFAULTLOGFILESIZE = 5120;
    public static final int LOGSIZETOBEFREE = 2560;
    public static final int EXTENDED_SIZE = 10240;
    private String dbName = null;
    private AbstractRecordStore dbStore = null;
    private static int defaultLogFileSize;
    private static int defaultLogStoreSizeToBeFree;
    private int firstRecord;
    private int logFileSize = 0;
    private static int firstRecordtoBeDeleted;

    public RMSAppender(String logfilename) {
        this.dbName = logfilename;
        defaultLogFileSize = 5120;
        defaultLogStoreSizeToBeFree = 2560;
        this.firstRecord = 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeLogMessage(String level, String msg) throws DataAccessException {
        msg = MailDateFormatter.dateToUTC(new Date()) + "\n[" + level + "] " + msg;
        boolean writeSuccess = true;
        this.openLogFile();
        this.logFileSize = this.getLogFilesize();
        if (this.logFileSize + msg.getBytes().length > defaultLogFileSize) {
            if (msg.getBytes().length > defaultLogFileSize) {
                throw new DataAccessException("Log Message too big.\n Total Size: " + this.logFileSize + msg.getBytes().length + ".\n " + "Default size set to: " + defaultLogFileSize + "\nChange default log file size to be written\n");
            }
            this.rotateLogStore(msg.getBytes().length);
        }
        if (writeSuccess) {
            try {
                this.dbStore.addRecord(msg.getBytes(), 0, msg.getBytes().length);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                this.closeLogFile();
            }
        } else {
            this.closeLogFile();
        }
    }

    public void openLogFile() {
        try {
            this.dbStore = AbstractRecordStore.openRecordStore(this.dbName, true);
        }
        catch (Exception e) {
            System.out.println("Exception opening " + this.dbName);
            System.out.println(e);
            e.printStackTrace();
        }
    }

    public void closeLogFile() {
        try {
            this.dbStore.closeRecordStore();
        }
        catch (Exception e) {
            System.out.println("Exception Closing " + this.dbName);
            System.out.println(e);
            e.printStackTrace();
        }
    }

    public void deleteLogFile() {
        try {
            AbstractRecordStore.deleteRecordStore(this.dbName);
            System.out.println("Log File deleted");
        }
        catch (RecordStoreNotFoundException ex) {
            System.out.println("Log file not found.");
        }
        catch (RecordStoreException ex) {
            System.out.println("RecordStoreException: " + (Object)((Object)ex));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initLogFile() {
        try {
            AbstractRecordStore.deleteRecordStore(this.dbName);
            System.out.println("Old Log File deleted");
        }
        catch (RecordStoreNotFoundException ex1) {
            System.out.println("Log file not found. Creating new Log file");
            try {
                this.dbStore = AbstractRecordStore.openRecordStore(this.dbName, true);
                this.dbStore.closeRecordStore();
            }
            catch (RecordStoreException ex2) {
                ex2.printStackTrace();
            }
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                System.out.println("Creating new Log file");
                this.dbStore = AbstractRecordStore.openRecordStore(this.dbName, true);
                this.dbStore.closeRecordStore();
            }
            catch (RecordStoreNotOpenException notOpenEx) {
                notOpenEx.printStackTrace();
            }
            catch (RecordStoreFullException fullEx) {
                fullEx.printStackTrace();
                System.out.println("Cannot create log file: Application reached RecordStore Maximum dimension");
            }
            catch (RecordStoreException rmsEx) {
                rmsEx.printStackTrace();
                System.err.println("Cannot create Log  file");
            }
        }
    }

    private void rotateLogStore(int msgSize) {
        System.out.println("Rotate log store");
        int actualFreeSize = 0;
        int sizeToBeFree = defaultLogStoreSizeToBeFree;
        if (msgSize >= defaultLogStoreSizeToBeFree) {
            sizeToBeFree = msgSize;
        }
        while (actualFreeSize < sizeToBeFree) {
            try {
                int nextRecord = this.dbStore.getNextRecordID();
                firstRecordtoBeDeleted = this.firstRecord = nextRecord - this.dbStore.getNumRecords();
                int nextRecordSize = this.dbStore.getRecordSize(this.firstRecord);
                this.dbStore.deleteRecord(this.firstRecord);
                actualFreeSize += nextRecordSize;
            }
            catch (RecordStoreNotOpenException ex) {
                ex.printStackTrace();
            }
            catch (InvalidRecordIDException ex) {
                if (this.logFileSize - actualFreeSize == 0) break;
                ex.printStackTrace();
                System.err.println("Record number: " + this.firstRecord + " not exixtent");
            }
            catch (RecordStoreException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void setDefaultLogFileSize(int newDefaultLogFileSize) {
        defaultLogFileSize = newDefaultLogFileSize;
    }

    public static int getDefaultLogFileSize() {
        return defaultLogFileSize;
    }

    public static void setDefaultLogStoreSizeToBeFree(int newDefaultLogStoreSizeToBeFree) {
        defaultLogStoreSizeToBeFree = newDefaultLogStoreSizeToBeFree;
    }

    public static int getDefaultLogStoreSizeToBeFree() {
        return defaultLogStoreSizeToBeFree;
    }

    public static int getFirstRecord() {
        return firstRecordtoBeDeleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getLogFilesize() {
        int storeSize = 0;
        try {
            RecordEnumeration re = this.dbStore.enumerateRecords(null, null, false);
            while (re.hasNextElement()) {
                try {
                    storeSize += this.dbStore.getRecordSize(re.nextRecordId());
                }
                catch (RecordStoreNotOpenException ex) {
                    ex.printStackTrace();
                }
                catch (InvalidRecordIDException ex) {
                    ex.printStackTrace();
                }
                catch (RecordStoreException ex) {
                    ex.printStackTrace();
                }
            }
            int ex = storeSize;
            return ex;
        }
        catch (RecordStoreNotOpenException ex) {
            ex.printStackTrace();
        }
        finally {
            return storeSize;
        }
    }
}

