/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.util;

import java.util.Vector;

public class StringUtil {
    private static final String HT = "\t";
    private static final String CRLF = "\r\n";

    private StringUtil() {
    }

    public static String[] split(String s, String sep) {
        String[] sepArray = new String[sep.length()];
        for (int i = 0; i < sep.length(); ++i) {
            sepArray[i] = new String("" + sep.charAt(i));
        }
        return StringUtil.split(s, sepArray);
    }

    public static String[] split(String s, String[] sepArray) {
        int i;
        Vector<Integer> tokenIndex = new Vector<Integer>(10);
        Vector<String> tokenSep = new Vector<String>(10);
        int len = s.length();
        for (i = 0; i < sepArray.length; ++i) {
            String sep = sepArray[i];
            int index = s.indexOf(sep);
            while (index >= 0) {
                tokenIndex.addElement(new Integer(index));
                tokenSep.addElement(sep);
                index = s.indexOf(sep, index + sep.length());
            }
        }
        int size = tokenIndex.size();
        for (i = 0; i < size; ++i) {
            int tokenI = (Integer)tokenIndex.elementAt(i);
            for (int j = i + 1; j < size; ++j) {
                int tokenJ = (Integer)tokenIndex.elementAt(j);
                if (tokenJ >= tokenI) continue;
                Object temp = tokenIndex.elementAt(i);
                tokenIndex.setElementAt((Integer)tokenIndex.elementAt(j), i);
                tokenIndex.setElementAt((Integer)temp, j);
            }
        }
        String[] elements = new String[size + 1];
        if (size == 0) {
            elements[0] = s;
        } else {
            String sep;
            int start = 0;
            int end = (Integer)tokenIndex.elementAt(0);
            elements[0] = s.substring(start, end);
            for (i = 1; i < size; ++i) {
                sep = (String)tokenSep.elementAt(i - 1);
                start = (Integer)tokenIndex.elementAt(i - 1) + sep.length();
                end = (Integer)tokenIndex.elementAt(i);
                elements[i] = s.substring(start, end);
            }
            sep = (String)tokenSep.elementAt(i - 1);
            start = (Integer)tokenIndex.elementAt(i - 1) + sep.length();
            elements[i] = start < s.length() ? s.substring(start) : "";
        }
        return elements;
    }

    public static String join(String[] list, String sep) {
        StringBuffer buffer = new StringBuffer(list[0]);
        int len = list.length;
        for (int i = 1; i < len; ++i) {
            buffer.append(sep).append(list[i]);
        }
        return buffer.toString();
    }

    public static String[] getStringArray(Vector stringVec) {
        if (stringVec == null) {
            return null;
        }
        String[] stringArray = new String[stringVec.size()];
        for (int i = 0; i < stringVec.size(); ++i) {
            stringArray[i] = (String)stringVec.elementAt(i);
        }
        return stringArray;
    }

    public static Vector getVectorFromArray(Object[] array) {
        Vector<Object> v = new Vector<Object>(array.length);
        for (int i = 0; i < array.length; ++i) {
            v.addElement(array[i]);
        }
        return v;
    }

    public static int findEmptyLine(String s) {
        int ret = 0;
        while ((ret = s.indexOf("\n", ret)) != -1) {
            while (s.charAt(ret) == '\r') {
                ++ret;
            }
            if (s.charAt(ret) != '\n') continue;
            ++ret;
            break;
        }
        return ret;
    }

    public static String removeBlanks(String content) {
        return StringUtil.removeChar(content, ' ');
    }

    public static String removeBackslashes(String content) {
        return StringUtil.removeChar(content, '\\');
    }

    public static String removeChar(String content, char ch) {
        if (content == null) {
            return null;
        }
        StringBuffer buff = new StringBuffer();
        buff.append(content);
        int len = buff.length();
        for (int i = len - 1; i >= 0; --i) {
            if (ch != buff.charAt(i)) continue;
            buff.deleteCharAt(i);
        }
        return buff.toString();
    }

    public static String fold(String recipients) {
        String[] list = StringUtil.split(recipients, ",");
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < list.length; ++i) {
            String address = list[i] + (i != list.length - 1 ? "," : "");
            buffer.append(i == 0 ? address + CRLF : HT + address + CRLF);
        }
        return buffer.toString();
    }

    public static boolean equalsIgnoreCase(String string1, String string2) {
        if (string1 == null && string2 == null) {
            return true;
        }
        if (string1 == null || string2 == null) {
            return false;
        }
        return string1.toLowerCase().equals(string2.toLowerCase());
    }

    public static boolean getBooleanValue(String string) {
        if (string == null || string.equals("")) {
            return false;
        }
        return StringUtil.equalsIgnoreCase(string, "true");
    }

    public static String trim(String s, char c) {
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return "";
        }
        int start = 0;
        int end = s.length() - 1;
        while (s.charAt(start) == c) {
            if (++start < end) continue;
            return "";
        }
        while (s.charAt(end) == c) {
            if (--end > start) continue;
            return "";
        }
        return s.substring(start, end + 1);
    }

    public static boolean isNullOrEmpty(String str) {
        if (str == null) {
            return true;
        }
        return str.trim().equals("");
    }

    public static String extractAddressFromUrl(String url, String protocol) {
        int pos;
        String prefix = protocol + "://";
        if (url.startsWith(prefix)) {
            url = url.substring(prefix.length(), url.length());
        }
        if ((pos = url.indexOf(58)) >= 0) {
            url = url.substring(0, pos);
        }
        if ((pos = url.indexOf(47)) >= 0) {
            url = url.substring(0, pos);
        }
        return url;
    }

    public static String extractAddressFromUrl(String url) {
        int start = 0;
        if (url.startsWith("https://")) {
            start = 8;
        } else if (url.startsWith("http://")) {
            start = 7;
        }
        int pos = url.substring(start).indexOf(47);
        if (pos >= 0) {
            url = url.substring(0, pos + start);
        }
        return url;
    }

    public static String removePortFromUrl(String url, String protocol) {
        int pos;
        String prefix = protocol + "://";
        int beginning = 0;
        if (url.startsWith(prefix)) {
            beginning = protocol.length() + 3;
        }
        if ((pos = url.indexOf(58, beginning)) >= 0) {
            int slash = url.indexOf(47, pos);
            url = url.substring(0, pos) + url.substring(slash);
        }
        return url;
    }

    public static String getProtocolFromUrl(String url) {
        int protocolEndIndex = url.indexOf("://");
        if (protocolEndIndex > 0) {
            return url.substring(0, protocolEndIndex);
        }
        return null;
    }
}

