/*
 * Decompiled with CFR 0.152.
 */
package com.telefonica.copiagenda.controllers;

import com.telefonica.copiagenda.Locale;
import com.telefonica.copiagenda.ui.LogViewer;
import com.telefonica.copiagenda.ui.ProgressView;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;

public class NetworkHandler
implements Runnable {
    private HttpConnection conn;
    private InputStream in;
    private ProgressView iProgressView;
    private boolean isRunning = false;
    Thread fetch = null;
    String[] iClientData = null;
    private String iExceptionMessage = null;
    private String iUrl = null;
    private String iMSISDN;

    public NetworkHandler(ProgressView aProgressView) {
        this.iProgressView = aProgressView;
    }

    public void setVersionCheckUrl(String aUrl) {
        this.iUrl = aUrl;
    }

    public String[] fetchClientInformation() {
        this.iClientData = null;
        this.iProgressView.setLabel(Locale.get("PROGRESSVIEW_INITIALIZING"));
        this.iProgressView.setValue(0);
        this.fetch = new Thread(this);
        this.isRunning = true;
        this.fetch.run();
        return this.iClientData;
    }

    public String getMSISDN() {
        return this.iMSISDN;
    }

    public void cancelFetch() {
        this.isRunning = false;
        this.iClientData = null;
        this.in = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.conn = null;
        this.in = null;
        this.iExceptionMessage = null;
        this.isRunning = true;
        try {
            block53: {
                block52: {
                    this.iProgressView.setString(Locale.get("PROGRESSVIEW_CONNECTING"));
                    this.conn = (HttpConnection)Connector.open((String)this.iUrl, (int)1, (boolean)true);
                    this.conn.setRequestProperty("Connection", "close");
                    LogViewer.debug("Open input");
                    this.in = this.conn.openInputStream();
                    LogViewer.debug("Input open");
                    this.iMSISDN = "DefaultMSISDN";
                    if (this.iExceptionMessage != null && this.iExceptionMessage.equals("Fetch cancelled")) {
                        throw new NullPointerException(this.iExceptionMessage);
                    }
                    LogViewer.debug("Input open");
                    this.iProgressView.setString(Locale.get("PROGRESSVIEW_READING"));
                    this.iProgressView.setValue(50);
                    if (this.in == null) break block52;
                    if (this.conn.getResponseCode() == 200 && this.isRunning) break block53;
                }
                LogViewer.debug("Resource not available from Internet: " + this.conn.getResponseCode());
                LogViewer.debug("Query: " + this.conn.getQuery());
                throw new NullPointerException("Resource not available from Internet: " + this.conn.getResponseCode());
            }
            int length = (int)this.conn.getLength();
            byte[] data = null;
            if (length > 0) {
                int actual = 0;
                data = new byte[length];
                for (int bytesread = 0; bytesread != length && actual != -1; bytesread += actual) {
                    actual = this.in.read(data, bytesread, length - bytesread);
                }
            } else {
                int ch;
                StringBuffer buf = new StringBuffer();
                while ((ch = this.in.read()) != -1) {
                    buf.append((char)ch);
                }
                data = buf.toString().getBytes();
                buf = null;
            }
            this.parseResponse(data);
            Object var2_24 = null;
        }
        catch (SecurityException se) {
            se.printStackTrace();
            this.iExceptionMessage = "Fetch cancelled";
        }
        catch (IOException ex) {
            LogViewer.debug("iURL: " + this.iUrl + " " + ex.getMessage());
            this.iExceptionMessage = ex.getMessage();
        }
        catch (NullPointerException ne) {
            LogViewer.debug("fileManager.run: NullPointer:" + ne.getMessage());
            this.iExceptionMessage = "Fetch cancelled";
        }
        catch (IllegalArgumentException ae) {
            ae.printStackTrace();
            this.iExceptionMessage = "Illegal argument";
        }
        catch (IndexOutOfBoundsException iob) {
            iob.printStackTrace();
            this.iExceptionMessage = "Fetch cancelled";
            this.iClientData = null;
        }
        finally {
            if (this.in != null) {
                try {
                    this.in.close();
                    this.in = null;
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            if (this.conn != null) {
                try {
                    this.conn.close();
                    this.conn = null;
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private void parseResponse(byte[] data) throws IndexOutOfBoundsException {
        String clientVersionData = new String(data);
        this.iClientData = new String[2];
        LogViewer.debug("Response: " + clientVersionData);
        int index = clientVersionData.indexOf("version");
        this.iClientData[0] = clientVersionData.substring(clientVersionData.indexOf("=", index) + 1, clientVersionData.indexOf("&&", index));
        LogViewer.debug("Version: " + this.iClientData[0]);
        index = clientVersionData.indexOf("url");
        this.iClientData[1] = clientVersionData.substring(clientVersionData.indexOf("=", index) + 1, clientVersionData.indexOf("&&", index));
        LogViewer.debug("URL: " + this.iClientData[1]);
    }
}

