/*
 * Decompiled with CFR 0.152.
 */
package com.telefonica.copiagenda.datasync.source;

import com.telefonica.copiagenda.ui.LogViewer;
import java.util.Date;
import java.util.Hashtable;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotFoundException;

public class CopiAgendaSyncRegister {
    private long iLastSyncTime = 0L;
    private RecordStore iRms = null;
    private final String SYNC_REGISTER;
    private long[] iClientModifications = new long[3];
    private long[] iServerModifications = new long[3];
    private Hashtable iRegister = null;
    public final long DEFAULT_ALARM_DELTA;

    public CopiAgendaSyncRegister() {
        this.SYNC_REGISTER = "CopiAgendaSyncRegister";
        this.DEFAULT_ALARM_DELTA = 30L;
        try {
            this.iRms = RecordStore.openRecordStore((String)"CopiAgendaSyncRegister", (boolean)true);
            this.iRegister = new Hashtable(3);
            RecordEnumeration e = this.iRms.enumerateRecords(null, null, false);
            long nextAlarm = 0L;
            long alarmDeltaTime = 0L;
            int syncMode = 0;
            while (e.hasNextElement()) {
                int i;
                int numIndex;
                String client;
                String records = new String(e.nextRecord());
                int index = records.indexOf("Client=");
                if (index > 0) {
                    client = records.substring(index += 7, records.indexOf(",", index));
                    numIndex = client.indexOf("|");
                    for (i = 0; i < 3; ++i) {
                        this.iClientModifications[i] = Long.parseLong(client.substring(0, numIndex));
                        client = client.substring(numIndex + 1);
                        numIndex = client.indexOf("|");
                    }
                }
                if ((index = records.indexOf("Server=")) > 0) {
                    client = records.substring(index += 7, records.indexOf(",", index));
                    numIndex = client.indexOf("|");
                    for (i = 0; i < 3; ++i) {
                        this.iServerModifications[i] = Long.parseLong(client.substring(0, numIndex));
                        client = client.substring(numIndex + 1);
                        numIndex = client.indexOf("|");
                    }
                }
                if ((index = records.indexOf("Sync=")) > 0) {
                    this.iLastSyncTime = Long.parseLong(records.substring(index += 5, records.indexOf(44, index)));
                }
                if ((index = records.indexOf("Alarm=")) > 0) {
                    nextAlarm = Long.parseLong(records.substring(index += 6, records.indexOf(44, index)));
                }
                if ((index = records.indexOf("AlarmDelta=")) > 0) {
                    alarmDeltaTime = Long.parseLong(records.substring(index += 11, records.indexOf(44, index)));
                }
                if ((index = records.indexOf("SyncMode=")) <= 0) continue;
                syncMode = Integer.parseInt(records.substring(index += 9, records.indexOf(125, index)));
            }
            if (alarmDeltaTime == 0L) {
                alarmDeltaTime = 30L;
            }
            String clientMods = this.iClientModifications[0] + "|" + this.iClientModifications[1] + "|" + this.iClientModifications[2] + "|";
            String serverMods = this.iServerModifications[0] + "|" + this.iServerModifications[1] + "|" + this.iServerModifications[2] + "|";
            this.iRegister.put("Sync", new Long(this.iLastSyncTime));
            this.iRegister.put("SyncMode", new Integer(syncMode));
            this.iRegister.put("Client", clientMods);
            this.iRegister.put("Server", serverMods);
            this.iRegister.put("Alarm", new Long(nextAlarm));
            this.iRegister.put("AlarmDelta", new Long(alarmDeltaTime));
            this.iRms.closeRecordStore();
        }
        catch (RecordStoreFullException ex) {
            ex.printStackTrace();
        }
        catch (RecordStoreNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
        }
        if (this.iRegister == null) {
            this.iRegister = new Hashtable(3);
        }
    }

    public void itemAdded(boolean isClientModification) {
        LogViewer.debug("itemAdded: " + isClientModification);
        if (isClientModification) {
            this.iClientModifications[0] = this.iClientModifications[0] + 1L;
        } else {
            this.iServerModifications[0] = this.iServerModifications[0] + 1L;
        }
    }

    public void itemUpdated(boolean isClientModification) {
        LogViewer.debug("itemUpdated: " + isClientModification);
        if (isClientModification) {
            this.iClientModifications[1] = this.iClientModifications[1] + 1L;
        } else {
            this.iServerModifications[1] = this.iServerModifications[1] + 1L;
        }
    }

    public void itemDeleted(boolean isClientModification) {
        LogViewer.debug("itemDeleted: " + isClientModification);
        if (isClientModification) {
            this.iClientModifications[2] = this.iClientModifications[2] + 1L;
        } else {
            this.iServerModifications[2] = this.iServerModifications[2] + 1L;
        }
    }

    public void resetCounters() {
        for (int i = 0; i < this.iClientModifications.length; ++i) {
            this.iClientModifications[i] = 0L;
            this.iServerModifications[i] = 0L;
        }
    }

    public void updateLastSync(long aTime, int aSyncMode) {
        LogViewer.debug("updateLastSync: " + new Date(aTime).toString());
        try {
            this.iRms = RecordStore.openRecordStore((String)"CopiAgendaSyncRegister", (boolean)true);
            this.iRegister.clear();
            this.iRegister.put("Sync", new Long(aTime));
            this.iRegister.put("SyncMode", new Integer(aSyncMode));
            String clientMods = this.iClientModifications[0] + "|" + this.iClientModifications[1] + "|" + this.iClientModifications[2] + "|";
            String serverMods = this.iServerModifications[0] + "|" + this.iServerModifications[1] + "|" + this.iServerModifications[2] + "|";
            this.iRegister.put("Client", clientMods);
            this.iRegister.put("Server", serverMods);
            LogViewer.debug("register: " + this.iRegister.toString());
            RecordEnumeration e = this.iRms.enumerateRecords(null, null, false);
            while (e.hasNextElement()) {
                this.iRms.deleteRecord(e.nextRecordId());
            }
            byte[] bytes = this.iRegister.toString().getBytes();
            this.iRms.addRecord(bytes, 0, bytes.length);
            this.iRms.closeRecordStore();
        }
        catch (RecordStoreFullException ex) {
            ex.printStackTrace();
        }
        catch (RecordStoreNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
        }
    }

    public long getLastSyncTime() {
        Long time = (Long)this.iRegister.get("Sync");
        if (time != null) {
            LogViewer.debug("getLastSyncTime: " + time);
        }
        return time != null ? time : 0L;
    }

    public int getLastSyncMode() {
        Integer mode = (Integer)this.iRegister.get("SyncMode");
        return mode != null ? mode : 0;
    }

    public long[] getClientModifications() {
        long[] tmp = new long[3];
        String clientData = (String)this.iRegister.get("Client");
        int index = clientData.indexOf("|");
        if (index > 0) {
            for (int i = 0; i < this.iClientModifications.length; ++i) {
                tmp[i] = Long.parseLong(clientData.substring(0, index));
                LogViewer.debug("Client:" + tmp[i]);
                clientData = clientData.substring(index + 1);
                index = clientData.indexOf("|");
            }
        }
        return tmp;
    }

    public long[] getServerModifications() {
        long[] tmp = new long[3];
        String clientData = (String)this.iRegister.get("Server");
        int index = clientData.indexOf("|");
        if (index > 0) {
            for (int i = 0; i < this.iClientModifications.length; ++i) {
                tmp[i] = Long.parseLong(clientData.substring(0, index));
                LogViewer.debug("Server:" + tmp[i]);
                clientData = clientData.substring(index + 1);
                index = clientData.indexOf("|");
            }
        }
        return tmp;
    }

    public void setAlarmMode(int aMode) {
        this.iRegister.remove("Alarm");
        this.iRegister.put("Alarm", new Long(aMode));
    }

    public void save() {
        try {
            this.iRms = RecordStore.openRecordStore((String)"CopiAgendaSyncRegister", (boolean)true);
            RecordEnumeration e = this.iRms.enumerateRecords(null, null, false);
            while (e.hasNextElement()) {
                this.iRms.deleteRecord(e.nextRecordId());
            }
            byte[] bytes = this.iRegister.toString().getBytes();
            this.iRms.addRecord(bytes, 0, bytes.length);
            this.iRms.closeRecordStore();
        }
        catch (RecordStoreFullException ex) {
            ex.printStackTrace();
        }
        catch (RecordStoreNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
        }
    }

    public void setAlarmDeltaTime(long aTime) {
        this.iRegister.remove("AlarmDelta");
        this.iRegister.put("AlarmDelta", new Long(aTime));
    }

    public int getAlarmMode() {
        Long mode = (Long)this.iRegister.get("Alarm");
        return mode != null ? (int)mode.longValue() : 0;
    }

    public long getAlarmDelta() {
        Long delta = (Long)this.iRegister.get("AlarmDelta");
        return delta != null ? delta : 0L;
    }
}

