/*
 * Decompiled with CFR 0.152.
 */
package com.telefonica.copiagenda.ui;

import com.telefonica.copiagenda.Locale;
import com.telefonica.copiagenda.datasync.source.CopiAgendaSyncRegister;
import com.telefonica.copiagenda.ui.LogViewer;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextField;

public class ConfigurationView
extends Form {
    private final CopiAgendaSyncRegister iSyncRegister;
    private final ChoiceGroup iReminderChoice;
    private final TextField iDelay;
    private final int MAX_NUMBER_LENGTH;

    public ConfigurationView(CopiAgendaSyncRegister aSyncRegister) {
        super(Locale.get("CONFIGURATION_MENU_TEXT"));
        this.MAX_NUMBER_LENGTH = 3;
        this.iSyncRegister = aSyncRegister;
        this.iReminderChoice = new ChoiceGroup(Locale.get("CONFIGURATION_VIEW_ENABLER"), 1);
        this.iReminderChoice.append(Locale.get("CONFIGURATION_VIEW_ON"), null);
        this.iReminderChoice.append(Locale.get("CONFIGURATION_VIEW_OFF"), null);
        this.append((Item)this.iReminderChoice);
        this.iDelay = new TextField(Locale.get("CONFIGURATION_VIEW_DAYS"), null, 3, 2);
        this.append((Item)this.iDelay);
    }

    public void updateUI() {
        long l;
        this.iReminderChoice.setSelectedIndex(this.iSyncRegister.getAlarmMode(), true);
        int days = (int)this.iSyncRegister.getAlarmDelta();
        if (days == 0) {
            this.iSyncRegister.getClass();
            l = 30L;
        } else {
            l = days;
        }
        days = (int)l;
        LogViewer.debug("Saved: " + this.iSyncRegister.getAlarmDelta() + " | " + this.iSyncRegister.getAlarmDelta());
        this.iDelay.setString(Integer.toString(days));
    }

    public void save() {
        String delay = this.iDelay.getString();
        if (delay != null) {
            int days = 0;
            try {
                days = Integer.parseInt(delay);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (days <= 0) {
                this.iSyncRegister.getClass();
                days = 30;
            }
            this.iSyncRegister.setAlarmDeltaTime(days);
        }
        this.iSyncRegister.setAlarmMode(this.iReminderChoice.getSelectedIndex());
        LogViewer.debug("Selected " + this.iReminderChoice.getSelectedIndex());
        System.out.println("Selected " + this.iReminderChoice.getSelectedIndex());
    }
}

