/*
 * Decompiled with CFR 0.152.
 */
package com.telefonica.copiagenda.ui;

import com.telefonica.copiagenda.CopiagendaApplication;
import com.telefonica.copiagenda.Locale;
import com.telefonica.copiagenda.datasync.source.CopiAgendaSyncRegister;
import com.telefonica.copiagenda.ui.CustomizedItem;
import com.telefonica.copiagenda.ui.LogViewer;
import com.telefonica.copiagenda.ui.MainMenuItem;
import com.telefonica.copiagenda.ui.MainMenuItemLCDUI;
import java.io.IOException;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;
import javax.microedition.lcdui.StringItem;

public class MainView
extends Form
implements ItemCommandListener {
    private String[] iMenuTexts = null;
    private String[] iMenuImages = null;
    private StringItem iLastSync = null;
    private Command iSelectCommand = null;
    public static final int MAIN_MENU_VIEW = 0;
    public static final int ADVANCED_OPTIONS_VIEW = 1;
    private CopiagendaApplication iMidlet;
    private CopiAgendaSyncRegister iRegister;
    public int iViewType;
    private int selectedIndex = 0;
    private boolean useNokiaUI = false;
    private boolean iIsNokiaPhone = false;

    public MainView(CopiagendaApplication aMidlet, CopiAgendaSyncRegister aRegister) {
        super(null);
        this.iMidlet = aMidlet;
        this.iRegister = aRegister;
        this.iSelectCommand = new Command(Locale.get("SELECT_COMMAND"), 4, 0);
        this.useNokiaUI = this.isDirectGraphicsAvailable();
        if (this.useNokiaUI) {
            this.iIsNokiaPhone = this.isNokiaPhone();
        }
    }

    public void construct(int aType) {
        this.iViewType = aType;
        this.iMenuTexts = null;
        this.iMenuImages = null;
        this.loadTexts();
        this.createMenuList();
        switch (aType) {
            case 0: {
                this.setTitle(this.iMidlet.getAppProperty("MIDlet-Name"));
                this.append((Item)this.getLastSync());
                break;
            }
            case 1: {
                this.setTitle(Locale.get("ADVANCED_OPTIONS_MENU_TEXT"));
            }
        }
    }

    private void loadTexts() {
        this.iMenuTexts = null;
        this.iMenuImages = null;
        switch (this.iViewType) {
            case 0: {
                this.iMenuTexts = new String[]{Locale.get("BACKUP_MENU_TEXT"), Locale.get("RESTORE_MENU_TEXT"), Locale.get("ADVANCED_OPTIONS_MENU_TEXT"), Locale.get("HELP_MENU_TEXT")};
                this.iMenuImages = new String[]{"/copiar_contactos.png", "/recuperar_contactos.png", "/opciones_avanzadas.png", "/ayuda.png"};
                break;
            }
            case 1: {
                this.iMenuTexts = new String[]{Locale.get("BIDIRECTIONAL_MENU_TEXT"), Locale.get("STATE_MENU_TEXT"), Locale.get("CONFIGURATION_MENU_TEXT"), Locale.get("ABOUT_MENU_TEXT")};
                this.iMenuImages = new String[]{"/copiagenda.png", "/estado.png", "/configuracion.png", "/acerca_de.png"};
            }
        }
    }

    private StringItem getLastSync() {
        if (this.iLastSync == null) {
            this.iLastSync = new StringItem(null, null);
            Font small = Font.getFont((int)0, (int)0, (int)0);
            this.iLastSync.setFont(small);
        }
        this.updateLastSynchronizationTime();
        return this.iLastSync;
    }

    private void createMenuList() {
        this.deleteAll();
        for (int i = 0; i < this.iMenuTexts.length; ++i) {
            try {
                CustomizedItem item;
                Image menuIcon = Image.createImage((String)this.iMenuImages[i]);
                if (this.useNokiaUI) {
                    item = new MainMenuItem(this.iMenuTexts[i], menuIcon, this.getWidth(), this.iMidlet.getDisplay(), i, this.iIsNokiaPhone);
                    item.setItemCommandListener(this);
                    item.setDefaultCommand(this.iSelectCommand);
                    this.append((Item)item);
                    continue;
                }
                item = new MainMenuItemLCDUI(this.iMenuTexts[i], menuIcon, this.getWidth(), this.iMidlet.getDisplay(), i);
                item.setItemCommandListener(this);
                item.setDefaultCommand(this.iSelectCommand);
                this.append((Item)item);
                continue;
            }
            catch (IOException ie) {
                ie.printStackTrace();
            }
        }
        if (this.iMidlet.getItemCount() == 0) {
            this.delete(0);
        }
    }

    private boolean isDirectGraphicsAvailable() {
        boolean isAvailable = false;
        try {
            Class<?> c = Class.forName("com.nokia.mid.ui.DirectGraphics");
            isAvailable = true;
            LogViewer.debug("USE NOKIA UI API");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isAvailable;
    }

    public void updateLastSynchronizationTime() {
        String timeString = null;
        long time = this.iRegister.getLastSyncTime();
        int syncMode = this.iRegister.getLastSyncMode();
        StringBuffer label = new StringBuffer("   ");
        label.append(Locale.get("LAST_SYNCHRONIZED_LABEL"));
        if (time > 0L) {
            label.append("\n   ");
            timeString = "   " + Locale.getLocalizedDate(time);
            switch (syncMode) {
                case 0: 
                case 200: 
                case 201: 
                case 205: {
                    label.append(Locale.get("LAST_SYNCHRONIZED_BIDIRECTIONAL"));
                    break;
                }
                case 202: {
                    label.append(Locale.get("LAST_SYNCHRONIZED_BACKUP"));
                    break;
                }
                case 204: {
                    label.append(Locale.get("LAST_SYNCHRONIZED_RESTORE"));
                }
            }
        } else {
            timeString = "   " + Locale.get("STATUS_NOT_SYNCHRONIZED");
        }
        this.iLastSync.setLabel(label.toString() + "\n");
        this.iLastSync.setText(timeString);
    }

    public int getSelected() {
        return this.selectedIndex;
    }

    public void commandAction(Command aCmd, Item aItem) {
        this.selectedIndex = this.useNokiaUI ? ((MainMenuItem)aItem).iIndex : ((MainMenuItemLCDUI)aItem).iIndex;
        this.iMidlet.viewAction();
    }

    private boolean isNokiaPhone() {
        boolean nokiaPhoneUsed = false;
        String platform = System.getProperty("microedition.platform");
        String mf_Nokia = "Nokia";
        if (platform != null && platform.indexOf("Nokia") >= 0) {
            nokiaPhoneUsed = true;
        }
        return nokiaPhoneUsed;
    }
}

