/*
 * Decompiled with CFR 0.152.
 */
package com.telefonica.copiagenda.ui;

import com.telefonica.copiagenda.Locale;
import com.telefonica.copiagenda.datasync.source.CopiAgendaSyncRegister;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;

public class RegisterView
extends Form {
    private StringItem lastSync = null;
    private CopiAgendaSyncRegister iSyncRegister;

    public RegisterView(CopiAgendaSyncRegister aSyncRegister) {
        super(null);
        this.iSyncRegister = aSyncRegister;
        this.setTitle(Locale.get("STATE_MENU_TEXT"));
    }

    public void updateUI() {
        this.deleteAll();
        long time = this.iSyncRegister.getLastSyncTime();
        String timeString = null;
        int syncMode = this.iSyncRegister.getLastSyncMode();
        StringBuffer label = new StringBuffer(Locale.get("LAST_SYNCHRONIZED_LABEL"));
        label.append(" ");
        switch (syncMode) {
            case 0: 
            case 200: 
            case 201: 
            case 205: {
                label.append(Locale.get("LAST_SYNCHRONIZED_BIDIRECTIONAL"));
                break;
            }
            case 202: {
                label.append(Locale.get("LAST_SYNCHRONIZED_BACKUP"));
                break;
            }
            case 204: {
                label.append(Locale.get("LAST_SYNCHRONIZED_RESTORE"));
            }
        }
        this.lastSync = new StringItem(label.toString() + "\n", null);
        timeString = time > 0L ? Locale.getLocalizedDate(time) : Locale.get("STATUS_NOT_SYNCHRONIZED");
        this.lastSync.setText(timeString);
        this.lastSync.setLayout(512);
        this.append((Item)this.lastSync);
        Font itemFont = Font.getFont((int)64, (int)0, (int)8);
        long[] clientModifications = this.iSyncRegister.getClientModifications();
        long[] serverModifications = this.iSyncRegister.getServerModifications();
        StringItem serverLabel = new StringItem(Locale.get("STATUS_SERVER_HEADER") + ":\n", null, 0);
        serverLabel.setFont(itemFont);
        this.append((Item)serverLabel);
        StringBuffer text = new StringBuffer(Locale.get("STATUS_ADDED"));
        text.append(": ");
        text.append(serverModifications[0]);
        text.append("\n");
        text.append(Locale.get("STATUS_UPDATED"));
        text.append(": ");
        text.append(serverModifications[1]);
        text.append("\n");
        text.append(Locale.get("STATUS_REMOVED"));
        text.append(": ");
        text.append(serverModifications[2]);
        text.append("\n");
        serverLabel.setText(text.toString());
        StringItem clientLabel = new StringItem(Locale.get("STATUS_CLIENT_HEADER") + ":\n", null, 0);
        clientLabel.setFont(itemFont);
        this.append((Item)clientLabel);
        text.delete(0, text.length());
        text.append(Locale.get("STATUS_ADDED"));
        text.append(": ");
        text.append(clientModifications[0]);
        text.append("\n");
        text.append(Locale.get("STATUS_UPDATED"));
        text.append(": ");
        text.append(clientModifications[1]);
        text.append("\n");
        text.append(Locale.get("STATUS_REMOVED"));
        text.append(": ");
        text.append(clientModifications[2]);
        text.append("\n");
        clientLabel.setText(text.toString());
    }
}

