/*
 * main.js
 */

/**
 * Objeto principal de control. 
 */

trace("loading --> main.js");

function TocToc() {
	// --------------------------------------------------------------- Variables
	/** Datos e informacin de usuario cargada */
	this.userInfo = null;
	
	/** Descripcin del anuncio actualmente seleccionado */
	this.currentAdDesc= null;
	
	/** Listado de anuncios consumidos. */
	this.consumedAds = {};
	
	/** Informacin de popUp. */
	this.popupInfo = null;
	
	/** Reintentar transaccin registro */
	this.retry_registro=true;
	
	/** ltimo nmero de teelfono introducido en el text-input de recomendar toctoc */
	this.phoneNumb="";
	
	this.pauseNokiaS60=false;
	
};
TocToc.prototype = {
	// -------------------------------------------------------------- Constantes
	/** Proporcin de la barra de progreso inicial correspondiente al proceso de  
	 * carga de datos informacin de usuario (GetUserInfo) */  
	PROG_UI: 0.20, // Progress User Info
	
	/** Tiempo de visualizacin del "snack" del anuncio por defecto */
	DEFAULT_SNACK_TIME: 5, 
	
	/** Men y opciones por defecto del Soft-Menu izquierdo */
	SM_LEFT: {
		text: msg["softmenu.options"],
		options: [
			{text: msg["softmenu.sound"], actions: "audio.switchVolume();"},
			{text: msg["softmenu.about"], actions: "softMenu.close();toctoc.showAbout();"},
			{text: msg["softmenu.help"], actions: "softMenu.close();toctoc.showAyuda();"},
			{text: msg["softmenu.exit"], actions: "softMenu.close();toctoc.exitConfirm();"}
		]
	},
	
	// --------------------------------------------------------------- Funciones
	/**
	 * Funcin de inicializacin.
	 */
	init: function() {
		
		player.onloadstart=this.onLoading;
		player.onloadend=this.onLoading;
		// subscribimos una funcin para manejar los errores de sistema 
		// (ej: out of memory)
		player.onerror=this.onError;
		
		// Se carga la introduccin inicial
//		player.open("splash.mcd", "content-frame");
		try {
			this.consumedAds = cache.load("toctoc/consumedAds");
			if (!this.consumedAds) this.consumedAds = {};
		} catch (err) {
			trace("error cargando informacin de anuncios consumidos: "+err);
		}

	},
	
	/**
	 *  Funcin manejadora de los errores de sistema (ej: Out of memory)
	 */
	onError: function(evt) {
		trace("error de sistema: " + evt.type);
		//softMenu.showLoading();
		player.close("content-frame");
		player.close("content-frame2");
		toctoc.showInfoPopUp(
    			{icon: "images/popUp/warning_img.png", 
		 			message: ["El servicio no est disponible temporalmente.",
		 			          "Intntalo de nuevo ms tarde."]}, 
    			{left: { text: msg["softmenu.accept"], actions: "player.exit()" }});

    	
    	
    	// al devolver false NO se levanta la pantalla de error.
		return false;
	},
	
	onLoading: function(evt) {
		trace("onLoading: "+evt.type+" -- "+evt.targetId+" -- "+evt.url);
		if (evt.targetId=="content-frame") {
			if (evt.type == "loadstart"){
				softMenu.showLoading();
			} else {
				softMenu.hideLoading();
			}
		}
		
	},
	
	/**
	 * Inicia el proceso inicial de carga y comprobacin de datos e informacin 
	 * de usuario.
	 */
	start: function() {
		var self = this;
		
		var adsDescription;
		var adsParam = "";
		var adsReq = new XMLHttpRequest();
		adsReq.open("GET",CONTENTS_URL+ "/adsDescription.js",false);
		adsReq.setRequestHeader("Cache-Control", "no-revalidate,only-if-cached");
		trace("Solicitando informacin de anuncios... ");
		try {
			adsReq.send();
			if ((adsReq.status == 0 || adsReq.status == 200 || adsReq.status == 204 
				|| adsReq.status == 304) && adsReq.error != null && adsReq.responseText != null) {
				trace("respuesta de peticin: "+adsReq.responseText);
				adsDescription = eval("(" + adsReq.responseText + ")");
				for (var i=0; i<adsDescription.ads.length; i++) {
					adsParam+="&currentAd="+adsDescription.ads[i].Id;
				}
			} else {
				trace("Error loading ad description.");
			}
		} catch (err) {
//			trace("Error reading ad description: " + err);
		}
		
		
		
		
		// Se realiza la peticin inicial de obtencin de datos e informacin de 
		// usuario
		
		
		
		var req = new XMLHttpRequest();
		req.open("POST", SERVER_URL + "/getUserInfo", true);
//		req.timeout=-1;
		req.onreadystatechange = function() {
			var p = (req.total > 0) 
					? parseInt(self.PROG_UI * (req.loaded * 100 / req.total)) 
					: (self.PROG_UI * 100);
			self.showProgressBar(p, 65);
			var error = false;
			if (req.readyState == 4) {
				if ((req.status == 0 || req.status == 200 || req.status == 204 || req.status == 304) && 
						req.error != null && req.responseText != null) {
					try {
						trace("respuesta --> "+req.responseText);
						var info = eval("(" + req.responseText + ")");
						self.userInfo = info;
						if (!self.checkVersion(info))
							self.checkUserInfo(info);
					} catch (err) {
						error = true;
						trace("Error reading user info: " + err);
					}
				} else {
					error = true;
					trace("Error loading user info.");
				}
				if (error) {
					self.hideProgressBar();
					self.showInfoPopUp({icon: "images/popUp/warning_img.png", 
							 			title: "tocAd",
							 			message: ["Servicio no disponible.","Intntalo de nuevo ms tarde."]}, 
										{
												left: {
													text: msg["softmenu.accept"],
													actions: "player.exit();"
												}
										});
				}
				// self.hideProgressBar();
			}
		};
		this.showProgressBar(12, 65);
		
		req.setRequestHeader("Cache-Control", "no-cache");
		req.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
		req.setRequestHeader("User-Agent",config.getSystemProperty("microedition.platform"));
		
		
		var info =	"";
		
		if(TM_user_msisdn)
			info += "TM_user_msisdn="+TM_user_msisdn+"&";
		
		info +=	"versionNum="+VERSION_NUM+
			 	"&portingId="+PORTING_ID+
			 	"&deviceId="+DEVICE_ID+adsParam;
		
		if(MAX_VIDEO_SIZE)
			info += "&maxVideoSize="+MAX_VIDEO_SIZE;

		req.send(info);
		
		 if(tactileVersion)player.open('keyb.jst','keyboard_frame');
	},

	checkVersion: function(info) {
		if (info.config && info.config.latestAppVersion) {
			var lv = info.config.latestAppVersion;
			if (lv.version && (lv.version != VERSION_NUM) && lv.downloadUrl) {
				this.hideProgressBar();
				if (lv.required) {
					this.showInfoPopUp({icon: "images/popUp/info_img.png", title: "Nueva versin", message: ["Para seguir usando tocAd debes actualizar la aplicacin","Deseas actualizarla ahora?"]}, 
							{ 
									left: {
									text: msg["softmenu.update"],
									actions: "toctoc.updateApp('"+lv.downloadUrl+"');"
								},
								right: {
									text: msg["softmenu.exit"],
									actions: "player.exit();"
								}
							}
						);					
				} else {
					this.showInfoPopUp({icon: "images/popUp/info_img.png", title: "Nueva versin", message: ["Hay una nueva versin de tocAd","Deseas actualizar la aplicacin ahora?"]}, 
							{ 
									left: {
									text: msg["softmenu.update"],
									actions: "toctoc.updateApp('"+lv.downloadUrl+"');"
								},
								right: {
									text: msg["softmenu.later"],
									actions: "toctoc.goHome();softMenu.hide();"
								}
							}
						);					
					
				}
				return true;
			}
		} 
		return false;

	},
	
	updateApp: function(url) {
		this.showConnectingPopUp(
					{icon: "images/popUp/mundo.png", 
					 title: "Actualizando...", 
					 message: ["Ahora se cerrar tocAd.","Sigue las instrucciones que aparecern en pantalla."]
					}, 
					{}
				);

		if (this.timer) clearTimeout(this.timer);
		this.timer = setTimeout("toctoc.gotoUpdateURL('"+url+"');", 4000);
	},
	
	gotoUpdateURL: function(url) {
		trace("going to: "+url);
		player.request(url,true);
	},
	
	/**
	 * Comprueba la informacin de usuario recibida.
	 * @param info Objeto de informacin de usuario
	 */
	checkUserInfo: function(info) {
		// TODO: Implementar lgica de chequeo...
		
		if (info.userInfo) {
			
			if (!info.userInfo.userPreferences.active) {
				player.close("intro");
				this.hideProgressBar();
				trace("loading library: js/form.js");
				document.library.load("form","js/form.js").send();
				this.showInfoPopUp({message: ["Ests dado de baja en tocAd","Deseas disfrutar de nuevo del servicio?"]}, 
					{ 
							left: {
							text: msg["softmenu.yes"],
							actions: "toctoc.activateUser();"
						},
						right: {
							text: msg["softmenu.no"],
							actions: "player.exit();"
						}
					}
				);
				
			} else {
				this.loadUserFeed();
			}
		} else {
			player.close("intro");
			this.loadWelcome();
		}
	},

	/**
	 * Inicia la precarga (prefetch) del bloque principal de anuncios del 
	 * usuario (feed). 
	 */
	loadUserFeed: function() {
		 
		trace (" ----- updateContents: "+toctoc.userInfo.updateContents);
		
//		if (!toctoc.userInfo.updateContents) {
//			this.hidePopUp();
//			this.hideProgressBar();
//			this.showMenu();
//			return;
//		}
		
//		try {
//			if (toctoc.userInfo.updateContents) {
//				this.consumedAds = {};
//				cache.save("toctoc/consumedAds",this.consumedAds);
//			}
//		} catch (err) {
//			trace(err);
//		}
		
		
		var self = this;
		var off = this.PROG_UI * 100;
//		var req = cache.prefetch(CONTENTS_URL + "/user_feed.php");
		var req = cache.prefetch(CONTENTS_URL + "/adsBlock.blk");
		req.onreadystatechange = function() {
			var p = (req.total > 0) 
					? parseInt(off + (1 - self.PROG_UI) * (req.loaded * 100 / req.total)) 
					: 100;
					
			trace("***********************    loaded: "+req.loaded+" total: "+req.total+" p: "+p);

			self.showProgressBar(p,65);
			
			if (req.readyState == 4) {
				if (req.status == 0 || req.status == 200 || req.status == 204 
						|| req.status == 304) {
					
					// TODO: Revisar la carga de los anuncios.
					// enviamos peticin adDownloadNotify
					if(req.loaded > 0 && toctoc.userInfo.updateContents) {
						
						try {
							self.consumedAds = {};
							cache.save("toctoc/consumedAds",self.consumedAds);
						} catch (err) {
							trace(err);
						}
												
						var req2 = new XMLHttpRequest();
						req2.open("GET", SERVER_URL + "/adDownloadNotify", true);
						req2.setRequestHeader("Cache-Control", "no-cache");
						req2.send();
					}
					
					self.showMenu();
				} else {
					trace("Error loading user feed.");
					self.showInfoPopUp({icon: "images/popUp/warning_img.png", 
			 			title: "tocAd",
			 			message: ["Servicio no disponible.","Intntalo de nuevo ms tarde."]}, 
						{
								left: {
									text: msg["softmenu.accept"],
									actions: "player.exit();"
								}
						});
				}
				self.hideProgressBar();
				player.close("intro");
			}
		};	
		this.showProgressBar(off,65);
//		req.setRequestHeader("Cache-Control", "no-cache");
		req.setRequestHeader("User-Agent",config.getSystemProperty("microedition.platform"));
		req.send();
	},
	

	/**
	 * Carga la pantalla de bienvenida para usuarios no registrados. 
	 */
	loadWelcome: function() {
		this.hideProgressBar();	
		this.showHeader(msg["bienvenida.welcome"],"",0);
		softMenu.show({
			left: {
				text: msg["softmenu.next"],
				actions: "toctoc.showRegisterForm()"
			},
			right: {
				text: msg["softmenu.cancel"],
				actions: "player.exit();"
			}
		});
		player.open("welcome.mcd", "content-frame");

	},

	exitConfirm: function() {
		softMenu.saveState();

		this.showInfoPopUp({message: ["Deseas salir de tocAd?"]},
				{
					left: {
					text: msg["softmenu.yes"],
					actions: "player.exit();"
					},
					right: {
					text: msg["softmenu.no"],
					actions: "toctoc.hidePopUp();"
					}
				});
	
	},
	
	/**
	 * Carga el formulario de personalizacin para el proceso de registro. 
	 */
	showProfileForm: function() {
		this.hidePopUp();
		this.showHeader(msg["profile.perfil"],msg["profile.conf"],0);
		softMenu.show({
			left: {
				text: msg["softmenu.next"],
				actions: "toctoc.showPreferencesForm()"
			},
		right: {
				text: msg["softmenu.cancel"],
				actions: "player.exit();"
			}
		});
		player.open("profile.jst", "content-frame");
	},

	/**
	 * Actualiza los datos de registro en funcin de los datos
	 * introducidos en el formulario.
	 */
	updateRegistryInfo: function() {
	   var date = new Date();
	   date.setTime(0);
	   var e = document.getElementById("date");
	   var yText=null;
	   var mText=null;
	   var dText=null;
	   var gender=null;
	   var pText=null;
	   var rText=null;
	   var gender=null;
	   
	   if(tactileVersion){
	      yText=e.yearElem.year.text;
		  mText=e.monthElem.month.text-1;
		  dText=e.dayElem.day.text;
		  e = document.getElementById("sexo");
		  if (e.hombreClip.hombre.active)gender="male";
		  else if (e.mujerClip.mujer.active)gender="female";
		  pText=document.getElementById("pais").paisText.text;
		  rText=document.getElementById("region").regionText.text;
       }
       else{
	      yText=e.yearElem.year.value;
		  mText=e.monthElem.month.value-1;
		  dText=e.dayElem.day.value;
		  e = document.getElementById("sexo");
		  if (e.hombre.active)gender="male";
		  else if (e.mujer.active)gender="female";
		  pText = document.getElementById("country").value;
		  rText = document.getElementById("region").value;
		 }
	      date.setYear(yText);
		  date.setMonth(mText);
		  date.setDate(dText);
		  
	      toctoc.userInfo.userInfo.DOB = date;
		  toctoc.userInfo.userInfo.country = pText;
		  toctoc.userInfo.userInfo.gender = gender;
		  toctoc.userInfo.userInfo.province = rText;	
	},
	
	/**
	 * Actualiza los datos de ajustes en funcin de los datos
	 * introducidos en el formulario.
	 */
	updateSettings: function() {

		// Se actualizan los datos del usuario con respecto a lo introducido en el formulario
//		for (var adtype in toctoc.userInfo.userInfo.userPreferences.adtypes) {
		for (var i = 0; i<toctoc.userInfo.userInfo.userPreferences.adtypes.length; i++) {
			
			var adtype = toctoc.userInfo.userInfo.userPreferences.adtypes[i];
			if(adtype.visible) {
				adtype.active = document.getElementById("adt_"+adtype.Id).check.active;
			}
		}
		
		var profElem = document.getElementById("profile");
		if (profElem.when_everyday.check.active) 
			toctoc.userInfo.userInfo.userPreferences.adtiming = "everyday";
		else if (profElem.when_weekdays.check.active)
			toctoc.userInfo.userInfo.userPreferences.adtiming = "weekdays";
		else if (profElem.when_weekends.check.active)
			toctoc.userInfo.userInfo.userPreferences.adtiming = "weekend";
		profElem = null;
	},
	
	/**
	 * Actualiza las preferencias del usuario en funcin de los datos
	 * introducidos en el formulario.
	 */
	updatePreferences: function() {
		// Se actualizan los datos del usuario con los valores introducidos en el formulario
//		for (var tag in toctoc.userInfo.userInfo.tags) {
		for (var i = 0; i<toctoc.userInfo.userInfo.tags.length; i++) {
			var tag = toctoc.userInfo.userInfo.tags[i];
			try {
				tag.active = document.getElementById("tag_"+tag.Id).check.active;
			} catch (err) {
				trace("error actualizando tag: tag_"+tag.Id+": "+err);
			}
		}
	}, 
	
	/**
	 * Carga el formulario de personalizacin para el proceso de registro. 
	 */
	showPreferencesForm: function() {

		this.updateSettings();
		
		toctoc.userInfo.isNewUser = true;
		
		this.showHeader(msg["profile.perfil"],msg["profile.interesa"],0);
		softMenu.show({
			left: {
				text: msg["softmenu.end"],
				actions: "toctoc.sendPreferences()"
			},
			right: {
				text: msg["softmenu.cancel"],
				actions: "player.exit();"
			}
		});
		player.open("preferences.jst", "content-frame");
	},

	/**
	 * Actualiza los datos del perfil del usuario
	 */
	validateRegistry: function() {
		
		var errmsg = toctoc.form.validateRegisterForm();
		if (errmsg) {
			softMenu.saveState();
			this.showInfoPopUp({message: [errmsg]},{
			left: { text: msg["softmenu.accept"], actions: "toctoc.hidePopUp();" }});
		}
		else {
			this.updateRegistryInfo();
			this.updateUserInfo(this.form.getExtendedUserInfoJSON(this.userInfo.userInfo));
		}
	},
	
	/**
	 * Actualiza los datos del perfil del usuario
	 */
	sendSettings: function() {
		
		this.updateSettings();
		this.updateUserInfo(this.form.getExtendedUserInfoJSON(this.userInfo.userInfo));
	},

	/**
	 * Actualiza las preferencias del usuario 
	 */
	sendPreferences: function() {
		
		this.updatePreferences();
		this.updateUserInfo(this.form.getExtendedUserInfoJSON(this.userInfo.userInfo));
	},
	
	/**
	 * Enva al servidor los datos del usuario para actualizarlos. 
	 */
	updateUserInfo: function(data,isActivating) {
		var self = this;
		// Se realiza la peticin inicial de obtencin de datos e informacin de 
		// usuario
		var req = new XMLHttpRequest();
		req.open("POST", SERVER_URL + "/updateUserInfo", true);
		req.onreadystatechange = function() {
			var p = (req.total > 0) 
					? parseInt(self.PROG_UI * (req.loaded * 100 / req.total)) 
					: (self.PROG_UI * 100);
			if (req.readyState == 4) {
				var error = false;
				if (req.status == 0 || req.status == 200 || req.status == 204 || req.status == 304) {
					try {
						var points = 0; 
						if (req.responseText) {
							var info = eval("(" + req.responseText + ")");
							if(!isActivating || toctoc.userInfo.isNewUser)
								points = info.points.total - self.userInfo.points.total;
							
							self.userInfo.userInfo = info;
							self.userInfo.points = info.points;
						}
						var popupInfo = null;
						if (toctoc.userInfo.isNewUser) {
							popupInfo = {
								 	message: ["Gracias por indicarnos tus preferencias.","Recuerda que puedes actualizarlas en la seccin Mi perfil de la aplicacin."]};
							if (points) {
								popupInfo.message[2]=msg["thanks.points"].replace("${points}", points);
							}
							toctoc.userInfo.updateContents = true;
							self.showInfoPopUp(popupInfo,
									{
										left: {
										text: msg["softmenu.accept"],
										actions: "toctoc.loadUserFeed();toctoc.showProgressPopup('Cargando anuncios...');"
									}
								});
						} else if (info.userPreferences.active){
							if (!isActivating) {
								popupInfo = {icon: "images/popUp/ok_img.png",
										title: "Mi perfil",
									 	message: ["Tus preferencias se han guardado correctamente."]};
								if (points) {
									popupInfo.message[1]=msg["thanks.points"].replace("${points}", points);
								}
								self.showInfoPopUp(popupInfo,
									{
										left: {
										text: msg["softmenu.accept"],
										actions: "toctoc.hidePopUp();toctoc.showPrefsMenu();"
									}
								});
							} else {
								toctoc.userInfo.updateContents = true;
								popupInfo = {
									 	message: ["Gracias por darte de alta en tocAd","Recuerda que puedes actualizar tus preferencias en la seccin Mi perfil de la aplicacin."]};
								self.showInfoPopUp(popupInfo,
									{
										left: {
										text: msg["softmenu.accept"],
										actions: "toctoc.loadUserFeed();toctoc.showProgressPopup('Cargando anuncios...');"
									}
								});
							}
						} else {
							popupInfo = {icon: "images/popUp/ok_img.png",
									title: "tocAd",
								 	message: ["Ya ests dado de baja.","Recuerda que te puedes volver a dar de alta ejecutando la aplicacin de nuevo."]};
							self.showInfoPopUp(popupInfo,
								{
									left: {
									text: msg["softmenu.close"],
									actions: "player.exit();"
								}
							});
						}
						
						
					} catch (err) {
						error = true;
						trace("Error reading user info: " + err);
						// TODO: Mostrar pantalla de error
					}
				} else {
					error = true;
					trace("Error loading user info.");
					// TODO: Mostrar pantalla de error
				}
				
				if (error) {
					var action = "toctoc.hidePopUp();toctoc.showMenu();";
					if (toctoc.userInfo.isNewUser || isActivating) {
						toctoc.userInfo.updateContents = true;
						action = "toctoc.loadUserFeed();toctoc.showProgressPopup('Cargando anuncios...');";
					}
					
					if(toctoc.retry_registro) {
						toctoc.retry_registro=false;
						self.showInfoPopUp({icon: "images/popUp/warning_img.png", 
				 			title: "Mi perfil",
				 			message: ["No se han podido guardar tus preferencias.","Reintentar?"]}, 
							{
									left: {
										text: "Si",
										actions: "toctoc.validateRegistry();"
									},
									right: {
										text: "No",
										actions: action
									}
							});
					} else {
						self.showInfoPopUp({icon: "images/popUp/warning_img.png", 
				 			title: "Mi perfil",
				 			message: ["No se han podido guardar tus preferencias.","Intntalo de nuevo ms tarde."]}, 
							{
									left: {
										text: msg["softmenu.accept"],
										actions: action
									}
							});
					}
				}
			}
		};
		this.showEsperarPopUp();
		req.setRequestHeader("Cache-Control", "no-cache");
		req.setRequestHeader("Content-Type", "application/json");
		trace(this.form.getExtendedUserInfoJSON(this.userInfo.userInfo));
		req.send(data);
		
	},
	
	goHome: function() {
		this.hidePopUp();
		this.checkUserInfo(this.userInfo);
	},
	
	/**
	 * Carga el formulario de registro. 
	 */
	showRegisterForm: function() {
		this.showHeader(msg["register.alta"],msg["register.datospers"],0);
		softMenu.show({
			left: {
				text: "Siguiente",
				actions: "form.validate();"
			},
			right: {
				text: "Cancelar",
				actions: "player.exit();"
			}
		});
		player.open("registerForm.jst", "content-frame");

	},
	
	/**
	 * Pregunta si quiere personalizar ahora el servicio
	 */
	showProfileQuestion: function() {
		
		this.showInfoPopUp(
			{
	 			message: ["A continuacin, indcanos tus preferencias para que las ofertas y promociones que recibas se ajusten a tus gustos. Recuerda que puedes actualizar tus preferencias en la seccin Mi Perfil de la aplicacin."]
			},{
				left: {
					text: msg["softmenu.customize"],
					actions: "toctoc.showProfileForm()"
				},
				right: {
					text: msg["softmenu.later"],
					actions: "toctoc.showProfileReminder();"
				}
	 		});
	},
	
	/**
	 * Muestra el recordatorio para personalizar el servicio. 
	 */
	showProfileReminder: function() {
		
		toctoc.userInfo.updateContents = true;
		this.showInfoPopUp(
				{
		 			message: ["No olvides que recibirs toques y nuestras ofertas se ajustarn ms a tus gustos si actualizas tus intereses en la seccin Mi perfil"]
				},{
					left: {
					text: "Continuar",
					actions: "toctoc.loadUserFeed();toctoc.showProgressPopup('Cargando anuncios...');"
				}
		 		});
	},
	
		
	/** 
	 * Muestra el men principal de opciones.
	 */
	showMenu: function() {
//		var points = 0;
//		try { points = this.userInfo.points.total; } catch (err) {}
//		this.showHeader("",points);
//		this.showHeader2("", msg["menu.points"],1);
		this.showHeader(msg["mainmenu.header"], msg["menu.points"], this.getPoints());
		this.hidePopUp();
		softMenu.show({
			left: this.SM_LEFT, 
			right: {
				text: msg["softmenu.close"],
				actions: "toctoc.exitConfirm();"
			}
		});
		
//		document.getElementById("sm-left-options").option0.text0.text=msg["softmenu.volume_"+document.volume];
		
		player.open("menu.jst", "content-frame");
	},

	/**
	 * Actualiza el valor de los puntos del usuario.
	 */
	getPoints: function() {
		var points = 0;
		try { points = this.userInfo.points.total; } catch (err) {}
		return points;
		
	},
	
	/**
	 * Muestra el men de Mi Perfil
	 */
	showPrefsMenu: function() {

		player.open("prefsmenu.jst", "content-frame");
		this.showHeader(msg["profile.perfil"],msg["mainmenu.header"],0);
		softMenu.show({
			left: this.SM_LEFT,
			right: {  
				text: msg["softmenu.back"],
				actions: "toctoc.showMenu();"
			}
		});
		
	},
	
	
	/**
	 * Muestra el men de Mi Perfil
	 */
	showRegisterMenu: function() {

		player.open("registerForm.jst", "content-frame");
		softMenu.show({
			left: {  
				text: msg["softmenu.back"],
				actions: "toctoc.showMenu();"
			},
			right: {
				text: msg["softmenu.close"],
				actions: "toctoc.exitConfirm();"
			}
		});
		
	},
	
	/** 
	 * Muestra la lista de "bites" de anuncio.
	 */
	showBites: function() {
		
		if (this.timer) clearTimeout(this.timer);
		this.timer = null;
		this.currentAdDesc = null;

		var ads = this.loadAds();
		if (!ads || ads.length == 0) {
			this.showInfoPopUp({message: ["No tienes anuncios en este momento.","Intntalo de nuevo ms tarde.]"]},
					{	
						left: {
							text: msg["softmenu.accept"],
							actions: "toctoc.showMenu();"
						}
					});
			return;
		}
		
		this.showHeader(msg["bites.advice"],msg["menu.points"],this.getPoints());
		softMenu.show({
			left: this.SM_LEFT, 
			right: {
				text: msg["softmenu.back"],
				actions: "toctoc.showMenu();"
			}
		});
		player.open("bites.jst", "content-frame");
	},
	
	/** 
	 * Muestra los puntos del usuario
	 */
	showPoints: function() {
		this.showHeader("",msg["mainmenu.mypoints"],0);
		softMenu.show({
			right: {
				text: msg["softmenu.back"],
				actions: "toctoc.showMenu();"
			}
		});
		player.open("points.jst", "content-frame");
	},
	
	/** 
	 * Muestra los puntos del usuario
	 */
	showAyuda: function() {
		softMenu.close();
		this.showHeader(msg["menu.help"],"",0);
		softMenu.show({
			right: {
				text: msg["softmenu.atras"],
				actions: "toctoc.showMenu();"
			}
		});
		player.open("ayuda.mcd", "content-frame");
	},
	
	/** 
	 * Muestra la pantalla de informacin acerca de la aplicacin.
	 */
	showAbout: function() {
		softMenu.close();
		this.showHeader(msg["softmenu.about"],"",0);
		softMenu.show({
			right: {
				text: msg["softmenu.accept"],
				actions: "toctoc.showMenu();"
			}
		});
		player.open("about.mcd", "content-frame");
	},

	/**
	 * Carga la lista de anuncios.
	 */
	loadAds: function() {
		
		var url = CONTENTS_URL + "/adsDescription.js";
		var req = new XMLHttpRequest();
		req.open("GET", url, false);
		req.setRequestHeader("Cache-Control", "no-revalidate,only-if-cached");
		req.send();
		var err = false;
		if ((req.status == 0 || req.status == 200 || req.status == 204 || req.status == 304) && 
				req.error != null && req.responseText != null) {
			var ads = [];
			try {
				trace("adsDescription: "+req.responseText);
				ads = eval("(" + req.responseText + ")");
				if (ads) {
					ads = ads.ads;
				}
				// No hay anuncios, se trata como error.
				if (ads.length == 0)
					err = true;
			} catch (e) {
				err = true;
				trace("Error reading ads: " + e);
				// TODO: Mostrar pantalla de error
			}
			if (!err) return ads;
		} else {
			err = true;
			trace("Error loading ads.");
			// TODO: Mostrar pantalla de error
		}
		return null;
	},

	 /* Inicia la precarga (prefetch) del bloque de recursos del anuncio 
	 * especificaddo.
	 * @param id Identificador de anuncio
	 */
   loadAdBlock: function(id) {
      var self = this;
	  var url = CONTENTS_URL + "/" + id + "/"+id+".blk";
	  var req = cache.prefetch(url);
	  req.onreadystatechange = function() {
	  var p = (req.total > 0)? parseInt(req.loaded * 100 / req.total): 100;	
	  trace("***********************    loaded: "+req.loaded+" total: "+req.total+" p: "+p);
			
      if(tactileVersion){
         self.showProgressBar(p,50);
      }		
      else{
         self.showProgressBar(p);
      }
      
	  if (req.readyState == 4) {
	     self.hideProgressPopUp();
		 var err = false;
		 try {
		    if (req.status == 0 || req.status == 200 || req.status == 204 || req.status == 304) {			
			   if (self.loadAdDesc(id)) {
			      // lanzamos peticin asncrona
			      self.consumeBite('click2Next');			
				  self.showSnack();
			   } 
			   else err = true;
			} else {
			   trace("Error loading ad block.");
			   err = true;		
			}
		    
		   } catch(e) {
		      err = true;
		   }
		   if (err) {
              if(tactileVersion){
	             self.showInfoPopUp({icon: "images/popUp/warning_img.png",message: ["No se ha podido cargar el anuncio.","Intntalo de nuevo ms tarde"]}, 
			   			            {left: { text: msg["softmenu.accept"], actions: "toctoc.hidePopUp();toctoc.showBites();" }});
               }
               else{
	    	      self.showInfoPopUp({icon: "images/popUp/warning_img.png", message: ["No se ha podido cargar el anuncio.","Intntalo de nuevo ms tarde"]}, 
			    			         {left: { text: msg["softmenu.accept"], actions: "toctoc.hidePopUp()" }});
               }
		    }
		  }
		};
		
		this.showProgressPopup("Cargando anuncio...");
		req.send();
	},

	/** 
	 * Carga la descripcin del anuncio especificado.
	 * @param id Identificador de anuncio
	 */
	loadAdDesc: function(id) {
		var url = CONTENTS_URL + "/" + id + "/description.js";
		var req = new XMLHttpRequest();
		req.open("GET", url, false);
		req.send();
		if ((req.status == 0 || req.status == 200 || req.status == 204 || req.status == 304) && 
				req.error != null && req.responseText != null) {
			try {
				trace("CurrentAdDesc: "+req.responseText);
				this.currentAdDesc = eval("(" + req.responseText + ")");
				this.currentAdDesc.Id = id;
				return true;
			} catch (err) {
				trace("Error reading ad description: " + err);
				// TODO: Mostrar pantalla de error
			}
		} else {
			trace("Error loading ad description.");
			// TODO: Mostrar pantalla de error
		}
		return false;
	},

	/**
	 * Busca en la descripcin del anuncio actual la vista del tipo especificada.
	 * @param type Tipo de vista especificada
	 * @return Objeto de la vista
	 */
	findAdView: function(type) {
		if (this.currentAdDesc && this.currentAdDesc.views) {
			for (var i = 0, views = this.currentAdDesc.views; i < views.length; i++) {
				if (views[i].viewType == type) {
					return views[i];
				}
			}
		}
		return null;
	},

	/**
	 * Muestra el "snack" del anuncio.
	 */
	showSnack: function() {
		this.hidePopUp();
		this.hideHeader();
		softMenu.show({
			left: { text: msg["softmenu.next"] },
			right: { text: msg["softmenu.close"], actions: "toctoc.closeSnack();" }
		});
		var view = toctoc.findView("snack",toctoc.currentAdDesc);
		
		if (view.viewContentType == "video") {
			trace("Iniciando prevent");
			player.preventScreensaver(true);
			trace("Iniciado prevent");
		}
		player.open("snack.jst", "content-frame");
	},

	
	/** 
	 * Inicia el contador de tiempo de visualizacin del "snack" del anuncio 
	 * actualmente seleccionado.
	 */
	startSnackTime: function() {
		var self = this;
		var resolvesLG = false;
		if(resolvesBugLG==true)resolvesLG=true;

		// var resolvesBugLG = false;
		var view = this.findView("snack",this.currentAdDesc);
		if (view.viewContentType == 'video') {
			var vid = document.getElementById('vid');
		 	var vplayer = vid.player;
		 	
		 	player.close("content-frame2");
		 	player.close("popup-frame2");
		 	
		 	document.fixtime = -1;
		 	//document.onHide = this.saveVideoState;
		 	//document.onShow = this.restoreVideoState;		 	
		    
		  vplayer.onreadystatechange = function(vplayer) {
		     var state = vplayer.readyState;
		     trace("state: " + state);
		    	
			 	var polling = document.getElementById("polling");
			 	if (polling) {
					if (state == 1) {
					     polling.play();
					} else if (state == 2 || state == 6  || state == 0) {
					     polling.stop();
					}
			 	}

			 	if(state == 3) {
		    		// STATE_INITIALIZING
		    		softMenu.showLoading();
		    		var cortina = document.getElementById('cortina'); 
		    		if (document.fixtime > 0) {
		    			cortina.loadt.text = "Continuando vdeo...";
		    		}
		    		cortina.active=true;
		    	} else if (state == 5) {
		    		// STATE_INITIALIZED
					// Estos eventos son reportados por el segundo video que cargamos para la correccin
					//msgElem.text="state: " + state + " Recuperando vdeo...";
		    		if (document.fixtime > 0) {
						trace('Tiempo a partir del cual se empezar a reproducir el video: ' + document.fixtime+ ' ms');
						vplayer.currentTime = document.fixtime;
						vplayer.play();
						document.fixtime = -1;
		    		}
		    	} else if (state == 1) {	
		    		// STATE_PLAYING
		    		if(resolvesLG){
		    			vplayer.pause();
		    		}
		    		if(toctoc.pauseNokiaS60==true){		  
		    		   //pausamos el S60 que ha cargado pero est bloqueado an
		 		       trace('pausando el nokiaS60');
		 		       softMenu.showLoading();
		    		   vplayer.pause();
		    		}
//	    			vplayer.muted = !audio.audio_enabled;
	    			vplayer.volume = audio.volume;
	    			document.fixtime = -1;
		    		softMenu.hideLoading();
		    		document.getElementById('cortina').active=false;
		    		if (config["video.refreshVideoBugFix"]) {
		    			trace("refresh Video: "+config["video.refreshVideoBugFix"]);
		    			document.getElementById('refresh').play();
		    		}
		    	} else if (state == 0) {
		    		// STATE_ENDED
		    		if (document.fixtime < 0) {
			    		self.showLastSnapshot();
			    		self.endSnackTime(true);
		    		}
//		    		vid.visible=false;
//		    		vplayer.visible=false;
//		    		vplayer.stop();
		    	} else if (state == 2) {
		    		// STATE_PAUSED
		    		if (!resolvesLG && document.fixtime < 0) {
		    			if(toctoc.pauseNokiaS60==false){
	          		       self.showLastSnapshot();
				    	   self.endSnackTime(true);			    	
				        }
			   	    }
		    		if(resolvesLG){
		    			resolvesLG = false;
		    			vplayer.play();
		    		}
		    	} else if (state == -10) {
		    		// STATE_ERROR

		    		softMenu.hideLoading();
		    		document.getElementById('cortina').active=false;
		    		
		    		if (document.fixtime == 0) return; 

		    		trace("loading error de video.");
			    	self.showInfoPopUp(
			    			{icon: "images/popUp/warning_img.png", 
					 			message: ["No se ha podido reproducir el anuncio.","Intntalo de nuevo ms tarde"]}, 
			    			{left: { text: msg["softmenu.accept"], actions: "toctoc.hidePopUp();toctoc.showBites();" }});
		    	}
		    };
		    
		    vplayer.onerror = function(vplayer) {
		    };
		    
		    
		    vplayer.onvolumechange = function(vplayer) {
		    	audio.volume = vplayer.volume;
		    	trace(" ---> Volume changed");
		    };
		    
		    
		    vplayer.onsizechange = function(vplayer) {
		    	trace(" ---> Size changed");
		    };
    		
		 	vplayer.play();
			
		}
		else {
			if (this.timer) {
				clearTimeout(this.timer);
				this.timer = null;
			}
			var time = view.arguments;
			if (!time) time = this.DEFAULT_SNACK_TIME;
			this.timer = setTimeout("toctoc.endSnackTime();", time * 1000);
		}
	},

	saveVideoState: function() {
		trace('OnHide');
		var vid = document.getElementById('vid');
	 	var vplayer = vid.player;
		var state = vplayer.readyState;
		if((state == 3)&& config["video.nokS60backgroundBugfix"]){
	      //Establecemos el flag para que el S60 no comience a reproducir hasta que no se desbloquee.		    
		  toctoc.pauseNokiaS60=true;	
		}
		else if((vplayer != 'undefined') && (state != 6) && (state != -1)){
			if(state != 0){
				try {
					document.fixtime = vplayer.currentTime;
					trace("Tiempo obtenido antes de cerrar el vdeo: " + document.fixtime + ' ms');
				} catch (err) {
					document.fixtime = 0;
				}
			} else {
				document.fixtime = vplayer.duration -100;
			}			
			
			if (document.fixtime == 0) {
				trace('Cierre del video en el evento hideNotify()');
				vplayer.stop();
			} else { 
				if (config["video.nokS60backgroundBugfix"]) {
					vplayer.stop();
				} else {
					vplayer.pause();
				}
			}
		}
	},
	
	restoreVideoState: function() {
       trace('OnShow');
       
	   if (document.fixtime != -1){
	      var vid = document.getElementById('vid');
		  var vplayer = vid.player;
		  var state = vplayer.readyState;	  
		  if (document.fixtime == 0) {
		     vplayer.play();
		  } 
		  else {
		     if (config["video.nokS60backgroundBugfix"]) { 
			    trace('Apertura del video en el evento showNotify()');			
				vplayer.initialize();	
			 } else {
			    trace('Continuacin del video en el evento showNotify()');			
				if(tactileVersion)vplayer.currentTime = document.fixtime;
				vplayer.play();
				document.fixtime = -1;
			 }
		  }
		}
	   else{
		  var vid = document.getElementById('vid');
		  var vplayer = vid.player;
		  var state = vplayer.readyState;
		  if(state==2 && config["video.nokS60backgroundBugfix"]){
		     if(toctoc.pauseNokiaS60==true){
				toctoc.pauseNokiaS60=false;
				vplayer.play();
			 }
		  }		   
	   }
	},
	
	releaseVideo: function() {
//	 	delete document.onHide;
//	 	delete document.onShow;
	 	delete document.fixtime;
		var snapshot = document.getElementById('snapshot-clip');
		if (snapshot) {
			document.library.unload("snapshot");
			snapshot.active=false;
		}
		var vid = document.getElementById('vid');
	 	var vplayer = vid.player;
		vid.visible=false;
		try {
    		vplayer.visible=false;
			vplayer.stop();
		} catch (err) {
			trace("error: "+err);
		}
	},
	
	/** 
	 * Finaliza la visualizacin del "snack" del anuncio actual. 
	 */
	endSnackTime: function(force) {
		if ((this.timer || force) && this.currentAdDesc) {
			try {
				clearTimeout(this.timer);
				this.timer = null;
			} catch (err) {}
			

			
			softMenu.show({
				left: { text: msg["softmenu.next"], actions: "toctoc.consumeSnack();" },
				right: { text: msg["softmenu.close"], actions: "toctoc.closeSnack();" }
			});
		    if (this.timer) clearTimeout(this.timer);
		    this.timer = setTimeout("toctoc.showBites();", 10000);
		}
	},

	showLastSnapshot: function () {
		trace("param: "+config["video.lastSnapShotBugFix"]);
		var view = this.findView("snack",this.currentAdDesc);
		
		if (config["video.lastSnapShotBugFix"]) {
			var snapshot = document.getElementById('snapshot-clip');
			var vid = document.getElementById('vid');
			if (snapshot && vid) {
				trace("showing image...");
		
			 	var vplayer = vid.player;
	    		vid.visible=false;
	    		try {
		    		vplayer.visible=false;
	    			vplayer.stop();
	    		} catch (err) {
	    			trace("error: "+err);
	    		}
	    		if (config["video.delayLastSnapShotLoad"] == "true") {
					trace("creating snapshot entry...");
					var lreq = document.library.load("snapshot",CONTENTS_URL+ "/" + toctoc.currentAdDesc.Id + "/"+view.lastSnapShot);
					lreq.onreadystatechange = function() {
						if (lreq.readyState == 4) {
							snapshot.write("<image id='snapshot' ref='snapshot'/>");
							trace("activating snapshot...");
							snapshot.active = true;
						}
					};
					lreq.send();
	    		} else {
					trace("activating snapshot...");
	    			snapshot.active = true;
	    		}
			}
		}
	},
	
	/** 
	 * Muestra el pop-up de puntos conseguidos despus de la visualizacin del 
	 * "snack" del anuncio. 
	 * @param ticket
	 */
	showSnackPopUp: function(ticket) {
		var view = this.findView("meal",this.currentAdDesc);

		if (!view || view.viewContentType == "none" || !view.content) {
			this.showThanksPopUp(msg["thanks.snack"], (ticket ? ticket.points : 0), {
				left: { text: msg["softmenu.seeagain"], actions: "toctoc.consumeMeal('seeAgain');toctoc.showSnack();" },
				right: { text: msg["softmenu.close"], actions: "toctoc.showBites();toctoc.hidePopUp();" }
			});
		} else {
			this.showThanksPopUp(msg["thanks.snack"], (ticket ? ticket.points : 0), {
				left: { text: msg["softmenu.accept"], actions: "toctoc.closeSnackPopUp();" }
			});
		}
	},

	/**
	 * Cierra el pop-up de puntos conseguidos despus de la visualizacin del 
	 * "snack" del anuncio. 
	 */
	closeSnackPopUp: function() {
		this.hidePopUp();
		this.showMeal();
	},

	/**
	 * Cierra la pantalla de visualizacin del "snack" del anuncio. 
	 */
	closeSnack: function() {
		clearTimeout(this.timer);
		this.timer = null;
		var view = this.findView("snack",this.currentAdDesc);
		if (view.viewContentType == 'video') {
			this.releaseVideo();
		}
		this.currentAdDesc = null;
		this.showBites();
	},

	/**
	 * Muestra las interacciones del anuncio sobre el "meal". 
	 */
	showMeal: function() {
		var view = this.findView("meal",this.currentAdDesc);

		if (view && view.viewContentType != "none") {
			player.open("meal.jst", "content-frame");
			softMenu.show({
				left: { text: msg["softmenu.seeagain"], actions: "toctoc.consumeMeal('seeAgain');toctoc.showSnack();" },
				right: { text: msg["softmenu.close"], actions: "toctoc.showBites();toctoc.hidePopUp();" }
			});
		} else {
			this.showBites();
		}
	},

	/**
	 * Emite la notificacin del ticket de consumicin del "snack" del anuncio. 
	 */
	consumeSnack: function() {

		player.preventScreensaver(true);
		clearTimeout(this.timer);
		this.timer = null;
		
		trace("consume snack .....");
		var self = this;
		var interaction = this.findInteraction("snack","click2Next",this.currentAdDesc);
		var url = SERVER_URL + "/consumeTicket?ticketId=" + interaction.ticket;
		var req = new XMLHttpRequest();
		softMenu.showLoading();
		req.open("GET", url, true);
		req.onreadystatechange = function() {
			if (req.readyState == 4) {
				softMenu.hideLoading();
				var view = self.findView("snack",self.currentAdDesc);

				if (view.viewContentType == 'video') {
					toctoc.releaseVideo();
				}
				self.consumedAds[self.currentAdDesc.Id] = true;
				trace ("------------- storing id as viewed: "+self.currentAdDesc.Id);
				cache.save("toctoc/consumedAds",self.consumedAds);
				if ((req.status == 0 || req.status == 200) && req.error != null && req.responseText != null) {
					var ticket = eval("(" + req.responseText + ")");
					if (ticket && ticket.points)
						self.userInfo.points.total += ticket.points;
					self.showSnackPopUp(ticket);
				} else {
					trace("Error consuming snack.");
					self.showSnackPopUp({points: 0});
					// TODO: Mostrar pantalla de error
				}
			}
		};
		req.setRequestHeader("Cache-Control", "no-cache");
		req.send();
	},

	/**
	 * Emite la notificacin del ticket de consumicin del "snack" del anuncio. 
	 */
	consumeMeal: function(interactionName) {
		trace("consume meal .....");
		var self = this;
		var interaction = this.findInteraction("meal",interactionName,this.currentAdDesc);
		if (interaction) {
			var url = SERVER_URL + "/consumeTicket?ticketId=" + interaction.ticket;
			var req = new XMLHttpRequest();
			req.open("GET", url, true);
			req.onreadystatechange = function() {
				if (req.readyState == 4) {
					// Se suman los puntos si ha habido respuesta.
					if ((req.status == 0 || req.status == 200 || req.status == 204 || req.status == 304) && 
							req.error != null && req.responseText != null) {
						var ticket = eval("(" + req.responseText + ")");
						if (ticket && ticket.points)
							self.userInfo.points.total += ticket.points;
					} 
				}
			};
			req.setRequestHeader("Cache-Control", "no-cache");
			req.send();
		}
	},
	
	consumeBite: function(interactionName) {
		trace("consume bite .....");
		var self = this;
		var interaction = this.findInteraction("biterect",interactionName,this.currentAdDesc);
		if (interaction) {
			var url = SERVER_URL + "/consumeTicket?ticketId=" + interaction.ticket;
			var req = new XMLHttpRequest();
			req.open("GET", url, true);
//			req.onreadystatechange = function() {
//				if (req.readyState == 4) {
//					// Se suman los puntos si ha habido respuesta.
//					if ((req.status == 0 || req.status == 200 || req.status == 204 || req.status == 304) && 
//							req.error != null && req.responseText != null) {
//						var ticket = eval("(" + req.responseText + ")");
//						if (ticket && ticket.points)
//							self.userInfo.points.total += ticket.points;
//					} 
//				}
//			};
			req.setRequestHeader("Cache-Control", "no-cache");
			req.send();
		}
	},
	
	/**
	 * Actualiza el contador con el anuncio seleccionado en el menu de bites
	 */
	updateBiteFocused: function(current,total) {
		var t=document.getElementById('biteLabel');
		if (t)
			t.text = current+"/"+total;
		
	},
	
	
	// -------------------------------------------------------------------------
	/**
	 * Informa del coste de la llamada y pide confirmacin.
	 * @param phone Nmero de telfono especificado  
	 */
	click2CallConfirm: function(phone) {
		softMenu.saveState();
		this.showInfoPopUp(
				{icon: "images/popUp/info_img.png", message: ["Esta llamada se tarificar segn tu tarifa actual.","Deseas continuar?"]},
				{
					left: { text: msg["softmenu.yes"], actions: "toctoc.click2Call('"+phone+"');" },
					right: { text: msg["softmenu.no"], actions: "toctoc.hidePopUp();" }
				});
	},
	
	recomConfirm: function(phone) {

		this.showInfoPopUp(
				{icon: "images/popUp/info_img.png", message: ["Esta conexin se tarificar segn tu tarifa actual.","Deseas continuar?"]},
				{
					left: { text: msg["softmenu.yes"], actions: "toctoc.sendRecom('"+phone+"');" },
					right: { text: msg["softmenu.no"], actions: "toctoc.hidePopUp();" }
				});
	},

	/**
	 * Inicia una llamada de telfono al nmero especificado.
	 * @param phone Nmero de telfono especificado  
	 */
	click2Call: function(phone) {
		this.showConnectingPopUp({icon: "images/popUp/telefono.png", title: "Llamada", message: ["Llamando al telfono:",phone]}, 
				{
					right: { text: msg["softmenu.cancel"], actions: "toctoc.cancelMealTimer();" }
				});

		if (this.timer) clearTimeout(this.timer);
		this.timer = setTimeout("toctoc.makeCall('"+phone+"');", 3000);

		softMenu.show();
	},
	
	cancelMealTimer: function() {
		
		trace("clearing timeout..."+this.timer);
		
		if (this.timer) clearTimeout(this.timer);
		this.timer = null;
		this.hidePopUp();
		softMenu.show({
			left: { text: msg["softmenu.seeagain"], actions: "toctoc.consumeMeal('seeAgain');toctoc.showSnack();" },
			right: { text: msg["softmenu.close"], actions: "toctoc.showBites();" }
		});
	},
	
	makeCall: function(phone) {
		this.consumeMeal("click2Call");
		player.request("tel:"+phone,false);
		this.cancelMealTimer();
	},


	/**
	 * Informa del coste del SMS y pide confirmacin.
	 * @param text Texto del mensaje  
	 * @param phone Nmero de telfono  
	 */
	click2SMSConfirm: function(text,phone) {
		softMenu.saveState();
		
		this.showInfoPopUp(
		{icon: "images/popUp/info_img.png", message: ["Este mensaje se tarificar segn tu tarifa actual.","Deseas continuar?"]},
		{
			left: { text: msg["softmenu.yes"], actions: "toctoc.click2SMS('"+text+"','"+phone+"');"},
			right: { text: msg["softmenu.no"], actions: "toctoc.hidePopUp();"}
		});
	},
	
	/**
	 * Inicia el envo de un mensaje corto (SMS) con el texto especificado.
	 * @param sms Texto del mensaje  
	 */
	click2SMS: function(text,phone) {
		this.showConnectingPopUp({icon: "images/popUp/sobres.png", title: "SMS", message: ["Enviando SMS al nmero:",phone]}, 
					{
						right: { text: msg["softmenu.cancel"], actions: "toctoc.cancelMealTimer();" }
					});
			
		if (this.timer) clearTimeout(this.timer);
		this.timer = setTimeout("toctoc.sendSMS('"+text+"','"+phone+"','click2SMS');", 3000);
	},

	
	sendSMS: function(text,phone,interactionId) {
		this.consumeMeal(interactionId);
		try {
			Message.send(phone,text);
			this.showInfoPopUp({icon: "images/popUp/ok_img.png", message: ["El mensaje ha sido enviado."]}, 
					{left: { text: msg["softmenu.accept"], actions: "toctoc.hidePopUp();"}});
		} catch (err) {
			this.showInfoPopUp({icon: "images/popUp/warning_img.png", message: ["El mensaje no ha podido ser enviado."]}, 
					{left: { text: msg["softmenu.accept"], actions: "toctoc.hidePopUp();"}});
		}
//		this.cancelMealTimer();
	},
	
	/**
	 * Informa del coste de conexin y pide confirmacin.
	 * @param text Texto del mensaje  
	 * @param phone Nmero de telfono  
	 */
	click2URLConfirm: function(url) {
		softMenu.saveState();
		this.showInfoPopUp(
				{icon: "images/popUp/info_img.png", message: ["Esta sesin de navegacin se tarificar segn tu tarifa actual.","Deseas continuar?"]},
				{
					left: { text: msg["softmenu.yes"], actions: "toctoc.click2URL('"+url+"');"},
					right: { text: msg["softmenu.no"], actions: "toctoc.hidePopUp();"}
				});
	},
	
	/**
	 * Inicia la apertura de la URL especificada.
	 * @param url Direccin URL especificada  
	 */
	click2URL: function(url) {
		this.showConnectingPopUp({icon: "images/popUp/mundo.png", title: "Conexin", message: ["Accediendo a:",url]}, 
				{
					right: { text: msg["softmenu.cancel"], actions: "toctoc.cancelMealTimer();" }
				});
		
		if (this.timer) clearTimeout(this.timer);
		this.timer = setTimeout("toctoc.gotoURL('"+url+"');", 3000);
	},
	
	gotoURL: function(url) {
		this.consumeMeal("click2Url");
		player.request(url,false);
		this.cancelMealTimer();
	},
	

	/**
	 * Inicia la recomendacin a un amigo. 
	 * @param text Mensaje opcional 
	 */
	click2Recommend: function(text) {
		this.showRecomPopUp({
			left: { text: msg["softmenu.send"], actions: "toctoc.validateAndSendSMS('"+text+"');" },
			right: { text: msg["softmenu.cancel"], actions: "toctoc.hidePopUp();" }
		},"Introduce el telfono al que quieres recomendar el anuncio:");
	},

	
	/**
	 * Informa del coste de conexin y pide confirmacin.
	 * @param url URL de la peticin  
	 */
	click2XConfirm: function(url) {
		softMenu.saveState();
		this.showInfoPopUp(
				{icon: "images/popUp/info_img.png", message: ["Esta conexin se tarificar segn tu tarifa actual.","Deseas continuar?"]},
				{
					left: { text: msg["softmenu.yes"], actions: "toctoc.click2X('"+url+"');"},
					right: { text: msg["softmenu.no"], actions: "toctoc.hidePopUp();"}
				});
	},
	
	/**
	 * Inicia el procesamiento de una peticin a la URL especificada.   
	 * @param url Direccin URL especificada  
	 */
	click2X: function(url) {
		var self = this;
		var req = new XMLHttpRequest();
		req.open("GET", url, true);
		
		req.onreadystatechange = function() {
			if (req.readyState == 4) {
				var error = false;
				if ((req.status == 0 || req.status == 200 || req.status == 204 || req.status == 304) && req.responseText != null) {
					try {
						var points = 0; 
						try {
							if (req.responseText != null) {
								var info = eval("(" + req.responseText + ")");
								points = info.points;
								self.userInfo.points.total += points;
							}
						} catch (t) {}
						var popupInfo = {
								 	message: ["Tu peticin se ha realizado con xito."]};
						if (points) {
							popupInfo.message[1]=msg["thanks.points"].replace("${points}", points);
						}
						self.showInfoPopUp(popupInfo,
							{
								left: {
								text: msg["softmenu.accept"],
								actions: "toctoc.hidePopUp();"
							}
						});
						self.consumeMeal("click2X");
						
					} catch (err) {
						error = true;
						trace("Error reading click2X response: " + err);
						// TODO: Mostrar pantalla de error
					}
				} else {
					error = true;
					trace("Error in click2X.");
					// TODO: Mostrar pantalla de error
				}
				if (error) {
					self.showInfoPopUp({icon: "images/popUp/warning_img.png", 
			 			message: ["No se han podido realizar tu peticin.","Intntalo de nuevo ms tarde."]}, 
						{
								left: {
									text: msg["softmenu.accept"],
									actions: "toctoc.hidePopUp();"
								}
						});
				}
			}
		};
		this.showEsperarPopUp();
		req.setRequestHeader("Cache-Control", "no-cache");
		req.send();
	},
	
	/**
	 * Valida que el nmero de telfono sea vlido y hace el envo.
	 * @param text Mensaje opcional 
	 */
	validateAndSendSMS: function(text) {
	   var n = document.getElementById("num");
	   var pText=null;
       if(tactileVersion){
          pText=n.text;
       }
       else{
          pText=n.value; 	 
	   }
       if (n && !pText) {
	      var i = document.getElementById("info");
	      if (i) i.text = "Introduce un nmero de telfono vlido.";
	   } else {
	      var phone = pText;
	      this.showInfoPopUp(
	      {icon: "images/popUp/info_img.png", message: ["Este mensaje se tarificar segn tu tarifa actual.","Deseas continuar?"]},
		  {left: { text: msg["softmenu.yes"], actions: "toctoc.startSMSTimer('"+text+"','"+phone+"','click2Recommend');"},
		   right: { text: msg["softmenu.no"], actions: "toctoc.hidePopUp();"}
	      });
	   }
     
       
       
       
	},
	
	/**
	 * Valida que el nmero de telfono sea vlido y hace el envo.
	 * @param text Mensaje opcional 
	 */
	validateAndRecomendTocToc: function(){
	   var n = document.getElementById("num");      
	   var nText=null;
       if(tactileVersion){
          nText=n.text;
       }
       else{
          nText=n.value;	      
       }
       if (n && !nText) {
	      var i = document.getElementById("info");
		  if (i) i.text = "Introduce un nmero de telfono vlido.";
	   } 
	   else {
	      toctoc.recomConfirm(nText);
	   }
	},
	
	sendRecom: function(phone) {
		var self = this;
		this.phoneNumb=phone;

		var req = new XMLHttpRequest();
		var recomURL = this.userInfo.config.recommendFriendUrl;
		recomURL = recomURL.replace("{friend}",phone);
		req.open("GET", recomURL, true);
		req.setRequestHeader("Cache-Control", "no-cache");
		req.send();
		
		document.recomendReq = new XMLHttpRequest();
		document.recomendReq.open("GET", SERVER_URL + "/recommendToFriend?userId="+this.userInfo.userInfo.Id+"&friendId="+phone, true);
		// document.recomendReq.open("POST", "http://127.0.0.1/timeout.php", true);
		document.recomendReq.onabort=function() {
			toctoc.recomTocToc();
		};
		document.recomendReq.onreadystatechange = function() {
			if (document.recomendReq.readyState == 4 && document.recomendReq.status != 0) {
				var error = false;
				if (document.recomendReq.status == 0 || document.recomendReq.status == 200 || document.recomendReq.status == 204 || document.recomendReq.status == 304) {
					try {
						var points = 0;
						if (document.recomendReq.error != null && document.recomendReq.responseText != null) {
							var info = eval("(" + document.recomendReq.responseText + ")");
							points = info.points;
							self.userInfo.points.total += info.points;
						}
						var popupInfo = {
								 	message: ["Gracias por recomendar el servicio Movistar tocAd."]};
							if (points) {
								popupInfo.message[1]=msg["thanks.points"].replace("${points}", points);
								toctoc.showHeader(msg["mainmenu.header"],msg["menu.points"],toctoc.getPoints());
							}
							
							self.showInfoPopUp(popupInfo,
								{
									left: {
									text: msg["softmenu.accept"],
									actions: "toctoc.hidePopUp();toctoc.cleanPhoneNumb();"
								}
							});
					} catch (err) {
						error = true;
						trace("Error reading user info: " + err);
						// TODO: Mostrar pantalla de error
					}
				} else {
					error = true;
					trace("Error loading user info.");
					// TODO: Mostrar pantalla de error
				}
				if (error) {
					self.showInfoPopUp({icon: "images/popUp/warning_img.png", 
			 			title: "Recomendar tocAd",
			 			message: ["No se han podido realizar tu peticin.","Intntalo de nuevo ms tarde."]}, 
						{
								left: {
									text: msg["softmenu.accept"],
									actions: "toctoc.hidePopUp();toctoc.showMenu();toctoc.cleanPhoneNumb();"
								}
						});
				}
			}
		};
		this.showEsperarWhileSMSPopUp(null);
		document.recomendReq.setRequestHeader("Cache-Control", "no-cache");
		document.recomendReq.send();
	},
	
	
	
	startSMSTimer: function(text, phone, interactionId)  {
		this.showConnectingPopUp({icon: "images/popUp/sobres.png", title: "SMS", message: ["Enviando SMS al nmero:",phone]}, 
				{
					right: { text: msg["softmenu.cancel"], actions: "toctoc.cancelMealTimer();" }
				});

		if (this.timer) clearTimeout(this.timer);
		this.timer = setTimeout("toctoc.sendSMS('"+text+"','"+phone+"','"+interactionId+"');", 3000);
	},

	// -------------------------------------------------------------------------
	
	/**
	 * Muestra la cabecera de pgina.
	 * @param title 		Titulo de cabecera o seccin
	 * @param subtitle 		Subttulo de cabecera o seccin
	 * @param points 		Puntos del usuario 
	 */
	showHeader: function(title, subtitle, points) {
		var e = document.getElementById("header");
		if (e && !e.active) {
			e.active = true;
		}
		if (typeof title != "undefined") {
			this.setHeaderTitle(title);
		}
		if (typeof subtitle != "undefined") {
			if (points) {
				subtitle = subtitle.replace("${points}",points);
			}
			this.setHeaderSubtitle(subtitle);
		}	
	},

	/**
	 * Establece el texto de cabecera o seccin.
	 * @param title Texto de cabecera o seccin
	 */
	setHeaderTitle: function(title) {
		var e = document.getElementById("header-title");
		if (e)
			e.text = title;
	},

	/**
	 * Establece el texto de cabecera o seccin.
	 * @param title Texto de cabecera o seccin
	 */
	setHeaderSubtitle: function(title) {
		var e = document.getElementById("header-subtitle");
		if (e)
			e.text = title;
	},

	

	/**
	 * Oculta la cabecera de pgina.
	 */
	hideHeader: function() {
		var e = document.getElementById("header");
		if (e && e.active) {
			e.active = false;
		}	
	},

	/**
	 * Muestra la barra de progreso.
	 * @param p Porcentaje de progreso inicial
	 */
	showProgressBar: function(p, topPos) {
		var e = document.getElementById("progress-bar");
		if (e) {
			if (!topPos) {
				topPos = 65; // default value
			}
			e.style.top = topPos + "%";
			if (!e.active) {
				e.active = true;
			}
			if (!p) {
				p = 0;
			}
			e.stop(p);
		}
	},

	/**
	 * Oculta la barra de progreso
	 */
	hideProgressBar: function() {
		var e = document.getElementById("progress-bar");
		if (e) {
			e.active = false;
		}
	},

	// -----------------------------------------------------------------------------
	
	showSucessPopUp: function() {
		
	},
	
	/**
	 * Muestra un Pop-Up de agradecimiento por consumo de ticket con el texto y 
	 * puntos obtenidos.
	 */
	showThanksPopUp: function(text, points, actions) {
		
		var info = {message: [text]};
		if (points)
			info.message[1]=msg["thanks.points"].replace("${points}", points);
		
		this.showInfoPopUp(info,actions);
/*		var out =	"<text fontRef=\"font_14_bold\" style='line-wrap:true; halign: center;width: 83%'>" + text + "</text>\n" ;
		if (points) {
			trace(" ----> "+msg["thanks.points"].replace("${points}", points)+" -- "+points);
			
			out += "<text fontRef=\"font_14_bold\" style='line-wrap:true;top: 60px; halign: center;width: 83%'>\n" + 
						msg["thanks.points"].replace("${points}", points) + "</text>\n";
		}

		var e = document.getElementById("popup-frame");
		if (!e.active) {
			e.active = true;
		}
		
		var e2 = document.getElementById("popup-frame2");
		if (e2) {
			e2.write(out);
			if (!e2.active) {
				e2.active = true;
			}
		}
		softMenu.show(actions);*/
	},
	
	recomTocToc: function() {
		
		this.showRecomPopUp({
			left: { text: msg["softmenu.send"], actions: "toctoc.validateAndRecomendTocToc();" },
			right: { text: msg["softmenu.cancel"], actions: "toctoc.hidePopUp();toctoc.cleanPhoneNumb();" }
		},"Introduce el telfono al que quieres recomendar tocAd:");
		
	},
	
	/**
	 * Muestra un Pop-Up pinchando en "Recomendar tocAd" en la pagina menu.jst 
	 */
	showRecomPopUp: function(actions,text) {

		toctoc.popupInfo = {icon: "images/popUp/sobres.png",
				 title: "Recomienda a un amigo",
				 message: [text]};
		
		player.open("recom_popup.jst","popup-frame2");
	
		var e = document.getElementById("popup-frame");
		if (!e.active) {
			e.active = true;
		}

//		player.focus('num');
	
		if(this.phoneNumb == '') {
			softMenu.saveState();
		}
		softMenu.show(actions);
	},
	
	
	showConnectingPopUp: function(info, actions) {
		toctoc.popupInfo = info;
		player.open("connecting_popup.jst","popup-frame2");
	
		var e = document.getElementById("popup-frame");
		if (!e.active) {
			e.active = true;
		}
		softMenu.show(actions);
	},
	
	
	/**
	 * Muestra un Pop-Up de espera durante la ejecucin de una transaccin 
	 * 
	 */
	showEsperarPopUp: function(actions) {
		toctoc.popupInfo = null;
		softMenu.showEmpty();
		player.open("wait_popup.mcd","popup-frame2");
	
		var e = document.getElementById("popup-frame");
		if (!e.active) {
			e.active = true;
		}
		
		softMenu.show();
		player.repaint();	
	},
	
	showEsperarWhileSMSPopUp: function(actions) {
		softMenu.showEmpty();
		player.open("wait_popup.mcd","popup-frame2");
	
		var e = document.getElementById("popup-frame");
		if (!e.active) {
			e.active = true;
		}
		
		softMenu.show({
			right: {
				text: msg["softmenu.cancel"],
				actions: "document.recomendReq.abort();"
			}
		});
		
		player.repaint();
	},
		
   showBorder: function(frameId) {
      if(tactileVersion){
	     var out = 
		    "<image ref=\"fondot\" resize=\"false\" style=\"width: 90%; top:57;right:0\"/>" + 
			"<image ref=\"fondol\" resize=\"true\" style=\"bottom:51;top:80\"/>" +
			"<image ref=\"fondotl\" resize=\"false\" style=\"top:57; left:0\"/>" +
			"<image ref=\"fondobl\" resize=\"false\" style=\"bottom:32; left:0\"/>" +
			"<image ref=\"fondob\" style=\"width: 90%; bottom:32;right:0\" resize=\"false\"/>";
	  }	
	  else{
	     var out = 
		    "<image ref=\"fondot\" resize=\"false\" style=\"width: 90%; top:57;right:0\"/>" + 
			"<image ref=\"fondol\" resize=\"false\" style=\"height:61%;top:80\"/>" +
			"<image ref=\"fondotl\" resize=\"false\" style=\"top:57; left:0\"/>" +
			"<image ref=\"fondobl\" resize=\"false\" style=\"bottom:20; left:0\"/>" +
			"<image ref=\"fondob\" style=\"width: 90%; bottom:20;right:0\" resize=\"false\"/>";
	     }	
		 if (!frameId) {
		    frameId = "border-frame";
		 }
			
		 var e = document.getElementById(frameId);
		 if (e) {
		    e.write(out);
			if (!e.active) {
			   e.active = true;
			}
	  }
   },
	
	/**
	 * Para eligir cual mensaje insear
	 */
	
	/**
	 * Muestra un Pop-Up de informacin
	 */
//	showInfoPopUp: function(text, actions) {
//		var out ="<text fontRef=\"font_14_bold\" style='line-wrap:true;halign: center;width: 83%; top:10%'>" + text + "</text>";
//				
//		var e = document.getElementById("popup-frame");
//		if (!e.active) {
//			e.active = true;
//		}
//		
//		var e2 = document.getElementById("popup-frame2");
//		if (e2) {
//			e2.write(out);
//			if (!e2.active) {
//				e2.active = true;
//			}
//		}
//		softMenu.show(actions);
//	},

	
		
   showProgressPopup: function(text) {
      softMenu.showEmpty();
	  toctoc.popupInfo = {message: text};
	  player.open("progress_popup.jst","popup-frame2");
	  var e = document.getElementById("popup-frame");
	  if (!e.active) {
	     e.active = true;
	  }
	  
	  if(tactileVersion){
	     this.showProgressBar(0,50);
	  }
	  else{
	     this.showProgressBar(0);
	  }
	  softMenu.show();
   },
	
	
	/**
	 * Muestra un Pop-Up de informacin
	 */
	showInfoPopUp: function(info, actions) {
//		player.close("intro");
		toctoc.popupInfo = info;
		player.open("info_popup.jst","popup-frame2");
	
		var e = document.getElementById("popup-frame");
		if (!e.active) {
			e.active = true;
		}
		softMenu.show(actions);
	},
	
	hideProgressPopUp: function() {
		this.hideProgressBar();
		this.hidePopUp();
	},
	 
	/**
	 * Cierra el Pop-Up.
	 */
	hidePopUp: function() {
		player.preventScreensaver(false);
		toctoc.popupInfo = null;
		softMenu.restoreState();
		var e = document.getElementById("popup-frame");
		if (e && e.active) {
			e.active = false;
		}
		player.close("popup-frame2");
	},
	
	
	/**
	 * Carga el formulario de registro para usuarios registrados 
	 */
	showRegistry: function() {
		this.showHeader(msg["profile.perfil"],msg["register.datospers"], 0);
		softMenu.show({
			left: {
				text: "Aceptar",
				actions: "toctoc.validateRegistry();"
			},
			right: {
				text: "Cancelar",
				actions: "toctoc.showPrefsMenu();"
			}
		});
		player.open("registerForm.jst", "content-frame");
	},
	
	/**
	 * Carga el formulario de configuracin para usuarios registrados 
	 */
	showSettings: function() {
		this.showHeader(msg["profile.perfil"],msg["profile.conf"], 0);
		softMenu.show({
			left: {
				text: "Aceptar",
				actions: "toctoc.sendSettings();"
			},
			right: {
				text: "Cancelar",
				actions: "toctoc.showPrefsMenu();"
			}
		});
		player.open("profile.jst", "content-frame");
		
	},

	/**
	 * Carga el formulario de preferencias para usuarios registrados 
	 */
	showLikes: function() {
		this.showHeader(msg["profile.perfil"],msg["profile.interesa"], 0);
		softMenu.show({
			left: {
				text: "Aceptar",
				actions: "toctoc.sendPreferences();"
			},
			right: {
				text: "Cancelar",
				actions: "toctoc.showPrefsMenu();"
			}
		});
		player.open("preferences.jst", "content-frame");
	},
	
	confirmUnregister: function() {
		softMenu.saveState();
		this.showInfoPopUp({message: ["Ests seguro que quieres darte de baja de tocAd?"]}, 
			{ 
					left: {
					text: msg["softmenu.yes"],
					actions: "toctoc.unregisterUser();"
				},
				right: {
					text: msg["softmenu.no"],
					actions: "toctoc.hidePopUp();"
				}
			}
		);
	},
	
	unregisterUser: function() {
		//angelfs|->>solucin bug
		toctoc.userInfo.isNewUser = false;
		toctoc.userInfo.userInfo.userPreferences.active = false;
		this.updateUserInfo(this.form.getExtendedUserInfoJSON(this.userInfo.userInfo));
	},

	activateUser: function() {
		toctoc.userInfo.userInfo.userPreferences.active = true;
		this.updateUserInfo(this.form.getExtendedUserInfoJSON(this.userInfo.userInfo),true);
	},
	
	
	activateSK_rightForDeleting: function(inputText,registered) {
		var input=document.getElementById(inputText);
		
		if(input.value != null && input.value != "") {
			if(registered) {
				softMenu.show({
					left: {
						text: "Aceptar",
						actions: "toctoc.validateRegistry();"
					},
					right: {
						text: msg["softmenu.delete"],
						actions: "toctoc.deleteLetter(\"" + inputText + "\"," + registered + ");"
					}
				});
			} else {
				softMenu.show({
					left: {
						text: "Siguiente",
						actions: "form.validate();"
				},
					right: {
						text: msg["softmenu.delete"],
						actions: "toctoc.deleteLetter(\""+ inputText +"\"," + registered + ");"
					}
				});
			}
		}
	},

	deActivateSK_rightForDeleting: function(registered) {
		softMenu.restoreDeletingState();
	},
	
	changeSK_right: function(textInput,registered) {
		var input=document.getElementById(textInput);

		if((input.value != null || input.value == "0") && input.value != "") {
			toctoc.activateSK_rightForDeleting(textInput,registered);
		} else {
			toctoc.deActivateSK_rightForDeleting(registered);
		}
	},
	
	changeSK_rightRecomPopUp: function() {
       var input=document.getElementById('num');
       var iText=null;
	   if(tactileVersion){
	      iText=input.text; 
	   }
	   else{
	      iText=input.value;		   
	   }
	   if(iText != null && iText != "") {
	      softMenu.state.right.text = msg["softmenu.delete"];
		  softMenu.state.right.actions ="toctoc.deleteLetter(\"num\",true);";
		  softMenu.refresh();
	   } else {
		  softMenu.state.right.text = msg["softmenu.cancel"];
		  softMenu.state.right.actions ="toctoc.hidePopUp();toctoc.cleanPhoneNumb();";
		  softMenu.refresh();
	   }
	   
	   
	},
	
	deleteLetter: function(inputText,registered) {
		var input=document.getElementById(inputText);
		input.deleteChars();
		if(inputText == 'country') {
//			loader.getCountries();
			loader.changeInputCountry(registered);
		} else if(inputText == 'region') {
//			loader.loadCities();
			loader.changeInputCity(registered);
		} else if(inputText == 'day' || inputText == 'month' || inputText == 'year') {
			if(input.value == "")
				toctoc.deActivateSK_rightForDeleting(registered);
		} else if(inputText == 'num') {
			if(input.value == "") {
				softMenu.show({
					left: { text: msg["softmenu.send"], actions: "toctoc.validateAndRecomendTocToc();" },
					right: { text: msg["softmenu.cancel"], actions: "toctoc.hidePopUp();toctoc.cleanPhoneNumb();" }
				});
			}
		}
	},
	
	findView: function(viewType, ad) {
		for (var i=0; i<ad.views.length; i++) {
			if (ad.views[i].viewType==viewType) {
				return ad.views[i];
			}
		}
		return null;
	},
	
	
	findInteraction: function(viewType, interactionType, ad) {
		var view = this.findView(viewType,ad);
		if (view) {
			for (var j=0; j<view.interactions.length; j++) {
				if (view.interactions[j].interactionType == interactionType) {
					return view.interactions[j];
				}
			}
		}
		return null;
	},
	
	playRegisterAudio: function() {
		
		if(audio.audio_enabled) {
			if(toctoc.userInfo.userInfo) {
				audio.playAudio('audio/registered.amr');
			} else {
				audio.playAudio('audio/unregistered.amr');
			}
		}
	},
	
	cleanPhoneNumb: function() {
		toctoc.phoneNumb='';
	}
	
};

trace("------------------------------- cargando main.js ---------------------------");

// Creacin del objeto
var toctoc = new TocToc();

//AlarmRegistry.setAlaram(new Date().getTime()+60000);

