/*
 * Decompiled with CFR 0.152.
 */
class CVEngine
extends FGEngine {
    public static final int DATA_VERSION = 7;
    public static final int TERRAINMOD_FLAT = 0;
    public static final int TERRAINMOD_SHALLOWHILL = 1;
    public static final int TERRAINMOD_STEEPHILL = 2;
    public static final int NUM_TERRAINMODS = 3;
    public static final int CIV_ROMANS = 0;
    public static final int CIV_JAPANESE = 1;
    public static final int CIV_RUSSIANS = 2;
    public static final int CIV_AMERICANS = 3;
    public static final int NUM_CIVS = 4;
    public static final int ERA_ANCIENT = 0;
    public static final int ERA_FEUDAL = 1;
    public static final int ERA_REN = 2;
    public static final int ERA_MODERN = 3;
    public static final int NUM_ERAS = 4;
    public static final int CONFRESP_SOUNDOFF = 0;
    public static final int CONFRESP_SOUNDON = 1;
    public static final int SND_THEME = 1;
    public static final int SND_UNIT_DIES = 2;
    public static final int SND_ART_FIRE = 3;
    public static final int SND_ART_HIT = 4;
    public static final int SND_MODMOB_KILL = 5;
    public static final int SND_UNIT_CREATE = 6;
    public static final int SND_RAGNED_KILL = 7;
    public static final int SND_LOSE_LEVEL = 8;
    public static final int SND_WIN_LEVEL = 9;
    public static final int SND_START_LEVEL = 10;
    public static final int SND_TECH_SELECT = 11;
    public static final int SND_WALL_DIES = 12;
    public static final int TIME_SOUND_DELAY = 500;
    public static final int CAMPAIGN_UNDEFINED = -100;
    public static final int MAX_HIGH_SCORES = 10;
    public static final int LANGUAGE_ENGLISH = 0;
    public static final int LANGUAGE_FRENCH = 1;
    public static final int LANGUAGE_ITALIAN = 2;
    public static final int LANGUAGE_GERMAN = 3;
    public static final int LANGUAGE_SPANISH = 4;
    public static final int NUM_LANGUAGES = 5;
    public static final int COLOR_GL_MENUSELECTOR = 7954517;
    public static final int CHEAT_ACTIVATE_CHEATS = 1;
    public static final int CHEAT_BYPASS_MRC = 2;
    public boolean sndOn;
    public int yOffset = 0;
    static boolean bWait = false;
    private static FGString m_log = new FGString();
    boolean bMoreGamesExit = false;
    public FGResLoader m_loader = new FGResLoader();
    public CVLoadingMode m_loadingMode = new CVLoadingMode();
    public CVUIMode m_UIMode = new CVUIMode();
    public CVGameMode m_gameMode = new CVGameMode();
    public FGLayout m_splash = new FGLayout();
    public FGModeManager m_modeManager = new FGModeManager();
    public FGFont m_mainFont = new FGFont();
    public FGFont m_titleFont = new FGFont();
    public FGStringManager m_strings = new FGStringManager();
    public int[][] m_unitPPS = new int[4][3];
    public int m_mobileForestPenalty;
    public int[] m_unitAttackTimes = new int[4];
    public int m_pushPct;
    public int m_rangedRange;
    public int[] m_plrWallHPs = new int[3];
    public int[] m_enemyWallHPs = new int[3];
    public int m_fortHPPct;
    public int m_rangedOdds;
    public int[] m_unitCosts = new int[4];
    public int m_foodBase;
    public int m_foodPerFarm;
    public int m_oreBase;
    public int m_orePerMine;
    public int m_artilleryCost;
    public int m_artilleryImpactWidth;
    public int m_artilleryPPS;
    public int m_artilleryGravity;
    public int m_artilleryWallDamage;
    public int m_artilleryFoodDestroy;
    public int m_artilleryOreDestroy;
    public int m_artilleryPowerPeriod;
    public int m_artilleryAnglePeriod;
    public int m_forcedMapID;
    public int m_campaignLevelsPerEra;
    public int m_japanMobileCost;
    public int m_japanRangedCost;
    public int m_russiaInfantryCost;
    public int m_russiaMobileCost;
    public int m_usaRangedCost;
    public int m_usaBonusTechLevels;
    public int m_maxFood;
    public int m_maxOre;
    public int m_meleeOdds;
    public int m_foodStart;
    public int m_oreStart;
    public int m_qpFProd;
    public int m_qpOProd;
    public int m_qpArtMiss;
    public int m_satelliteTechSpeed;
    public int m_playerMTechStart;
    public int m_playerSTechStart;
    public int m_playerETechStart;
    public int m_enemyMTechStart;
    public int m_enemySTechStart;
    public int m_enemyETechStart;
    public int m_campaignPlayerCiv;
    public int m_campaignLevel = -100;
    public int m_campaignDifficulty;
    public int[] m_campaignMTech = new int[2];
    public int[] m_campaignSTech = new int[2];
    public int[] m_campaignETech = new int[2];
    public int[] m_techValues = new int[30];
    public int[] m_difficultyLevels = new int[3];
    FGString m_softkeyLeft = new FGString();
    FGString m_softkeyCenter = new FGString();
    FGString m_softkeyRight = new FGString();
    public FGImage m_softkeyButtonCap;
    public FGImage m_softkeyButtonTile;
    public FGImage m_leftArrow;
    public FGImage m_softkeyBackArrow;
    public FGImage m_softkeyPause;
    public FGImage[] m_portraits = new FGImage[4];
    FGCheats m_cheats = new FGCheats();
    boolean m_bCheats;
    FGTweaks m_levelTable = new FGTweaks();
    boolean m_bShowedTutorial;
    boolean m_bHardModeUnlocked;
    FGTimer m_campaignPlayTime = new FGTimer();
    int[] m_highScores = new int[10];
    int[] m_hsDifficulties = new int[10];
    int m_currentLanguage;
    int m_defaultLanguage;
    boolean[] m_bLanguagesSupported = new boolean[5];
    FGTimer m_soundTimer = new FGTimer();
    boolean m_bCanSave;

    static boolean isLarge() {
        return FGProjectSettings.isLarge();
    }

    static boolean isMedium() {
        return FGProjectSettings.isMedium();
    }

    static boolean isSmall() {
        return FGProjectSettings.isSmall();
    }

    public CVEngine() {
        for (int i = 0; i < 10; ++i) {
            this.m_highScores[i] = -1;
            this.m_hsDifficulties[i] = -1;
        }
        this.m_bShowedTutorial = false;
        this.m_bHardModeUnlocked = false;
        this.m_bCanSave = false;
    }

    public int getDefaultLanguage() {
        return this.m_defaultLanguage;
    }

    public boolean isLanguageAvailable(int n) {
        return this.m_bLanguagesSupported[n];
    }

    public boolean isSingleLanguageBuild() {
        int n = 0;
        for (int i = 0; i < 5; ++i) {
            if (this.isLanguageAvailable(i)) {
                ++n;
            }
            if (n <= 1) continue;
            return false;
        }
        return true;
    }

    public void init() {
        this.m_cheats.registerCheat("7692004", 1);
        for (int i = 0; i < 5; ++i) {
            this.m_bLanguagesSupported[i] = true;
        }
        String string = this.getProperty("C2M-LangList");
        if (string != null) {
            FGString fGString = new FGString(string);
            if (fGString.indexOf("en-GB") == -1) {
                this.m_bLanguagesSupported[0] = false;
            }
            if (fGString.indexOf("fr-FR") == -1) {
                this.m_bLanguagesSupported[1] = false;
            }
            if (fGString.indexOf("it-IT") == -1) {
                this.m_bLanguagesSupported[2] = false;
            }
            if (fGString.indexOf("de-DE") == -1) {
                this.m_bLanguagesSupported[3] = false;
            }
            if (fGString.indexOf("es-ES") == -1) {
                this.m_bLanguagesSupported[4] = false;
            }
        }
        this.m_mainFont.init("smallfont.png", "smallfont.font");
        this.m_softkeyButtonCap = FGImage.createImage("buttonMenuL.png");
        this.m_softkeyButtonTile = FGImage.createImage("buttonMenuM.png");
        this.m_UIMode.init();
        this.m_loadingMode.init();
        this.m_UIMode.takeControlConfirm(8);
    }

    public void SetupInitialLanguageMenu() {
        this.m_UIMode.initInitialLanguageMenu();
        this.m_UIMode.takeControl(this.m_UIMode.m_languageMenu);
    }

    public void SetupInitialSoundConfirm() {
        this.load();
        this.m_bCanSave = true;
        this.m_UIMode.takeControlConfirm(0);
    }

    public void primaryInit() {
        this.m_bCheats = false;
        if (this.getSku().equals("SKU_J2SE") || this.getSku().equals("SKU_EMULATOR")) {
            this.m_bCheats = true;
        }
        this.prepSplash();
        this.getSoundManager().registerSound("theme.mid", 1);
        if (CVEngine.isLarge()) {
            this.m_titleFont.init("fontLarge.png", "fontLarge.font");
        } else {
            this.m_titleFont = this.m_mainFont;
        }
        this.m_levelTable.initTable("ltable.txt");
        FGTweaks fGTweaks = new FGTweaks();
        fGTweaks.init("tweaks.txt");
        this.m_unitPPS[0][0] = fGTweaks.getIntTweak("INFANTRY_PPS");
        this.m_unitPPS[1][0] = fGTweaks.getIntTweak("RANGED_PPS");
        this.m_unitPPS[2][0] = fGTweaks.getIntTweak("MOBILE_PPS");
        this.m_unitPPS[0][1] = fGTweaks.getIntTweak("INFANTRY_PPS_SHALLOWHILL");
        this.m_unitPPS[1][1] = fGTweaks.getIntTweak("RANGED_PPS_SHALLOWHILL");
        this.m_unitPPS[2][1] = fGTweaks.getIntTweak("MOBILE_PPS_SHALLOWHILL");
        this.m_unitPPS[0][2] = fGTweaks.getIntTweak("INFANTRY_PPS_STEEPHILL");
        this.m_unitPPS[1][2] = fGTweaks.getIntTweak("RANGED_PPS_STEEPHILL");
        this.m_unitPPS[2][2] = fGTweaks.getIntTweak("MOBILE_PPS_STEEPHILL");
        this.m_unitAttackTimes[0] = fGTweaks.getIntTweak("INFANTRY_ATTACK_TIME");
        this.m_unitAttackTimes[1] = fGTweaks.getIntTweak("RANGED_ATTACK_TIME");
        this.m_unitAttackTimes[2] = fGTweaks.getIntTweak("MOBILE_ATTACK_TIME");
        this.m_mobileForestPenalty = fGTweaks.getIntTweak("MOBILE_FOREST_PENALTY");
        this.m_pushPct = fGTweaks.getIntTweak("PUSH_PERCENT");
        this.m_rangedRange = fGTweaks.getIntTweak("RANGED_RANGE");
        this.m_plrWallHPs[0] = fGTweaks.getIntTweak("PLR_WALL_HPS_EASY");
        this.m_plrWallHPs[1] = fGTweaks.getIntTweak("PLR_WALL_HPS_MEDIUM");
        this.m_plrWallHPs[2] = fGTweaks.getIntTweak("PLR_WALL_HPS_HARD");
        this.m_enemyWallHPs[0] = fGTweaks.getIntTweak("ENEMY_WALL_HPS_EASY");
        this.m_enemyWallHPs[1] = fGTweaks.getIntTweak("ENEMY_WALL_HPS_MEDIUM");
        this.m_enemyWallHPs[2] = fGTweaks.getIntTweak("ENEMY_WALL_HPS_HARD");
        this.m_fortHPPct = fGTweaks.getIntTweak("FORT_HP_PCT");
        this.m_rangedOdds = fGTweaks.getIntTweak("RANGED_ODDS");
        this.m_meleeOdds = fGTweaks.getIntTweak("MELEE_ODDS");
        this.m_foodBase = fGTweaks.getIntTweak("FOOD_GAIN_BASE");
        this.m_foodPerFarm = fGTweaks.getIntTweak("FOOD_GAIN_PER_FARM");
        this.m_oreBase = fGTweaks.getIntTweak("ORE_GAIN_BASE");
        this.m_orePerMine = fGTweaks.getIntTweak("ORE_GAIN_PER_MINE");
        this.m_maxFood = fGTweaks.getIntTweak("FOOD_MAX");
        this.m_maxOre = fGTweaks.getIntTweak("ORE_MAX");
        this.m_foodStart = fGTweaks.getIntTweak("FOOD_START");
        this.m_oreStart = fGTweaks.getIntTweak("ORE_START");
        this.m_unitCosts[0] = fGTweaks.getIntTweak("INFANTRY_COST");
        this.m_unitCosts[1] = fGTweaks.getIntTweak("RANGED_COST");
        this.m_unitCosts[2] = fGTweaks.getIntTweak("MOBILE_COST");
        this.m_unitCosts[3] = 0;
        this.m_artilleryCost = fGTweaks.getIntTweak("ARTILLERY_COST");
        this.m_artilleryImpactWidth = fGTweaks.getIntTweak("ARTILLERY_IMPACT_WIDTH");
        this.m_artilleryPPS = fGTweaks.getIntTweak("ARTILLERY_PPS");
        this.m_artilleryGravity = fGTweaks.getIntTweak("ARTILLERY_GRAVITY_PPSPS");
        this.m_artilleryWallDamage = fGTweaks.getIntTweak("ARTILLERY_WALL_DAMAGE");
        this.m_artilleryFoodDestroy = fGTweaks.getIntTweak("ARTILLERY_FOOD_DESTROY");
        this.m_artilleryOreDestroy = fGTweaks.getIntTweak("ARTILLERY_ORE_DESTROY");
        this.m_artilleryPowerPeriod = fGTweaks.getIntTweak("ARTILLERY_POWER_PERIOD");
        this.m_artilleryAnglePeriod = fGTweaks.getIntTweak("ARTILLERY_ANGLE_PERIOD");
        this.m_forcedMapID = fGTweaks.getIntTweak("FORCE_MAPID");
        this.m_campaignLevelsPerEra = fGTweaks.getIntTweak("CAMPAIGN_LEVELS_PER_ERA");
        this.m_japanMobileCost = fGTweaks.getIntTweak("JAPAN_MOBILE_COST");
        this.m_japanRangedCost = fGTweaks.getIntTweak("JAPAN_RANGED_COST");
        this.m_russiaInfantryCost = fGTweaks.getIntTweak("RUSSIA_INFANTRY_COST");
        this.m_russiaMobileCost = fGTweaks.getIntTweak("RUSSIA_MOBILE_COST");
        this.m_usaRangedCost = fGTweaks.getIntTweak("USA_RANGED_COST");
        this.m_usaBonusTechLevels = fGTweaks.getIntTweak("USA_BONUS_TECH_LEVELS");
        this.m_difficultyLevels[0] = fGTweaks.getIntTweak("DIFF_EASY");
        this.m_difficultyLevels[1] = fGTweaks.getIntTweak("DIFF_MEDIUM");
        this.m_difficultyLevels[2] = fGTweaks.getIntTweak("DIFF_HARD");
        for (int i = 0; i < 30; ++i) {
            this.m_techValues[i] = 0;
        }
        this.m_techValues[1] = fGTweaks.getIntTweak("TECH_ROADS");
        this.m_techValues[2] = fGTweaks.getIntTweak("TECH_ARCHERY");
        this.m_techValues[3] = fGTweaks.getIntTweak("TECH_IRON");
        this.m_techValues[4] = fGTweaks.getIntTweak("TECH_CIVIL");
        this.m_techValues[18] = fGTweaks.getIntTweak("TECH_CHEMISTRY");
        this.m_techValues[7] = fGTweaks.getIntTweak("TECH_STEEL");
        this.m_techValues[8] = fGTweaks.getIntTweak("TECH_RADIO");
        this.m_techValues[9] = fGTweaks.getIntTweak("TECH_ADV_MUNITIONS");
        this.m_techValues[10] = fGTweaks.getIntTweak("TECH_AGRICULTURE");
        this.m_techValues[11] = fGTweaks.getIntTweak("TECH_MINING");
        this.m_techValues[12] = fGTweaks.getIntTweak("TECH_CURRENCY");
        this.m_techValues[13] = fGTweaks.getIntTweak("TECH_FEUDALISM");
        this.m_techValues[14] = fGTweaks.getIntTweak("TECH_GUILDS");
        this.m_techValues[16] = fGTweaks.getIntTweak("TECH_RIFLING");
        this.m_techValues[15] = fGTweaks.getIntTweak("TECH_DEMOCRACY");
        this.m_techValues[19] = fGTweaks.getIntTweak("TECH_MASSMEDIA");
        this.m_techValues[20] = fGTweaks.getIntTweak("TECH_MASONRY");
        this.m_techValues[21] = fGTweaks.getIntTweak("TECH_CONSTRUCTION");
        this.m_techValues[23] = fGTweaks.getIntTweak("TECH_MACHINERY");
        this.m_techValues[24] = fGTweaks.getIntTweak("TECH_ENGINEERING");
        this.m_techValues[25] = fGTweaks.getIntTweak("TECH_GUNPOWDER");
        this.m_techValues[26] = fGTweaks.getIntTweak("TECH_STEAM");
        this.m_techValues[6] = fGTweaks.getIntTweak("TECH_MEDICINE");
        this.m_techValues[28] = fGTweaks.getIntTweak("TECH_COMPOSITES");
        this.m_techValues[29] = fGTweaks.getIntTweak("TECH_SATELLITES_HIT");
        this.m_satelliteTechSpeed = fGTweaks.getIntTweak("TECH_SATELLITES_SPD");
        this.m_playerMTechStart = fGTweaks.getIntTweak("PLAYER_MTECH_START") - 1;
        this.m_playerSTechStart = fGTweaks.getIntTweak("PLAYER_STECH_START") - 1;
        this.m_playerETechStart = fGTweaks.getIntTweak("PLAYER_ETECH_START") - 1;
        this.m_enemyMTechStart = fGTweaks.getIntTweak("ENEMY_MTECH_START") - 1;
        this.m_enemySTechStart = fGTweaks.getIntTweak("ENEMY_STECH_START") - 1;
        this.m_enemyETechStart = fGTweaks.getIntTweak("ENEMY_ETECH_START") - 1;
        this.m_qpFProd = fGTweaks.getIntTweak("QP_FPROD");
        this.m_qpOProd = fGTweaks.getIntTweak("QP_OPROD");
        this.m_qpArtMiss = fGTweaks.getIntTweak("QP_ART_MISS");
        this.m_gameMode.init();
        this.registerNeededResources();
        this.getSoundManager().play(1);
    }

    public void playTheme() {
        this.getSoundManager().play(1);
    }

    public int getSoftkeyAreaHeight() {
        if (this.m_softkeyButtonCap == null) {
            return 0;
        }
        return this.m_softkeyButtonCap.getHeight();
    }

    public void drawSoftkeys(FGGraphics fGGraphics) {
        if (this.m_softkeyButtonCap == null) {
            return;
        }
        int n = 0;
        this.drawSoftkey(fGGraphics, this.m_softkeyLeft.getNativeString(), 0);
        n = this.getSoftkeyButtonWidth(this.m_softkeyCenter.getNativeString());
        this.drawSoftkey(fGGraphics, this.m_softkeyCenter.getNativeString(), (FGEngine.getScreenWidth() - n) / 2);
        n = this.getSoftkeyButtonWidth(this.m_softkeyRight.getNativeString());
        this.drawSoftkey(fGGraphics, this.m_softkeyRight.getNativeString(), FGEngine.getScreenWidth() - n);
    }

    private void drawSoftkey(FGGraphics fGGraphics, String string, int n) {
        if (FGString.nativeLength(string) == 0) {
            return;
        }
        int n2 = FGEngine.getScreenHeight() - this.m_softkeyButtonCap.getHeight();
        int n3 = this.m_mainFont.getDisplayLength(string);
        int n4 = n3 + 2 * this.m_softkeyButtonCap.getWidth();
        this.drawCappedElement(fGGraphics, n, n2, this.m_softkeyButtonCap, this.m_softkeyButtonTile, n4);
        int n5 = n2 + (this.m_softkeyButtonCap.getHeight() - this.m_mainFont.getHeight()) / 2;
        int n6 = n + n4 / 2;
        this.m_mainFont.setJustify(2);
        this.m_mainFont.drawText(fGGraphics, string, n6, n5);
        this.m_mainFont.setJustify(0);
        if (bWait) {
            if (FGEngine.touchX == -100) {
                bWait = false;
            } else {
                return;
            }
        }
        if (FGEngine.touchY >= n2 && FGEngine.touchY <= n2 + this.m_softkeyButtonCap.getHeight() && FGEngine.touchX >= n && FGEngine.touchX <= n + n4) {
            if (FGEngine.touchX < FGEngine.getScreenWidth() >> 1) {
                System.out.println("Left click");
                this.onKeyPressed(FGEngine.AVK_LEFT_SOFT);
                bWait = true;
            } else {
                System.out.println("Right click");
                this.onKeyPressed(FGEngine.AVK_RIGHT_SOFT);
                bWait = true;
            }
        }
    }

    private int getSoftkeyButtonWidth(String string) {
        if (this.m_softkeyButtonCap == null) {
            return 0;
        }
        if (FGString.nativeLength(string) == 0) {
            return 0;
        }
        int n = 2 * this.m_softkeyButtonCap.getWidth();
        return n += this.m_mainFont.getDisplayLength(string);
    }

    public void setSoftkeys(String string, String string2, String string3) {
        if (string == null) {
            this.m_softkeyLeft.set("");
        } else {
            this.m_softkeyLeft.set(string);
        }
        if (string2 == null) {
            this.m_softkeyCenter.set("");
        } else {
            this.m_softkeyCenter.set(string2);
        }
        if (string3 == null) {
            this.m_softkeyRight.set("");
        } else {
            this.m_softkeyRight.set(string3);
        }
    }

    public void onKeyPressed(int n) {
        int n2 = this.m_cheats.keyPressed(n);
        if (n2 == 1) {
            this.m_bCheats = !this.m_bCheats;
        } else if (n2 == 2 && this.m_UIMode != null) {
            this.m_UIMode.bypassMRC();
        }
        if (n == this.AVK_BACKSPACE) {
            n = FGEngine.AVK_RIGHT_SOFT;
        }
        if (n == 52) {
            n = FGEngine.AVK_LEFT;
        }
        if (n == 53) {
            n = FGEngine.AVK_FIRE;
        }
        if (n == 54) {
            n = FGEngine.AVK_RIGHT;
        }
        if (this.m_modeManager.getCurrentMode() != this.m_gameMode) {
            if (n == 50) {
                n = FGEngine.AVK_UP;
            }
            if (n == 56) {
                n = FGEngine.AVK_DOWN;
            }
        }
        this.m_modeManager.keyPressed(n);
    }

    public void postSoundConfirm() {
        this.m_UIMode.takeControlMRC();
    }

    public void postMRC() {
        this.m_loadingMode.takeControl(this.m_loader, 0);
    }

    public void onKeyReleased(int n) {
        this.m_modeManager.keyReleased(n);
    }

    public void onDrawSelf(FGGraphics fGGraphics) {
        this.m_modeManager.drawSelf(fGGraphics);
        this.drawSoftkeys(fGGraphics);
    }

    public void onMousePressed(int n) {
        this.m_modeManager.mousePressed(n);
    }

    public void onMouseReleased(int n) {
        this.m_modeManager.mouseReleased(n);
    }

    public void onMouseWheel(int n) {
        this.m_modeManager.mouseWheel(n);
    }

    public void onTick() {
        this.m_modeManager.tick();
    }

    public void log(String string) {
        m_log.add(string);
        FGData fGData = new FGData();
        fGData.adopt(m_log.getNativeString().getBytes(), m_log.length());
        this.getFileSystem().putFile("log.txt", fGData);
    }

    public void SetMoreGamesExit() {
        this.bMoreGamesExit = true;
    }

    public void onPause() {
        System.out.println("onPause");
        System.out.println(this.sndOn);
        if (this.bMoreGamesExit) {
            this.exitApp();
        }
    }

    public void onResume() {
        System.out.println("On resume");
        if (this.m_modeManager.m_nextAction == -1 && this.m_modeManager.getCurrentMode() == this.m_gameMode && this.m_gameMode.m_mode == 3) {
            this.m_UIMode.takeControl(this.m_UIMode.m_pauseMenu);
        }
        System.out.println("Setting sound " + this.sndOn);
        this.getSoundManager().init();
        this.getSoundManager().setSoundOn(this.sndOn);
        if (this.getSoundManager().getSoundOn()) {
            this.getSoundManager().startOverLastSoundPlayed();
        }
    }

    public void onExitApp() {
        if (!CVUIMode.bSavedAlready) {
            this.save();
        }
    }

    public void drawSplash(FGGraphics fGGraphics, boolean bl) {
        if (this.m_splash.getNumElements() == 0) {
            return;
        }
        int n = this.m_splash.getFirstIdx("title");
        this.m_splash.m_bNotes[n] = !bl;
        this.m_splash.drawSelf(fGGraphics, 0, 0);
        this.m_splash.m_bNotes[n] = false;
        FGFont fGFont = this.m_titleFont;
        if (System.currentTimeMillis() / 1000L % 2L == 0L) {
            fGFont.drawText(fGGraphics, "Demo", 195, 2);
        }
    }

    public void drawScreenTitle(FGGraphics fGGraphics, String string) {
        int n = FGEngine.getScreenWidth();
        FGFont fGFont = this.m_titleFont;
        int n2 = this.getScreenTitleHeight(string);
        int n3 = fGFont.getDisplayHeight(string, n);
        int n4 = (n2 - n3) / 2 + this.yOffset;
        fGFont.setJustify(2);
        fGFont.drawText(fGGraphics, string, 0, n4, n);
        fGFont.setJustify(0);
    }

    public int getScreenTitleHeight(String string) {
        int n = FGEngine.getScreenWidth();
        FGFont fGFont = this.m_titleFont;
        int n2 = fGFont.getDisplayHeight(string, n);
        int n3 = n2 + fGFont.getHeight();
        return n3;
    }

    public void prepSplash() {
        FGResLoader fGResLoader = new FGResLoader();
        this.m_splash.init("splash.lyt");
        this.m_splash.registerNeededImages(fGResLoader);
        fGResLoader.loadAllResources();
        this.m_splash.getNeededImages(fGResLoader);
        int n = FGEngine.getScreenWidth();
        int n2 = FGEngine.getScreenHeight();
        this.m_splash.m_width = n;
        this.m_splash.m_height = n2;
        int n3 = this.m_splash.getFirstIdx("image");
        this.m_splash.m_xValues[n3] = (n - this.m_splash.m_widths[n3]) / 2;
        this.m_splash.m_yValues[n3] = n2 - this.m_splash.m_heights[n3];
        int n4 = this.m_splash.getFirstIdx("title");
        this.m_splash.m_xValues[n4] = (n - this.m_splash.m_widths[n4]) / 2;
        this.m_splash.m_yValues[n4] = n2 <= 128 ? 1 : (this.m_splash.m_yValues[n3] - this.m_splash.m_heights[n4]) / 2;
        if (this.m_splash.m_yValues[n4] < 0) {
            this.m_splash.m_yValues[n4] = 0;
        }
    }

    public void registerNeededResources() {
        if (!CVEngine.isSmall()) {
            this.m_loader.registerImage("port_0.png");
            this.m_loader.registerImage("port_1.png");
            this.m_loader.registerImage("port_2.png");
            this.m_loader.registerImage("port_3.png");
            this.m_loader.registerImage("arrowLeft.png");
        }
        this.m_loader.registerImage("buttonBack.png");
        this.m_loader.registerImage("buttonPause.png");
        this.m_UIMode.registerNeededResources(this.m_loader);
        this.m_gameMode.registerNeededResources(this.m_loader);
        this.registerSounds();
    }

    public void getNeededResources() {
        if (!CVEngine.isSmall()) {
            this.m_portraits[0] = this.m_loader.getImage("port_0.png");
            this.m_portraits[1] = this.m_loader.getImage("port_1.png");
            this.m_portraits[2] = this.m_loader.getImage("port_2.png");
            this.m_portraits[3] = this.m_loader.getImage("port_3.png");
            this.m_leftArrow = this.m_loader.getImage("arrowLeft.png");
        }
        this.m_softkeyBackArrow = this.m_loader.getImage("buttonBack.png");
        this.m_softkeyPause = this.m_loader.getImage("buttonPause.png");
        this.m_UIMode.getNeededResources(this.m_loader);
        this.m_gameMode.getNeededResources(this.m_loader);
    }

    public void startNewCampaign(int n, int n2) {
        this.m_campaignPlayerCiv = n;
        this.m_campaignLevel = 0;
        this.setUpTechForCiv(0, this.m_campaignPlayerCiv);
        this.setUpTechForCiv(1, 0);
        this.m_campaignDifficulty = n2;
        this.m_campaignPlayTime.start(0);
        this.m_campaignPlayTime.pause();
        this.startCurrentWar();
        this.m_modeManager.setMode(this.m_gameMode);
    }

    public void setUpTechForCiv(int n, int n2) {
        this.m_campaignMTech[n] = -1;
        this.m_campaignSTech[n] = -1;
        this.m_campaignETech[n] = -1;
        if (n2 == 0) {
            this.m_campaignMTech[n] = 0;
            this.m_campaignSTech[n] = 0;
            this.m_campaignETech[n] = 0;
        } else if (n2 == 1) {
            this.m_campaignMTech[n] = 1;
        }
    }

    public void aiTechAdvance() {
        int n = this.m_campaignMTech[1];
        int n2 = this.m_campaignSTech[1];
        int n3 = this.m_campaignETech[1];
        int n4 = this.m_gameMode.m_techMax[this.m_campaignDifficulty];
        if (n + n2 + n3 == n4 * 3) {
            return;
        }
        boolean bl = false;
        while (!bl) {
            bl = true;
            if (this.rand() % 1000 < 625) {
                if (n >= n2 && n >= n3) {
                    ++n;
                } else if (n2 >= n && n2 >= n3) {
                    ++n2;
                } else {
                    ++n3;
                }
            } else {
                int n5 = this.rand() % 3;
                switch (n5) {
                    case 0: {
                        ++n;
                        break;
                    }
                    case 1: {
                        ++n2;
                        break;
                    }
                    case 2: {
                        ++n3;
                    }
                }
            }
            if (n > n4) {
                n = n4;
                bl = false;
            }
            if (n2 > n4) {
                n2 = n4;
                bl = false;
            }
            if (n3 <= n4) continue;
            n3 = n4;
            bl = false;
        }
        this.m_campaignMTech[1] = n;
        this.m_campaignSTech[1] = n2;
        this.m_campaignETech[1] = n3;
    }

    public boolean nextWar() {
        int n = this.getCampaignEra(this.m_campaignLevel);
        ++this.m_campaignLevel;
        int n2 = this.getCampaignEra(this.m_campaignLevel);
        if (n2 >= 4) {
            this.m_campaignLevel = -100;
            return false;
        }
        if (n != n2) {
            this.setUpTechForCiv(1, n2);
        }
        while (this.deservesTech(1)) {
            this.aiTechAdvance();
        }
        return true;
    }

    public void startCurrentWar() {
        int n = this.getCampaignEra(this.m_campaignLevel);
        int n2 = this.getCampaignEra(this.m_campaignLevel + 1);
        this.m_gameMode.startNewGame(-1, this.m_campaignDifficulty, n, this.m_campaignPlayerCiv, n, true);
        this.m_gameMode.adoptTechsFromCampaign();
    }

    public int getCampaignEra(int n) {
        return n / this.m_campaignLevelsPerEra;
    }

    public int howManyTechsShouldSideHave(int n) {
        int n2 = this.m_campaignPlayerCiv;
        if (n == 1) {
            n2 = this.getCampaignEra(this.m_campaignLevel);
        }
        int n3 = this.m_campaignLevel;
        int n4 = 0;
        if (n2 == 3) {
            n4 = this.m_campaignLevel / this.m_usaBonusTechLevels;
        } else if (n2 == 0) {
            n4 += 3;
        } else if (n2 == 1) {
            n4 += 2;
        }
        return n3 + n4;
    }

    public boolean deservesTech(int n) {
        int n2 = this.m_campaignMTech[n] + this.m_campaignSTech[n] + this.m_campaignETech[n];
        return (n2 += 3) < this.howManyTechsShouldSideHave(n);
    }

    public void save() {
        int n;
        if (!this.m_bCanSave) {
            return;
        }
        FGDataWriter fGDataWriter = new FGDataWriter();
        fGDataWriter.init();
        fGDataWriter.writeInt(7);
        fGDataWriter.writeBoolean(this.getSoundManager().getSoundOn());
        fGDataWriter.writeInt(this.m_campaignLevel);
        fGDataWriter.writeInt(this.m_campaignDifficulty);
        fGDataWriter.writeInt(this.m_campaignPlayerCiv);
        this.m_campaignPlayTime.save(fGDataWriter);
        for (n = 0; n < 2; ++n) {
            fGDataWriter.writeInt(this.m_campaignMTech[n]);
            fGDataWriter.writeInt(this.m_campaignSTech[n]);
            fGDataWriter.writeInt(this.m_campaignETech[n]);
        }
        for (n = 0; n < 10; ++n) {
            fGDataWriter.writeInt(this.m_highScores[n]);
            fGDataWriter.writeInt(this.m_hsDifficulties[n]);
        }
        fGDataWriter.writeBoolean(this.m_bShowedTutorial);
        fGDataWriter.writeBoolean(this.m_bHardModeUnlocked);
        FGData fGData = fGDataWriter.getData();
        this.getFileSystem().putFile("civ.sav", fGData);
    }

    public boolean load() {
        int n;
        FGData fGData = this.getFileSystem().getFile("civ.sav");
        if (fGData == null) {
            return false;
        }
        FGDataReader fGDataReader = new FGDataReader();
        fGDataReader.init(fGData);
        int n2 = fGDataReader.readInt();
        if (n2 != 7) {
            this.getFileSystem().deleteFile("civ.sav");
            return false;
        }
        this.sndOn = fGDataReader.readBoolean();
        this.getSoundManager().setSoundOn(this.sndOn);
        this.m_campaignLevel = fGDataReader.readInt();
        this.m_campaignDifficulty = fGDataReader.readInt();
        this.m_campaignPlayerCiv = fGDataReader.readInt();
        this.m_campaignPlayTime.load(fGDataReader);
        for (n = 0; n < 2; ++n) {
            this.m_campaignMTech[n] = fGDataReader.readInt();
            this.m_campaignSTech[n] = fGDataReader.readInt();
            this.m_campaignETech[n] = fGDataReader.readInt();
        }
        for (n = 0; n < 10; ++n) {
            this.m_highScores[n] = fGDataReader.readInt();
            this.m_hsDifficulties[n] = fGDataReader.readInt();
        }
        this.m_bShowedTutorial = fGDataReader.readBoolean();
        this.m_bHardModeUnlocked = fGDataReader.readBoolean();
        return true;
    }

    public void drawCappedElement(FGGraphics fGGraphics, int n, int n2, FGImage fGImage, FGImage fGImage2, int n3) {
        fGImage.drawSelf(fGGraphics, n, n2);
        int n4 = n3 - fGImage.getWidth() * 2;
        fGImage2.drawTiled(fGGraphics, n + fGImage.getWidth(), n2, n4, fGImage2.getHeight());
        fGImage.drawSelfFlippedH(fGGraphics, n + n3 - fGImage.getWidth(), n2);
    }

    public String getTechName(int n, int n2) {
        FGString fGString = new FGString();
        fGString.set("STR_TECHNAME_");
        switch (n) {
            case 0: {
                fGString.add("M");
                break;
            }
            case 1: {
                fGString.add("S");
                break;
            }
            case 2: {
                fGString.add("E");
            }
        }
        fGString.add(n2);
        return this.m_strings.getString(fGString.getNativeString());
    }

    public String getTechDesc(int n, int n2) {
        FGString fGString = new FGString();
        fGString.set("STR_TECHDESC_");
        switch (n) {
            case 0: {
                fGString.add("M");
                break;
            }
            case 1: {
                fGString.add("S");
                break;
            }
            case 2: {
                fGString.add("E");
            }
        }
        fGString.add(n2);
        String string = this.m_strings.getString(fGString.getNativeString());
        FGString fGString2 = new FGString();
        if (CVEngine.isLarge()) {
            fGString2.set(this.getTechName(n, n2));
            fGString2.add(":\n\n");
        }
        fGString2.add(string);
        return fGString2.getNativeString();
    }

    public int getScore() {
        return this.m_campaignPlayTime.elapsedTime() / 1000;
    }

    public void addHighScore() {
        int n;
        int n2 = -1;
        int n3 = this.getScore();
        for (n = 0; n < 10; ++n) {
            if (this.m_campaignDifficulty > this.m_hsDifficulties[n]) {
                n2 = n;
                break;
            }
            if (this.m_campaignDifficulty == this.m_hsDifficulties[n] && n3 < this.m_highScores[n]) {
                n2 = n;
                break;
            }
            if (this.m_highScores[n] != -1) continue;
            n2 = n;
            break;
        }
        if (n2 == -1) {
            return;
        }
        for (n = 9; n > n2; --n) {
            this.m_highScores[n] = this.m_highScores[n - 1];
            this.m_hsDifficulties[n] = this.m_hsDifficulties[n - 1];
        }
        this.m_highScores[n2] = n3;
        this.m_hsDifficulties[n2] = this.m_campaignDifficulty;
    }

    public String getDifficultyStr(int n) {
        switch (n) {
            case 0: {
                return this.m_strings.getString("STR_EASY");
            }
            case 1: {
                return this.m_strings.getString("STR_MEDIUM");
            }
            case 2: {
                return this.m_strings.getString("STR_HARD");
            }
        }
        return null;
    }

    public void setLanguage(int n) {
        this.m_currentLanguage = n;
        this.m_strings.init(this.getLanguageFilename("strings").getNativeString());
        this.m_UIMode.languageChanged();
        if (this.m_loadingMode.m_bDoneLoading) {
            this.m_gameMode.languageChanged();
        }
    }

    public FGString getLanguageFilename(String string) {
        FGString fGString = new FGString();
        fGString.set(string);
        switch (this.m_currentLanguage) {
            case 0: {
                fGString.add("_e");
                break;
            }
            case 1: {
                fGString.add("_f");
                break;
            }
            case 2: {
                fGString.add("_i");
                break;
            }
            case 3: {
                fGString.add("_g");
                break;
            }
            case 4: {
                fGString.add("_s");
            }
        }
        fGString.add(".txt");
        return fGString;
    }

    public void registerSounds() {
        if (!CVEngine.isSmall()) {
            this.m_loader.registerSound("clashing_swords.mid", 2);
            this.m_loader.registerSound("cannon_shell_hit.mid", 4);
            this.m_loader.registerSound("cannon_shot.mid", 5);
            this.m_loader.registerSound("menu_movement.mid", 6);
            this.m_loader.registerSound("gun_shot.mid", 7);
            this.m_loader.registerSound("tech_selection_sound.mid", 11);
            this.m_loader.registerSound("wall_crumbling.mid", 12);
        }
        this.m_loader.registerSound("artillery_piece_firing.mid", 3);
        this.m_loader.registerSound("level_end_lose.mid", 8);
        this.m_loader.registerSound("level_end_win.mid", 9);
        this.m_loader.registerSound("level_start.mid", 10);
    }

    public void playSound(int n) {
        if (this.m_soundTimer.isOver()) {
            this.getSoundManager().play(n);
            this.m_soundTimer.start(500);
        }
    }
}

