/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDletStateChangeException;

public abstract class FGEngine {
    public static final boolean OVERRIDE_SCREEN_SIZE = false;
    public static final int OVERRIDE_SCREEN_X = 128;
    public static final int OVERRIDE_SCREEN_Y = 160;
    public static final int NUM_KEYCODES = 23;
    public static final int AVK_1 = 49;
    public static final int AVK_2 = 50;
    public static final int AVK_3 = 51;
    public static final int AVK_4 = 52;
    public static final int AVK_5 = 53;
    public static final int AVK_6 = 54;
    public static final int AVK_7 = 55;
    public static final int AVK_8 = 56;
    public static final int AVK_9 = 57;
    public static final int AVK_0 = 48;
    public static final int AVK_STAR = 42;
    public static final int AVK_POUND = 35;
    public static int AVK_LEFT = 2;
    public static int AVK_RIGHT = 5;
    public static int AVK_UP = 1;
    public static int AVK_DOWN = 6;
    public static int AVK_LEFT_SOFT;
    public static int AVK_RIGHT_SOFT;
    public static int AVK_FIRE;
    public int AVK_SEND;
    public int AVK_END;
    public int AVK_CLR;
    public int AVK_VOLUME_UP;
    public int AVK_VOLUME_DOWN;
    public int AVK_BACKSPACE;
    public int AVK_SONYQUIT;
    protected static final Object EXECUTION_MUTEX;
    public static boolean bSizeChanged;
    public static boolean needToPause;
    public static boolean tickInPaint;
    static final int INF_CALL_SERIALLY = 1;
    static final int INF_FIXED_SLEEP = 2;
    static final int INF_NO_SYSTEM_GC = 3;
    static final int INF_USE_WATCHDOG = 11;
    static final int INF_IGNORE_HIDE_NOTIFY = 12;
    static final int INF_INTERRUPT_VIA_START_APP = 13;
    static final int INF_FORCE_SIZE = 21;
    static final int INF_FORCE_NO_FLIPPING_CODE = 22;
    static final int INF_FORCE_USE_ALTERNATE_SIZE_DETECT = 23;
    static final int INF_FORCE_KEYS = 41;
    static final int INF_NO_TOUCH = 42;
    static final int INF_NO_QWERTY = 43;
    static final int INF_MMAPI = 60;
    static final int INF_MUSIC_ON = 61;
    static final int INF_SFX_ON = 63;
    static final int INF_ALERTS = 65;
    static final int INF_BEEPS_ON = 68;
    static final int INF_SOUND_THREAD = 73;
    static final int INF_SET_VOLUME = 74;
    static final int INF_SOUND_LISTENER = 76;
    static final int INF_SOUND_PREFETCH = 77;
    static final int INF_SOUND_REALIZE = 78;
    static final int INF_SOUND_DEALLOCATE = 79;
    static final int INF_SOUND_RELOAD = 80;
    static final int INF_SOUND_RELOAD_ALL = 81;
    static final int INF_SOUND_STOP_BEFORE = 82;
    static final int INF_SOUND_LOOP_FIX = 83;
    static final int INF_DOUBLE_TAP = 101;
    static final int INF_VIBRATION = 102;
    static final int INF_ALT_BUYMORE_LOGIC = 103;
    static final int INF_USE_MIDP_IMAGE = 111;
    static final int INF_MIDP_IMAGE_FRAME_BUFFER = 112;
    static final int INF_NO_RT_DEPACK = 113;
    static final int INF_NO_MIDP_IMAGES = 114;
    static final int INF_FILE_CACHE_ALWAYS_ON = 115;
    static final int INF_ORIENTATION = 131;
    static final int INF_ORIENTATION_PORTRAIT = 1;
    static final int INF_ORIENTATION_LANDSCAPE = 2;
    static final int INF_ORIENTATION_ANY = 3;
    static final int INF_PROJECT_DEFINES = 200;
    static final int VALUE_NOT_SET = -999;
    static int lastInfKey;
    static String value;
    static final char SEP = ',';
    static Hashtable infs;
    static Vector vInfLines;
    static boolean bInfCallSerially;
    static boolean bInfFixedSleep;
    static int iInfFixedSleepLength;
    static boolean bInfNoSystemGC;
    static boolean bInfUseWatchdog;
    static int iInfWatchdogTimeout;
    static boolean bInfIgnoreHideNotify;
    static boolean bInfInterruptViaStartApp;
    static boolean bInfForceSize;
    static int iInfForcedWidth;
    static int iInfForcedHeight;
    static boolean bInfNoFlippingCode;
    static boolean bInfNoCreateRGB;
    static boolean bInfUseAlternateSizeDetect;
    static int iInfSizeDetectMethod;
    static boolean bInfForceKeys;
    static int iInfLSK;
    static int iInfRSK;
    static int iInfFire;
    static int iInfUp;
    static int iInfDown;
    static int iInfLeft;
    static int iInfRight;
    static boolean bInfNoTouch;
    static boolean bInfNoQwerty;
    static boolean bInfMMAPI;
    static boolean bInfMusicOn;
    static int iInfMusicType;
    static boolean bInfSFXOn;
    static int iInfSFXType;
    static boolean bInfAlertsOn;
    static int iInfAlertOne;
    static int iInfAlertTwo;
    static boolean bInfBeepsOn;
    static int iInfMinPitch;
    static int iInfMaxPitch;
    static int iInfMinDuration;
    static int iInfBeepVolume;
    static boolean bInfSoundThread;
    static boolean bInfSetVolume;
    static int iInfMaxVolume;
    static boolean bInfSoundListener;
    static boolean bInfSoundPrefetch;
    static boolean bInfSoundRealize;
    static boolean bInfSoundDeallocate;
    static boolean bInfSoundReload;
    static boolean bInfSoundReloadAll;
    static boolean bInfSoundStopBefore;
    static boolean bInfSoundLoopfix;
    static int iInfDoubleTap;
    static boolean bInfVibration;
    static boolean bInfAltBuymoreLogic;
    static int iInfAltBuymoreMethod;
    static boolean bInfUseMIDPImage;
    static boolean bInfMIDPImageFrameBuffer;
    static boolean bInfNoRTDepack;
    static boolean bInfNoMIDPImages;
    static boolean bInfFileCacheAlwaysOn;
    static String sInfProjectDefines;
    static boolean bInfRotationEnabled;
    static boolean bInfPortrait;
    static boolean bInfLandscape;
    static boolean bInfAnyOrientation;
    static boolean bTouchEnabled;
    public static String g_log;
    public static boolean bLoaded;
    private static FGEngine g_engine;
    protected boolean[] m_bKeyStates = new boolean[23];
    protected boolean[] m_bKeysWereDown = new boolean[23];
    protected int[] m_keyIDs = new int[23];
    protected boolean m_bFailed = false;
    protected String m_failStr;
    public MidletScreen m_midletScreen;
    public boolean m_bDoRepaint = false;
    private static int m_screenWidth;
    private static int m_screenHeight;
    private int m_nextRandNum;
    long m_lastTickTime;
    long m_lastTickDuration;
    private FGFileSystem m_fileSystem = new FGFileSystem();
    public FGSoundManager m_soundManager = new FGSoundManager();
    private FGGraphics m_graphics = new FGGraphics();
    public boolean m_bExit;
    public FGString m_skuName = new FGString();
    boolean m_bOffscreen = false;
    Image m_offscreenImg = null;
    Graphics m_offscreenG = null;
    boolean m_bPaused = false;
    private FGPointerList m_timerRegistry = new FGPointerList();
    private boolean m_bWasPaused = false;
    private long m_pauseTime = 0L;
    public static long someCounter;
    public static int touchX;
    public static int touchY;

    static boolean getParamBool(int n, int n2) {
        if (infs == null) {
            return false;
        }
        String string = FGEngine.getParamString(n, n2);
        if (string != null) {
            return !string.equals("");
        }
        return false;
    }

    static int getParamInt(int n, int n2) {
        if (infs == null) {
            return -999;
        }
        String string = FGEngine.getParamString(n, n2);
        if (string != null) {
            if (string.equals("")) {
                return -999;
            }
            return Integer.valueOf(string);
        }
        return -999;
    }

    static String getParamString(int n, int n2) {
        int n3;
        if (infs == null) {
            return null;
        }
        if (lastInfKey != n) {
            value = (String)infs.get(new Integer(n));
            lastInfKey = n;
            if (value == null) {
                lastInfKey = -1;
                return null;
            }
        }
        int n4 = -1;
        for (n3 = 0; n3 < n2; ++n3) {
            if ((n4 = value.indexOf(44, n4 + 1)) != -1) continue;
            return null;
        }
        n3 = value.indexOf(44, n4 + 1);
        if (n3 == -1) {
            return value.substring(n4 + 1).trim();
        }
        return value.substring(n4 + 1, n3).trim();
    }

    static int getParamCount(int n) {
        return -1;
    }

    static void processInfVariables() {
        bInfCallSerially = FGEngine.getParamBool(1, 0);
        bInfFixedSleep = FGEngine.getParamBool(2, 0);
        iInfFixedSleepLength = FGEngine.getParamInt(2, 1);
        bInfNoSystemGC = FGEngine.getParamBool(3, 0);
        bInfUseWatchdog = FGEngine.getParamBool(11, 0);
        iInfWatchdogTimeout = FGEngine.getParamInt(11, 1);
        bInfIgnoreHideNotify = FGEngine.getParamBool(12, 0);
        bInfInterruptViaStartApp = FGEngine.getParamBool(13, 0);
        bInfForceSize = FGEngine.getParamBool(21, 0);
        iInfForcedWidth = FGEngine.getParamInt(21, 1);
        iInfForcedHeight = FGEngine.getParamInt(21, 2);
        bInfNoFlippingCode = FGEngine.getParamBool(22, 0);
        bInfUseAlternateSizeDetect = FGEngine.getParamBool(23, 0);
        iInfSizeDetectMethod = FGEngine.getParamInt(23, 1);
        bInfForceKeys = FGEngine.getParamBool(41, 0);
        iInfLSK = FGEngine.getParamInt(41, 1);
        iInfRSK = FGEngine.getParamInt(41, 2);
        iInfFire = FGEngine.getParamInt(41, 3);
        iInfUp = FGEngine.getParamInt(41, 4);
        iInfDown = FGEngine.getParamInt(41, 5);
        iInfLeft = FGEngine.getParamInt(41, 6);
        iInfRight = FGEngine.getParamInt(41, 7);
        bInfNoTouch = FGEngine.getParamBool(42, 0);
        bInfNoQwerty = FGEngine.getParamBool(43, 0);
        bInfMMAPI = FGEngine.getParamBool(60, 0);
        bInfMusicOn = FGEngine.getParamBool(61, 0);
        iInfMusicType = FGEngine.getParamInt(61, 1);
        bInfSFXOn = FGEngine.getParamBool(63, 0);
        iInfSFXType = FGEngine.getParamInt(63, 1);
        bInfAlertsOn = FGEngine.getParamBool(65, 0);
        iInfAlertOne = FGEngine.getParamInt(65, 1);
        iInfAlertTwo = FGEngine.getParamInt(65, 2);
        bInfBeepsOn = FGEngine.getParamBool(68, 0);
        iInfMinPitch = FGEngine.getParamInt(68, 1);
        iInfMaxPitch = FGEngine.getParamInt(68, 2);
        iInfMinDuration = FGEngine.getParamInt(68, 3);
        iInfBeepVolume = FGEngine.getParamInt(68, 4);
        bInfSoundThread = FGEngine.getParamBool(73, 0);
        bInfSetVolume = FGEngine.getParamBool(74, 0);
        iInfMaxVolume = FGEngine.getParamInt(74, 1);
        bInfSoundListener = FGEngine.getParamBool(76, 0);
        bInfSoundPrefetch = FGEngine.getParamBool(77, 0);
        bInfSoundRealize = FGEngine.getParamBool(78, 0);
        bInfSoundDeallocate = FGEngine.getParamBool(79, 0);
        bInfSoundReload = FGEngine.getParamBool(80, 0);
        bInfSoundReloadAll = FGEngine.getParamBool(81, 0);
        bInfSoundStopBefore = FGEngine.getParamBool(82, 0);
        bInfSoundLoopfix = FGEngine.getParamBool(83, 0);
        iInfDoubleTap = FGEngine.getParamInt(101, 1);
        bInfVibration = FGEngine.getParamBool(102, 0);
        bInfAltBuymoreLogic = FGEngine.getParamBool(103, 0);
        iInfAltBuymoreMethod = FGEngine.getParamInt(103, 1);
        bInfUseMIDPImage = FGEngine.getParamBool(111, 0);
        bInfMIDPImageFrameBuffer = FGEngine.getParamBool(112, 0);
        bInfNoRTDepack = FGEngine.getParamBool(113, 0);
        bInfNoMIDPImages = FGEngine.getParamBool(114, 0);
        bInfFileCacheAlwaysOn = FGEngine.getParamBool(115, 0);
        sInfProjectDefines = FGEngine.getParamString(200, 0);
        if (FGEngine.getParamBool(200, 0) && value.indexOf("TICK_IN_PAINT") >= 0) {
            tickInPaint = true;
        }
        bInfRotationEnabled = FGEngine.getParamBool(131, 0);
        bInfPortrait = FGEngine.getParamInt(131, 1) == 1;
        bInfLandscape = FGEngine.getParamInt(131, 1) == 2;
        bInfAnyOrientation = FGEngine.getParamInt(131, 1) == 3;
        System.out.println("" + bInfPortrait + " " + bInfLandscape + " " + bInfAnyOrientation);
        if (iInfWatchdogTimeout < 1000) {
            iInfWatchdogTimeout = 1000;
        }
        if (!bInfPortrait && !bInfLandscape) {
            if (FGEngine.getScreenWidth() > FGEngine.getScreenHeight()) {
                bInfLandscape = true;
                bInfPortrait = false;
            } else {
                bInfPortrait = true;
                bInfLandscape = false;
            }
        }
    }

    static boolean readBoxalInf() {
        String string = "/boxal.inf";
        try {
            InputStream inputStream = string.getClass().getResourceAsStream(string);
            if (inputStream == null) {
                System.out.println("no stream");
                return false;
            }
            try {
                int n;
                StringBuffer stringBuffer = new StringBuffer();
                infs = new Hashtable();
                while ((n = inputStream.read()) != -1) {
                    char c = (char)n;
                    if (c == '\n') {
                        String string2 = stringBuffer.toString();
                        int n2 = string2.indexOf(44);
                        if (n2 == -1) {
                            n2 = string2.length() - 1;
                        }
                        infs.put(new Integer(Integer.parseInt(string2.substring(0, n2))), string2);
                        stringBuffer.delete(0, stringBuffer.length());
                        continue;
                    }
                    stringBuffer.append(c);
                }
                inputStream.close();
                FGEngine.processInfVariables();
                infs = null;
            }
            catch (Exception exception) {
                System.out.println(exception.toString());
                return false;
            }
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            return false;
        }
        return true;
    }

    public void init() {
    }

    public void onKeyPressed(int n) {
    }

    public void onKeyReleased(int n) {
    }

    public void onDrawSelf(FGGraphics fGGraphics) {
    }

    public void onTick() {
    }

    public void onPause() {
    }

    public void onResume() {
    }

    public void onExitApp() {
    }

    public boolean isFullScreenApp() {
        return true;
    }

    public static FGEngine getEngine() {
        return g_engine;
    }

    public boolean isKeyDown(int n) {
        for (int i = 0; i < 23; ++i) {
            if (this.m_keyIDs[i] != n) continue;
            return this.m_bKeyStates[i];
        }
        return false;
    }

    public boolean wasKeyDownSinceTick(int n) {
        for (int i = 0; i < 23; ++i) {
            if (this.m_keyIDs[i] != n) continue;
            return this.m_bKeysWereDown[i];
        }
        return false;
    }

    public static void fatal(String string) {
        FGEngine fGEngine = FGEngine.getEngine();
        if (fGEngine.m_bFailed) {
            return;
        }
        fGEngine.m_failStr = string == null ? "Unspecified Fatal Error." : string;
        if (g_log.length() > 0) {
            fGEngine.m_failStr = fGEngine.m_failStr + ":";
            fGEngine.m_failStr = fGEngine.m_failStr + g_log;
        }
        fGEngine.m_bFailed = true;
        try {
            throw new RuntimeException("Fatal called: " + string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public boolean hasFailed() {
        return this.m_bFailed;
    }

    public static int getScreenWidth() {
        if (bInfForceSize) {
            return iInfForcedWidth;
        }
        return m_screenWidth;
    }

    public static int getScreenHeight() {
        if (bInfForceSize) {
            return iInfForcedHeight;
        }
        return m_screenHeight;
    }

    public FGString getSku() {
        return this.m_skuName;
    }

    public void exitApp() {
        try {
            FGApp.g_app.destroyApp(true);
            FGApp.g_app.notifyDestroyed();
        }
        catch (MIDletStateChangeException mIDletStateChangeException) {
            // empty catch block
        }
    }

    public int getTickTime() {
        return (int)this.m_lastTickDuration;
    }

    public void resetTickTimer() {
        this.m_lastTickTime = System.currentTimeMillis();
    }

    public int rand() {
        this.m_nextRandNum = this.m_nextRandNum * 1103515245 + 12345;
        int n = this.m_nextRandNum / 65536 % 32768;
        if (n < 0) {
            n = -n;
        }
        return n;
    }

    public void srand(int n) {
        this.m_nextRandNum = n;
    }

    public void srand() {
        this.srand((int)System.currentTimeMillis());
    }

    public FGFileSystem getFileSystem() {
        return this.m_fileSystem;
    }

    public FGSoundManager getSoundManager() {
        return this.m_soundManager;
    }

    public FGPointerList getTimerRegistry() {
        if (this.m_timerRegistry == null) {
            this.m_timerRegistry = new FGPointerList();
        }
        return this.m_timerRegistry;
    }

    public FGEngine() {
        this.srand();
    }

    public void keyStateChange(int n, boolean bl) {
        if (!bl) {
            this.clearKeyStates();
            return;
        }
        for (int i = 0; i < 23; ++i) {
            if (this.m_keyIDs[i] != n) continue;
            this.m_bKeyStates[i] = bl;
            if (!bl) continue;
            this.m_bKeysWereDown[i] = true;
        }
    }

    public void clearKeyStates() {
        for (int i = 0; i < 23; ++i) {
            this.m_bKeyStates[i] = false;
        }
    }

    public void clearKeyWasStates() {
        for (int i = 0; i < 23; ++i) {
            this.m_bKeysWereDown[i] = false;
        }
    }

    public void entInit() {
        g_engine = this;
        this.m_midletScreen = new MidletScreen();
        FGApp.g_app.m_display.setCurrent((Displayable)this.m_midletScreen);
        if (!FGEngine.readBoxalInf()) {
            System.out.println("No boxal inf found, will result in a standard setup");
        }
        this.m_lastTickTime = System.currentTimeMillis();
        this.setUpForSku();
        if (bInfForceKeys) {
            AVK_LEFT = iInfLeft;
            AVK_RIGHT = iInfRight;
            AVK_UP = iInfUp;
            AVK_DOWN = iInfDown;
            AVK_LEFT_SOFT = iInfLSK;
            AVK_RIGHT_SOFT = iInfRSK;
            AVK_FIRE = iInfFire;
        }
        this.m_keyIDs[0] = 49;
        this.m_keyIDs[1] = 50;
        this.m_keyIDs[2] = 51;
        this.m_keyIDs[3] = 52;
        this.m_keyIDs[4] = 53;
        this.m_keyIDs[5] = 54;
        this.m_keyIDs[6] = 55;
        this.m_keyIDs[7] = 56;
        this.m_keyIDs[8] = 57;
        this.m_keyIDs[9] = 48;
        this.m_keyIDs[10] = 42;
        this.m_keyIDs[11] = 35;
        this.m_keyIDs[12] = AVK_LEFT;
        this.m_keyIDs[13] = AVK_RIGHT;
        this.m_keyIDs[14] = AVK_UP;
        this.m_keyIDs[15] = AVK_DOWN;
        this.m_keyIDs[16] = AVK_LEFT_SOFT;
        this.m_keyIDs[17] = AVK_RIGHT_SOFT;
        this.m_keyIDs[18] = AVK_FIRE;
        this.m_keyIDs[19] = this.AVK_VOLUME_UP;
        this.m_keyIDs[20] = this.AVK_VOLUME_DOWN;
        this.m_keyIDs[21] = this.AVK_BACKSPACE;
        this.m_keyIDs[22] = this.AVK_SONYQUIT;
        this.clearKeyStates();
        this.clearKeyWasStates();
        this.m_fileSystem.init();
        this.m_soundManager.init();
        this.init();
    }

    public String getProperty(String string) {
        String string2 = FGApp.g_app.getAppProperty(string);
        return string2;
    }

    private void setUpForSku() {
        AVK_LEFT_SOFT = -6;
        AVK_RIGHT_SOFT = -7;
        AVK_FIRE = -5;
        this.AVK_CLR = -350;
        this.AVK_VOLUME_UP = -360;
        this.AVK_VOLUME_DOWN = -370;
        this.AVK_BACKSPACE = -380;
        this.AVK_SONYQUIT = -390;
        this.AVK_SEND = -400;
        this.AVK_END = -410;
        this.m_bOffscreen = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void entPaint(Graphics graphics) {
        if (this.m_bPaused) {
            return;
        }
        if (this.m_bWasPaused) {
            return;
        }
        if (!this.m_bDoRepaint) {
            return;
        }
        if (this.hasFailed()) {
            graphics.setColor(0xFFFFFF);
            graphics.fillRect(0, 0, FGEngine.getScreenWidth(), m_screenHeight);
            return;
        }
        Object object = EXECUTION_MUTEX;
        synchronized (object) {
            Graphics graphics2 = graphics;
            if (this.m_bOffscreen) {
                if (this.m_offscreenG == null || this.m_offscreenImg == null) {
                    this.m_offscreenImg = Image.createImage((int)m_screenWidth, (int)m_screenHeight);
                    this.m_offscreenG = this.m_offscreenImg.getGraphics();
                }
                graphics2 = this.m_offscreenG;
            }
            graphics2.setClip(0, 0, m_screenWidth, m_screenHeight);
            this.m_graphics.setGraphics(graphics2);
            if (FGApp.g_app.isGameLobbyIncontrol()) {
                FGApp.g_app.glDrawSelf(this.m_graphics);
            } else {
                this.onDrawSelf(this.m_graphics);
            }
            if (this.m_bOffscreen) {
                graphics.drawImage(this.m_offscreenImg, 0, 0, 20);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void entKeyPressed(int n) {
        if (this.m_bPaused) {
            return;
        }
        if (n == this.AVK_SEND || n == this.AVK_END) {
            return;
        }
        if (n == 0) {
            return;
        }
        Object object = EXECUTION_MUTEX;
        synchronized (object) {
            if (this.hasFailed()) {
                this.exitApp();
                return;
            }
            this.keyStateChange(n, true);
            if (FGApp.g_app.isGameLobbyIncontrol()) {
                FGApp.g_app.glKeyPressed(n);
            } else {
                this.onKeyPressed(n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void entKeyReleased(int n) {
        if (this.m_bPaused) {
            return;
        }
        if (n == this.AVK_SEND || n == this.AVK_END) {
            return;
        }
        if (n == 0) {
            return;
        }
        Object object = EXECUTION_MUTEX;
        synchronized (object) {
            this.keyStateChange(n, false);
            this.onKeyReleased(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void entTick() {
        if (this.m_bPaused) {
            return;
        }
        if (this.m_bWasPaused) {
            this.clearKeyStates();
            this.clearKeyWasStates();
            long l = System.currentTimeMillis();
            int n = (int)(l - this.m_pauseTime);
            for (int i = 0; i < this.m_timerRegistry.getNumPointers(); ++i) {
                FGTimer fGTimer = (FGTimer)this.m_timerRegistry.getPointer(i);
                if (fGTimer.isPaused()) continue;
                fGTimer.advance(-n);
            }
            this.m_bWasPaused = false;
            this.onResume();
        }
        if (this.hasFailed()) {
            this.showFatalAlert();
            return;
        }
        Object object = EXECUTION_MUTEX;
        synchronized (object) {
            this.m_lastTickDuration = System.currentTimeMillis() - this.m_lastTickTime;
            if (this.m_lastTickDuration <= 0L) {
                return;
            }
            this.resetTickTimer();
            if (FGApp.g_app.isGameLobbyIncontrol()) {
                FGApp.g_app.glTick();
            } else {
                this.onTick();
            }
            this.clearKeyWasStates();
        }
    }

    public void entPause() {
        if (this.m_bPaused) {
            return;
        }
        this.m_bPaused = true;
        this.m_soundManager.doStop();
        this.m_bWasPaused = true;
        this.m_pauseTime = System.currentTimeMillis();
        this.onPause();
    }

    public void entResume() {
        if (!this.m_bPaused) {
            return;
        }
        this.m_bPaused = false;
        this.resetTickTimer();
    }

    public void entExitApp() {
        this.m_bExit = true;
        this.onExitApp();
        this.m_soundManager.shutDown();
    }

    public void entExitAppQuiet() {
        this.m_bExit = true;
        this.m_soundManager.shutDown();
        this.m_soundManager = null;
    }

    public void showFatalAlert() {
        Alert alert = new Alert("Fatal");
        alert.setString(this.m_failStr);
        alert.setTimeout(-2);
        FGApp.g_app.m_display.setCurrent((Displayable)alert);
        boolean bl = true;
        while (bl) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
    }

    public void setAlternateHeapSize(int n) {
    }

    public boolean isUsingAlternateHeap() {
        return false;
    }

    public void useAlternateHeap(boolean bl) {
    }

    static {
        EXECUTION_MUTEX = new Object();
        bSizeChanged = false;
        needToPause = false;
        tickInPaint = false;
        lastInfKey = -1;
        bInfCallSerially = false;
        bInfFixedSleep = false;
        iInfFixedSleepLength = -1;
        bInfNoSystemGC = false;
        bInfUseWatchdog = false;
        iInfWatchdogTimeout = -1;
        bInfIgnoreHideNotify = false;
        bInfInterruptViaStartApp = false;
        bInfForceSize = false;
        iInfForcedWidth = -1;
        iInfForcedHeight = -1;
        bInfNoFlippingCode = false;
        bInfNoCreateRGB = false;
        bInfUseAlternateSizeDetect = false;
        iInfSizeDetectMethod = -1;
        bInfForceKeys = false;
        iInfLSK = -1;
        iInfRSK = -1;
        iInfFire = -1;
        iInfUp = -1;
        iInfDown = -1;
        iInfLeft = -1;
        iInfRight = -1;
        bInfNoTouch = false;
        bInfNoQwerty = false;
        bInfMMAPI = true;
        bInfMusicOn = true;
        iInfMusicType = 1;
        bInfSFXOn = true;
        iInfSFXType = 1;
        bInfAlertsOn = false;
        iInfAlertOne = -1;
        iInfAlertTwo = -1;
        bInfBeepsOn = false;
        iInfMinPitch = -1;
        iInfMaxPitch = -1;
        iInfMinDuration = -1;
        iInfBeepVolume = -1;
        bInfSoundThread = false;
        bInfSetVolume = false;
        iInfMaxVolume = -1;
        bInfSoundListener = false;
        bInfSoundPrefetch = false;
        bInfSoundRealize = false;
        bInfSoundDeallocate = false;
        bInfSoundReload = false;
        bInfSoundReloadAll = false;
        bInfSoundStopBefore = false;
        bInfSoundLoopfix = false;
        iInfDoubleTap = -1;
        bInfVibration = false;
        bInfAltBuymoreLogic = false;
        iInfAltBuymoreMethod = -1;
        sInfProjectDefines = "EMPTY";
        bInfRotationEnabled = false;
        bInfPortrait = false;
        bInfLandscape = false;
        bInfAnyOrientation = false;
        bTouchEnabled = false;
        g_log = "";
        bLoaded = false;
        m_screenWidth = -1;
        m_screenHeight = -1;
        touchX = -100;
        touchY = -100;
    }

    class MidletScreen
    extends Canvas {
        boolean bFirstPaint = true;

        public MidletScreen() {
            if (FGEngine.this.isFullScreenApp()) {
                this.setFullScreenMode(true);
            }
            if (m_screenWidth == -1) {
                m_screenWidth = this.getWidth();
                m_screenHeight = this.getHeight();
            }
        }

        protected void sizeChanged(int n, int n2) {
            m_screenWidth = n;
            m_screenHeight = n2;
        }

        public void paint(Graphics graphics) {
            if (this.bFirstPaint && bInfUseAlternateSizeDetect && iInfSizeDetectMethod == 1) {
                this.bFirstPaint = false;
                m_screenWidth = graphics.getClipWidth();
                m_screenHeight = graphics.getClipHeight();
            }
            boolean bl = false;
            if (bInfPortrait && this.getWidth() > this.getHeight()) {
                bl = true;
            }
            if (bInfLandscape && this.getHeight() > this.getWidth()) {
                bl = true;
            }
            if (bl) {
                graphics.setColor(0);
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                graphics.setColor(0xFFFFFF);
                graphics.drawString("Please Reorientate Handset Screen", 5, (this.getHeight() >> 1) - 40, 0x10 | 4);
                graphics.drawString("R\u00e9orientez l\u2019\u00e9cran s\u2019il vous pla\u00eet", 5, (this.getHeight() >> 1) - 20, 0x10 | 4);
                graphics.drawString("Riposiziona Schermo", 5, this.getHeight() >> 1, 0x10 | 4);
                graphics.drawString("Bitte richte Display neu aus", 5, (this.getHeight() >> 1) + 20, 0x10 | 4);
                graphics.drawString("Reorienta la pantalla del m\u00f3vil", 5, (this.getHeight() >> 1) + 40, 0x10 | 4);
                return;
            }
            if (bInfUseWatchdog) {
                if (FGApp.lLastPaintTime == 0L) {
                    FGApp.lLastPaintTime = System.currentTimeMillis();
                }
                if (System.currentTimeMillis() > FGApp.lLastPaintTime + (long)iInfWatchdogTimeout) {
                    FGApp.paintPause = true;
                }
            }
            if (tickInPaint) {
                FGEngine.this.entTick();
            }
            try {
                FGEngine.this.entPaint(graphics);
                if (bInfUseWatchdog) {
                    FGApp.lLastPaintTime = System.currentTimeMillis();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                FGEngine.fatal(exception.toString());
            }
        }

        protected void keyPressed(int n) {
            if (bInfPortrait && this.getWidth() > this.getHeight()) {
                return;
            }
            if (bInfLandscape && this.getHeight() > this.getWidth()) {
                return;
            }
            int n2 = 0;
            try {
                n2 = this.getGameAction(n);
            }
            catch (Exception exception) {
                return;
            }
            try {
                FGEngine.this.entKeyPressed(n2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                FGEngine.fatal(exception.toString());
            }
        }

        protected void keyReleased(int n) {
            if (bInfPortrait && this.getWidth() > this.getHeight()) {
                return;
            }
            if (bInfLandscape && this.getHeight() > this.getWidth()) {
                return;
            }
            int n2 = 0;
            try {
                n2 = this.getGameAction(n);
            }
            catch (Exception exception) {
                return;
            }
            try {
                FGEngine.this.entKeyReleased(n2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                FGEngine.fatal(exception.toString());
            }
        }

        public void hideNotify() {
            FGEngine.this.m_soundManager.shutDown();
            if (bInfIgnoreHideNotify) {
                return;
            }
            try {
                if (!FGApp.g_app.isPaused()) {
                    FGApp.g_app.pauseApp();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                FGEngine.fatal(exception.toString());
            }
        }

        public void showNotify() {
            if (bInfIgnoreHideNotify) {
                return;
            }
            try {
                if (FGApp.g_app.isPaused() && FGApp.g_app.appWasStarted()) {
                    try {
                        FGApp.g_app.startApp();
                        Thread.sleep(50L);
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                FGEngine.fatal(exception.toString());
            }
        }

        public int getGameAction(int n) {
            for (int i = 0; i < 23; ++i) {
                if (FGEngine.this.m_keyIDs[i] != n) continue;
                return n;
            }
            return super.getGameAction(n);
        }

        public void pointerPressed(int n, int n2) {
            bTouchEnabled = true;
            if (bInfPortrait && this.getWidth() > this.getHeight()) {
                return;
            }
            if (bInfLandscape && this.getHeight() > this.getWidth()) {
                return;
            }
            if (!bInfNoTouch) {
                touchX = n;
                touchY = n2;
            }
        }

        public void pointerDragged(int n, int n2) {
        }

        public void pointerReleased(int n, int n2) {
            if (bInfPortrait && this.getWidth() > this.getHeight()) {
                return;
            }
            if (bInfLandscape && this.getHeight() > this.getWidth()) {
                return;
            }
            if (!bInfNoTouch) {
                touchX = -100;
                touchY = -100;
            }
        }
    }
}

