/*
 * Decompiled with CFR 0.152.
 */
class FGForm {
    public static final boolean SCROLL_WHOLE_PAGE = true;
    public static final int HORIZ_GUTTER = 2;
    private FGString m_text = new FGString();
    private FGFont m_font;
    private FGImage m_upArrowImg;
    private FGImage m_downArrowImg;
    private FGString m_title = new FGString();
    private int m_bkColor;
    private int m_scroll;
    private int m_lastScrollPos;
    private int m_displayableLines;
    private int m_justify;

    public void init(FGFont fGFont, FGImage fGImage, FGImage fGImage2, String string, String string2, int n) {
        this.init(fGFont, fGImage, fGImage2, n);
        this.setTitle(string2);
        FGData fGData = FGEngine.getEngine().getFileSystem().getFile(string);
        if (fGData == null) {
            FGEngine.fatal("Could not find file in FGForm.init()");
            return;
        }
        FGString fGString = new FGString(fGData);
        String string3 = fGString.getNativeString();
        if (string.equals("about.txt")) {
            string3 = "\n" + FGApp.g_app.getAppProperty("MIDlet-Name") + "\n" + "\nVersion " + FGApp.g_app.getAppProperty("MIDlet-Version") + "\n" + "\nDeveloped By\n" + FGApp.g_app.getAppProperty("MIDlet-Vendor") + "\n" + string3;
        }
        this.setText(string3);
        this.m_justify = 0;
    }

    public void clear() {
        this.m_title.set("");
        this.m_text.set("");
        this.m_font = null;
        this.m_upArrowImg = null;
        this.m_downArrowImg = null;
        this.m_bkColor = 0;
    }

    public void setTitle(String string) {
        this.m_title.set(string);
    }

    public void setText(String string) {
        this.m_text.set(string);
        this.init(this.m_font, this.m_upArrowImg, this.m_downArrowImg, this.m_bkColor);
    }

    public void setScroll(int n) {
        this.m_scroll = n;
    }

    public void setJustify(int n) {
        this.m_justify = n;
    }

    public void init(FGFont fGFont, FGImage fGImage, FGImage fGImage2, int n) {
        this.m_font = fGFont;
        this.m_upArrowImg = fGImage;
        this.m_downArrowImg = fGImage2;
        this.m_bkColor = n;
        this.m_scroll = 0;
        int n2 = this.getDisplayableTextHeight();
        this.m_displayableLines = n2 / (this.m_font.getHeight() + this.m_font.getLineSpacing());
        int n3 = this.m_font.getDisplayLines(this.m_text.getNativeString(), this.getDisplayAreaWidth());
        this.m_lastScrollPos = n3 - this.m_displayableLines;
        if (this.m_lastScrollPos < 0) {
            this.m_lastScrollPos = 0;
        }
    }

    private int getDisplayAreaWidth() {
        FGEngine.getEngine();
        return FGEngine.getScreenWidth() - 4;
    }

    public void drawSelf(FGGraphics fGGraphics) {
        FGEngine.getEngine();
        int n = FGEngine.getScreenWidth();
        FGEngine.getEngine();
        int n2 = FGEngine.getScreenHeight();
        boolean bl = false;
        if (this.m_upArrowImg != null && this.m_downArrowImg != null) {
            bl = true;
        }
        if (this.m_bkColor != 0xFF00FF) {
            fGGraphics.setColor(this.m_bkColor);
            fGGraphics.fillRect(0, 0, n, n2);
        }
        int n3 = this.m_font.getLineSpacing();
        int n4 = n3 + this.m_font.getHeight() + this.m_font.getLineSpacing();
        int n5 = 0;
        if (bl) {
            n5 = this.m_upArrowImg.getHeight();
            if (this.m_downArrowImg.getHeight() > n5) {
                n5 = this.m_downArrowImg.getHeight();
            }
            n5 += 2;
        }
        int n6 = n2 - n5;
        this.m_font.setJustify(2);
        this.m_font.drawText(fGGraphics, this.m_title.getNativeString(), n / 2, n3);
        this.m_font.setJustify(0);
        this.m_font.setJustify(this.m_justify);
        this.m_font.drawText(fGGraphics, this.m_text.getNativeString(), 2, n4, this.getDisplayAreaWidth(), this.getDisplayableTextHeight(), this.m_scroll);
        this.m_font.setJustify(0);
        int n7 = n6;
        if (bl) {
            int n8;
            boolean bl2 = false;
            boolean bl3 = false;
            if (this.m_scroll > 0) {
                bl2 = true;
            }
            if (this.m_scroll < this.m_lastScrollPos) {
                bl3 = true;
            }
            int n9 = bl3 && bl2 ? this.m_upArrowImg.getWidth() + this.m_downArrowImg.getWidth() : (bl3 ? this.m_downArrowImg.getWidth() : (bl2 ? this.m_upArrowImg.getWidth() : 0));
            int n10 = (n - n9) / 2;
            if (bl2) {
                n8 = n7 + (n5 - this.m_upArrowImg.getHeight()) / 2;
                this.m_upArrowImg.drawSelf(fGGraphics, n10, n8);
                if (CVEngine.bWait) {
                    if (FGEngine.touchX == -100) {
                        CVEngine.bWait = false;
                    }
                } else if (FGEngine.touchX >= n10 && FGEngine.touchX <= n10 + this.m_upArrowImg.getWidth() && FGEngine.touchY > n8 && FGEngine.touchY <= n8 + this.m_upArrowImg.getHeight()) {
                    FGEngine.getEngine().onKeyPressed(FGEngine.AVK_UP);
                    CVEngine.bWait = true;
                }
                n10 += this.m_upArrowImg.getWidth();
            }
            if (bl3) {
                n8 = n7 + (n5 - this.m_downArrowImg.getHeight()) / 2;
                this.m_downArrowImg.drawSelf(fGGraphics, n10, n8);
                if (CVEngine.bWait) {
                    if (FGEngine.touchX == -100) {
                        CVEngine.bWait = false;
                    }
                } else if (FGEngine.touchX > n10 && FGEngine.touchX <= n10 + this.m_downArrowImg.getWidth() && FGEngine.touchY > n8 && FGEngine.touchY <= n8 + this.m_downArrowImg.getHeight()) {
                    FGEngine.getEngine().onKeyPressed(FGEngine.AVK_DOWN);
                    CVEngine.bWait = true;
                }
            }
        }
    }

    public void handleKey(int n) {
        if (n == FGEngine.AVK_DOWN) {
            this.pageDown();
        } else if (n == FGEngine.AVK_UP) {
            this.pageUp();
        }
    }

    public void pageDown() {
        this.m_scroll += this.m_displayableLines - 1;
        ++this.m_scroll;
        if (this.m_scroll > this.m_lastScrollPos) {
            this.m_scroll = this.m_lastScrollPos;
        }
    }

    public void pageUp() {
        this.m_scroll -= this.m_displayableLines - 1;
        --this.m_scroll;
        if (this.m_scroll < 0) {
            this.m_scroll = 0;
        }
    }

    private int getDisplayableTextHeight() {
        FGEngine.getEngine();
        int n = FGEngine.getScreenHeight();
        boolean bl = false;
        if (this.m_upArrowImg != null && this.m_downArrowImg != null) {
            bl = true;
        }
        int n2 = this.m_font.getLineSpacing();
        int n3 = n2 + this.m_font.getHeight() + this.m_font.getLineSpacing();
        int n4 = 0;
        if (bl) {
            n4 = this.m_upArrowImg.getHeight();
            if (this.m_downArrowImg.getHeight() > n4) {
                n4 = this.m_downArrowImg.getHeight();
            }
            n4 += 2;
        }
        int n5 = n - n4;
        return n5 - n3;
    }
}

