/*
 * Decompiled with CFR 0.152.
 */
class FGTripleTapEntry {
    public static final int FLAG_NO_SYMBOLS = 1;
    public static final int FLAG_NO_NUMBERS = 2;
    public static final int FLAG_NO_LOWERCASE = 4;
    public static final int FLAG_NO_UPPERCASE = 8;
    public static final int FLAG_NO_SPACE = 16;
    public static final int FLAG_NO_LETTERS = 12;
    public static final int FLAG_UPPERCASE_LETTERS_ONLY = 23;
    public static final int FLAG_NUMBERS_ONLY = 29;
    public static final int LETTER_TIMEOUT = 1000;
    public static final int MAX_CHARS = 256;
    public static final int KEYCHAR_ID_STAR = 10;
    public static final int KEYCHAR_ID_POUND = 11;
    private static final String SYMBOLS = ".@?!-,&:'~/";
    private static final String LOWERCASE = "abcdefghijklmnopqrstuvwxyz";
    private static final String UPPERCASE = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final String DIGITS = "1234567890";
    private static final int NUM_KEY_CHARS = 12;
    private static final int NUM_KEY_SUBCHARS = 12;
    private static final int KEY_ADVANCE = FGEngine.AVK_RIGHT;
    char[][] m_keyChars = new char[12][12];
    FGTimer m_timeSinceLastPress = new FGTimer();
    char[] m_chars = new char[256];
    int m_pos;
    int m_flags;
    int m_maxLength;
    int m_backspace;
    int m_backspace2;

    public FGTripleTapEntry() {
        for (int i = 0; i < 12; ++i) {
            for (int j = 0; j < 12; ++j) {
                this.m_keyChars[i][j] = 65535;
            }
        }
        this.m_keyChars[0][0] = 48;
        this.m_keyChars[0][1] = 32;
        this.m_keyChars[1][0] = 46;
        this.m_keyChars[1][1] = 33;
        this.m_keyChars[1][2] = 63;
        this.m_keyChars[1][3] = 49;
        this.m_keyChars[1][4] = 64;
        this.m_keyChars[1][5] = 45;
        this.m_keyChars[1][6] = 44;
        this.m_keyChars[1][7] = 38;
        this.m_keyChars[1][8] = 58;
        this.m_keyChars[1][9] = 39;
        this.m_keyChars[1][10] = 47;
        this.m_keyChars[1][11] = 126;
        this.m_keyChars[2][0] = 97;
        this.m_keyChars[2][1] = 98;
        this.m_keyChars[2][2] = 99;
        this.m_keyChars[2][3] = 50;
        this.m_keyChars[2][4] = 65;
        this.m_keyChars[2][5] = 66;
        this.m_keyChars[2][6] = 67;
        this.m_keyChars[3][0] = 100;
        this.m_keyChars[3][1] = 101;
        this.m_keyChars[3][2] = 102;
        this.m_keyChars[3][3] = 51;
        this.m_keyChars[3][4] = 68;
        this.m_keyChars[3][5] = 69;
        this.m_keyChars[3][6] = 70;
        this.m_keyChars[4][0] = 103;
        this.m_keyChars[4][1] = 104;
        this.m_keyChars[4][2] = 105;
        this.m_keyChars[4][3] = 52;
        this.m_keyChars[4][4] = 71;
        this.m_keyChars[4][5] = 72;
        this.m_keyChars[4][6] = 73;
        this.m_keyChars[5][0] = 106;
        this.m_keyChars[5][1] = 107;
        this.m_keyChars[5][2] = 108;
        this.m_keyChars[5][3] = 53;
        this.m_keyChars[5][4] = 74;
        this.m_keyChars[5][5] = 75;
        this.m_keyChars[5][6] = 76;
        this.m_keyChars[6][0] = 109;
        this.m_keyChars[6][1] = 110;
        this.m_keyChars[6][2] = 111;
        this.m_keyChars[6][3] = 54;
        this.m_keyChars[6][4] = 77;
        this.m_keyChars[6][5] = 78;
        this.m_keyChars[6][6] = 79;
        this.m_keyChars[7][0] = 112;
        this.m_keyChars[7][1] = 113;
        this.m_keyChars[7][2] = 114;
        this.m_keyChars[7][3] = 115;
        this.m_keyChars[7][4] = 55;
        this.m_keyChars[7][5] = 80;
        this.m_keyChars[7][6] = 81;
        this.m_keyChars[7][7] = 82;
        this.m_keyChars[7][8] = 83;
        this.m_keyChars[8][0] = 116;
        this.m_keyChars[8][1] = 117;
        this.m_keyChars[8][2] = 118;
        this.m_keyChars[8][3] = 56;
        this.m_keyChars[8][4] = 84;
        this.m_keyChars[8][5] = 85;
        this.m_keyChars[8][6] = 86;
        this.m_keyChars[9][0] = 119;
        this.m_keyChars[9][1] = 120;
        this.m_keyChars[9][2] = 121;
        this.m_keyChars[9][3] = 122;
        this.m_keyChars[9][4] = 57;
        this.m_keyChars[9][5] = 87;
        this.m_keyChars[9][6] = 88;
        this.m_keyChars[9][7] = 89;
        this.m_keyChars[9][8] = 90;
        this.m_flags = 0;
        this.m_maxLength = 256;
    }

    public FGString getString() {
        FGString fGString = new FGString();
        for (int i = 0; i <= this.m_pos; ++i) {
            if (this.m_chars[i] == '\u0000') continue;
            fGString.add(this.m_chars[i]);
        }
        return fGString;
    }

    public void init(String string) {
        int n = FGEngine.getEngine().AVK_BACKSPACE;
        FGEngine.getEngine();
        this.setBackspaceKeys(n, FGEngine.AVK_LEFT);
        if (string == null) {
            this.m_pos = 0;
        } else {
            for (int i = 0; i < string.length(); ++i) {
                this.m_chars[i] = string.charAt(i);
            }
            this.m_pos = string.length();
        }
        this.m_chars[this.m_pos] = '\u0000';
        if (this.m_pos >= this.m_maxLength) {
            this.m_pos = this.m_maxLength - 1;
        }
    }

    public void setFlags(int n) {
        this.m_flags = n;
    }

    public void setMaxLength(int n) {
        this.m_maxLength = n;
    }

    public void keyPressed(int n) {
        if (n == this.m_backspace || n == KEY_ADVANCE || n == this.m_backspace2) {
            this.handleSpecialKey(n);
            this.m_timeSinceLastPress.start(1000);
            return;
        }
        int n2 = -1;
        switch (n) {
            case 48: {
                n2 = 0;
                break;
            }
            case 49: {
                n2 = 1;
                break;
            }
            case 50: {
                n2 = 2;
                break;
            }
            case 51: {
                n2 = 3;
                break;
            }
            case 52: {
                n2 = 4;
                break;
            }
            case 53: {
                n2 = 5;
                break;
            }
            case 54: {
                n2 = 6;
                break;
            }
            case 55: {
                n2 = 7;
                break;
            }
            case 56: {
                n2 = 8;
                break;
            }
            case 57: {
                n2 = 9;
            }
        }
        if (n2 == -1) {
            return;
        }
        int n3 = this.getNumValidSubchars(n2);
        if (n3 == 0) {
            return;
        }
        this.m_timeSinceLastPress.start(1000);
        if (this.m_chars[this.m_pos] == '\u0000') {
            char c;
            boolean bl = false;
            this.m_chars[this.m_pos] = c = this.m_keyChars[n2][this.getFirstValidSubchar(n2)];
            if (n3 == 1) {
                this.confirmChar();
            }
        } else {
            int n4 = this.getKeycharForChar(this.m_chars[this.m_pos]);
            int n5 = this.getKeycharSubcharForChar(this.m_chars[this.m_pos]);
            if (n4 == n2) {
                if (n3 == 1) {
                    return;
                }
                n5 = this.advanceSubchar(n4, n5);
                this.m_chars[this.m_pos] = this.m_keyChars[n4][n5];
            } else {
                this.confirmChar();
                this.m_chars[this.m_pos] = this.m_keyChars[n2][this.getFirstValidSubchar(n2)];
                if (n3 == 1) {
                    this.confirmChar();
                }
            }
        }
    }

    private int getFirstValidSubchar(int n) {
        int n2 = 0;
        char c = this.m_keyChars[n][n2];
        if (!this.isValidResult(c)) {
            n2 = this.advanceSubchar(n, n2);
        }
        return n2;
    }

    private int getNumValidSubchars(int n) {
        int n2 = 0;
        for (int i = 0; i < 12; ++i) {
            if (!this.isValidResult(this.m_keyChars[n][i])) continue;
            ++n2;
        }
        return n2;
    }

    public void tick() {
        if (this.m_chars[this.m_pos] != '\u0000' && this.m_timeSinceLastPress.isOver()) {
            this.confirmChar();
        }
    }

    public boolean isOnUndecidedChar() {
        return this.m_chars[this.m_pos] != '\u0000';
    }

    public void drawSelf(FGGraphics fGGraphics, FGFont fGFont, int n, int n2, int n3) {
        FGString fGString = this.getString();
        fGFont.drawText(fGGraphics, fGString.getNativeString(), n, n2);
        if (!this.isOnUndecidedChar()) {
            int n4 = fGFont.getDisplayLength(fGString.getNativeString());
            int n5 = n + n4 + 1;
            if (fGFont.getJustify() == 2) {
                n5 = n + n4 / 2 + 1;
            } else if (fGFont.getJustify() == 1) {
                n5 = n + 1;
            }
            int n6 = n2;
            int n7 = n2 + fGFont.getHeight();
            fGGraphics.setColor(n3);
            fGGraphics.drawLine(n5, n6, n5, n7);
        }
    }

    private void handleSpecialKey(int n) {
        if (n == this.m_backspace || n == this.m_backspace2) {
            if (this.m_chars[this.m_pos] != '\u0000') {
                this.m_chars[this.m_pos] = '\u0000';
            } else if (this.m_pos > 0) {
                --this.m_pos;
                this.m_chars[this.m_pos] = '\u0000';
            }
        } else if (n == KEY_ADVANCE && this.m_chars[this.m_pos] != '\u0000') {
            this.confirmChar();
        }
    }

    private int getKeycharForChar(char c) {
        for (int i = 0; i < 12; ++i) {
            for (int j = 0; j < 12; ++j) {
                if (this.m_keyChars[i][j] != c) continue;
                return i;
            }
        }
        FGEngine.fatal("Failed getKeycharForChar");
        return 0;
    }

    private int getKeycharSubcharForChar(char c) {
        for (int i = 0; i < 12; ++i) {
            for (int j = 0; j < 12; ++j) {
                if (this.m_keyChars[i][j] != c) continue;
                return j;
            }
        }
        FGEngine.fatal("Failed getKeycharSubcharForChar");
        return 0;
    }

    private void confirmChar() {
        if (this.m_pos < this.m_maxLength - 1) {
            ++this.m_pos;
            this.m_chars[this.m_pos] = '\u0000';
        }
    }

    private int advanceSubchar(int n, int n2) {
        boolean bl = true;
        int n3 = n2++;
        n2 %= 12;
        while (bl) {
            bl = false;
            char c = this.m_keyChars[n][n2];
            if (this.isValidResult(c)) continue;
            ++n2;
            if ((n2 %= 12) == n3) {
                FGEngine.fatal("infinite loop in advanceSubchar");
                return 0;
            }
            bl = true;
        }
        return n2;
    }

    private boolean isValidResult(char c) {
        if (c == '\uffff') {
            return false;
        }
        if ((this.m_flags & 2) != 0 && this.isDigit(c)) {
            return false;
        }
        if ((this.m_flags & 4) != 0 && this.isLower(c)) {
            return false;
        }
        if ((this.m_flags & 8) != 0 && this.isUpper(c)) {
            return false;
        }
        if ((this.m_flags & 1) != 0 && this.isSymbol(c)) {
            return false;
        }
        return (this.m_flags & 0x10) == 0 || c != ' ';
    }

    private boolean isDigit(char c) {
        return DIGITS.indexOf(c) != -1;
    }

    private boolean isLower(char c) {
        return LOWERCASE.indexOf(c) != -1;
    }

    private boolean isUpper(char c) {
        return UPPERCASE.indexOf(c) != -1;
    }

    private boolean isSymbol(char c) {
        return SYMBOLS.indexOf(c) != -1;
    }

    private void setBackspaceKeys(int n, int n2) {
        this.m_backspace = n;
        this.m_backspace2 = n2;
    }
}

