/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.push;

import com.funambol.push.PushNotificationListener;
import com.funambol.util.ConnectionManager;
import com.funambol.util.Log;
import com.funambol.util.ThreadPool;
import java.io.IOException;
import javax.wireless.messaging.Message;
import javax.wireless.messaging.MessageConnection;
import javax.wireless.messaging.MessageListener;

public class OTAService
implements MessageListener,
Runnable {
    private MessageConnection smsconn;
    private String smsConnection;
    private ThreadPool threadPool = null;
    private PushNotificationListener pushListener = null;
    public static boolean smsHandling;
    public static boolean syncViaSMS;
    public static boolean startViaOTA;
    public static boolean firstSMS;
    private int pending = 0;

    public OTAService(String smsPort) {
        this.smsConnection = "sms://:" + smsPort;
    }

    public OTAService(String smsPort, ThreadPool threadPool) {
        this.smsConnection = "sms://:" + smsPort;
        this.threadPool = threadPool;
    }

    public void setPushNotificationListener(PushNotificationListener pushListener) {
        this.pushListener = pushListener;
    }

    public void startService() {
        this.pending = 0;
        if (this.smsconn == null) {
            try {
                Log.info("[OTAService] Start");
                this.smsconn = (MessageConnection)ConnectionManager.getInstance().open(this.smsConnection);
                Log.info("[OTAService] smsConnection open");
                this.smsconn.setMessageListener((MessageListener)this);
                Log.info("[OTAService] set MessageListener");
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                Log.error("[OTAService] IOException opening smsConnection or setting message listener: " + ioe.getMessage());
            }
        }
    }

    public void stopService() {
        if (this.smsconn != null) {
            try {
                Log.info("[OTAService] Closing");
                this.smsconn.close();
                Log.info("[OTAService] Closed");
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                Log.error("[OTAService] IOException closing smsConnection");
            }
        }
    }

    public void setConnection(MessageConnection mc) throws IOException {
        this.smsconn = mc;
        this.smsconn.setMessageListener((MessageListener)this);
    }

    public void notifyIncomingMessage(MessageConnection messageConnection) {
        Log.info("[OTAMessagesListener] notifyIncomingMessage invoked");
        Log.info("[OTAMessagesListener] smsHandling: " + smsHandling);
        ++this.pending;
        smsHandling = true;
        if (!startViaOTA) {
            syncViaSMS = true;
        } else {
            startViaOTA = false;
        }
        this.threadPool.startThread(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            while (this.pending > 0) {
                Log.info("[OTAMessagesListener] Message receiving");
                try {
                    Message msg = this.smsconn.receive();
                    if (msg == null || this.pushListener == null) continue;
                    this.pushListener.handleMessage(msg);
                }
                catch (Exception e) {
                    Log.error("Error: " + e.toString());
                    e.printStackTrace();
                }
                finally {
                    if (this.pending <= 0) continue;
                    --this.pending;
                    Log.info("[OTAMessageListener] message parsed, " + this.pending + " pending messages");
                }
            }
            return;
        }
        finally {
            smsHandling = false;
        }
    }

    static {
        firstSMS = true;
    }
}

