/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.storage;

import com.funambol.storage.AbstractRecordStore;
import com.funambol.storage.ObjectComparator;
import com.funambol.storage.ObjectFilter;
import com.funambol.storage.Serializable;
import com.funambol.storage.Serialized;
import com.funambol.util.Log;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Enumeration;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotOpenException;

public class ObjectEnumeration
implements Enumeration {
    int index = 0;
    byte[] filter = null;
    AbstractRecordStore rs = null;
    Serializable s = null;
    RecordEnumeration re = null;
    int size = 0;

    public ObjectEnumeration() {
    }

    public ObjectEnumeration(AbstractRecordStore refrs, ObjectFilter rf, ObjectComparator rc, Serializable obj) {
        this.rs = refrs;
        this.s = obj;
        try {
            this.re = this.rs.enumerateRecords(rf, rc, false);
            this.size = this.re.numRecords();
        }
        catch (RecordStoreNotOpenException ex) {
            Log.debug(this, "objectEnumeration constructor: RecordStoreBotFoundException ");
            ex.printStackTrace();
        }
    }

    public boolean hasMoreElements() {
        return this.re.hasNextElement();
    }

    public Object nextElement() {
        ByteArrayInputStream dataStream = null;
        Object in = null;
        try {
            int recordIndex = this.re.nextRecordId();
            dataStream = new ByteArrayInputStream(this.rs.getRecord(recordIndex));
            Serializable so = (Serializable)this.s.getClass().newInstance();
            return new Serialized(new DataInputStream(dataStream), so, recordIndex);
        }
        catch (InvalidRecordIDException ex) {
            ex.printStackTrace();
            Log.error(this, "nextElement() InvalidRecordIDException ");
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
            Log.error(this, "nextElement() RecordStoreException ");
        }
        catch (IOException ex) {
            Log.error(this, "nextElement() IOException ");
            ex.printStackTrace();
        }
        catch (InstantiationException ex) {
            Log.error(this, "nextElement() InstantittionException ");
            ex.printStackTrace();
        }
        catch (IllegalAccessException ex) {
            Log.error(this, "nextElement() IllegalAccessException ");
            ex.printStackTrace();
        }
        return null;
    }

    public int getSize() {
        return this.size;
    }
}

