/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.storage;

import com.funambol.storage.ObjectStore;
import com.funambol.storage.Serializable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.rms.RecordStoreException;

class ObjectMap
implements Serializable {
    private ObjectStore objs;
    private Hashtable objmap;
    private Enumeration e;

    ObjectMap(ObjectStore s) {
        this.objs = s;
        this.objmap = new Hashtable();
    }

    public void init() throws RecordStoreException, IOException {
        this.objmap.clear();
        if (this.objs.size() > 0) {
            this.objs.store(1, this);
        } else {
            this.objs.store(this);
        }
    }

    public void load() throws RecordStoreException, IOException {
        this.objs.retrieve(1, this);
    }

    public void save() throws RecordStoreException, IOException {
        this.objs.store(1, this);
    }

    public void add(String name, int index) throws RecordStoreException, IOException {
        this.objmap.put(name, new Integer(index));
        this.save();
    }

    public void del(String name) throws RecordStoreException, IOException {
        this.objmap.remove(name);
        this.save();
    }

    public String[] list() {
        int size = this.objmap.size();
        String[] ret = new String[size];
        Enumeration e = this.objmap.keys();
        for (int i = 0; i < size; ++i) {
            ret[i] = (String)e.nextElement();
        }
        return ret;
    }

    public int lookup(String name) {
        Integer val = (Integer)this.objmap.get(name);
        if (val != null) {
            return val;
        }
        return 0;
    }

    public void serialize(DataOutputStream out) throws IOException {
        out.writeInt(this.objmap.size());
        Enumeration e = this.objmap.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            int val = (Integer)this.objmap.get(key);
            out.writeUTF(key);
            out.writeInt(val);
        }
    }

    public void deserialize(DataInputStream in) throws IOException {
        this.objmap.clear();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            String key = in.readUTF();
            Integer val = new Integer(in.readInt());
            this.objmap.put(key, val);
        }
    }
}

