/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.storage;

import com.funambol.storage.AbstractRecordStore;
import com.funambol.storage.ObjectComparator;
import com.funambol.storage.ObjectEnumeration;
import com.funambol.storage.ObjectFilter;
import com.funambol.storage.ObjectStoreListener;
import com.funambol.storage.Serializable;
import com.funambol.util.Log;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotOpenException;

public class ObjectStore {
    private AbstractRecordStore rs = null;
    private RecordEnumeration re = null;
    private ObjectFilter of;
    private ObjectComparator oc;

    public Enumeration getObjects(Serializable s) {
        return new ObjectEnumeration(this.rs, this.of, this.oc, s);
    }

    public String getName() throws RecordStoreNotOpenException {
        return this.rs.getName();
    }

    public boolean open(String name) throws RecordStoreException {
        return this.openStore(name, false);
    }

    public boolean create(String name) throws RecordStoreException {
        return this.openStore(name, true);
    }

    private boolean openStore(String name, boolean create) throws RecordStoreException {
        if (this.rs != null) {
            if (this.rs.getName().equals(name)) {
                return false;
            }
            this.close();
        }
        this.rs = AbstractRecordStore.openRecordStore(name, create);
        return true;
    }

    public void close() throws RecordStoreException {
        if (this.rs != null) {
            this.rs.closeRecordStore();
        }
        this.rs = null;
        this.re = null;
    }

    public int size() {
        int ret = 0;
        try {
            if (this.rs == null) {
                return -1;
            }
            ret = this.rs.getNumRecords();
        }
        catch (RecordStoreNotOpenException ex) {
            Log.error("Can't get size of ObjectStore: recordstore not open.");
            ret = -1;
        }
        return ret;
    }

    public int getFirstIndex() throws RecordStoreException {
        this.re = this.rs.enumerateRecords(null, null, true);
        return this.getNextIndex();
    }

    public int getNextIndex() throws RecordStoreException {
        if (this.re.hasNextElement()) {
            return this.re.nextRecordId();
        }
        return -1;
    }

    public int store(Serializable obj) throws RecordStoreException, IOException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(byteStream);
        obj.serialize(out);
        byte[] data = byteStream.toByteArray();
        int ret = this.rs.addRecord(data, 0, data.length);
        obj = null;
        data = null;
        byteStream = null;
        out = null;
        return ret;
    }

    public int createEmptyRecord() throws RecordStoreException, IOException {
        int ret = this.rs.addRecord(null, 0, 0);
        return ret;
    }

    public int store(int index, Serializable obj) throws RecordStoreException, IOException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(byteStream);
        obj.serialize(out);
        byte[] data = byteStream.toByteArray();
        this.rs.setRecord(index, data, 0, data.length);
        obj = null;
        return index;
    }

    public Serializable retrieve(int index, Serializable obj) throws RecordStoreException, IOException {
        byte[] data = this.rs.getRecord(index);
        if (data == null) {
            return null;
        }
        ByteArrayInputStream dataStream = new ByteArrayInputStream(data);
        DataInputStream in = new DataInputStream(dataStream);
        obj.deserialize(in);
        return obj;
    }

    public DataInputStream retrieveBytes(int index) throws RecordStoreException, IOException {
        byte[] data = this.rs.getRecord(index);
        if (data != null) {
            ByteArrayInputStream dataStream = new ByteArrayInputStream(data);
            DataInputStream in = new DataInputStream(dataStream);
            return in;
        }
        return null;
    }

    public void remove(int index) throws RecordStoreException {
        this.rs.deleteRecord(index);
    }

    public int getAvaliableStorage() {
        try {
            return this.rs.getSizeAvailable();
        }
        catch (RecordStoreNotOpenException e) {
            e.printStackTrace();
            Log.error("ObjectStore.getAvaliableStorage: " + e.toString());
            return 0;
        }
    }

    public void addStoreListener(ObjectStoreListener listener) {
        throw new RuntimeException("addStoreListener() not implemented");
    }

    public void removeStoreListener(ObjectStoreListener listener) {
        throw new RuntimeException("removeStoreListener() not implemented");
    }

    public void setObjectFilter(ObjectFilter newOf) {
        this.of = newOf;
    }

    public void removeObjectFilter() {
        this.of = null;
    }

    public void setObjectComparator(ObjectComparator newOc) {
        this.oc = newOc;
    }

    public void removeObjectComparator() {
        this.oc = null;
    }
}

