/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.syncml.client;

import com.funambol.push.MessageParserException;
import com.funambol.syncml.client.OTAConfigMessage;
import com.funambol.util.Log;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;

public class OTAConfigMessageParser {
    OTAConfigMessage message = new OTAConfigMessage();
    private String[] remoteURIs;

    public OTAConfigMessageParser() {
        Log.info(this, "OTAConfigMessageParser for OTA Configuration Binary Message");
        this.remoteURIs = new String[7];
    }

    public OTAConfigMessage parseMessage(byte[] byArray) throws IOException, MessageParserException {
        int n = byArray.length - 6;
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 6, byArray2, 0, n);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        int n2 = 0;
        while (dataInputStream.available() != 0) {
            this.parseSection(dataInputStream);
            ++n2;
        }
        this.message.setRemoteURIs(this.remoteURIs);
        return this.message;
    }

    private int parseSection(DataInputStream dataInputStream) throws IOException, MessageParserException {
        Object var2_2 = null;
        int n = this.getSectionType(dataInputStream);
        switch (n) {
            case 1: {
                this.message.setSyncUrl(this.getSectionField(dataInputStream));
                this.message.setUserName(this.getSectionField(dataInputStream));
                this.message.setPassword(this.getSectionField(dataInputStream));
                break;
            }
            case 2: {
                this.remoteURIs[0] = this.getSectionField(dataInputStream);
                this.message.setVisibleName(this.getSectionField(dataInputStream));
                this.message.setMailAddress(this.getSectionField(dataInputStream));
                break;
            }
            case 3: {
                this.remoteURIs[1] = this.getSectionField(dataInputStream);
                String string = this.getSectionField(dataInputStream);
                break;
            }
            case 4: {
                this.remoteURIs[2] = this.getSectionField(dataInputStream);
                String string = this.getSectionField(dataInputStream);
                break;
            }
            case 5: {
                this.remoteURIs[3] = this.getSectionField(dataInputStream);
                String string = this.getSectionField(dataInputStream);
                break;
            }
            case 6: {
                this.remoteURIs[4] = this.getSectionField(dataInputStream);
                break;
            }
            case 7: {
                this.remoteURIs[5] = this.getSectionField(dataInputStream);
                break;
            }
        }
        return n;
    }

    private int getSectionType(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readByte() & 0xFF;
        return n;
    }

    private String getSectionField(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readByte() & 0xFF;
        if (n == 0) {
            return null;
        }
        byte[] byArray = new byte[n];
        dataInputStream.read(byArray, 0, n);
        return new String(byArray);
    }
}

