/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.syncml.spds;

import com.funambol.storage.Serializable;
import com.funambol.util.Log;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class SourceConfig
implements Serializable {
    public static final String MAIL = "mail";
    public static final String CONTACT = "contact";
    public static final String TASK = "task";
    public static final String CALENDAR = "calendar";
    public static final String NOTE = "note";
    public static final String BRIEFCASE = "briefcase";
    public static final String VCARD_NAME = "card";
    public static final String VCARD_TYPE = "text/x-vcard";
    public static final String EMAIL_OBJECT_NAME = "mail";
    public static final String EMAIL_OBJECT_TYPE = "application/vnd.omads-email+xml";
    protected static final int VERSION = 600;
    private int version = 600;
    private String name;
    private String type;
    private String encoding;
    private int syncMode;
    private String remoteUri;
    private long lastAnchor;
    private long nextAnchor;
    private boolean supportsLO;

    public SourceConfig() {
        this.name = BRIEFCASE;
        this.type = "application/*";
        this.encoding = "b64";
        this.syncMode = 200;
        this.remoteUri = BRIEFCASE;
        this.lastAnchor = 0L;
        this.nextAnchor = 0L;
        this.supportsLO = false;
    }

    public SourceConfig(String string, String string2, String string3) {
        this.name = string;
        this.type = string2;
        this.encoding = "b64";
        this.syncMode = 200;
        this.remoteUri = string3;
        this.lastAnchor = 0L;
        this.nextAnchor = 0L;
        this.supportsLO = false;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public int getSyncMode() {
        return this.syncMode;
    }

    public void setSyncMode(int n) {
        this.syncMode = n;
    }

    public String getRemoteUri() {
        return this.remoteUri;
    }

    public void setRemoteUri(String string) {
        this.remoteUri = string;
    }

    public long getLastAnchor() {
        return this.lastAnchor;
    }

    public void setLastAnchor(long l) {
        Log.debug("[Sourceconfig] [ANCHOR]" + this.name + " setting last anchor to " + l);
        this.lastAnchor = l;
    }

    public long getNextAnchor() {
        return this.nextAnchor;
    }

    public void setNextAnchor(long l) {
        Log.debug("[Sourceconfig] [ANCHOR] " + this.name + " setting next anchor to " + l);
        this.nextAnchor = l;
    }

    public boolean getSupportsLO() {
        return this.supportsLO;
    }

    public void setSupportsLO() {
        this.supportsLO = true;
    }

    public void serialize(DataOutputStream dataOutputStream) throws IOException {
        Log.trace("[Sourceconfig.serialize] " + this.name + " serializing. " + "LastAnchor = " + this.lastAnchor + " NextAnchor = " + this.nextAnchor);
        dataOutputStream.writeInt(this.version);
        dataOutputStream.writeUTF(this.name);
        dataOutputStream.writeUTF(this.type);
        dataOutputStream.writeUTF(this.encoding);
        dataOutputStream.writeInt(this.syncMode);
        dataOutputStream.writeUTF(this.remoteUri);
        dataOutputStream.writeLong(this.lastAnchor);
        dataOutputStream.writeLong(this.nextAnchor);
        dataOutputStream.writeInt(this.supportsLO ? 1 : 0);
    }

    public void deserialize(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        if (n != 600) {
            Log.error("Invalid source config version.");
            return;
        }
        this.version = n;
        this.name = dataInputStream.readUTF();
        this.type = dataInputStream.readUTF();
        this.encoding = dataInputStream.readUTF();
        this.syncMode = dataInputStream.readInt();
        this.remoteUri = dataInputStream.readUTF();
        this.lastAnchor = dataInputStream.readLong();
        this.nextAnchor = dataInputStream.readLong();
        int n2 = dataInputStream.readInt();
        this.supportsLO = n2 == 1;
    }
}

