/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.syncml.spds;

import com.funambol.syncml.protocol.SyncFilter;
import com.funambol.syncml.protocol.SyncMLCommand;
import com.funambol.syncml.protocol.SyncMLStatus;
import com.funambol.syncml.spds.Challenge;
import com.funambol.syncml.spds.CmdId;
import com.funambol.syncml.spds.CompressedSyncException;
import com.funambol.syncml.spds.DeviceConfig;
import com.funambol.syncml.spds.MappingManager;
import com.funambol.syncml.spds.ReadResponseException;
import com.funambol.syncml.spds.SyncConfig;
import com.funambol.syncml.spds.SyncException;
import com.funambol.syncml.spds.SyncItem;
import com.funambol.syncml.spds.SyncSource;
import com.funambol.syncml.spds.SyncSourceLOHandler;
import com.funambol.syncml.spds.WriteRequestException;
import com.funambol.util.Base64;
import com.funambol.util.BasicSyncListener;
import com.funambol.util.ChunkedString;
import com.funambol.util.CodedException;
import com.funambol.util.HttpTransportAgent;
import com.funambol.util.Log;
import com.funambol.util.StringUtil;
import com.funambol.util.SyncListener;
import com.funambol.util.XmlException;
import com.funambol.util.XmlUtil;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class SyncManager {
    private static final int STATE_SENDING_ADD = 1;
    private static final int STATE_SENDING_REPLACE = 2;
    private static final int STATE_SENDING_DELETE = 3;
    private static final int STATE_MODIFICATION_COMPLETED = 4;
    private SyncConfig config;
    protected SyncSource source;
    private String deviceId;
    private int maxMsgSize;
    private boolean sendDevInf = false;
    private boolean addDevInfResults = false;
    private String lastServerUrl;
    private String cmdIDget = null;
    private String msgIDget = null;
    int state;
    private Hashtable serverAlerts;
    protected int alertCode;
    private String serverUrl;
    private String login = null;
    private String sessionID = null;
    private Hashtable mappings = null;
    private Vector statusList = null;
    private int msgID = 0;
    private CmdId cmdID = new CmdId(0);
    private HttpTransportAgent transportAgent;
    private static final int PROTOCOL_OVERHEAD = 3072;
    private boolean busy;
    private SyncListener listener;
    private static SyncListener basicListener = null;
    private MappingManager mappingManager = null;
    private boolean isMappingTestDisabled = true;
    private SyncSourceLOHandler sourceLOHandler = null;

    public SyncManager(SyncConfig syncConfig) {
        this.config = syncConfig;
        this.login = syncConfig.userName + ":" + syncConfig.password;
        this.source = null;
        this.deviceId = this.config.deviceConfig.devID;
        this.maxMsgSize = this.config.deviceConfig.maxMsgSize;
        this.state = 0;
        this.serverAlerts = null;
        this.alertCode = 0;
        this.mappings = null;
        this.busy = false;
        this.statusList = null;
        this.transportAgent = new HttpTransportAgent(this.config.syncUrl, this.config.userAgent, "UTF-8", syncConfig.compress, syncConfig.forceCookies);
        Log.debug("Creating Mapping Manager");
        this.mappingManager = new MappingManager();
        Log.debug("Mapping Manager Created");
    }

    public void sync(SyncSource syncSource) throws SyncException {
        this.sync(syncSource, syncSource.getSyncMode());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void sync(SyncSource syncSource, int n) throws SyncException {
        this.busy = true;
        this.resetMsgID();
        this.sourceLOHandler = new SyncSourceLOHandler(syncSource, this.maxMsgSize);
        this.listener = syncSource.getListener();
        if (this.listener == null) {
            if (basicListener == null) {
                basicListener = this.listener = new BasicSyncListener();
            } else {
                this.listener = basicListener;
            }
        }
        this.listener.startSession();
        if (n == 0) {
            Log.info("[SyncManager] Source not active.");
            this.listener.endSession(128);
            return;
        }
        int n2 = 128;
        try {
            String string;
            String string2;
            String string3;
            String string4;
            String string5 = null;
            this.source = syncSource;
            this.nextState(1);
            this.source.setNextAnchor(System.currentTimeMillis());
            this.sessionID = String.valueOf(System.currentTimeMillis());
            this.serverUrl = this.config.syncUrl;
            if (this.isNewServerUrl(this.serverUrl)) {
                this.setFlagSendDevInf();
            }
            Log.info("[SyncManager] Sending init message");
            this.listener.startConnecting();
            String string6 = this.prepareInizializationMessage(n, null);
            Log.debug(string6);
            Log.info("Really sending message");
            string5 = this.postRequest(string6);
            string6 = null;
            Log.info("[SyncManager] Response received");
            Log.debug("[SyncManager] Response: " + string5);
            this.listener.dataReceived(this.transportAgent.getResponseDate(), string5.length());
            ChunkedString chunkedString = new ChunkedString(string5);
            boolean bl = false;
            try {
                this.checkStatus(chunkedString, "SyncHdr");
            }
            catch (SyncException syncException) {
                if (syncException.getCode() != 6 && syncException.getCode() != 401) throw syncException;
                bl = true;
            }
            try {
                this.checkStatus(chunkedString, "Alert");
            }
            catch (SyncException syncException) {
                if (syncException.getCode() != 6) throw syncException;
                bl = true;
            }
            if (bl) {
                string4 = this.findChallenge(chunkedString);
                String string7 = null;
                if (string4 != null) {
                    string7 = this.generateChallengeResponseTags(string4);
                }
                Log.info("[SyncManager] Resending init message");
                string6 = this.prepareInizializationMessage(n, string7);
                Log.debug(string6);
                this.transportAgent.setRetryOnWrite(3);
                string5 = this.postRequest(string6);
                chunkedString = new ChunkedString(string5);
                string6 = null;
                Log.info("[SyncManager] Response received");
                Log.debug("[SyncManager] Response: " + string5);
            }
            this.checkServerAlerts(chunkedString);
            string4 = this.source.getName();
            Log.debug(string4);
            this.alertCode = this.getSourceAlertCode(string4);
            Log.info("[SyncManager] Alert code: " + this.alertCode);
            Log.info("[SyncManager] Initialization succesfully completed");
            this.listener.endConnecting(this.alertCode);
            this.addDevInfResults = this.isGetCommandFromServer(chunkedString);
            try {
                this.serverUrl = XmlUtil.getTagValue(chunkedString, "RespURI").toString();
            }
            catch (XmlException xmlException) {
                Log.error("[SyncManager] Error parsing RespURI from server " + xmlException.toString());
            }
            string5 = null;
            this.statusList = new Vector();
            switch (this.alertCode) {
                case 200: 
                case 204: 
                case 206: 
                case 209: {
                    this.mappings = this.mappingManager.getMappings(this.source.getName());
                    break;
                }
                case 0: 
                case 201: 
                case 202: 
                case 203: 
                case 205: 
                case 207: 
                case 208: 
                case 210: {
                    this.mappings = new Hashtable();
                    this.mappingManager.resetMappings(this.source.getName());
                    break;
                }
            }
            boolean bl2 = this.listener.startSyncing(this.alertCode);
            if (!bl2) {
                Log.info("[SyncManager] Sync process aborted by the user");
                return;
            }
            this.source.beginSync(this.alertCode);
            this.listener.syncStarted(this.alertCode);
            boolean bl3 = false;
            do {
                this.listener.startSending(this.source.getClientAddNumber(), this.source.getClientReplaceNumber(), this.source.getClientDeleteNumber());
                string3 = this.findChallenge(chunkedString);
                string2 = null;
                if (string3 != null) {
                    string2 = this.generateChallengeResponseTags(string3);
                }
                string = this.prepareModificationMessage(string2);
                Log.info("[SyncManager] Sending modification");
                Log.debug(string);
                string5 = this.postRequest(string);
                chunkedString = new ChunkedString(string5);
                try {
                    this.checkStatus(chunkedString, "SyncHdr");
                }
                catch (SyncException syncException) {
                    Log.error("SyncManager.sync: not authenticated, bailing out");
                    throw syncException;
                }
                string = null;
                Log.info("response received");
                Log.debug(string5);
                this.listener.endSending();
                this.processModifications(new ChunkedString(string5));
                bl3 = string5.indexOf("<Final/>") >= 0 || string5.indexOf("</Final>") >= 0;
                string5 = null;
                this.listener.endReceiving();
                this.mappingManager.saveMappings(this.source.getName(), this.mappings);
            } while (!bl3);
            Log.info("Modification session succesfully completed");
            this.listener.endSyncing();
            this.listener.startMapping();
            if (!this.isMappingTestDisabled) {
                Log.debug("MAPPING OBJECTS CLEARED FOR TESTING PURPOSES");
                throw new SyncException(2, "Connection blocked for test purposes");
            }
            if (this.statusList.size() > 0 || this.mappings.size() > 0) {
                string3 = this.findChallenge(chunkedString);
                string2 = null;
                if (string3 != null) {
                    string2 = this.generateChallengeResponseTags(string3);
                }
                string = this.prepareMappingMessage(string2);
                Log.info("Sending Mappings\n");
                Log.debug(string);
                try {
                    string5 = this.postRequest(string);
                }
                catch (ReadResponseException readResponseException) {
                    this.source.setLastAnchor(this.source.getNextAnchor());
                    Log.info("[SyncManager] Last sync message sent - Error reading the response " + readResponseException);
                }
                string = null;
                if (string5 != null) {
                    Log.info("response received");
                    Log.debug(string5);
                    this.checkStatus(new ChunkedString(string5), "SyncHdr");
                    string5 = null;
                } else {
                    Log.info("Response not received");
                    Log.info("Skipping check for status");
                }
                Log.info("Mapping session succesfully completed");
            } else {
                Log.info("No mapping message to send");
            }
            Log.debug("Notifying listener end mapping");
            this.listener.endMapping();
            Log.debug("Changing anchors");
            this.source.setLastAnchor(this.source.getNextAnchor());
            Log.debug("source endSync method call");
            this.source.endSync();
            if (this.isMappingTestDisabled) {
                this.mappingManager.resetMappings(this.source.getName());
            }
            switch (this.source.getStatus()) {
                case 0: {
                    n2 = 128;
                    return;
                }
                case 1: {
                    n2 = 150;
                    return;
                }
                case 2: {
                    n2 = 151;
                    return;
                }
                default: {
                    n2 = 149;
                    return;
                }
            }
        }
        catch (CompressedSyncException compressedSyncException) {
            Log.error("[SyncManager] CompressedSyncException: " + compressedSyncException);
            n2 = 8;
            throw compressedSyncException;
        }
        catch (SyncException syncException) {
            switch (syncException.getCode()) {
                case 401: {
                    n2 = 129;
                    throw syncException;
                }
                case 403: {
                    n2 = 130;
                    throw syncException;
                }
                case 406: {
                    n2 = 131;
                    throw syncException;
                }
                case 0: {
                    n2 = 143;
                    throw syncException;
                }
                case 1: {
                    n2 = 144;
                    throw syncException;
                }
                case 2: {
                    n2 = 145;
                    throw syncException;
                }
                case 511: {
                    n2 = 141;
                    throw syncException;
                }
                case 405: {
                    n2 = 142;
                    throw syncException;
                }
                case 3: {
                    n2 = 146;
                    throw syncException;
                }
                case 4: {
                    n2 = 147;
                    throw syncException;
                }
                case 400: {
                    n2 = 134;
                    throw syncException;
                }
                case 404: {
                    n2 = 135;
                    throw syncException;
                }
                case 407: {
                    n2 = 136;
                    throw syncException;
                }
                case 409: {
                    n2 = 137;
                    throw syncException;
                }
                case 500: {
                    n2 = 138;
                    throw syncException;
                }
                case 503: {
                    n2 = 139;
                    throw syncException;
                }
                case 506: {
                    n2 = 140;
                    throw syncException;
                }
                case 5: {
                    n2 = 148;
                    throw syncException;
                }
                default: {
                    n2 = 149;
                }
            }
            throw syncException;
        }
        finally {
            Log.debug("[SyncManager] Ending session");
            this.listener.endSession(n2);
            this.releaseResources();
        }
    }

    private void releaseResources() {
        this.mappings = null;
        this.statusList = null;
        this.source = null;
        this.sessionID = null;
        this.serverUrl = null;
        this.busy = false;
    }

    public void setFlagSendDevInf() {
        this.sendDevInf = true;
    }

    public boolean isBusy() {
        return this.busy;
    }

    private boolean isNewServerUrl(String string) {
        this.lastServerUrl = this.config.lastServerUrl;
        return !StringUtil.equalsIgnoreCase(this.lastServerUrl, string);
    }

    private String postRequest(String string) throws SyncException {
        this.transportAgent.setRequestURL(this.serverUrl);
        try {
            return this.transportAgent.sendMessage(string);
        }
        catch (CodedException codedException) {
            int n;
            switch (codedException.getCode()) {
                case 200: {
                    n = 407;
                    break;
                }
                case 201: {
                    n = 406;
                    break;
                }
                case 202: {
                    n = 409;
                    break;
                }
                case 203: {
                    int n2 = 1;
                    WriteRequestException writeRequestException = new WriteRequestException(n2, codedException.toString());
                    throw writeRequestException;
                }
                case 204: {
                    CompressedSyncException compressedSyncException = new CompressedSyncException(codedException.toString());
                    throw compressedSyncException;
                }
                case 205: {
                    n = 3;
                    break;
                }
                case 206: {
                    int n3 = 0;
                    ReadResponseException readResponseException = new ReadResponseException(n3, codedException.toString());
                    throw readResponseException;
                }
                default: {
                    n = 400;
                }
            }
            SyncException syncException = new SyncException(n, codedException.toString());
            throw syncException;
        }
    }

    private boolean checkMD5(String string) {
        return false;
    }

    private void checkStatus(ChunkedString chunkedString, String string) throws SyncException {
        Vector vector = null;
        try {
            vector = XmlUtil.getTagValues(XmlUtil.getTagValues(XmlUtil.getTagValues(chunkedString, "SyncML"), "SyncBody"), "Status");
        }
        catch (XmlException xmlException) {
            xmlException.printStackTrace();
            Log.error("checkStatus: error parsing server status " + chunkedString);
            return;
        }
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            ChunkedString chunkedString2 = (ChunkedString)vector.elementAt(i);
            SyncMLStatus syncMLStatus = SyncMLStatus.parse(chunkedString2);
            if (syncMLStatus == null || !string.equals(syncMLStatus.getCmd())) continue;
            switch (syncMLStatus.getStatus()) {
                case 200: {
                    return;
                }
                case 508: {
                    Log.info("[SyncManager] Refresh required by server.");
                    return;
                }
                case 212: {
                    Log.info("[SyncManager] Authentication accepted by the server.");
                    return;
                }
                case 401: {
                    if (this.checkMD5(chunkedString.toString())) {
                        Log.error("MD5 authentication not supported");
                        throw new SyncException(401, "MD5 authentication not supported");
                    }
                    Log.error("Invalid credentials: " + this.config.userName);
                    throw new SyncException(401, "Authentication failed for: " + this.source.getSourceUri());
                }
                case 407: {
                    Log.error("[SyncManager] Missing credentials )");
                    throw new SyncException(6, "Missing credentials for: " + this.source.getSourceUri());
                }
                case 403: {
                    throw new SyncException(403, "User not authorized: " + this.config.userName + " for source: " + this.source.getSourceUri());
                }
                case 404: {
                    Log.error(this, "Source URI not found on server: " + this.source.getSourceUri());
                    throw new SyncException(405, "Source URI not found on server: " + this.source.getSourceUri());
                }
                case 503: {
                    throw new SyncException(503, "Server busy, another sync in progress for " + this.source.getSourceUri());
                }
                case 506: {
                    throw new SyncException(506, "Error processing source: " + this.source.getSourceUri() + syncMLStatus.getStatusDataMessage());
                }
                case 511: {
                    throw new SyncException(511, "Error processing source: " + this.source.getSourceUri() + syncMLStatus.getStatusDataMessage());
                }
            }
            Log.debug("[SyncManger] Unhandled Status Code, throwing exception");
            throw new SyncException(500, "Error from server: " + syncMLStatus.getStatus());
        }
        Log.error("checkStatus: can't find Status in " + string + " in server response");
        throw new SyncException(500, "Status Tag for " + string + " not found in server response");
    }

    private String generateChallengeResponseTags(String string) {
        CharSequence charSequence;
        if (string == null) {
            throw new IllegalArgumentException("aChallenge is null");
        }
        ChunkedString chunkedString = new ChunkedString(string);
        byte[] byArray = null;
        Log.info("Challenge found, resending init package with challenge response");
        try {
            charSequence = XmlUtil.getTagValue(chunkedString, "Type").toString();
            String string2 = XmlUtil.getTagValue(chunkedString, "Format").toString();
            String string3 = XmlUtil.getTagValue(chunkedString, "NextNonce").toString();
            System.out.println("2nonceData before decode: " + string3);
            String string4 = new String(Base64.decode(string3, "UTF-8"));
            System.out.println("Data after decode: '" + string4 + "'");
            System.out.println("User: '" + this.config.userName + "'");
            System.out.println("PASS: '" + this.config.password + "'");
            try {
                byArray = Challenge.challengeResponse((String)charSequence, string2, this.config.userName, this.config.password, string4.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                System.out.println("generateChallengeResponseTags:UnsupportedEncodingException");
                byArray = Challenge.challengeResponse((String)charSequence, string2, this.config.userName, this.config.password, string4.getBytes());
            }
        }
        catch (XmlException xmlException) {
            throw new SyncException(401, "Cannot parse challenge from: " + chunkedString);
        }
        if (byArray == null) {
            throw new SyncException(400, "Could not create response");
        }
        charSequence = new StringBuffer("<Cred>\n");
        ((StringBuffer)charSequence).append("<Meta>").append("<Type xmlns='syncml:metinf'>syncml:auth-md5</Type>\n").append("<Format xmlns='syncml:metinf'>b64</Format>\n").append("</Meta>\n").append("<Data>").append(new String(byArray)).append("</Data>").append("</Cred>\n");
        return ((StringBuffer)charSequence).toString();
    }

    private String findChallenge(ChunkedString chunkedString) {
        Vector vector = null;
        try {
            vector = XmlUtil.getTagValues(XmlUtil.getTagValues(XmlUtil.getTagValues(chunkedString, "SyncML"), "SyncBody"), "Status");
        }
        catch (XmlException xmlException) {
            xmlException.printStackTrace();
            Log.error("checkStatus: error parsing chal elements " + chunkedString);
            return null;
        }
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            String string;
            ChunkedString chunkedString2 = (ChunkedString)vector.elementAt(i);
            SyncMLStatus syncMLStatus = SyncMLStatus.parse(chunkedString2);
            if (syncMLStatus == null || !"SyncHdr".equals(syncMLStatus.getCmd()) || (string = syncMLStatus.getChallenge()) == null) continue;
            Log.info("SyncManager.findChallenge: Found challenge: " + string.toString());
            return string;
        }
        return null;
    }

    private void checkServerAlerts(ChunkedString chunkedString) throws SyncException {
        ChunkedString chunkedString2 = null;
        ChunkedString chunkedString3 = null;
        Vector vector = null;
        this.serverAlerts = new Hashtable();
        try {
            vector = XmlUtil.getTagValues(XmlUtil.getTagValues(XmlUtil.getTagValues(chunkedString, "SyncML"), "SyncBody"), "Alert");
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ChunkedString chunkedString4 = (ChunkedString)vector.elementAt(i);
                chunkedString3 = XmlUtil.getTagValue(chunkedString4, "Data");
                Log.info("CHUNK: " + chunkedString4.toString() + " is " + chunkedString3);
                Vector vector2 = XmlUtil.getTagValues(chunkedString4, "Item");
                int n2 = vector2.size();
                for (int j = 0; j < n2; ++j) {
                    ChunkedString chunkedString5 = (ChunkedString)vector2.elementAt(j);
                    chunkedString2 = XmlUtil.getTagValue(chunkedString5, "Target");
                    chunkedString2 = XmlUtil.getTagValue(chunkedString2, "LocURI");
                    Log.info("The server alert code for " + chunkedString2 + " is " + chunkedString3);
                    this.serverAlerts.put(chunkedString2.toString(), chunkedString3.toString());
                }
            }
        }
        catch (XmlException xmlException) {
            Log.error("checkServerAlerts: error parsing server alert " + chunkedString);
            xmlException.printStackTrace();
            throw new SyncException(500, "Invalid alert from server.");
        }
    }

    private String prepareSyncHeader(String string, String string2, String string3, String string4, String string5) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<SyncHdr>\n").append("<VerDTD>1.2</VerDTD>\n").append("<VerProto>SyncML/1.2</VerProto>\n").append("<SessionID>").append(string).append("</SessionID>\n").append("<MsgID>").append(string2).append("</MsgID>\n").append("<Target><LocURI>").append(this.urlEncode(string4)).append("</LocURI></Target>\n").append("<Source><LocURI>").append(string3).append("</LocURI><LocName>").append(this.config.userName).append("</LocName></Source>\n");
        if (string5 != null) {
            stringBuffer.append(string5);
        }
        stringBuffer.append("</SyncHdr>\n");
        return stringBuffer.toString();
    }

    private String prepareInizializationMessage(int n, String string) throws SyncException {
        String string2 = null;
        StringBuffer stringBuffer = new StringBuffer("<SyncML xmlns='SYNCML:SYNCML1.2'>\n");
        boolean bl = false;
        if (string == null) {
            string2 = new String(Base64.encode(this.login.getBytes()));
            Log.info("Login: " + string2);
            StringBuffer stringBuffer2 = new StringBuffer("<Cred>\n");
            stringBuffer2.append("<Meta>").append("<Type xmlns=\"syncml:metinf\">syncml:auth-basic</Type>\n").append("<Format xmlns=\"syncml:metinf\">b64</Format>\n").append("</Meta>\n").append("<Data>").append(string2).append("</Data>").append("</Cred>\n");
            stringBuffer2.append("<Meta><MaxMsgSize>").append(this.maxMsgSize).append("</MaxMsgSize></Meta>\n");
            string = stringBuffer2.toString();
        }
        stringBuffer.append(this.prepareSyncHeader(this.sessionID, this.getNextMsgID(), this.deviceId, this.serverUrl, string));
        if (bl) {
            string = null;
        }
        stringBuffer.append("<SyncBody>\n");
        if (this.msgID > 1) {
            int n2 = this.msgID - 1;
            stringBuffer.append("<Status>\n").append("<CmdID>").append(this.resetCmdID()).append("</CmdID>\n").append("<MsgRef>" + n2 + "</MsgRef><CmdRef>0</CmdRef>\n").append("<Cmd>SyncHdr</Cmd>\n").append("<TargetRef>").append(this.deviceId).append("</TargetRef>\n").append("<SourceRef>").append(this.urlEncode(this.serverUrl)).append("</SourceRef>\n").append("<Data>200</Data>\n</Status>\n");
        }
        if (this.sendDevInf) {
            stringBuffer.append(this.createPut(this.config.deviceConfig, 2));
        }
        stringBuffer.append(this.createAlerts(this.source, n, 3));
        stringBuffer.append("<Final/>").append("</SyncBody>\n");
        stringBuffer.append("</SyncML>\n");
        return stringBuffer.toString();
    }

    private String prepareTermsRejectedMessage() throws SyncException {
        StringBuffer stringBuffer = new StringBuffer("<SyncML xmlns='SYNCML:SYNCML1.2'>\n");
        stringBuffer.append(this.prepareSyncHeader(this.sessionID, this.getNextMsgID(), this.deviceId, this.serverUrl, null));
        stringBuffer.append("<SyncBody>\n");
        if (this.msgID > 1) {
            int n = this.msgID - 1;
            stringBuffer.append("<Status>\n").append("<CmdID>").append(this.resetCmdID()).append("</CmdID>\n").append("<MsgRef>" + n + "</MsgRef><CmdRef>0</CmdRef>\n").append("<Cmd>SyncHdr</Cmd>\n").append("<TargetRef>").append(this.deviceId).append("</TargetRef>\n").append("<SourceRef>").append(this.urlEncode(this.serverUrl)).append("</SourceRef>\n").append("<Data>").append(403).append("</Data>\n</Status>\n");
        }
        if (this.sendDevInf) {
            stringBuffer.append(this.createPut(this.config.deviceConfig, 2));
        }
        stringBuffer.append("<Final/>").append("</SyncBody>\n");
        stringBuffer.append("</SyncML>\n");
        return stringBuffer.toString();
    }

    private String[] processFormat(ChunkedString chunkedString) {
        String[] stringArray = null;
        try {
            ChunkedString chunkedString2;
            if (XmlUtil.getTag(chunkedString, "Format") != -1 && (chunkedString2 = XmlUtil.getTagValue(chunkedString, "Format")) != null && !chunkedString2.equals("")) {
                stringArray = StringUtil.split(chunkedString2.toString(), ";");
            }
        }
        catch (XmlException xmlException) {
            Log.error("[processFormat] Error parsing format from server: " + chunkedString + ". Ignoring it.");
            xmlException.printStackTrace();
        }
        return stringArray;
    }

    private byte[] decodeItemData(String[] stringArray, byte[] byArray) throws UnsupportedEncodingException {
        if (stringArray != null && byArray != null) {
            for (int i = stringArray.length - 1; i >= 0; --i) {
                String string = stringArray[i];
                if (string.equals("b64")) {
                    byArray = Base64.decode(byArray);
                    continue;
                }
                if (string.equals("des")) {
                    return null;
                }
                if (!string.equals("3des")) continue;
                return null;
            }
        }
        return byArray;
    }

    private SyncItem getItem(char c, String string, ChunkedString chunkedString, String[] stringArray) throws SyncException {
        String string2 = null;
        String string3 = null;
        String string4 = null;
        byte[] byArray = null;
        try {
            string2 = XmlUtil.getTagValue(chunkedString, "LocURI").toString();
        }
        catch (XmlException xmlException) {
            Log.error("[getItem] Invalid item key from server: " + chunkedString);
            xmlException.printStackTrace();
            throw new SyncException(500, "Invalid item key from server.");
        }
        if (XmlUtil.getTag(chunkedString, "TargetParent") > 0) {
            try {
                string4 = XmlUtil.getTagValue(XmlUtil.getTagValue(chunkedString, "TargetParent"), "LocURI").toString();
            }
            catch (XmlException xmlException) {
                Log.error("[getItem] Invalid item parent from server: " + xmlException.toString());
                throw new SyncException(500, "Invalid item parent from server.");
            }
        }
        if (XmlUtil.getTag(chunkedString, "Data") != -1) {
            try {
                string3 = XmlUtil.getTagValue(chunkedString, "Data").toString();
                if (stringArray != null) {
                    byArray = this.decodeItemData(stringArray, string3.getBytes());
                } else if (!this.source.getEncoding().equals("none")) {
                    stringArray = this.processFormat(new ChunkedString(this.source.getEncoding()));
                    byArray = this.decodeItemData(stringArray, string3.toString().getBytes());
                } else {
                    byArray = XmlUtil.unescapeXml(string3).getBytes("UTF-8");
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
                Log.error("[getItem] Can't decode content for item: " + string2);
                byArray = null;
            }
            catch (XmlException xmlException) {
                xmlException.printStackTrace();
                Log.error("[getItem] Can't parse data tag for item: " + string2);
                byArray = null;
            }
        }
        return new SyncItem(string2, string, c, string4, byArray);
    }

    private SyncMLStatus processSyncItem(SyncMLCommand syncMLCommand, ChunkedString chunkedString, String[] stringArray) throws SyncException {
        int n = 0;
        SyncItem syncItem = null;
        String string = null;
        String string2 = syncMLCommand.getName();
        if (string2.equals("Add")) {
            syncItem = this.getItem('N', syncMLCommand.getType(), chunkedString, stringArray);
            string = new String(syncItem.getKey());
            if (syncItem.getContent() != null) {
                n = this.sourceLOHandler.addItem(syncItem);
                if (SyncMLStatus.isSuccess(n)) {
                    this.listener.itemReceived(syncItem.getClientRepresentation());
                }
            } else {
                n = 500;
            }
            if (SyncMLStatus.isSuccess(n)) {
                this.mappings.put(new String(syncItem.getKey()), string);
            }
        } else if (string2.equals("Replace")) {
            syncItem = this.getItem('U', syncMLCommand.getType(), chunkedString, stringArray);
            if (syncItem.getContent() != null) {
                n = this.sourceLOHandler.updateItem(syncItem);
                if (SyncMLStatus.isSuccess(n)) {
                    this.listener.itemUpdated(syncItem.getKey(), syncItem.getClientRepresentation());
                }
            } else {
                n = 500;
            }
        } else if (string2.equals("Delete")) {
            syncItem = this.getItem('D', syncMLCommand.getType(), chunkedString, stringArray);
            n = this.source.deleteItem(syncItem.getKey());
            if (SyncMLStatus.isSuccess(n)) {
                this.listener.itemDeleted(syncItem.getKey());
            }
        } else {
            Log.error("[processItem] Invalid command: " + syncMLCommand.toString());
        }
        SyncMLStatus syncMLStatus = new SyncMLStatus();
        syncMLStatus.setCmd(string2);
        syncMLStatus.setCmdRef(syncMLCommand.getCmdId());
        if (string != null) {
            syncMLStatus.setSrcRef(string);
        } else {
            syncMLStatus.setTgtRef(syncItem.getKey());
        }
        syncMLStatus.setStatus(n);
        return syncMLStatus;
    }

    private int processCommand(ChunkedString chunkedString, String string, ChunkedString chunkedString2) throws SyncException {
        ChunkedString chunkedString3 = null;
        int n = 0;
        try {
            chunkedString3 = XmlUtil.getTagValue(chunkedString2, "CmdID");
        }
        catch (XmlException xmlException) {
            Log.error("[processCommand] Invalid command Id from server: " + chunkedString2);
            xmlException.printStackTrace();
            throw new SyncException(500, "Invalid command from server.");
        }
        SyncMLCommand syncMLCommand = new SyncMLCommand(string, chunkedString3.toString());
        try {
            int n2 = XmlUtil.getTag(chunkedString2, "Type");
            String string2 = null;
            if (n2 != -1) {
                try {
                    string2 = XmlUtil.getTagValue(chunkedString2, "Type").toString();
                }
                catch (XmlException xmlException) {
                    xmlException.printStackTrace();
                    Log.error("Error parsing item type, using default for source.");
                }
            }
            if (string2 != null) {
                syncMLCommand.setType(string2);
            } else {
                syncMLCommand.setType(this.source.getType());
            }
            String[] stringArray = this.processFormat(chunkedString2);
            Vector vector = XmlUtil.getTagValues(chunkedString2, "Item");
            int n3 = vector.size();
            SyncMLStatus syncMLStatus = null;
            for (n = 0; n < n3; ++n) {
                syncMLStatus = this.processSyncItem(syncMLCommand, (ChunkedString)vector.elementAt(n), stringArray);
                syncMLStatus.setMsgRef(chunkedString.toString());
                this.statusList.addElement(syncMLStatus);
            }
        }
        catch (XmlException xmlException) {
            xmlException.printStackTrace();
            Log.error("[processCommand] Parse error: " + xmlException.toString());
            throw new SyncException(500, "Error processing command:" + string + " in message " + chunkedString);
        }
        return n;
    }

    protected boolean processModifications(ChunkedString chunkedString) throws SyncException {
        int n;
        int n2;
        String[] stringArray;
        Object object;
        boolean bl = false;
        ChunkedString chunkedString2 = null;
        ChunkedString chunkedString3 = null;
        try {
            if (XmlUtil.getTag(chunkedString, "SyncML") == -1) {
                Log.error("Invalid message from server.");
                throw new SyncException(500, "Invalid message from server.");
            }
            object = XmlUtil.getTagValue(chunkedString, "SyncHdr");
            chunkedString2 = XmlUtil.getTagValue((ChunkedString)object, "MsgID");
            chunkedString3 = XmlUtil.getTagValue(chunkedString, "SyncBody");
        }
        catch (XmlException xmlException) {
            Log.error("[processModification] error parsing message: " + xmlException.toString());
            throw new SyncException(500, "Error parsing message: " + xmlException.getMessage());
        }
        object = null;
        Vector<ChunkedString> vector = new Vector<ChunkedString>(1);
        vector.addElement(chunkedString3);
        if (this.alertCode != 202 && this.alertCode != 203) {
            try {
                if (XmlUtil.getTag(chunkedString3, "Sync") != -1) {
                    bl = true;
                    stringArray = new String[]{"Add", "Replace", "Delete"};
                    this.processSyncCommand(chunkedString2, chunkedString3);
                    chunkedString3 = null;
                    for (n2 = 0; n2 < stringArray.length; ++n2) {
                        n = 0;
                        Log.debug("[processModification] processing " + stringArray[n2] + " commands");
                        object = XmlUtil.getTagValues(vector, stringArray[n2]);
                        int n3 = ((Vector)object).size();
                        for (int i = 0; i < n3; ++i) {
                            ChunkedString chunkedString4 = (ChunkedString)((Vector)object).elementAt(i);
                            n += this.processCommand(chunkedString2, stringArray[n2], chunkedString4);
                            chunkedString4 = null;
                        }
                        object = null;
                        Log.info(stringArray[n2] + ": " + n + " items processed");
                    }
                }
            }
            catch (XmlException xmlException) {
                xmlException.printStackTrace();
                Log.error("[processModification] error parsing command: " + xmlException.toString());
            }
        }
        try {
            object = XmlUtil.getTagValues(vector, "Status");
            stringArray = null;
            n = ((Vector)object).size();
            for (n2 = 0; n2 < n; ++n2) {
                stringArray = SyncMLStatus.parse((ChunkedString)((Vector)object).elementAt(n2));
                if (stringArray != null) {
                    String string = stringArray.getCmd();
                    Log.debug("[processModification] processing Status for <" + string + "> command.");
                    if (string.equals("SyncHdr") || string.equals("Sync")) {
                        if (!SyncMLStatus.isSuccess(stringArray.getStatus())) {
                            SyncException syncException;
                            String string2 = "Server responded " + stringArray.getStatus() + " to command " + string + " [" + stringArray.getStatusDataMessage() + "]";
                            Log.error(string2);
                            switch (stringArray.getStatus()) {
                                case 503: {
                                    syncException = new SyncException(503, string2);
                                    break;
                                }
                                case 506: {
                                    syncException = new SyncException(506, string2);
                                    break;
                                }
                                case 511: {
                                    syncException = new SyncException(511, string2);
                                    break;
                                }
                                default: {
                                    syncException = new SyncException(500, string2);
                                }
                            }
                            throw syncException;
                        }
                    } else {
                        String[] stringArray2 = stringArray.getItemKeys();
                        int n4 = stringArray.getStatus();
                        if (stringArray2 != null) {
                            int n5 = stringArray2.length;
                            for (int i = 0; i < n5; ++i) {
                                this.source.setItemStatus(stringArray2[i], n4);
                            }
                        } else {
                            this.source.setItemStatus(stringArray.getRef(), n4);
                        }
                    }
                    stringArray = null;
                    continue;
                }
                Log.error("[processModification] error in Status command.");
            }
        }
        catch (XmlException xmlException) {
            xmlException.printStackTrace();
            Log.error("[processModification] error parsing status: " + xmlException.toString());
        }
        chunkedString = null;
        return bl;
    }

    private String prepareModificationMessage(String string) throws SyncException {
        StringBuffer stringBuffer = new StringBuffer("<SyncML xmlns='SYNCML:SYNCML1.2'>");
        StringBuffer stringBuffer2 = new StringBuffer();
        if (string != null) {
            stringBuffer2.append(string);
        }
        stringBuffer2.append("<Meta><MaxMsgSize>" + this.maxMsgSize + "</MaxMsgSize></Meta>\n");
        String string2 = this.prepareSyncHeader(this.sessionID, this.getNextMsgID(), this.deviceId, this.serverUrl, stringBuffer2.toString());
        stringBuffer.append(string2);
        stringBuffer.append("<SyncBody>\n");
        int n = this.msgID - 1;
        stringBuffer.append("<Status>\n").append("<CmdID>").append(this.resetCmdID()).append("</CmdID>\n").append("<MsgRef>" + n + "</MsgRef><CmdRef>0</CmdRef>\n").append("<Cmd>SyncHdr</Cmd>\n").append("<TargetRef>").append(this.deviceId).append("</TargetRef>\n").append("<SourceRef>").append(this.urlEncode(this.serverUrl)).append("</SourceRef>\n").append("<Data>200</Data>\n</Status>\n");
        if (this.msgID == 3) {
            stringBuffer.append("<Status>\n").append("<CmdID>").append(this.getNextCmdID()).append("</CmdID>\n").append("<MsgRef>1</MsgRef><CmdRef>1</CmdRef><Cmd>Alert</Cmd>\n").append("<TargetRef>").append(this.source.getSourceUri()).append("</TargetRef>\n").append("<SourceRef>").append(this.source.getSourceUri()).append("</SourceRef>\n").append("<Data>200</Data>\n").append("<Item>\n").append("<Data>\n").append("<Anchor xmlns='syncml:metinf'><Next>").append(this.source.getNextAnchor()).append("</Next></Anchor>\n").append("</Data>\n").append("</Item>\n").append("</Status>\n");
        }
        this.appendStatusTags(stringBuffer);
        this.appendMapTag(stringBuffer);
        if (this.state != 4) {
            stringBuffer.append(this.prepareSyncTag(stringBuffer.length()));
        }
        if (this.addDevInfResults) {
            stringBuffer.append(this.createResults(this.config.deviceConfig));
            this.addDevInfResults = false;
        }
        if (this.state == 4) {
            Log.info("Modification done, sending <final> tag.");
            stringBuffer.append("<Final/>\n");
        }
        stringBuffer.append("</SyncBody></SyncML>");
        return stringBuffer.toString();
    }

    private String prepareMappingMessage(String string) {
        return this.prepareMappingMessage(true, string);
    }

    private String prepareMappingMessage(boolean bl, String string) {
        boolean bl2 = false;
        StringBuffer stringBuffer = new StringBuffer("<SyncML xmlns='SYNCML:SYNCML1.2'>\n");
        StringBuffer stringBuffer2 = new StringBuffer();
        if (string != null) {
            stringBuffer2.append(string);
        }
        stringBuffer2.append("<Meta><MaxMsgSize>" + this.maxMsgSize + "</MaxMsgSize></Meta>\n");
        stringBuffer.append(this.prepareSyncHeader(this.sessionID, this.getNextMsgID(), this.deviceId, this.serverUrl, stringBuffer2.toString()));
        stringBuffer.append("<SyncBody>\n");
        int n = this.msgID - 1;
        stringBuffer.append("<Status>\n").append("<CmdID>").append(this.resetCmdID()).append("</CmdID>\n").append("<MsgRef>" + n + "</MsgRef>\n").append("<CmdRef>0</CmdRef>\n").append("<Cmd>SyncHdr</Cmd>\n").append("<TargetRef>").append(this.deviceId).append("</TargetRef>\n").append("<SourceRef>").append(this.urlEncode(this.serverUrl)).append("</SourceRef>\n").append("<Data>200</Data>\n").append("</Status>\n");
        if (bl) {
            this.appendStatusTags(stringBuffer);
        }
        this.appendMapTag(stringBuffer);
        stringBuffer.append("<Final/>\n").append("</SyncBody>\n").append("</SyncML>");
        return stringBuffer.toString();
    }

    private void appendMapTag(StringBuffer stringBuffer) {
        if (this.mappings.size() == 0) {
            return;
        }
        String string = null;
        String string2 = null;
        Enumeration enumeration = this.mappings.keys();
        stringBuffer.append("<Map>\n").append("<CmdID>" + this.getNextCmdID() + "</CmdID>\n").append("<Target>\n").append("<LocURI>" + this.source.getSourceUri() + "</LocURI>\n").append("</Target>\n").append("<Source>\n").append("<LocURI>" + this.source.getName() + "</LocURI>\n").append("</Source>\n");
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            string = (String)this.mappings.get(string2);
            stringBuffer.append("<MapItem>\n").append("<Target>\n").append("<LocURI>" + string + "</LocURI>\n").append("</Target>\n").append("<Source>\n").append("<LocURI>" + string2 + "</LocURI>\n").append("</Source>\n").append("</MapItem>\n");
        }
        stringBuffer.append("</Map>\n");
        this.mappings.clear();
    }

    private void appendStatusTags(StringBuffer stringBuffer) {
        int n = this.statusList.size();
        if (n == 0) {
            return;
        }
        SyncMLStatus syncMLStatus = null;
        for (int i = 0; i < n; ++i) {
            syncMLStatus = (SyncMLStatus)this.statusList.elementAt(i);
            syncMLStatus.setCmdId(this.getNextCmdID());
            stringBuffer.append(syncMLStatus.toString());
        }
        this.statusList.removeAllElements();
    }

    private String createAlerts(SyncSource syncSource, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "<Next>" + syncSource.getNextAnchor() + "</Next>\n";
        if (this.source.getLastAnchor() != 0L) {
            string = "<Last>" + syncSource.getLastAnchor() + "</Last>\n" + string;
        }
        stringBuffer.append("<Alert>\n");
        stringBuffer.append("<CmdID>");
        stringBuffer.append(n2);
        stringBuffer.append("</CmdID>\n");
        stringBuffer.append("<Data>");
        if (n != 0) {
            stringBuffer.append(n);
        } else if (syncSource.getSyncMode() != 0) {
            stringBuffer.append(201);
        } else if (syncSource.getLastAnchor() != 0L) {
            stringBuffer.append(200);
        } else {
            stringBuffer.append(syncSource.getSyncMode());
        }
        SyncFilter syncFilter = syncSource.getFilter();
        stringBuffer.append("</Data>\n");
        stringBuffer.append("<Item>\n");
        stringBuffer.append("<Target><LocURI>");
        stringBuffer.append(syncSource.getSourceUri());
        stringBuffer.append("</LocURI>\n");
        if (syncFilter != null) {
            int n3 = this.maxMsgSize - 3072;
            stringBuffer.append(syncFilter.toSyncML(n3));
        }
        stringBuffer.append("</Target>\n");
        stringBuffer.append("<Source><LocURI>");
        stringBuffer.append(syncSource.getName());
        stringBuffer.append("</LocURI></Source>\n");
        stringBuffer.append("<Meta>\n");
        stringBuffer.append("<Anchor xmlns='syncml:metinf'>\n");
        stringBuffer.append(string);
        stringBuffer.append("</Anchor>\n");
        stringBuffer.append("<Meta><MaxMsgSize xmlns='syncml:metinf'>10240</MaxMsgSize></Meta>\n");
        stringBuffer.append("</Meta>\n");
        stringBuffer.append("</Item>\n");
        stringBuffer.append("</Alert>");
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    private String createPut(DeviceConfig deviceConfig, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<Put>\n").append("<CmdID>").append(n).append("</CmdID>\n").append("<Meta>\n").append("<Type xmlns='syncml:metinf'>application/vnd.syncml-devinf+xml</Type>\n").append("</Meta>\n").append("<Item>\n").append("<Source><LocURI>./devinf12</LocURI></Source>\n").append("<Data>\n").append(this.createDevInf(deviceConfig)).append("</Data>\n").append("</Item>\n").append("</Put>\n");
        return stringBuffer.toString();
    }

    private String createResults(DeviceConfig deviceConfig) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<Results>\n").append("<CmdID>" + this.getNextCmdID() + "</CmdID>\n").append("<MsgRef>" + this.msgIDget + "</MsgRef>\n").append("<CmdRef>" + this.cmdIDget + "</CmdRef>\n").append("<Meta>\n").append("<Type xmlns='syncml:metinf'>application/vnd.syncml-devinf+xml</Type>\n").append("</Meta>\n").append("<Item>\n").append("<Source><LocURI>./devinf12</LocURI></Source>\n").append("<Data>\n").append(this.createDevInf(deviceConfig)).append("</Data>\n").append("</Item>\n").append("</Results>");
        return stringBuffer.toString();
    }

    private String createDevInf(DeviceConfig deviceConfig) {
        StringBuffer stringBuffer = new StringBuffer();
        if (deviceConfig.man == null) {
            deviceConfig.man = "";
        }
        if (deviceConfig.mod == null) {
            deviceConfig.mod = "";
        }
        if (deviceConfig.oem == null) {
            deviceConfig.oem = "";
        }
        if (deviceConfig.fwv == null) {
            deviceConfig.fwv = "";
        }
        if (deviceConfig.swv == null) {
            deviceConfig.swv = "";
        }
        if (deviceConfig.hwv == null) {
            deviceConfig.hwv = "";
        }
        if (deviceConfig.devID == null) {
            deviceConfig.devID = "";
        }
        if (deviceConfig.devType == null) {
            deviceConfig.devType = "";
        }
        stringBuffer.append("<DevInf xmlns='syncml:devinf'>\n").append("<VerDtd>1.2</VerDtd>\n").append("<Man>" + deviceConfig.man + "</Man>\n").append("<Mod>" + deviceConfig.mod + "</Mod>\n").append("<OEM>" + deviceConfig.oem + "</OEM>\n").append("<FwV>" + deviceConfig.fwv + "</FwV>\n").append("<SwV>" + deviceConfig.swv + "</SwV>\n").append("<HwV>" + deviceConfig.hwv + "</HwV>\n").append("<DevId>" + deviceConfig.devID + "</DevId>\n").append("<DevTyp>" + deviceConfig.devType + "</DevTyp>\n");
        if (deviceConfig.utc) {
            stringBuffer.append("<UTC/>\n");
        }
        if (deviceConfig.loSupport) {
            stringBuffer.append("<SupportLargeObjs/>\n");
        }
        if (deviceConfig.nocSupport) {
            stringBuffer.append("<SupportNumberOfChanges/>\n");
        }
        stringBuffer.append("<DataStore>\n").append("<SourceRef>" + this.source.getName() + "</SourceRef>\n").append("<DisplayName>clientdisplayname</DisplayName><MaxGuidSize>255</MaxGuidSize>").append("<Rx-Pref>\n").append("<CTType>").append(this.source.getType()).append("</CTType>\n").append("<VerCt>2.1</VerCt>\n").append("</Rx-Pref>\n").append("<Tx-Pref>\n").append("<CTType>").append(this.source.getType()).append("</CTType>\n").append("<VerCt>2.1</VerCt>\n").append("</Tx-Pref>\n").append("<SyncCap>\n").append("<SyncType>1</SyncType>\n").append("<SyncType>2</SyncType>\n").append("<SyncType>3</SyncType>\n").append("<SyncType>4</SyncType>\n").append("<SyncType>5</SyncType>\n").append("<SyncType>6</SyncType>\n").append("<SyncType>7</SyncType>\n").append("</SyncCap>\n").append("<CTCap><CTType>text/x-vcard</CTType><VerCt>2.1</VerCt><FieldLevel/></CTCap>").append("</DataStore>\n").append("</DevInf>\n");
        return stringBuffer.toString();
    }

    private boolean isGetCommandFromServer(ChunkedString chunkedString) {
        ChunkedString chunkedString2 = null;
        ChunkedString chunkedString3 = null;
        ChunkedString chunkedString4 = null;
        ChunkedString chunkedString5 = null;
        ChunkedString chunkedString6 = null;
        if (XmlUtil.getTag(chunkedString, "Get") == -1) {
            Log.debug("No <Get> command.");
            return false;
        }
        try {
            chunkedString2 = XmlUtil.getTagValue(chunkedString, "Get");
            if (chunkedString2 != null) {
                chunkedString3 = XmlUtil.getTagValue(chunkedString2, "Item");
                chunkedString4 = XmlUtil.getTagValue(chunkedString3, "Target");
                chunkedString5 = XmlUtil.getTagValue(chunkedString4, "LocURI");
                this.cmdIDget = XmlUtil.getTagValue(chunkedString2, "CmdID").toString();
                chunkedString6 = XmlUtil.getTagValue(chunkedString, "SyncHdr");
                this.msgIDget = XmlUtil.getTagValue(chunkedString6, "MsgID").toString();
            }
        }
        catch (XmlException xmlException) {
            xmlException.printStackTrace();
            Log.error("Invalid get command from server.");
            return false;
        }
        return "./devinf12".equals(chunkedString5);
    }

    private String getAddCommand(int n) throws SyncException {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = this.sourceLOHandler.getAddCommand(n, this.listener, stringBuffer, this.cmdID);
        if (bl) {
            this.nextState(2);
        }
        if ((string = stringBuffer.toString()).length() == 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    private String getReplaceCommand(int n) throws SyncException {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = this.sourceLOHandler.getReplaceCommand(n, this.listener, stringBuffer, this.cmdID);
        if (bl) {
            this.nextState(3);
        }
        if ((string = stringBuffer.toString()).length() == 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    private String getDeleteCommand(int n) throws SyncException {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = this.sourceLOHandler.getDeleteCommand(n, this.listener, stringBuffer, this.cmdID);
        if (bl) {
            this.nextState(4);
        }
        if ((string = stringBuffer.toString()).length() == 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    private String getNextCmdTag(int n) throws SyncException {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.source.getSourceUri();
        switch (this.alertCode) {
            case 201: 
            case 203: {
                boolean bl = this.sourceLOHandler.getNextCommand(n, this.listener, stringBuffer, this.cmdID);
                if (bl) {
                    this.nextState(4);
                }
                if (stringBuffer.toString().length() != 0) break;
                return null;
            }
            case 204: 
            case 205: {
                this.nextState(4);
                return null;
            }
            case 200: 
            case 202: {
                String string2 = null;
                switch (this.state) {
                    case 1: {
                        string2 = this.getAddCommand(n);
                        break;
                    }
                    case 2: {
                        string2 = this.getReplaceCommand(n);
                        break;
                    }
                    case 3: {
                        string2 = this.getDeleteCommand(n);
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                if (string2 == null) break;
                stringBuffer.append(string2);
                break;
            }
            default: {
                Log.error("[getNextCmdTag] Invalid alert code: " + this.alertCode);
                throw new SyncException(500, "Invalid alert code: " + this.alertCode);
            }
        }
        return stringBuffer.toString();
    }

    private String prepareSyncTag(int n) throws SyncException {
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        stringBuffer.append("<Sync>\n").append("<CmdID>").append(this.getNextCmdID()).append("</CmdID>\n").append("<Target><LocURI>").append(this.source.getSourceUri()).append("</LocURI></Target>\n").append("<Source><LocURI>").append(this.source.getName()).append("</LocURI></Source>\n");
        do {
            if ((string = this.getNextCmdTag(n + stringBuffer.length())) == null) {
                Log.debug("[prepareSyncTag] No more commands to send");
                break;
            }
            stringBuffer.append(string);
        } while (n + stringBuffer.length() < this.maxMsgSize);
        stringBuffer.append("</Sync>\n");
        return stringBuffer.toString();
    }

    private void processSyncCommand(ChunkedString chunkedString, ChunkedString chunkedString2) throws SyncException {
        Object object;
        String string = null;
        String string2 = null;
        try {
            string = XmlUtil.getTagValue(chunkedString2, "CmdID").toString();
            string2 = XmlUtil.getTagValue(XmlUtil.getTagValue(chunkedString2, "Target"), "LocURI").toString();
        }
        catch (XmlException xmlException) {
            Log.error("[processModification] Invalid Sync command: " + xmlException.toString());
            xmlException.printStackTrace();
            throw new SyncException(500, "Invalid Sync command from server.");
        }
        if (!string2.equals(this.source.getName())) {
            Log.error("[processModification] Invalid uri: '" + string2 + "' for source: '" + this.source.getName() + "'");
            throw new SyncException(500, "Invalid source to sync: " + string2);
        }
        int n = -1;
        if (XmlUtil.getTag(chunkedString2, "NumberOfChanges") > 0) {
            try {
                object = XmlUtil.getTagValue(chunkedString2, "NumberOfChanges");
                n = Integer.parseInt(((ChunkedString)object).toString());
                Log.info("Number of changes from server: " + n);
            }
            catch (XmlException xmlException) {
                xmlException.printStackTrace();
                Log.error("Error parsing NumberOfChanges, ignoring it.");
            }
        }
        this.listener.startReceiving(n);
        this.source.setServerItemsNumber(n);
        object = new SyncMLStatus();
        ((SyncMLStatus)object).setMsgRef(chunkedString.toString());
        ((SyncMLStatus)object).setCmdRef(string.toString());
        ((SyncMLStatus)object).setCmd("Sync");
        ((SyncMLStatus)object).setTgtRef(this.source.getName());
        ((SyncMLStatus)object).setSrcRef(this.source.getSourceUri());
        this.statusList.addElement(object);
    }

    private int getSourceAlertCode(String string) {
        try {
            String string2 = (String)this.serverAlerts.get(string);
            return Integer.parseInt(string2);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Log.error("ERROR: unrecognized server alert code (" + this.serverAlerts.get(string) + ") for " + string.toString());
            return -1;
        }
    }

    private String getDisplayMessage() {
        String string = null;
        try {
            string = (String)this.serverAlerts.get("display");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return string;
    }

    private String messageFormat(String string, String string2, String string3) {
        String string4 = null;
        String string5 = null;
        string4 = string.substring(0, string.indexOf(string2));
        string5 = string.substring(string.indexOf(string2) + string2.length());
        return string4 + string3 + string5;
    }

    private String resetMsgID() {
        this.msgID = 0;
        return "0";
    }

    private String getNextMsgID() {
        return String.valueOf(++this.msgID);
    }

    private String resetCmdID() {
        this.cmdID.setValue(1);
        return "1";
    }

    public String getNextCmdID() {
        return String.valueOf(this.cmdID.next());
    }

    private void nextState(int n) {
        this.state = n;
        String string = null;
        if (Log.getLogLevel() >= 2) {
            switch (n) {
                case 1: {
                    string = "state=>STATE_SENDING_ADD";
                    break;
                }
                case 2: {
                    string = "state=>STATE_SENDING_REPLACE";
                    break;
                }
                case 3: {
                    string = "state=>STATE_SENDING_DELETE";
                    break;
                }
                case 4: {
                    string = "state=>STATE_MODIFICATION_COMPLETED";
                    break;
                }
                default: {
                    string = "UNKNOWN STATE!";
                }
            }
            Log.debug(string);
        }
    }

    private String sendLastSyncMappingMessage(String string) throws SyncException {
        String string2 = this.prepareMappingMessage(false, null);
        Log.info("Sending mapping commands lost in the last sync");
        Log.debug(string2);
        string = this.postRequest(string2);
        string2 = null;
        Log.info("response received");
        Log.debug(string);
        return string;
    }

    public void enableMappingTest(boolean bl) {
        this.isMappingTestDisabled = bl;
    }

    private String urlEncode(String string) {
        Log.debug("urlEncode,original: " + string);
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        block3: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block3;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        Log.debug("urlEncode,result: " + stringBuffer.toString());
        return stringBuffer.toString();
    }
}

