/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.updater;

import com.funambol.storage.Serializable;
import com.funambol.updater.UpdaterConfig;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class BasicUpdaterConfig
implements UpdaterConfig,
Serializable {
    private String url;
    private String downloadUrl;
    private String type;
    private String availableVersion;
    private long lastCheck;
    private long checkInterval;
    private long reminderInterval;
    private long lastReminder;
    private boolean skip;

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public boolean isMandatory() {
        return "mandatory".equals(this.type);
    }

    public boolean isOptional() {
        return "optional".equals(this.type);
    }

    public String getAvailableVersion() {
        return this.availableVersion;
    }

    public void setAvailableVersion(String availableVersion) {
        this.availableVersion = availableVersion;
    }

    public long getLastCheck() {
        return this.lastCheck;
    }

    public void setLastCheck(long time) {
        this.lastCheck = time;
    }

    public long getCheckInterval() {
        return this.checkInterval;
    }

    public void setCheckInterval(long checkInterval) {
        this.checkInterval = checkInterval;
    }

    public long getReminderInterval() {
        return this.reminderInterval;
    }

    public void setReminderInterval(long reminderInterval) {
        this.reminderInterval = reminderInterval;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }

    public long getLastReminder() {
        return this.lastReminder;
    }

    public void setLastReminder(long lastReminder) {
        this.lastReminder = lastReminder;
    }

    public boolean getSkip() {
        return this.skip;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public void serialize(DataOutputStream out) throws IOException {
        if (this.url != null) {
            out.writeUTF(this.url);
        } else {
            out.writeUTF("");
        }
        if (this.downloadUrl != null) {
            out.writeUTF(this.downloadUrl);
        } else {
            out.writeUTF("");
        }
        if (this.type != null) {
            out.writeUTF(this.type);
        } else {
            out.writeUTF("");
        }
        if (this.availableVersion != null) {
            out.writeUTF(this.availableVersion);
        } else {
            out.writeUTF("");
        }
        out.writeLong(this.lastCheck);
        out.writeLong(this.checkInterval);
        out.writeLong(this.lastReminder);
        out.writeLong(this.reminderInterval);
        out.writeBoolean(this.skip);
    }

    public void deserialize(DataInputStream in) throws IOException {
        this.url = in.readUTF();
        this.downloadUrl = in.readUTF();
        this.type = in.readUTF();
        this.availableVersion = in.readUTF();
        this.lastCheck = in.readLong();
        this.checkInterval = in.readLong();
        this.lastReminder = in.readLong();
        this.reminderInterval = in.readLong();
        this.skip = in.readBoolean();
    }

    public abstract void save();

    public abstract void load();
}

