/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.util;

import com.funambol.util.CodedException;
import com.funambol.util.ConnectionListener;
import com.funambol.util.ConnectionManager;
import com.funambol.util.Log;
import com.funambol.util.StreamReaderFactory;
import com.funambol.util.TransportAgent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.io.HttpConnection;

public final class HttpTransportAgent
implements TransportAgent {
    private static final int NUM_RETRY = 3;
    private static final String PROP_MICROEDITION_CONFIGURATION = "microedition.configuration";
    private static final String PROP_CONTENT_LANGUAGE = "Content-Language";
    private static final String PROP_CONTENT_LENGTH = "Content-Length";
    private static final String PROP_UNCOMPR_LENGHT = "Uncompressed-Content-Length";
    private static final String PROP_CONTENT_TYPE = "Content-Type";
    private static final String PROP_MICROEDITION_LOCALE = "microedition.locale";
    private static final String PROP_MICROEDITION_PROFILES = "microedition.profiles";
    private static final String PROP_USER_AGENT = "User-Agent";
    private static final String PROP_DEVICE_AGENT = "Device-Agent";
    private static final String PROP_FORCE_COOKIES = "x-funambol-force-cookies";
    private static final String PROP_ACCEPT_ENCODING = "Accept-Encoding";
    private static final String PROP_CONTENT_ENCODING = "Content-Encoding";
    private static final String PROP_DATE = "Date";
    private static final String PROP_SIZE_THRESHOLD = "Size-Threshold";
    private static final String COMPRESSION_TYPE_GZIP = "gzip";
    private static final String COMPRESSION_TYPE_ZLIB = "deflate";
    private final String userAgent;
    private final String charset;
    private final int OPEN_CONNECTION;
    private final int WRITE_REQUEST;
    private final int READ_RESPONSE;
    private final int RESPONSE_CORRECTLY_PROCESSED;
    private String requestURL;
    private String contentType;
    private int sizeThreshold;
    private boolean enableCompression;
    private String responseDate;
    private boolean forceCookies;
    private int uncompressedLength;
    private int retryOnWrite;
    private int counter;
    private int status = 0;
    private static HttpConnection c = null;
    private static InputStream is = null;
    private static OutputStream os = null;
    private long CONNECTION_SLEEP_TIME = 10000L;
    private ConnectionManager connectionManager = null;
    private ConnectionListener connectionListener = null;

    public HttpTransportAgent(String requestURL, boolean compress, boolean forceCookies) {
        this(requestURL, null, null, compress, forceCookies);
    }

    public HttpTransportAgent(String requestURL, String userAgent, boolean compress, boolean forceCookies) {
        this(requestURL, userAgent, null, compress, forceCookies);
    }

    public HttpTransportAgent(String requestURL, String userAgent, String charset, boolean compress, boolean forceCookies) {
        this.OPEN_CONNECTION = 0;
        this.WRITE_REQUEST = 1;
        this.READ_RESPONSE = 2;
        this.RESPONSE_CORRECTLY_PROCESSED = 3;
        if (requestURL == null) {
            throw new NullPointerException("[HttpTransportAgent]Request URL parameter is null");
        }
        this.retryOnWrite = 3;
        Log.info("[HttpTransportAgent]Number of writing Attempts: " + this.retryOnWrite);
        this.userAgent = userAgent;
        Log.info("[HttpTransportAgent]UserAgent set to: " + this.userAgent);
        this.requestURL = requestURL;
        Log.info("[HttpTransportAgent]Request Url set to: " + this.requestURL);
        this.charset = charset;
        Log.info("[HttpTransportAgent]Charset set to: " + this.charset);
        this.sizeThreshold = 0;
        Log.info("[HttpTransportAgent]Threshold size set to: " + this.sizeThreshold);
        this.enableCompression = compress;
        Log.info("[HttpTransportAgent]enableCompression: " + this.enableCompression);
        this.responseDate = null;
        Log.info("[HttpTransportAgent]responseDate: " + this.responseDate);
        this.forceCookies = forceCookies;
        Log.info("[HttpTransportAgent]forceCookies: " + forceCookies);
        this.connectionManager = ConnectionManager.getInstance();
        this.connectionListener = this.connectionManager.getConnectionListener();
    }

    public String sendMessage(String request) throws CodedException {
        return this.sendMessage(request, this.charset);
    }

    public String sendMessage(String request, String charset) throws CodedException {
        byte[] indata = null;
        byte[] outdata = null;
        if (charset != null) {
            try {
                indata = request.getBytes(charset);
            }
            catch (UnsupportedEncodingException uee) {
                Log.error("[HttpTransportAgent.sendMessage]Charset " + charset + " not supported. Using default");
                charset = null;
                indata = request.getBytes();
            }
        } else {
            indata = request.getBytes();
        }
        request = null;
        outdata = this.sendMessage(indata);
        indata = null;
        if (outdata == null) {
            String msg = "Response data null";
            Log.error("[HttpTransportAgent.sendMessage]" + msg);
            throw new CodedException(200, msg);
        }
        if (charset != null) {
            try {
                return new String(outdata, charset);
            }
            catch (UnsupportedEncodingException uee) {
                Log.error("[HttpTransportAgent.sendMessage]Charset " + charset + " not supported. Using default");
                charset = null;
                return new String(outdata);
            }
        }
        return new String(outdata);
    }

    public byte[] sendMessage(byte[] request) throws CodedException {
        byte[] data = null;
        try {
            this.writeRequest(request);
            data = this.readResponse(data);
            Log.info("<!--READ_BEGIN-->\n");
            Log.info(new String(data));
            Log.info("<!--</READ_END>-->\n");
            if (this.status == 3) {
                byte[] byArray = data;
                return byArray;
            }
        }
        catch (ConnectionNotFoundException e) {
            String msg = "[HttpTransportAgent.sendMessage]Can't open connection -->" + e.toString();
            Log.error(msg);
            throw new CodedException(201, msg);
        }
        catch (IllegalArgumentException e) {
            String msg = "[HttpTransportAgent.sendMessage]Invalid argument for connection --> " + e.toString();
            Log.error(msg);
            throw new CodedException(202, msg);
        }
        finally {
            this.clear();
        }
        return data;
    }

    public void enableCompression(boolean enable) {
        this.enableCompression = enable;
    }

    public void setThreshold(int threshold) {
        this.sizeThreshold = threshold;
    }

    public void setRequestURL(String requestURL) {
        this.requestURL = requestURL;
    }

    public String getResponseDate() {
        return this.responseDate;
    }

    public void setRetryOnWrite(int retryOnWrite) {
        this.retryOnWrite = retryOnWrite;
    }

    private void openConnection(byte[] request, int i) throws IOException {
        this.status = 0;
        Log.info("[HttpTransportAgent.openConnection]Url: [" + this.requestURL + "]");
        c = (HttpConnection)this.connectionManager.open(this.requestURL, 3, true);
        if (request.length > 0) {
            this.setConfig(c, request.length);
        }
    }

    private void writeRequest(byte[] request) throws IllegalArgumentException, ConnectionNotFoundException, CodedException {
        for (int i = 0; i < this.retryOnWrite; ++i) {
            try {
                this.openConnection(request, i);
                this.connectionListener.connectionOpened();
                if (request == null || request.length <= 0) break;
                this.status = 1;
                os = c.openOutputStream();
                os.write(request);
                Log.info("[HttpTransportAgent.writeRequest]Message sent at attempt " + (i + 1) + ", waiting for response.");
                this.connectionListener.requestWritten();
                break;
            }
            catch (IOException e) {
                this.clear();
                if (this.status == 0) {
                    Log.error("[HttpTransportAgent.writeRequest]Attempt n." + (i + 1) + " failed. Retrying...");
                    if (i == this.retryOnWrite - 1) {
                        throw new CodedException(201, "[HttpTransportAgent.writeRequest]Network problem: Cannot send the request to the server");
                    }
                    this.waitToConnect();
                    continue;
                }
                if (this.status != 1) continue;
                Log.error("[HttpTransportAgent.writeRequest]Attempt n." + (i + 1) + " failed. Retrying...");
                if (i == this.retryOnWrite - 1) {
                    throw new CodedException(203, "[HttpTransportAgent.writeRequest]Network problem: Cannot send the request to the server");
                }
                this.waitToConnect();
                continue;
            }
        }
    }

    private void waitToConnect() {
        try {
            long startTime = System.currentTimeMillis();
            Log.info("[HttpTransportAgent.waitToConnect]Connection timer started");
            Thread.sleep(this.CONNECTION_SLEEP_TIME);
            long now = System.currentTimeMillis();
            Log.info("[HttpTransportAgent.waitToConnect]Retrying after " + (now - startTime) + " msec");
        }
        catch (InterruptedException ex) {
            Log.error("[HttpTransportAgent.waitToConnect]Connection timer failed");
            ex.printStackTrace();
        }
    }

    private byte[] readResponse(byte[] data) throws CodedException {
        this.status = 2;
        try {
            is = c.openInputStream();
            Log.info("[HttpTransportAgent.readResponse]Message received");
            this.logHeaders(c);
            long len = c.getLength();
            Log.info("[HttpTransportAgent.readResponse]Response length: " + len);
            int httpCode = c.getResponseCode();
            Log.info("[HttpTransportAgent.readResponse]Http Code: " + httpCode);
            if (httpCode != 200) {
                Log.debug("response: " + c.getResponseMessage());
                Log.error("[HttpTransportAgent.readResponse]Http error: code=[" + httpCode + "] msg=[" + c.getResponseMessage() + "]");
                String msg = "[HttpTransportAgent.readResponse]Http error: code=[" + httpCode + "] msg=[" + c.getResponseMessage() + "]";
                throw new CodedException(201, msg);
            }
            this.responseDate = c.getHeaderField(PROP_DATE);
            Log.info("[HttpTransportAgent.readResponse]Date from server: " + this.responseDate);
            this.contentType = c.getHeaderField(PROP_CONTENT_ENCODING);
            Log.info("[HttpTransportAgent.readResponse]Encoding Response Type from server: " + this.contentType);
            Log.info("[HttpTransportAgent.readResponse]Uncompressed Content Lenght: " + this.uncompressedLength);
            if (len == -1L && this.responseDate == null && this.contentType == null) {
                Log.error("Http error: httpCode=[" + httpCode + "] msg=[" + c.getResponseMessage() + "] len=[" + len + "] date=[" + this.responseDate + "] contentType=[" + this.contentType + "]");
                Log.error("[HttpTransportAgent.readResponse]Error in http response, not reading stream...");
            } else {
                data = StreamReaderFactory.getStreamReader(this.contentType).readStream(is, (int)len);
                Log.debug("[HttpTransportAgent.readResponse]Data length: " + data.length);
                Log.info("[HttpTransportAgent.readResponse]Stream correctly processed.");
                this.status = 3;
                this.connectionListener.responseReceived();
            }
        }
        catch (CodedException e) {
            String msg = "[HttpTransportAgent.readResponse] Exception catched " + e.toString() + ", propagating it";
            Log.error(msg);
            throw e;
        }
        catch (IOException ioe) {
            String msg = "[HttpTransportAgent.readResponse]Error reading server response --> " + ioe.toString();
            Log.error(msg);
            throw new CodedException(206, "[HttpTransportAgent.readResponse]Network problem: Cannot read the server response");
        }
        return data;
    }

    private void setConfig(HttpConnection c, int length) throws IOException {
        int jsIndex;
        String ua = this.userAgent;
        String locale = System.getProperty(PROP_MICROEDITION_LOCALE);
        if (ua == null) {
            String conf = System.getProperty(PROP_MICROEDITION_CONFIGURATION);
            String prof = System.getProperty(PROP_MICROEDITION_PROFILES);
            ua = "Profile/" + prof + " Configuration/" + conf;
        }
        c.setRequestMethod("POST");
        c.setRequestProperty(PROP_CONTENT_TYPE, "application/vnd.syncml+xml");
        if (length == 0) {
            Log.error("[HttpTransportAgent.setConfig]Content length has been set to 0 !");
        }
        if (this.forceCookies) {
            c.setRequestProperty(PROP_FORCE_COOKIES, "true");
        }
        if (this.enableCompression) {
            c.setRequestProperty(PROP_ACCEPT_ENCODING, COMPRESSION_TYPE_GZIP);
            Log.debug("[HttpTransportAgent.setConfig]Encoding Response Required from Client: gzip");
        }
        if (this.sizeThreshold != 0) {
            c.setRequestProperty(PROP_SIZE_THRESHOLD, String.valueOf(this.sizeThreshold));
        }
        if (locale != null) {
            // empty if block
        }
        if ((jsIndex = this.requestURL.indexOf("jsessionid")) != -1) {
            String jsessionidString = this.requestURL.substring(jsIndex, this.requestURL.length());
            int posEquals = jsessionidString.indexOf("=");
            String cookieName = jsessionidString.substring(0, posEquals);
            String cookieValue = jsessionidString.substring(posEquals + 1);
            c.setRequestProperty("Cookie", cookieName.toUpperCase() + "=" + cookieValue);
        }
    }

    private void logHeaders(HttpConnection c) throws IOException {
        if (Log.getLogLevel() >= 1) {
            StringBuffer sbh = new StringBuffer();
            String tmp = "";
            for (int h = 0; h < 12; ++h) {
                tmp = c.getHeaderFieldKey(h);
                sbh.append("[").append(h).append("] - ").append(tmp);
                if (tmp != null && !tmp.equals("")) {
                    sbh.append(": ").append(c.getHeaderField(tmp)).append("\n");
                    continue;
                }
                sbh.append("\n");
            }
            Log.info("[HttpTransportAgent.logHeaders]Header: \n" + sbh.toString());
        }
    }

    private String createDeviceAgent() {
        StringBuffer sbAgent = new StringBuffer();
        sbAgent.append(System.getProperty("microedition.platform"));
        sbAgent.append(" ").append(System.getProperty(PROP_MICROEDITION_PROFILES));
        sbAgent.append(" ").append(System.getProperty(PROP_MICROEDITION_CONFIGURATION));
        return sbAgent.toString();
    }

    private void clear() {
        this.clearResponseStream();
        this.clearRequestStream();
        this.closeConnection();
    }

    private void clearRequestStream() {
        if (os != null) {
            try {
                System.out.println("clearRequestStream");
                os.close();
                os = null;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                Log.error("[HttpTransportAgent.clearRequestStream]Can't close output stream.");
            }
        }
    }

    private void clearResponseStream() {
        if (is != null) {
            try {
                System.out.println("clearResponseStream");
                is.close();
                is = null;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                Log.error("[HttpTransportAgent.clearResponseStream]Can't close input stream.");
            }
        }
    }

    private void closeConnection() {
        if (c != null) {
            try {
                System.out.println("closeConnection");
                c.close();
                c = null;
                this.connectionListener.connectionClosed();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                Log.error("[HttpTransportAgent.closeConnection]Can't close connection.");
            }
        }
    }
}

