/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.util;

import com.funambol.storage.AbstractRecordStore;
import com.funambol.util.Log;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotOpenException;

public class LogViewer {
    public static final int RMSLOG = 0;
    public static final int JSR75LOG = 1;

    public String[] getLogEntries(int mode) {
        String[] logArray = null;
        if (mode == 0) {
            logArray = this.getRMSLogStrings();
        } else if (mode == 1) {
            Log.info("JSR75 will be supported in future versions");
        }
        return logArray;
    }

    private String[] getRMSLogStrings() {
        AbstractRecordStore rs = null;
        String[] result = null;
        try {
            rs = AbstractRecordStore.openRecordStore("funambol.log", true);
            int size = rs.getNumRecords();
            result = size == 0 ? new String[]{"No Log entries found."} : this.recordsToStringArray(rs);
            rs.closeRecordStore();
        }
        catch (RecordStoreException ex) {
            Log.error(this, "getRMSLogStrings() recordstore Exception");
            ex.printStackTrace();
        }
        return result;
    }

    private String[] recordsToStringArray(AbstractRecordStore rs) throws RecordStoreNotOpenException {
        int i = 0;
        String[] result = new String[rs.getNumRecords()];
        RecordEnumeration re = rs.enumerateRecords(null, null, false);
        while (re.hasNextElement()) {
            try {
                result[i++] = new String(re.nextRecord());
            }
            catch (Throwable t) {
                Log.error("throwable catched at recordsStoStringArray:  " + t.toString());
                t.printStackTrace();
            }
        }
        return result;
    }

    private void getJsr75LogFile() {
    }
}

