/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.util;

import com.funambol.util.Log;
import java.util.Calendar;
import java.util.Date;

public class MailDateFormatter {
    public static final int FORMAT_MONTH_DAY = 0;
    public static final int FORMAT_MONTH_DAY_YEAR = 1;
    public static final int FORMAT_HOURS_MINUTES = 2;
    public static final int FORMAT_HOURS_MINUTES_SECONDS = 3;
    public static final int FORMAT_DAY_MONTH = 4;
    public static final int FORMAT_DAY_MONTH_YEAR = 5;
    private static String deviceOffset = "+0000";
    private static long millisDeviceOffset = 0L;
    private static String[] monthNames = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};

    public static String dateToRfc2822(Date date) {
        Calendar deviceTime = Calendar.getInstance();
        deviceTime.setTime(date);
        String dayweek = "";
        int dayOfWeek = deviceTime.get(7);
        switch (dayOfWeek) {
            case 1: {
                dayweek = "Sun";
                break;
            }
            case 2: {
                dayweek = "Mon";
                break;
            }
            case 3: {
                dayweek = "Tue";
                break;
            }
            case 4: {
                dayweek = "Wed";
                break;
            }
            case 5: {
                dayweek = "Thu";
                break;
            }
            case 6: {
                dayweek = "Fri";
                break;
            }
            case 7: {
                dayweek = "Sat";
            }
        }
        int dayOfMonth = deviceTime.get(5);
        String monthInYear = MailDateFormatter.getMonthName(deviceTime.get(2));
        int year = deviceTime.get(1);
        int hourOfDay = deviceTime.get(11);
        int minutes = deviceTime.get(12);
        int seconds = deviceTime.get(13);
        String rfc = dayweek + ", " + dayOfMonth + " " + monthInYear + " " + year + " " + hourOfDay + ":" + minutes + ":" + seconds + " " + deviceOffset;
        return rfc;
    }

    public static String dateToUTC(Date d) {
        StringBuffer date = new StringBuffer();
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        date.append(cal.get(1));
        date.append(MailDateFormatter.printTwoDigits(cal.get(2) + 1)).append(MailDateFormatter.printTwoDigits(cal.get(5))).append("T");
        date.append(MailDateFormatter.printTwoDigits(cal.get(11))).append(MailDateFormatter.printTwoDigits(cal.get(12))).append(MailDateFormatter.printTwoDigits(cal.get(13))).append("Z");
        return date.toString();
    }

    public static String getFormattedStringFromDate(Date date, int format, String separator) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        StringBuffer ret = new StringBuffer();
        switch (format) {
            case 2: {
                if (cal.get(9) == 1 && cal.get(10) == 0) {
                    ret.append("12");
                } else {
                    ret.append(cal.get(10));
                }
                ret.append(separator).append(MailDateFormatter.printTwoDigits(cal.get(12))).append(MailDateFormatter.getAMPM(cal));
                break;
            }
            case 3: {
                if (cal.get(9) == 1 && cal.get(10) == 0) {
                    ret.append("12");
                } else {
                    ret.append(cal.get(10));
                }
                ret.append(separator).append(MailDateFormatter.printTwoDigits(cal.get(12))).append(separator).append(cal.get(13)).append(MailDateFormatter.getAMPM(cal));
                break;
            }
            case 0: {
                ret.append(cal.get(2) + 1).append(separator).append(cal.get(5));
                break;
            }
            case 4: {
                ret.append(cal.get(5)).append(separator).append(cal.get(2) + 1);
                break;
            }
            case 1: {
                ret.append(cal.get(2) + 1).append(separator).append(cal.get(5)).append(separator).append(cal.get(1));
                break;
            }
            case 5: {
                ret.append(cal.get(5)).append(separator).append(cal.get(2) + 1).append(separator).append(cal.get(1));
                break;
            }
            default: {
                Log.error("getFormattedStringFromDate: invalid format (" + format + ")");
            }
        }
        return ret.toString();
    }

    public static String formatLocalTime(Date d) {
        int dateFormat = 1;
        int timeFormat = 2;
        if (!System.getProperty("microedition.locale").equals("en")) {
            dateFormat = 5;
        }
        return MailDateFormatter.getFormattedStringFromDate(d, 1, "/") + " " + MailDateFormatter.getFormattedStringFromDate(d, 2, ":");
    }

    public static Date parseRfc2822Date(String stringDate) {
        if (stringDate == null) {
            return null;
        }
        long hourOffset = 0L;
        long minOffset = 0L;
        Calendar cal = Calendar.getInstance();
        try {
            Log.info("Date original: " + stringDate);
            StringBuffer cleanedDate = new StringBuffer();
            int previous = 97;
            for (int i = 0; i < stringDate.length(); ++i) {
                char ch = stringDate.charAt(i);
                if (ch != ' ' || previous != 32) {
                    cleanedDate.append(ch);
                }
                previous = ch;
            }
            stringDate = cleanedDate.toString();
            Log.debug("Cleaned date: " + stringDate);
            int start = stringDate.indexOf(44);
            start = start == -1 ? 0 : start + 2;
            stringDate = stringDate.substring(start).trim();
            start = 0;
            int end = stringDate.indexOf(32, start);
            int day = 1;
            try {
                day = Integer.parseInt(stringDate.substring(start, end));
            }
            catch (NumberFormatException ex) {
                Log.error("Invalid date with day: " + stringDate.substring(start, end));
                Log.info("Applying Nokia 6111 patch");
                day = Integer.parseInt(stringDate.substring(start + 3, end));
            }
            cal.set(5, day);
            start = end + 1;
            end = stringDate.indexOf(32, start);
            cal.set(2, MailDateFormatter.getMonthNumber(stringDate.substring(start, end)));
            start = end + 1;
            end = stringDate.indexOf(32, start);
            cal.set(1, Integer.parseInt(stringDate.substring(start, end)));
            start = end + 1;
            end = stringDate.indexOf(58, start);
            cal.set(11, Integer.parseInt(stringDate.substring(start, end).trim()));
            start = end + 1;
            end = stringDate.indexOf(58, start);
            cal.set(12, Integer.parseInt(stringDate.substring(start, end)));
            start = end + 1;
            end = stringDate.indexOf(32, start);
            cal.set(13, Integer.parseInt(stringDate.substring(start, end)));
            start = end + 1;
            end = stringDate.indexOf(13, start);
            int sign = 43;
            String hourDiff = "0";
            String minDiff = "0";
            String offset = stringDate.substring(start).trim();
            if (offset.startsWith("+") || offset.startsWith("-")) {
                if (offset.length() >= 5) {
                    sign = offset.charAt(0);
                    hourDiff = offset.substring(1, 3);
                    minDiff = offset.substring(3, 5);
                } else if (offset.length() == 3) {
                    sign = offset.charAt(0);
                    hourDiff = offset.substring(1);
                    minDiff = "00";
                }
                hourOffset = Long.parseLong(hourDiff);
                minOffset = Long.parseLong(minDiff);
                if (sign == 45) {
                    hourOffset = -hourOffset;
                }
            } else if (offset.equals("EDT")) {
                hourOffset = -4L;
            } else if (offset.equals("EST") || offset.equals("CDT")) {
                hourOffset = -5L;
            } else if (offset.equals("CST") || offset.equals("MDT")) {
                hourOffset = -6L;
            } else if (offset.equals("PDT") || offset.equals("MST")) {
                hourOffset = -7L;
            } else if (offset.equals("PST")) {
                hourOffset = -8L;
            } else if (offset.equals("GMT") || offset.equals("UT")) {
                hourOffset = 0L;
            } else if (offset.substring(0, 3).equals("GMT") && offset.length() > 3) {
                sign = offset.charAt(3);
                hourDiff = offset.substring(4, 6);
                minDiff = offset.substring(6, 8);
            }
            long millisOffset = hourOffset * 3600000L + minOffset * 60000L;
            Date gmtDate = cal.getTime();
            long millisDate = gmtDate.getTime();
            gmtDate.setTime(millisDate -= millisOffset);
            return gmtDate;
        }
        catch (Exception e) {
            Log.error("Exception in parseRfc2822Date: " + e.toString() + " parsing " + stringDate);
            e.printStackTrace();
            return null;
        }
    }

    public static Date getDeviceLocalDate(Date gmtDate) {
        if (null != gmtDate) {
            gmtDate.setTime(gmtDate.getTime() + millisDeviceOffset);
            return gmtDate;
        }
        return null;
    }

    public static Date parseUTCDate(String utc) {
        int day = 0;
        int month = 0;
        int year = 0;
        int hour = 0;
        int minute = 0;
        int second = 0;
        Calendar calendar = null;
        day = Integer.parseInt(utc.substring(6, 8));
        month = Integer.parseInt(utc.substring(4, 6));
        year = Integer.parseInt(utc.substring(0, 4));
        hour = Integer.parseInt(utc.substring(9, 11));
        minute = Integer.parseInt(utc.substring(11, 13));
        second = Integer.parseInt(utc.substring(13, 15));
        calendar = Calendar.getInstance();
        calendar.set(5, day);
        calendar.set(2, month - 1);
        calendar.set(1, year);
        calendar.set(11, hour);
        calendar.set(12, minute);
        calendar.set(13, second);
        Date date = calendar.getTime();
        long dateInMillis = date.getTime();
        date.setTime(dateInMillis + millisDeviceOffset);
        return date;
    }

    public static void setTimeZone(String timeZone) {
        if (timeZone == null || timeZone.length() < 5) {
            Log.error("setTimeZone: invalid timezone " + timeZone);
        }
        try {
            deviceOffset = timeZone;
            String hstmz = deviceOffset.substring(1, 3);
            String mstmz = deviceOffset.substring(3, 5);
            long hhtmz = Long.parseLong(hstmz);
            long mmtmz = Long.parseLong(mstmz);
            millisDeviceOffset = hhtmz * 3600000L + mmtmz * 60000L;
            if (deviceOffset.charAt(0) == '-') {
                millisDeviceOffset *= -1L;
            }
        }
        catch (Exception e) {
            Log.error("setTimeZone: " + e.toString());
            e.printStackTrace();
        }
    }

    public static String getReplyDateString(String date) {
        StringBuffer ret = new StringBuffer();
        String monthName = MailDateFormatter.getMonthName(Integer.parseInt(date.substring(0, date.indexOf(47))) - 1);
        String day = date.substring(date.indexOf(47) + 1, date.lastIndexOf(47));
        String yearAndTime = date.substring(date.lastIndexOf(47) + 1);
        ret.append(monthName).append(" ").append(day).append(", ").append(yearAndTime);
        return ret.toString();
    }

    private static int getMonthNumber(String name) {
        int l = monthNames.length;
        for (int i = 0; i < l; ++i) {
            if (!monthNames[i].equals(name)) continue;
            return i;
        }
        return -1;
    }

    private static String getMonthName(int number) {
        if (number >= 0 && number < monthNames.length) {
            return monthNames[number];
        }
        return null;
    }

    private static String getAMPM(Calendar cal) {
        return cal.get(9) == 0 ? "a" : "p";
    }

    private static String printTwoDigits(int number) {
        if (number > 9) {
            return String.valueOf(number);
        }
        return "0" + number;
    }
}

