/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.util;

import com.funambol.util.Log;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;

public class QuotedPrintable {
    private static byte HT;
    private static byte LF;
    private static byte CR;
    private static final byte ESCAPE_CHAR = 61;
    private static final byte TAB = 9;
    private static final byte SPACE = 32;
    private static final boolean[] SAFE_CHARS;

    public static int decode(byte[] qp) {
        int qplen = qp.length;
        int retlen = 0;
        for (int i = 0; i < qplen; ++i) {
            if (qp[i] == 61 && qplen - i > 2) {
                if (qp[i + 1] == CR && qp[i + 2] == LF) {
                    i += 2;
                    continue;
                }
                if (QuotedPrintable.isHexDigit(qp[i + 1]) && QuotedPrintable.isHexDigit(qp[i + 2])) {
                    qp[retlen++] = (byte)(QuotedPrintable.getHexValue(qp[i + 1]) * 16 + QuotedPrintable.getHexValue(qp[i + 2]));
                    i += 2;
                    continue;
                }
                Log.error("decode: Invalid sequence = " + qp[i + 1] + qp[i + 2]);
            }
            if ((qp[i] < 32 || qp[i] > 127) && qp[i] != HT && qp[i] != CR && qp[i] != LF) continue;
            qp[retlen++] = qp[i];
        }
        return retlen;
    }

    private static boolean isHexDigit(byte b) {
        return b >= 48 && b <= 57 || b >= 65 && b <= 70;
    }

    private static byte getHexValue(byte b) {
        return (byte)Character.digit((char)b, 16);
    }

    public static String decode(byte[] qp, String enc) {
        int len = QuotedPrintable.decode(qp);
        try {
            return new String(qp, 0, len, enc);
        }
        catch (UnsupportedEncodingException e) {
            Log.error("qp.decode: " + enc + " not supported. " + e.toString());
            return new String(qp, 0, len);
        }
    }

    public static final byte[] encode(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        for (int i = 0; i < bytes.length; ++i) {
            int b = bytes[i];
            if (b < 0) {
                b = 256 + b;
            }
            if (SAFE_CHARS[b]) {
                buffer.write(b);
                continue;
            }
            buffer.write(61);
            String hexValue = Integer.toHexString(b);
            if (hexValue.length() < 2) {
                hexValue = "0" + hexValue;
            }
            byte[] values = hexValue.toUpperCase().getBytes();
            for (int j = 0; j < values.length; ++j) {
                buffer.write(values[j]);
            }
        }
        return buffer.toByteArray();
    }

    public static final String encode(String str, String enc) throws UnsupportedEncodingException {
        if (str == null) {
            return null;
        }
        return new String(QuotedPrintable.encode(str.getBytes(enc)), enc);
    }

    public static final String encode(String str) throws UnsupportedEncodingException {
        if (str == null) {
            return null;
        }
        return new String(QuotedPrintable.encode(str.getBytes()));
    }

    static {
        int i;
        HT = (byte)9;
        LF = (byte)10;
        CR = (byte)13;
        SAFE_CHARS = new boolean[256];
        for (i = 33; i <= 60; ++i) {
            QuotedPrintable.SAFE_CHARS[i] = true;
        }
        for (i = 62; i <= 126; ++i) {
            QuotedPrintable.SAFE_CHARS[i] = true;
        }
        QuotedPrintable.SAFE_CHARS[9] = true;
        QuotedPrintable.SAFE_CHARS[32] = true;
    }
}

