/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.util;

import com.funambol.util.GzipStreamReader;
import com.funambol.util.SimpleStreamReader;
import com.funambol.util.StreamReader;
import com.funambol.util.StringUtil;

public class StreamReaderFactory {
    private static GzipStreamReader gzipStreamReader;
    private static SimpleStreamReader simpleStreamReader;

    private StreamReaderFactory() {
    }

    public static StreamReader getStreamReader(String type) {
        if (type != null) {
            if (StringUtil.equalsIgnoreCase(type, "gzip")) {
                if (gzipStreamReader == null) {
                    gzipStreamReader = new GzipStreamReader();
                }
                return gzipStreamReader;
            }
            if (StringUtil.equalsIgnoreCase(type, "deflate")) {
                return null;
            }
        } else {
            if (simpleStreamReader == null) {
                simpleStreamReader = new SimpleStreamReader();
            }
            return simpleStreamReader;
        }
        return null;
    }
}

