/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.util;

import com.funambol.util.Log;
import com.funambol.util.ThreadPoolMonitor;
import java.util.Vector;

public class ThreadPool {
    private final ThreadPoolMonitor monitor;
    private Vector threads;
    private int numberOfThreads;

    public ThreadPool(ThreadPoolMonitor monitor, int numberOfThreads) {
        this.monitor = monitor;
        this.numberOfThreads = numberOfThreads;
        this.threads = new Vector();
    }

    public ThreadPool(int numberOfThreads) {
        this(new ThreadPoolMonitor(), numberOfThreads);
    }

    private int getRunnableCount(int[] availableIdx) {
        int numRunning = 0;
        int idx = -1;
        for (int i = 0; i < this.threads.size(); ++i) {
            MonitorThread tr = (MonitorThread)this.threads.elementAt(i);
            if (tr == null) continue;
            if (!tr.isAlive()) {
                this.threads.setElementAt(null, i);
                idx = i;
                continue;
            }
            Log.debug(tr.toString());
            ++numRunning;
        }
        availableIdx[0] = idx;
        return numRunning;
    }

    public int getRunnableCount() {
        int[] availableIdx = new int[1];
        return this.getRunnableCount(availableIdx);
    }

    public synchronized Thread startThread(Runnable task) {
        MonitorThread thread = new MonitorThread(task);
        int[] availableIdx = new int[1];
        int numRunning = this.getRunnableCount(availableIdx);
        int idx = availableIdx[0];
        if (idx == -1) {
            this.threads.addElement(thread);
        } else {
            this.threads.setElementAt(thread, idx);
        }
        Log.debug("Number of running threads: " + numRunning);
        if (numRunning > this.numberOfThreads) {
            Log.error(numRunning + "/" + this.numberOfThreads + " running threads. " + "About to exceed the max.");
        }
        thread.setPriority(1);
        thread.start();
        return thread;
    }

    private class MonitorThread
    extends Thread {
        private Runnable task;

        private MonitorThread() {
        }

        public MonitorThread(Runnable task) {
            this.task = task;
        }

        public final void run() {
            try {
                this.task.run();
            }
            catch (Throwable t) {
                Log.error(this, "throwable catched in run()");
                ThreadPool.this.monitor.handleThrowable(this.getClass(), this.task, t);
            }
        }

        public String toString() {
            return "MonitorThread " + this.task;
        }
    }
}

