/*
 * Decompiled with CFR 0.152.
 */
package com.telefonica.copiagenda.controllers;

import com.funambol.syncml.spds.SourceConfig;
import com.funambol.syncml.spds.SyncException;
import com.funambol.syncml.spds.SyncManager;
import com.telefonica.copiagenda.CopiagendaApplication;
import com.telefonica.copiagenda.Locale;
import com.telefonica.copiagenda.controllers.DataController;
import com.telefonica.copiagenda.controllers.NetworkHandler;
import com.telefonica.copiagenda.controllers.SIMRegistry;
import com.telefonica.copiagenda.datasync.ContactsSyncListener;
import com.telefonica.copiagenda.datasync.CopiAgendaSyncConfig;
import com.telefonica.copiagenda.datasync.MessageListener;
import com.telefonica.copiagenda.datasync.source.ContactsManager;
import com.telefonica.copiagenda.datasync.source.ContactsSource;
import com.telefonica.copiagenda.datasync.source.ContactsSourceConfig;
import com.telefonica.copiagenda.datasync.source.CopiAgendaSyncRegister;
import com.telefonica.copiagenda.ui.LogViewer;
import com.telefonica.copiagenda.ui.ProgressView;
import java.util.Date;
import javax.microedition.pim.PIMException;

public class DataHandler
implements DataController,
MessageListener,
Runnable {
    private NetworkHandler iNetworkHandler;
    private String iErrorMessage = null;
    private ContactsManager contactsManager = null;
    private SyncManager syncManager = null;
    private CopiAgendaSyncConfig syncConfig = null;
    private ContactsSourceConfig contactsSourceConfig = null;
    private ContactsSource contactsSource = null;
    private ContactsSyncListener contactsSyncListener = null;
    private int iSyncMode = 203;
    public static final int BACKUP = 203;
    private ProgressView iProgressView = null;
    private CopiAgendaSyncRegister iSyncRegister = null;
    private SIMRegistry iSIMRegistry = null;

    public DataHandler(ProgressView aProgressView, CopiAgendaSyncRegister aRegister) {
        this.iProgressView = aProgressView;
        this.iNetworkHandler = new NetworkHandler(aProgressView);
        this.iSyncRegister = aRegister;
        this.iSIMRegistry = new SIMRegistry();
    }

    public String[] latestVersion() {
        return this.iNetworkHandler.fetchClientInformation();
    }

    public boolean isSIMRegistered() {
        return this.iSIMRegistry.isSIMRegistered(this.iNetworkHandler.getMSISDN());
    }

    public String backupContacts() {
        this.iSyncMode = 202;
        return this.sync();
    }

    public String restoreContacts() {
        this.iSyncMode = 204;
        return this.sync();
    }

    public String bidirectionalSync() {
        this.iSyncMode = 200;
        return this.sync();
    }

    private String sync() {
        this.iErrorMessage = null;
        this.run();
        return this.iErrorMessage;
    }

    public void cancelOperation() {
        LogViewer.debug("DataHandler:Cancel");
        this.iNetworkHandler.cancelFetch();
        this.contactsSource.cancelSync();
    }

    public void initSyncFramework(CopiagendaApplication aMIDlet) throws PIMException {
        this.contactsManager = new ContactsManager(this, this.iSyncRegister);
        if (!this.contactsManager.openContactList()) {
            throw new PIMException(Locale.get("CONTACT_LIST_NOT_OPEN_ERROR"));
        }
        String[] deviceInfo = new String[]{"Copiagenda", "java-phone"};
        this.syncConfig = new CopiAgendaSyncConfig(deviceInfo[0], deviceInfo[1], null);
        String syncUrl = this.createSyncAddress(aMIDlet, deviceInfo);
        System.out.println("EncRes: " + this.urlEncode(syncUrl));
        String userName = aMIDlet.getAppProperty("userName");
        String password = aMIDlet.getAppProperty("passWord");
        String contactsRemoteUri = aMIDlet.getAppProperty("contactsRemoteUri");
        String versionCheckUrl = aMIDlet.getAppProperty("versionCheckUrl");
        this.iNetworkHandler.setVersionCheckUrl(versionCheckUrl);
        this.syncConfig.setServerSettings(syncUrl, userName, password, contactsRemoteUri);
        this.contactsSourceConfig = new ContactsSourceConfig(contactsRemoteUri, this.iSyncMode);
        this.contactsSource = new ContactsSource(this.contactsSourceConfig, this.contactsManager);
        this.contactsSyncListener = new ContactsSyncListener(this.iProgressView, this.contactsSource, aMIDlet);
        this.contactsSource.setListener(this.contactsSyncListener);
        this.syncManager = new SyncManager(this.syncConfig);
    }

    private String createSyncAddress(CopiagendaApplication aMIDlet, String[] aDeviceInfo) {
        StringBuffer address = new StringBuffer();
        address.append(aMIDlet.getAppProperty("SyncUrl"));
        address.append("?mfg=");
        address.append(aDeviceInfo[0]);
        address.append("&model=");
        address.append(aDeviceInfo[1]);
        address.append("&type=CopiagendaJME_phone&ver=");
        int version = (int)(Float.parseFloat(aMIDlet.getAppProperty("MIDlet-Version")) * 100.0f);
        address.append(version);
        return address.toString();
    }

    public void ErrorMessage(String message) {
        LogViewer.debug("ErrorMessage: " + message);
        this.iErrorMessage = message;
    }

    public void InfoMessage(String message) {
        LogViewer.debug("InfoMessage: " + message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.contactsManager.openContactList()) {
            SourceConfig config = this.contactsSource.getConfig();
            config.setSyncMode(this.iSyncMode);
            this.contactsSource.setConfig(config);
            this.iSyncRegister.resetCounters();
            this.contactsManager.clearStatus();
            LogViewer.debug("DataHandler:run, Last sync: " + new Date(this.iSyncRegister.getLastSyncTime()).toString());
            long lastSyncTime = this.iSyncRegister.getLastSyncTime();
            this.contactsSource.setLastAnchor(lastSyncTime);
            if (lastSyncTime == 0L) {
                this.iSyncMode = 201;
            }
            try {
                LogViewer.debug("SyncManager.sync");
                this.syncManager.sync(this.contactsSource, this.iSyncMode);
            }
            catch (SecurityException e) {
                this.ErrorMessage(Locale.get("NETWORK_PERMISSION_DENIED"));
            }
            catch (SyncException se) {
                this.ErrorMessage(se.getMessage());
            }
            finally {
                int actualSyncMode = this.contactsSource.lastSyncMode();
                LogViewer.debug("DataHandler, Synced #" + actualSyncMode + ":" + new Date(this.contactsSource.getLastAnchor()).toString());
                this.contactsManager.updateStatus();
                this.iSyncRegister.updateLastSync(this.contactsSource.getLastAnchor(), actualSyncMode);
            }
        }
    }

    public int[] modificationCount() {
        return this.contactsManager.getModificationCount();
    }

    public void termsDisplayed(boolean aIsAccepted) {
        LogViewer.debug("Terms displayed, accepted=" + aIsAccepted);
        if (aIsAccepted) {
            this.iSIMRegistry.registerSim(this.iNetworkHandler.getMSISDN());
        }
    }

    public int getItemCount() {
        return this.contactsManager.getContactCount();
    }

    public String urlEncode(String aUrl) {
        LogViewer.debug("urlEncode,original: " + aUrl);
        if (aUrl == null) {
            return null;
        }
        StringBuffer urlOK = new StringBuffer();
        block3: for (int i = 0; i < aUrl.length(); ++i) {
            char ch = aUrl.charAt(i);
            switch (ch) {
                case '&': {
                    urlOK.append("&amp;");
                    continue block3;
                }
                default: {
                    urlOK.append(ch);
                }
            }
        }
        LogViewer.debug("urlEncode,result: " + urlOK.toString());
        return urlOK.toString();
    }
}

