/*
 * Decompiled with CFR 0.152.
 */
package com.telefonica.copiagenda.datasync;

import com.funambol.syncml.devinf.DevInf;
import com.funambol.util.SyncListener;
import com.telefonica.copiagenda.CopiagendaApplication;
import com.telefonica.copiagenda.Locale;
import com.telefonica.copiagenda.datasync.source.ContactsSource;
import com.telefonica.copiagenda.ui.LogViewer;
import com.telefonica.copiagenda.ui.ProgressView;

public class ContactsSyncListener
implements SyncListener {
    private final ProgressView iProgressView;
    private int iTotalItems;
    private int iSentItems;
    private int iReceiveItems;
    private double iProgress;
    private CopiagendaApplication iMIDlet;
    private final ContactsSource iContactSource;
    private boolean iTermsDisplayed;
    private boolean iTermsAccepted;

    public ContactsSyncListener(ProgressView aProgressView, ContactsSource aSource, CopiagendaApplication aMIDlet) {
        this.iProgressView = aProgressView;
        this.iContactSource = aSource;
        this.iMIDlet = aMIDlet;
    }

    public void dataReceived(String date, int size) {
        LogViewer.debug("DataReceived: " + date + "|" + size);
    }

    public void endConnecting(int action) {
        LogViewer.debug("EndConnecting:" + action);
    }

    public void endMapping() {
        LogViewer.debug("endMapping");
    }

    public void endReceiving() {
        LogViewer.debug("endReceiving");
    }

    public void endSending() {
        LogViewer.debug("endSending");
    }

    public void endSession(int status) {
        LogViewer.debug("ContactsSyncListener::endSession: " + status);
        this.iContactSource.sessionEnded(status);
        this.iProgressView.setString(Locale.get("SYNCHRONIZATION_COMPLETE"));
    }

    public void endSyncing() {
        LogViewer.debug("ContactsSyncListener::endSyncing ");
    }

    public void itemAddChunkSent(String key, String parent, int size) {
        LogViewer.debug("itemAddChunkSent: " + key + "|" + parent + "|" + size);
    }

    public void itemAddSendingEnded(String key, String parent, int size) {
        LogViewer.debug("itemAddSendingEnded: " + key + "|" + parent + "|" + size);
    }

    public void itemAddSendingStarted(String key, String parent, int size) {
        LogViewer.debug("itemAddSendingStarted: " + key + "|" + parent + "|" + size);
    }

    public void itemDeleteSent(Object item) {
        LogViewer.debug("itemDeleteSent");
        ++this.iSentItems;
        this.iProgress = (double)this.iSentItems / (double)this.iTotalItems * 100.0;
        this.iProgressView.setValue((int)this.iProgress);
    }

    public void itemDeleted(Object item) {
        LogViewer.debug("itemDeleted");
    }

    public void itemReceived(Object item) {
        LogViewer.debug("itemReceived");
        ++this.iReceiveItems;
        this.iProgress = (double)this.iReceiveItems / (double)this.iTotalItems * 100.0;
        this.iProgressView.setValue((int)this.iProgress);
    }

    public void itemReplaceChunkSent(String key, String parent, int size) {
        LogViewer.debug("itemReplaceChunkSent: " + key + "|" + parent + "|" + size);
    }

    public void itemReplaceSendingEnded(String key, String parent, int size) {
        LogViewer.debug("itemReplaceSendingEnded: " + key + "|" + parent + "|" + size);
    }

    public void itemReplaceSendingStarted(String key, String parent, int size) {
        LogViewer.debug("itemReplaceSendingStarted: " + key + "|" + parent + "|" + size);
    }

    public void itemUpdated(Object item) {
        LogViewer.debug("itemUpdated");
    }

    public void itemUpdated(Object item, Object update) {
        LogViewer.debug("itemUpdated, item/update");
    }

    public void startConnecting() {
        this.iProgressView.setString(Locale.get("PROGRESSVIEW_CONNECTING"));
    }

    public void startMapping() {
        this.iProgressView.setString(Locale.get("PROGRESSVIEW_FINALIZING"));
    }

    public void startReceiving(int number) {
        this.iProgressView.setString(Locale.get("PROGRESSVIEW_DOWNLOADING"));
        this.iTotalItems = number;
        if (this.iTotalItems < 0) {
            this.iTotalItems = 0;
        }
        this.iReceiveItems = 0;
        this.iProgress = 0.0;
    }

    public void startSending(int numNewItems, int numUpdItems, int numDelItems) {
        if (this.iTotalItems == 0) {
            this.iTotalItems = numNewItems + numUpdItems + numDelItems;
        }
        this.iProgressView.setString(Locale.get("PROGRESSVIEW_SENDING"));
    }

    public void startSession() {
    }

    public boolean startSyncing(int alertCode, DevInf devInf) {
        this.iProgressView.setLabel(Locale.get("PROGRESSVIEW_SYNCHRONIZING"));
        LogViewer.debug("SyncListener:startSyncing");
        return true;
    }

    public void syncStarted(int alertCode) {
        LogViewer.debug("syncStarted: " + alertCode);
    }

    public void itemAddSent(Object item) {
        LogViewer.debug("itemAddSent");
        ++this.iSentItems;
        this.iProgress = (double)this.iSentItems / (double)this.iTotalItems * 100.0;
        this.iProgressView.setValue((int)this.iProgress);
    }

    public void itemReplaceSent(Object item) {
        ++this.iSentItems;
        LogViewer.debug("itemReplaceSent: " + (double)this.iSentItems / (double)this.iTotalItems);
        LogViewer.debug("Total|Sent: " + this.iTotalItems + " | " + this.iSentItems);
        this.iProgress = (double)this.iSentItems / (double)this.iTotalItems * 100.0;
        this.iProgressView.setValue((int)this.iProgress);
    }

    public boolean startSyncing(int alertCode) {
        LogViewer.debug("SyncListener:startSyncing");
        this.iProgressView.setLabel(Locale.get("PROGRESSVIEW_SYNCHRONIZING"));
        this.iSentItems = 0;
        this.iProgress = 0.0;
        this.iProgressView.setValue(0);
        this.iTotalItems = 0;
        return true;
    }

    public void setTotalItems(int aClientItemsNumber) {
        this.iTotalItems = aClientItemsNumber;
        LogViewer.debug("SetNumber: " + this.iTotalItems);
    }

    public synchronized void termsDisplayed(boolean aIsAccepted) {
        this.iTermsDisplayed = true;
        this.iTermsAccepted = aIsAccepted;
        this.notify();
    }

    public synchronized boolean isDisplayMessageHandled(String message) {
        this.iTermsDisplayed = false;
        this.iMIDlet.displayTerms();
        while (!this.iTermsDisplayed) {
            LogViewer.debug("ContactsSyncListener, waiting for message handling");
            try {
                this.wait();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        return this.iTermsAccepted;
    }
}

