/*
 * Decompiled with CFR 0.152.
 */
package com.telefonica.copiagenda.ui;

import com.telefonica.copiagenda.CopiagendaApplication;
import com.telefonica.copiagenda.Locale;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;
import javax.microedition.lcdui.StringItem;

public class InformationView
extends Form
implements ItemCommandListener {
    public static final int LEGAL_NOTICE = 0;
    public static final int HELP = 1;
    public static final int ABOUT = 2;
    public static final int REMINDER = 3;
    private StringItem iText;
    public int iType = 0;
    private final CopiagendaApplication iMidlet;
    private final Command iOpenLinkCmd = new Command(Locale.get("GO_TO_COMMAND"), 4, 1);

    public InformationView(CopiagendaApplication aMIDlet) {
        super(null);
        this.iMidlet = aMIDlet;
    }

    public void construct(int aType) {
        this.deleteAll();
        this.iType = aType;
        this.iText = null;
        Item termsAndConditionsLink = null;
        switch (aType) {
            case 0: {
                this.setTitle(Locale.get("LEGAL_NOTICE"));
                Font itemFont = Font.getFont((int)64, (int)0, (int)0);
                String text = null;
                switch (this.iMidlet.iSyncMode) {
                    case 0: {
                        text = Locale.get("REGISTRATION_BACKUP");
                        break;
                    }
                    case 1: {
                        text = Locale.get("REGISTRATION_RESTORE");
                        break;
                    }
                    case 2: {
                        text = Locale.get("REGISTRATION_TWO_WAY");
                    }
                }
                text = text.replace('|', '\n');
                this.iText = new StringItem(null, text);
                this.iText.setFont(itemFont);
                break;
            }
            case 1: {
                this.setTitle(Locale.get("HELP_MENU_TEXT"));
                String text = Locale.get("HELP_TEXT");
                text = text.replace('|', '\n');
                this.iText = new StringItem(null, text);
                Font itemFont = Font.getFont((int)64, (int)0, (int)0);
                this.iText.setFont(itemFont);
                break;
            }
            case 2: {
                this.setTitle(Locale.get("ABOUT_MENU_TEXT"));
                StringItem copyrightHeader = new StringItem(Locale.get("COPYRIGHT") + "\n", this.iMidlet.getAppProperty("MIDlet-Vendor"));
                this.append((Item)copyrightHeader);
                StringItem applicationNameHeader = new StringItem(Locale.get("APPLICATION_NAME") + "\n", this.iMidlet.getAppProperty("MIDlet-Name"));
                this.append((Item)applicationNameHeader);
                StringItem versionHeader = new StringItem(Locale.get("VERSION") + "\n", this.iMidlet.getAppProperty("MIDlet-Version"));
                this.append((Item)versionHeader);
                StringItem moreInformationHeader = new StringItem(Locale.get("MORE_INFORMATION") + "\n", this.iMidlet.getAppProperty("homePage"), 1);
                moreInformationHeader.setItemCommandListener((ItemCommandListener)this);
                moreInformationHeader.setDefaultCommand(this.iOpenLinkCmd);
                this.append((Item)moreInformationHeader);
                break;
            }
            case 3: {
                this.addBackupPrompt();
                Font itemFont = Font.getFont((int)64, (int)0, (int)8);
                this.iText.setFont(itemFont);
                break;
            }
        }
        if (this.iText != null) {
            this.append((Item)this.iText);
        }
        if (termsAndConditionsLink != null) {
            this.append(termsAndConditionsLink);
        }
    }

    public void construct(int aType, int[] aMods) {
        if (aMods != null) {
            this.setTitle(System.getProperty("MIDlet-Name"));
            this.addBackupPrompt();
            Font itemFont = Font.getFont((int)64, (int)0, (int)8);
            this.iText.setFont(itemFont);
        }
        this.construct(aType);
    }

    private void addBackupPrompt() {
        String text = Locale.get("MODIFICATIONS_PROMPT");
        text = text.replace('|', '\n');
        this.iText = new StringItem(Locale.get("MODIFICATIONS_REMIND_TITLE"), text);
    }

    public void commandAction(Command cmd, Item item) {
        if (cmd == this.iOpenLinkCmd) {
            String url = ((StringItem)item).getText();
            StringBuffer formattedUrl = new StringBuffer();
            if (!url.startsWith("http://")) {
                formattedUrl.append("http://");
            }
            formattedUrl.append(url);
            this.iMidlet.openLink(formattedUrl.toString());
        }
    }
}

