/*
 * main.js
 */

/**
 * Objeto principal de control. 
 */
function Form() {
	// --------------------------------------------------------------- Variables
	/** Datos e informacin de usuario cargada */
	this.userInfo = null;
	
	/** Descripcin del anuncio actualmente seleccionado */
	this.currentAdDesc= null;
	
	/** Reintentar transaccin alta */
	this.retry_alta=true;
	
	this.selecteddateelem='day';
	
};
Form.prototype = {
	// -------------------------------------------------------------- Constantes
	/** Proporcin de la barra de progreso inicial correspondiente al proceso de  
	 * carga de datos informacin de usuario (GetUserInfo) */  
	PROG_UI: 0.10, // Progress User Info
	
	
	// --------------------------------------------------------------- Funciones
	/**
	 * Funcin de inicializacin.
	 */
	init: function() {
		// Se carga la introduccin inicial
		player.open("splash.mcd", "content-frame");
	},
	
	
	/**
	 * Muestra las condiciones legales
	 */
	showLegal: function() {
		player.open("legal.mcd","content-frame2");
		var e = document.getElementById("content-frame2");
		
		if (e) {
			if (!e.active) {
				e.active = true;
				e.boxedFocus=true;
				e.controlsFocus = true;
			}
		}
		var e2 = document.getElementById("content-frame");
		if (e2) {
			if (e2.active) {
				e2.active = false;
			}
		}
		toctoc.showHeader(msg["register.alta"],msg["register.terminos"]);
		softMenu.show({
			left: { text: "Acepto", actions: "form.hideLegal(true);" },
			right: { text: "No acepto", actions: "form.hideLegal(false);" }
		});
		
	},

	/**
	 * Oculta las condiciones legales
	 */
	hideLegal: function(accept) {
		var e = document.getElementById("content-frame2");
		var l=document.getElementById("legalCheck");
		
		if (e) {
			e.active = false;
			document.getElementById("content-frame").active=true;
		}
		l.active=accept;
		
		softMenu.show({
			left: {
				text: msg["softmenu.next"],
				actions: "form.validate();"
			},
			right: {
				text: msg["softmenu.cancel"],
				actions: "player.exit();"
			}
		});
	},
	
	validateRegisterForm: function() {
		trace("VALIDATE ENTRAR");
	   var date = document.getElementById("date");
	   var sex	= document.getElementById("sexo");
	   var region = document.getElementById("region");
	   var country=null;
	   var day= null;
	   var month = null;
	   var year = null;
	   var pText =null;
	   var rText =null;
	   var hActive=false;
	   var mActive=false;
		
			
	   if(tactileVersion){
		  trace();
	      country = document.getElementById("pais");
		  day = date.dayElem.day.text;
		  month = date.monthElem.month.text;
		  year = date.yearElem.year.text;
		  pText = country.paisText.text;
		  rText = region.regionText.text;
		  hActive=sex.hombreClip.hombre.active;
		  mActive=sex.mujerClip.mujer.active;
	    }
		else{
		   country = document.getElementById("country");
		   day = date.dayElem.day.value;
		   month = date.monthElem.month.value;
		   year = date.yearElem.year.value;
		   pText = country.value;
		   rText= region.value;
		   hActive=sex.hombre.active;
		   mActive=sex.mujer.active;
		}		
	   
		var legal = document.getElementById("legalCheck");
		var errmsg;
		if (!day || !month || !year ||(!hActive && !mActive) ||!pText || !rText) {
		   errmsg = "Por favor, rellene todos los campos del formulario.";
		} else if (day > 31 || month > 12 || year > 2009 || year < 1900) {
		   errmsg = "Por favor, introduzca una fecha de nacimiento vlida.";
		} else if (legal && !legal.active) {
		   errmsg = "Debe aceptar las condiciones legales para darse de alta.";
		}
		
		var date = new Date();
		try {
		   date.setTime(0);
		   date.setDate(2);
		   date.setYear(year);
		   date.setMonth(month-1);
		   date.setDate(day);
		} catch (err) {
		   errmsg = "Por favor, introduzca una fecha de nacimiento vlida.";
		}
		trace("VALIDATE SALIR");
		return errmsg;		
	},
	
	/**
	 * Valida los datos del formulario
	 */
	validate: function() {
		//TODO: chequear datos del formulario y lanzar transaccin
		var errmsg = this.validateRegisterForm();
		if (errmsg) {
			softMenu.saveState();
			toctoc.showInfoPopUp({message: [errmsg]},{
			left: { text: msg["softmenu.accept"], actions: "form.closePopUp();" }});
		}
		else {
			var self = this;
			var req = new XMLHttpRequest();
			var dir = SERVER_URL + "/registerUser";
			if(TM_user_msisdn)
				dir += "?TM_user_msisdn=" + TM_user_msisdn;
			req.open("POST", dir, true);
			toctoc.showEsperarPopUp();
			req.onreadystatechange = function() {
			var error = false;
			if (req.readyState == 4) {
					if (req.status == 0 || req.status == 200 || req.status == 204 
							|| req.status == 304) {
					
						try {
							var info = eval("(" + req.responseText + ")");
							toctoc.userInfo.userInfo = info;
							toctoc.userInfo.points = info.points;
							
							var popupInfo = {icon: "images/popUp/ok_img.png", 
						 			title: "tocAd",
						 			message: ["Gracias por darte de alta en tocAd"]};
							var i=1;
							if (info.points.last.points) {
								popupInfo.message[i]=msg["thanks.points"].replace("${points}", info.points.last.points);
								i++;
							}

							toctoc.showInfoPopUp(popupInfo, 
								{
										left: {
											text: msg["softmenu.accept"],
											actions: "toctoc.showProfileQuestion();"
										}
								});
							
						} catch (err) {
							error = true;
							trace("Error registering user: " + err);
							// TODO: Mostrar pantalla de error
						}
						
					} else {
						error = true;
						trace("Error loading user feed.");
						// TODO: Mostrar pantalla de error
					}
					toctoc.hideProgressBar();
					if (error) {								
						if(form.retry_alta) {							
							form.retry_alta=false;
							toctoc.showInfoPopUp({icon: "images/popUp/warning_img.png", 
					 			title: "tocAd",
					 			message: ["En este momento no es posible darte de alta.","Deseas intentarlo de nuevo?"]}, 
								{
										left: {
											text: "Si",
											actions: "form.validate();"
										},
										right: {
											text: "No",
											actions: "toctoc.hidePopUp();player.exit();"
										}
								});
						} else {
							toctoc.showInfoPopUp({icon: "images/popUp/warning_img.png", 
					 			title: "tocAd",
					 			message: ["En este momento no es posible darte de alta.","Intntalo de nuevo ms tarde."]}, 
								{
										left: {
											text: msg["softmenu.accept"],
											actions: "toctoc.hidePopUp();player.exit();"
										}
								});
						}
					}
				}
			};	
			req.setRequestHeader("Cache-Control", "no-cache");
			req.setRequestHeader("Content-Type", "application/json");
			req.send(this.getUserInfoJSON());
		}
	},
	
	closePopUp: function() {
		toctoc.hidePopUp();
		softMenu.restoreState();
//		softMenu.show({
//			left: {
//				text: "Siguiente",
//				actions: "form.validate();"
//			},
//			right: {
//				text: "Cancelar",
//				actions: "player.exit();"
//			}
//		});
	},
	
	getUserInfoJSON: function() {
		var date = new Date();
		var e = document.getElementById("date");
		date.setTime(0);
		date.setDate(2);
		
		var pText=null;
		var rText=null;		
		var yText=null;
		var dText=null;
		var mText=null;
		var gender=null;
		
		if(tactileVersion){
		   yText=e.yearElem.year.text;
		   mText=e.monthElem.month.text-1;
      	   dText=e.dayElem.day.text;
      	   
		   pText=document.getElementById("pais").paisText.text;
		   rText=document.getElementById("region").regionText.text;
		   
		   e = document.getElementById("sexo");
		   if (e.hombreClip.hombre.active)gender="male";
		   else if (e.mujerClip.mujer.active)gender="female";
		   
		}
		else{
			yText=e.yearElem.year.value;
			mText=e.monthElem.month.value-1;
			dText=e.dayElem.day.value;
			e = document.getElementById("sexo");
			if (e.hombre.active)gender="male";
			else if (e.mujer.active)gender="female";
			pText=document.getElementById("country").value;
			rText=document.getElementById("region").value;
		}
		   date.setYear(yText);
		   date.setMonth(mText);
		   date.setDate(dText);
		   var data = "{ \"DOB\": \"/Date("+(date.getTime())+")/\"," +
					   //" \"Id\":"+TM_user_msisdn+
					   " \"Id\": null"+
					   ", \"country\": \""+pText+
					   "\", \"gender\": \""+gender+
					   "\", \"province\":\""+rText+
					   "\", \"tags\": null, \"userPreferences\": null }";
		
		return data;
	},
	
	getExtendedUserInfoJSON: function(userInfo) {
		
		trace(" --------------> "+userInfo.country);
		trace(" --------------> "+userInfo.tags);
		
		var data = "{ \"DOB\": \"/Date("+userInfo.DOB.getTime()+")/\"," +
		   " \"Id\":"+userInfo.Id+
		   ", \"country\": \""+userInfo.country+
		   "\", \"gender\": \""+userInfo.gender+
		   "\", \"province\":\""+userInfo.province+
		   "\", \"tags\": "+this.getTagsInfoJSON(userInfo.tags) +
		   ",\"userPreferences\": "+this.getPreferencesInfoJSON(userInfo.userPreferences) +
		   "}";
		   
		return data;
	},

	getTagsInfoJSON: function(tags) {
		if(tags != null){
			if (tags.length == 0) return "null";
			else {
				var data = "[";
				for (var i=0; i<tags.length; i++) {
					data+="{";
					data+="\"Id\":"+tags[i].Id+
						  ",\"active\":"+tags[i].active+
						  ",\"name\":\""+tags[i].name+
						  "\",\"rootId\":"+tags[i].rootId;
					if (i == tags.length-1)
						data+="}";
					else
						data+="},";
				}
				data += "]";
				return data;
			}
		} else return "[]";
	},

	getPreferencesInfoJSON: function(prefs) {
		if (prefs.length == 0) return "null";
		else {
			var data = "{\"active\":"+prefs.active+
						 ",\"adtiming\":\""+prefs.adtiming+
						 "\",\"adtypes\":"+this.getTagsInfoJSON(prefs.adtypes)+"}";
			return data;
		}
	}
};

//Creacin del objeto
var form = new Form();
toctoc.form = form;