
function Loader()
{
	// --------------------------------------------------------------- Variables
	/** Datos e informacin de usuario cargada */
	this.req = null;
	this.allRegions = {};
	this.miArray = new Array();
	this.max_countries = 5;
	this.urlCountries=SERVER_URL+"/getCountries?language=es-es&name=";
	this.inputCountry="";
	this.inputCity="";
	this.frameHeight=0;
	this.regulableFrame=true;
	
	/**
	 * rf = RegionFrame --> clip que contiene el frame con las regiones.
	 * ri = RegionInput --> text-input de las regiones.
	 * cf = CountryFrame --> clip que contiene el frame con los pases.
	 * ci = CountryInput --> text-input de los pases.
	 */
	this.rf=null;
	this.ri=null;
	this.cf=null;
	this.ci=null;
	this.leftBorderCountries=null;
	this.rightBorderCountries=null;
	this.leftBorderCities=null;
	this.rightBorderCities=null;
	this.bLeft=null;
	this.bCenter=null;
	this.bRight=null;
	this.clipScroll=null;
	this.scrollPaises=null;
	this.lista=null;
	this.listaPaises=null;
	
	this.registered=false;
	
};

Loader.prototype =
{
	/**
	 * Carga las regiones e inicializa las variables globales.
	 */
	init: function(reg) {
	
		this.loadRegions();
		this.ri = document.getElementById('region');
		this.rf = document.getElementById('regionFrameClip');
		this.ci = document.getElementById('country');
		this.cf = document.getElementById('countryFrameClip');
		
		this.leftBorderCountries	= document.getElementById('leftBorder');
		this.rightBorderCountries	= document.getElementById('rightBorder');
		this.leftBorderCities		= document.getElementById('imgBorderL');
		this.rightBorderCities		= document.getElementById('imgBorderR');
		
		this.bLeft	= document.getElementById('bl');
		this.bCenter= document.getElementById('bc');
		this.bRight	= document.getElementById('br');
		
		this.clipScroll		=document.getElementById('clipScroll');
		this.scrollPaises	=document.getElementById('scrollPaises');
		this.lista			=document.getElementById('lista');
		this.listaPaises	=document.getElementById('listaPaises');
		
		this.registered=reg;
	},
	
	/**
	 * Carga las regiones en un array.
	 */
	loadRegions: function() {
		var url="resources/regions2.js";
		this.req=new XMLHttpRequest();
		this.req.open("GET",url,true);
		this.req.onreadystatechange=this.callback;
		this.req.send();
	},
	
	/**
	 * Evala la respuesta y la guarda en un array.
	 */
	callback: function() {
		if(loader.req.readyState == 4) {
			if(loader.req.status == 200 || loader.req.status == 304 || loader.req.status == 0) {
				var regions=loader.req.responseText;
				loader.allRegions=eval(regions);
			}
		}
	},
	
	/**
	 * Mtodo que recoge las regiones que comiencen por el valor del text-input de regiones.
	 * Es llamado cada vez que el valor del text-input cambia.
	 */
	loadCities: function() {
		// si el frame no tiene el foco
		if(!this.rf.regionFrame.controlsFocus) {
			this.resetCitySuggestions();
			var input=this.ri.value;
			
			this.inputCity=input;
			var words=new Array();
			
			if(input != "" && input != null) {
				var j=0;
				var arrayList=new Array();
				var dup_input=this.deleteAccent(input);
				var miArray = this.allRegions[dup_input.charAt(0)];
				if (miArray) {
					for(var i=0; i < miArray.length; i++) {
					
						words=this.fillWords(miArray,i);
						if(words.length == 1) {
							if(this.deleteAccent(miArray[i]).startsWith(dup_input))
								arrayList[j++]=miArray[i];
						} else {
							for(var k=0; k < words.length; k++) {
								if(this.deleteAccent(words[k]).startsWith(dup_input)) {
									arrayList[j++]=miArray[i];
									break;
								}
							}
						}
					}
				}
				
				if(arrayList.length != 0) { // si hay sugerencias
					for(var k=0; k < arrayList.length; k++) {
						var elem; 
						trace("actualizando: "+k);
						if(k == arrayList.length-1) {
							elem = this.lista.city9;
						} else {
							elem = this.lista["city"+k];
						}
						elem.txt.text=arrayList[k];
						elem.foc.txt.text=arrayList[k];
						elem.active=true;
					}
					// calcula y modifica la altura del frame
					this.calcProvFrameHeight(arrayList.length);
					this.clipScroll.height=this.getFrameHeight();
					if(this.regulableFrame) {
						this.leftBorderCities.height=this.getBorderLength(arrayList.length);
						this.rightBorderCities.height=this.leftBorderCities.height;
					}
					this.rf.active=true;
				} else {
					this.rf.active=false;
				}
			} else {
				this.rf.active=false;
			}
		}
	},
	
	resetCitySuggestions: function() {
		
		 for(var n=0; n < 10; n++)
			 this.lista["city"+n].active=false;
	},
	
	resetCountrySuggestions: function() {
		 for(var i=0; i < this.max_countries; i++) 
			 this.listaPaises["country"+i].active=false;
	},
	
	/**
	 * Se ejecuta en el evento onKeyDown del text-input de regiones.
	 * @param keyCode tecla presionada
	 * @return true para que siga evaluando eventos
	 */
	onKeyDownRegion: function(keyCode) {
		
		if (keyCode == -1 && this.rf.active) { // arriba
			this.rf.regionFrame.boxedFocus=true;
			this.rf.regionFrame.controlsFocus=true;
			if(!clearKey)toctoc.deActivateSK_rightForDeleting(this.registered);
			return false;
		} else	if (keyCode == -2 && this.rf.active) { // abajo
			this.rf.active = false;
			this.rf.regionFrame.boxedFocus=false;
			return true;
		} else if (keyCode == -5) {
			if (!this.rf.active){
				this.loadCities();
			} else {
				this.rf.active = false;
				this.rf.regionFrame.boxedFocus=false;
			}
			return true;
		} else {
			return true;
		}
	},
	
	/**
	 * Se ejecuta en el evento onKeyDown del text-input de pases.
	 * @param keyCode tecla presionada
	 * @return true para que siga evaluando eventos
	 */
	onKeyDownCountry: function(keyCode) {
		if (keyCode == -2 && this.cf.active) { // abajo
			this.cf.countryFrame.boxedFocus=true;
			this.cf.countryFrame.controlsFocus=true;
			if(!clearKey)toctoc.deActivateSK_rightForDeleting(this.registered);
			return false;
		} else	if (keyCode == -1 && this.cf.active) { // arriba
			this.cf.active = false;
			this.cf.countryFrame.boxedFocus=false;
			return true;
		} else if (keyCode == -5) { // botn central (se muestra u oculta la lista)
			if (!this.cf.active){
				this.loadCountries();
			} else {
				this.cf.active = false;
				this.cf.countryFrame.boxedFocus=false;
			}
			return true;
		} else {
			return true;
		}
	},
	 
	
	/**
	 * Asigna altura al frame de regiones dependiendo del nmero de sugerencias encontradas.
	 * @param num nmero de sugerencias
	 */
	calcProvFrameHeight: function(num) {
		
		switch(num) {
			case 1:		this.frameHeight=38;break;
			case 2: 	this.frameHeight=53;break;
			case 3:		this.frameHeight=65;break;
			default:	this.frameHeight=65;break;
		}
	},
	
	/**
	 * Devuelve la altura del frame.
	 * @return altura del frame
	 */
	getFrameHeight: function() {
		return this.frameHeight;
	},
	
	/**
	 * Altura dinmica del los bordes laterales del frame de sugerencias de regiones,
	 * dependiendo de la altura del frame (que depende del nmero de
	 * sugerencias).
	 * @return altura de los bordes
	 */
	getBorderLength: function(num) {
		
		var length=0;
		
		switch(num) {
			case 1:		length=25;break;
			case 2: 	length=55;break;
			case 3:		length=75;break;
			default:	length=75;break;
		}
		return length;
	},
	
	/**
	* Asigna altura al frame de pases dependiendo del nmero de sugerencias encontradas.
	* @param num nmero de sugerencias
	*/
	calcCountryFrameHeight: function(num) {
		
		switch(num) {
			case 1:		this.frameHeight=20;break;
			case 2: 	this.frameHeight=43;break;
			case 3:		this.frameHeight=65;break;
			default:	this.frameHeight=65;break;
		}
	},
	
	/**
	* Altura y posicin dinmica del los bordes laterales del frame de sugerencias de pases,
	* dependiendo de la altura del frame (que depende del nmero de
	* sugerencias).
	* @return altura y posicin
	*/
	getBorderLengthForCountries: function(num) {
		
		var length=0;
		
		switch(num) {
			case 1:		length=15;break;
			case 2: 	length=38;break;
			case 3:		length=60;break;
			default:	length=60;break;
		}
		return length;
	},
	
	/**
	 * Devuelve array con las distintas palabras de una regin.
	 * @param n posicin de la regin en el array de regiones.
	 * @return array con las palabras de una regin
	 */
	fillWords: function(array,n) {
		var site=array[n];
		var words=site.split(" ");
		
		return words;
	},
	
	hideCountriesList: function() {
		this.cf.active=false;
		this.ci.parent.loadingCountry.active=false;
	},
	 
	/**
	 * Peticin de sugerencias de pases con el valor del text-input.
	 * Es llamado cada vez que el valor del text-input cambia.
	 */
	getCountries: function() {
		if(!this.cf.countryFrame.controlsFocus && player.focusedElement.id == this.ci.id) {
			var valor=new String();
			valor=this.ci.value;
			valor=valor.replace(" ","&nbsp;");
			
			this.hideCountriesList();
	
			if(valor.length > 1) {
				this.req=new XMLHttpRequest();
				this.req.open("GET",this.urlCountries+valor,true);
				this.req.onreadystatechange=this.loadCountries;
				this.req.country = this.ci.value;
				this.req.send();
				this.ci.parent.loadingCountry.active=true;
			}
		}
	},
	
	/**
	* Evala la respuesta y muestra las sugerencias de pases.
	* Es llamado cada vez que el valor del text-input cambia.
	*/
	loadCountries: function() {
		
		try {
			if(loader.req.readyState == 4) {
				if(loader.req.status == 200 || loader.req.status == 304 || loader.req.status == 0) {
					loader.resetCountrySuggestions();
					var countries=loader.req.responseText;
					var arrayC=new Array();
					arrayC=eval(countries);
					var show=true;
					if (player.focusedElement.id != loader.ci.id || (loader.req.country != loader.ci.value && loader.cf.active)) {
		//				insertCountry(ci.value);
		//				player.focus("country");
		//				cf.countryFrame.controlsFocus=false;
						loader.cf.active=false;
						return;
					}
					loader.ci.parent.loadingCountry.active=false;
					// si hay sugerencias, y no sobrepasan el valor mximo de sugerencias a mostrar
					if(arrayC.length != 0 && arrayC.length <= loader.max_countries) {
						if(arrayC.length == 1 && arrayC[0] == loader.ci.value) {
							show=false;
						}
						
						if(show) {
							// calcula y modifica la altura del frame
							loader.calcCountryFrameHeight(arrayC.length);
							loader.scrollPaises.height=loader.getFrameHeight();
							if(loader.regulableFrame) {
								var height = loader.getBorderLengthForCountries(arrayC.length);
								loader.leftBorderCountries.height=
								loader.rightBorderCountries.height=
								loader.bLeft.style.top=
								loader.bCenter.style.top=
								loader.bRight.style.top=height;
							}
							loader.cf.active=true;
							var country;
							for(var k=0; k < arrayC.length; k++) {
								country = loader.listaPaises["country"+k]; 
							    country.txt.text=country.foc.txt.text=arrayC[k];
	//							country.foc.txt.text=arrayC[k];
								country.active=true;
							}
		
							loader.cf.countryFrame.boxedFocus=false;
							loader.ci.value=loader.req.country;
						}
					} else {
						loader.hideCountriesList();
					}
				}
			}
		} catch(err) {
			trace("Error load country "+loader.req.country+": "+err);
		}
	},
	
	/**
	 * Quita el acento a una palabra.
	 * @param word palabra a la que quitar el acento.
	 * @return palabra sin acentos
	 */
	deleteAccent: function(word) {
		var dup=new String();
		dup=word.toUpperCase();
		
		if(dup.indexOf("") != -1) dup=dup.replace("","A");
		if(dup.indexOf("") != -1) dup=dup.replace("","E");
		if(dup.indexOf("") != -1) dup=dup.replace("","I");
		if(dup.indexOf("") != -1) dup=dup.replace("","O");
		if(dup.indexOf("") != -1) dup=dup.replace("","U");
		
		return dup;
	},
	
	/**
	 * Inserta el valor que se le pasa por parmetro en el text-input de regiones.
	 * @param id valor a insertar
	 */
	insertProvince: function(id) {
		this.ri.value=id;
		this.rf.regionFrame.boxedFocus=false;
		this.rf.active=false;
		this.inputCity=id;
		if(!clearKey)toctoc.activateSK_rightForDeleting("region",this.registered);
		player.focus('region');
	},
	
	/**
	* Inserta el valor que se le pasa por parmetro en el text-input de pases.
	* @param id valor a insertar
	*/
	insertCountry: function(id) {
		this.ci.value=id;
		this.cf.countryFrame.boxedFocus=false;
		this.cf.active=false;
		this.inputCountry=id;
		if(!clearKey)toctoc.activateSK_rightForDeleting("country",this.registered);
		player.focus('country');
	},
	
	/**
	 * Devuelve el valor del text-input de pases.
	 * @return valor del text-input de pases
	 */
	getInputCountry: function() {
		
		if(this.inputCountry != "" && this.inputCountry != null)
			return this.inputCountry;
		else
			return this.ci.value;
	},
	
	/**
	* Devuelve el valor del text-input de regiones.
	* @return valor del text-input de regiones
	*/
	getInputCity: function() {
		if(this.inputCity != "" && this.inputCity != null)
			return this.inputCity;
		else
			return this.ri.value;
	},
	
	/**
	 * Slamente modifica la variable inputCountry si el usuario escribe en el text-input.
	 * Activa la softkey derecha como tecla de borrado, si as est especificado en el descriptor.
	 * @param registered si est registrado
	 */
	changeInputCountry: function(registered) {
		if(!this.cf.countryFrame.controlsFocus) {
			this.inputCountry=this.ci.value;
			if(this.inputCountry != null && this.inputCountry != "") {
				if(!clearKey)toctoc.activateSK_rightForDeleting("country",registered);
			} else {
				if(!clearKey)toctoc.deActivateSK_rightForDeleting(registered);
			}
		}
	},
	
	/**
	* Slamente modifica la variable inputCity si el usuario escribe en el text-input.
	* Activa la softkey derecha como tecla de borrado, si as est especificado en el descriptor.
	* @param registered si est registrado
	*/
	changeInputCity: function(registered) {
		if(!this.rf.regionFrame.controlsFocus) {
			this.inputCity=this.ri.value;
			if(this.inputCity != null && this.inputCity != "") {
				if(!clearKey)toctoc.activateSK_rightForDeleting("region",registered);
			} else {
				if(!clearKey)toctoc.deActivateSK_rightForDeleting(registered);
			}
		}
	}
};

var loader = new Loader();
