/*
 * soft_menu.js
 */

trace("loading --> softmenu.js");

/**
 * Objeto de control del Soft-Menu.
 */
var softMenu = {
	opened: false,
	visible: false,
	loading: false,
	state: {
		left: {
			text: "",
			actions: null,
			options: []
		},
		right: {
			text: "",
			actions: null
		}
	},
	savedState: null,
	leftClick: function() {
		if (this.loading) {
			trace("ignoring event");
			return;
		}
		if (this.opened) {
			player.linkFocus();
		} else {
			if (this.state.left) {
				var left = this.state.left;
				if (left.options && left.options.length > 0) {
					this.openLeftMenu();
				} else {
					if (left.actions) {
						eval(left.actions);
					}
				}
			}
		}
	},
	rightClick: function() {
		if (this.loading) {
			return;
		}
		if (this.opened) {
			this.close();
		} else {
			if (this.state.right && this.state.right.actions) {
				eval(this.state.right.actions);
			}
		}
	},
	openLeftMenu: function() {
		var e = document.getElementById("sm-left-options");
		var e2 = document.getElementById("bordo");
		if (e && !e.active) {
			e.active = true;
			e2.active = true;
			document.getElementById('volumeChecked').active=audio.audio_enabled;
		}
//		if (e = document.getElementById("sm-left-text")) {
//			e.text = "Seleccionar";
//		}			
		if (e = document.getElementById("sm-right-text")) {
			e.text = "Cancelar";
		}
		this.opened = true;
	},
	close: function() {
		var e = document.getElementById("sm-left-options");
		var e2 = document.getElementById("bordo");
		if (e && e.active) {
			e.active = false;
			e2.active = false;
			audio.saveVolume();
		}
		if (e = document.getElementById("sm-left-text")) {
			e.text = (this.state.left && this.state.left.text) ? this.state.left.text : "";
		}
		if (e = document.getElementById("sm-right-text")) {
			e.text = (this.state.right && this.state.right.text) ? this.state.right.text : "";
		}
		this.opened = false;
	},	
	show: function(state) {
		if (state) {
			this.state = state;
			this.refresh();
		}
		var e = document.getElementById("soft-menu");
		if (e) {
			e.active = true;
			e.alpha = 100;
		}
		this.visible = true;
	},
	showEmpty: function() {
		this.show({
			left: {
				text: msg[""],
				actions: ""
			},
			right: {
				text: msg[""],
				actions: ""
			}
		});
	},

	hide: function() {
		var e = document.getElementById("soft-menu");
		if (e && e.active) {
			this.close(); 
			e.active = false;
		}
		this.visible = false;
	},

	refresh: function() {
		var e;
		if (e = document.getElementById("sm-left-text")) {
			e.text = (this.state.left && this.state.left.text) ? this.state.left.text : "";
			if (this.state.left && !this.state.left.actions && !this.state.left.options) {
				e.alpha=50;
			} else {
				e.alpha=SM_TEXT_ALPHA_LEVEL;
			}
		}		
		if (e = document.getElementById("sm-left-options")) {
			var out ="";						
			if (this.state.left && this.state.left.options) {
				for (var i = 0; i < this.state.left.options.length; i++) {
					
					if(i == 0) {
						out +="<clip id='option"+i+"' actions='" + this.state.left.options[i].actions + "' style='width: 96px; padding: 2px;' onFocus='softMenu.switchVolumeLabel(audio.audio_enabled);' onBlur='document.getElementById(\"sm-left-text\").text=\"Seleccionar\";' >" +
						"<text id='text"+i+"' fontRef=\"font_14_bold\" style=\"right:15\">" + this.state.left.options[i].text + "</text>" +
						"<image ref='checkBox' style=\"right:62\" />" +
						"<clip id='volumeChecked' active=\""+audio.audio_enabled+"\" style=\"right:62\" ><image ref='checked' /></clip>" +
						"</clip>";
					} else {
						out +="<clip id='option"+i+"' actions='" + this.state.left.options[i].actions + "' style='width: 96px; padding: 2px;'>" +
						"<text id='text"+i+"' fontRef=\"font_14_bold\" style=\"right:15\">" + this.state.left.options[i].text + "</text>" +
						"</clip>";
					}
					
				}
			}
			e.write(out);
		}
		if (e = document.getElementById("sm-right-text")) {
			e.text = (this.state.right && this.state.right.text) ? this.state.right.text : "";
			if (this.state.right && !this.state.right.actions) {
				e.alpha=50;
			} else {
				e.alpha=SM_TEXT_ALPHA_LEVEL;
			}
		}
	},
	
	saveState: function() {
		this.savedState = this.state;
	},
	
	restoreState: function() {
		if (this.savedState) {
			this.show(this.savedState);
			this.savedState = null;
		}
	},
	
	showLoading: function() {
		this.loading = true;
		var e = document.getElementById("loading");
		var lt = document.getElementById("sm-left-text");
		var rt = document.getElementById("sm-right-text");
		if (e) {
			e.active = true;
			e.play();
		}
		if (lt) lt.active=false;
		if (rt) rt.active=false;	
	},
	hideLoading: function() {
		this.loading = false;
		var e = document.getElementById("loading");
		var lt = document.getElementById("sm-left-text");
		var rt = document.getElementById("sm-right-text");
		if (e) {
			e.active = false;
			e.stop();
		}
		if (lt) lt.active=true;
		if (rt) rt.active=true;
	},
	
	switchVolumeLabel: function(volume) {
		
		if(volume) {
			document.getElementById("sm-left-text").text="Desactivar";
		} else {
			document.getElementById("sm-left-text").text="Activar";
		}
		document.getElementById("volumeChecked").active=volume;

	}

	
};