/*
 * Decompiled with CFR 0.152.
 */
import com.mgie.darkchess.DarkChessConfig;
import com.mgie.lib.MGIECanvas;
import com.mgie.lib.MGIESoundAdvance;
import com.mgie.ui.UIHelper;
import javax.microedition.lcdui.Graphics;

public class GameDisplay
extends MGIECanvas
implements GameConfig,
DarkChessConfig {
    private final GameControl game;
    public GameRes res = null;
    public static final int THEME_COLOR_TEXT = 0xFFFFFF;
    public static final int THEME_COLOR_TEXT_BORDER = 0;
    public static final int THEME_COLOR_PAD_BG = 41193;

    public GameDisplay(GameControl gameControl) {
        super(GameMidlet.midlet);
        this.game = gameControl;
        this.res = this.game.res;
    }

    private void drawCanvasCore(Graphics graphics) {
        graphics.setFont(GameRes.font);
        this.fillEmptyBG(graphics, 0);
        switch (this.game.gameState) {
            case 1: {
                this.drawLogo(graphics);
                break;
            }
            case 2: {
                this.drawAnyKey(graphics);
                break;
            }
            case 3: {
                this.drawEnableSound(graphics);
                break;
            }
            case 5: {
                this.drawQuit(graphics);
                break;
            }
            case 4: {
                this.drawMainMenu(graphics);
                break;
            }
            case 6: 
            case 13: {
                this.drawGame(graphics);
                break;
            }
            case 8: {
                this.drawSetting(graphics);
                break;
            }
            case 7: {
                this.drawIntroduction(graphics);
                break;
            }
            case 9: {
                this.drawCredit(graphics);
                break;
            }
            case 10: {
                this.drawSelectRole(graphics);
                break;
            }
            case 11: {
                this.drawBalance(graphics);
                break;
            }
            case 12: {
                this.drawGameExitThanks(graphics);
                break;
            }
            case 14: {
                this.drawSave(graphics);
                break;
            }
            case 15: {
                GameDisplay.fillRect(graphics, 0, 0, 240, 260, 0);
            }
        }
    }

    private void drawLogo(Graphics graphics) {
        this.fillEmptyBG(graphics, 0xFFFFFF);
        GameDisplay.drawImage(graphics, images[21], 120, 130, 3);
    }

    private void drawAnyKey(Graphics graphics) {
        this.fillEmptyBG(graphics, 41193);
        GameDisplay.drawImage(graphics, images[11], 0, 0, 20);
        if (this.game.runTick % 10 < 6) {
            GameDisplay.drawRoundString(graphics, GameRes.gameText[0], 120, 195, 17, 0, 0xFFFFFF);
        }
    }

    private void drawEnableSound(Graphics graphics) {
        this.fillEmptyBG(graphics, 41193);
        GameDisplay.drawImage(graphics, images[11], 0, 0, 20);
        GameDisplay.drawRoundString(graphics, GameRes.gameText[1], 120, 195, 17, 0, 0xFFFFFF);
        this.drawImgButton(graphics, true, true, false);
    }

    private void drawIntroduction(Graphics graphics) {
        this.drawAlertPage(graphics, 3);
    }

    private void drawCredit(Graphics graphics) {
        this.drawAlertPage(graphics, 1);
    }

    private void drawQuit(Graphics graphics) {
        this.fillImageBG(graphics, 2);
        this.drawImgButton(graphics, true, true, false);
        GameDisplay.drawRoundString(graphics, GameRes.gameText[7], 120, 86, 17, 0, 0xFFFFFF);
    }

    private void drawSave(Graphics graphics) {
        this.fillImageBG(graphics, 2);
        if (this.res.game_saving) {
            GameDisplay.drawRoundString(graphics, GameRes.gameText[31], 120, 86, 17, 0, 0xFFFFFF);
        } else {
            GameDisplay.drawRoundString(graphics, GameRes.gameText[30], 120, 86, 17, 0, 0xFFFFFF);
        }
        this.drawImgButton(graphics, true, true, false);
    }

    private void drawGameExitThanks(Graphics graphics) {
        this.fillImageBG(graphics, 2);
        int n = 109;
        for (int i = 0; i < this.game.displayTexts.length; ++i) {
            GameDisplay.drawString(graphics, this.game.displayTexts[i], 120, n, 17, 0xFFFFFF);
            n += 21;
        }
    }

    private void fillEmptyBG(Graphics graphics, int n) {
        graphics.setColor(n);
        GameDisplay.fillRect(graphics, 0, 0, 240, 260);
    }

    private void fillImageBG(Graphics graphics, int n) {
        for (int i = 0; i < 240; ++i) {
            GameDisplay.drawImage(graphics, images[n], i, 0, 20);
        }
    }

    private void drawImgButton(Graphics graphics, boolean bl, boolean bl2, boolean bl3) {
        if (bl) {
            GameDisplay.drawImage(graphics, images[20], 0, 260, 36);
        }
        if (bl2) {
            GameDisplay.drawImage(graphics, images[19], 240, 260, 40);
        }
        if (bl3) {
            GameDisplay.drawImage(graphics, images[18], 240, 260, 40);
        }
    }

    private void drawAlertPage(Graphics graphics, int n) {
        this.fillImageBG(graphics, 2);
        UIHelper.setDrawRegion(9, 41, 226, 201);
        graphics.setColor(0xFFFFFF);
        UIHelper.drawText(graphics, this.game.displayTexts, this.game.menuIdx, 22, 20, null);
        this.drawScrollBar(graphics, this.game.menuIdx, this.game.displayTexts.length, 22, 201, 36);
        this.drawImageTitle(graphics, n);
        GameDisplay.resetClip(graphics);
        this.drawImgButton(graphics, false, false, true);
    }

    private void drawImageTitle(Graphics graphics, int n) {
        GameDisplay.drawClipImage(graphics, images[29], 0, 0, 0, n * 33, 240, 33);
        GameDisplay.resetClip(graphics);
    }

    private void drawScrollBar(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        UIHelper.setDrawRegion(233, n5, 7, n4);
        UIHelper.drawScrollBar(graphics, n2, n, n3, 0, 9363538, 0xFFFFFF, 0x999999, false, 10);
    }

    private void drawMainMenu(Graphics graphics) {
        try {
            GameDisplay.drawImage(graphics, images[11], 0, 0, 20);
            int n = GameDisplay.getStringHeight(graphics.getFont());
            GameDisplay.fillRect(graphics, 0, 195, 240, n, 0);
            GameDisplay.drawRoundString(graphics, GameRes.gameText[this.game.menuTextIdx[this.game.menuIdx]], 120, 195, 17, 0, 0xFFFFFF);
            int n2 = GameDisplay.getStringWidth(GameRes.gameText[this.game.menuTextIdx[this.game.menuIdx]], graphics.getFont());
            int n3 = 5;
            int n4 = (n - GameDisplay.getImageHeight(images[3])) / 2;
            GameDisplay.drawImage(graphics, images[3], (240 - n2) / 2 - n3, 195 + n4, 24);
            GameDisplay.drawImage(graphics, images[4], (240 + n2) / 2 + n3, 195 + n4, 20);
            this.drawImgButton(graphics, true, true, false);
        }
        catch (RuntimeException runtimeException) {
            this.game.menuIdx = 0;
        }
    }

    private void drawSelectRole(Graphics graphics) {
        this.fillEmptyBG(graphics, 0);
        this.drawImageTitle(graphics, 0);
        GameDisplay.drawImage(graphics, images[28], 0, 260, 36);
        for (int i = 0; i < GameConfig.PLAYER_IMAGE_LIST.length; ++i) {
            GameDisplay.drawImage(graphics, images[GameConfig.PLAYER_IMAGE_LIST[i]], 80 * i, 49, 20);
            if (i == this.game.menuIdx) {
                GameDisplay.drawImage(graphics, images[26], 80 * i, 49, 20);
                continue;
            }
            GameDisplay.drawImage(graphics, images[10], 80 * i, 49, 20);
        }
        GameDisplay.drawRoundString(graphics, GameRes.gameText[this.game.menuTextIdx[this.game.menuIdx]], 120, 217, 17, 0, 0xFFFFFF);
        this.drawImgButton(graphics, true, true, false);
    }

    private void drawGame(Graphics graphics) {
        if (this.game.play_action_state == 15) {
            this.drawQuit(graphics);
            return;
        }
        this.fillEmptyBG(graphics, 41193);
        this.drawDarkChess(graphics);
        switch (this.game.play_action_state) {
            case 10: {
                this.drawSelectFirst(graphics);
                break;
            }
            case -3: 
            case 3: {
                int n = 48 + this.res.lastChess.col * 36;
                int n2 = -15 + this.res.lastChess.row * 32;
                int n3 = this.game.counter;
                GameDisplay.drawClipImage(graphics, images[0], n, n2, 71 * n3, 0, 71, 63);
                GameDisplay.drawClipImage(graphics, images[1], 38, 104, 0, 51, 164, 51);
                GameDisplay.resetClip(graphics);
                break;
            }
            case 13: {
                if (this.res.player_winner) {
                    GameDisplay.drawClipImage(graphics, images[1], 38, 104, 0, 0, 164, 51);
                } else {
                    GameDisplay.drawClipImage(graphics, images[1], 38, 104, 0, 102, 164, 51);
                }
                GameDisplay.resetClip(graphics);
                break;
            }
            case 16: {
                GameDisplay.drawClipImage(graphics, images[1], 38, 104, 0, 153, 164, 51);
                GameDisplay.resetClip(graphics);
                break;
            }
            case 14: {
                this.drawGamePause(graphics);
                break;
            }
        }
        GameDisplay.resetClip(graphics);
    }

    private void drawGamePause(Graphics graphics) {
        int n = GameDisplay.getStringHeight(graphics.getFont());
        int n2 = n + 4;
        GameDisplay.fillRect(graphics, 0, 67, 240, n2 * this.game.menuTextIdx.length + 6, 3763784);
        GameDisplay.fillRect(graphics, 0, 69, 240, n2 * this.game.menuTextIdx.length + 2, 11004470);
        GameDisplay.fillRect(graphics, 0, 70, 240, n2 * this.game.menuTextIdx.length, 674145);
        for (int i = 0; i < this.game.menuTextIdx.length; ++i) {
            int n3 = 70 + i * n2;
            if (i == this.game.menuIdx) {
                GameDisplay.fillRect(graphics, 0, n3, 240, n, 9632766);
                GameDisplay.drawString(graphics, GameRes.gameText[this.game.menuTextIdx[i]], 120, n3, 17, 0);
                continue;
            }
            GameDisplay.drawString(graphics, GameRes.gameText[this.game.menuTextIdx[i]], 120, n3, 17, 0xFFFFFF);
        }
    }

    private void drawSelectFirst(Graphics graphics) {
        this.fillImageBG(graphics, 2);
        this.drawImageTitle(graphics, 2);
        if (this.res.player_first) {
            GameDisplay.drawImage(graphics, images[14], 38, 104, 20);
            GameDisplay.drawClipImage(graphics, images[12], 70, 93, 0, 0, 106, 39);
            GameDisplay.drawClipImage(graphics, images[12], 70, 139, 0, 117, 106, 39);
        } else {
            GameDisplay.drawImage(graphics, images[14], 38, 143, 20);
            GameDisplay.drawClipImage(graphics, images[12], 70, 93, 0, 78, 106, 39);
            GameDisplay.drawClipImage(graphics, images[12], 70, 139, 0, 39, 106, 39);
        }
        GameDisplay.resetClip(graphics);
        this.drawImgButton(graphics, true, true, false);
    }

    private void drawDarkChess(Graphics graphics) {
        int n;
        int n2;
        GameDisplay.drawImage(graphics, images[13], 0, 0, 20);
        GameDisplay.drawImage(graphics, images[GameConfig.HEAD_IMAGE_LIST[this.res.player_rival]], 0, 260, 36);
        if (this.res.display_chess_map == null) {
            return;
        }
        byte by = 0;
        for (n2 = 0; n2 < 8; ++n2) {
            for (n = 0; n < 4; ++n) {
                this.drawChessUnit(graphics, n2, n, by);
                by = (byte)(by + 1);
            }
        }
        for (n2 = 0; n2 < this.res.delete_chess_total.length - 1; ++n2) {
            n = this.getChessNumber(n2, this.res.delete_chess_total[n2 + 1]);
            int n3 = -1;
            if (this.res.player_chess_color == -1) {
                n3 = n > 0 ? 0 : 2;
            } else if (this.res.player_chess_color == 1) {
                n3 = n > 0 ? 1 : 3;
            }
            if (n3 == -1) {
                n = 0;
                GameDisplay.drawImage(graphics, images[6], 4, 22 + n2 * 23, 20);
            } else {
                GameDisplay.drawClipImage(graphics, images[8], 4, 22 + n2 * 23, n2 * 17, n3 * 18, 17, 18);
            }
            GameDisplay.drawClipImage(graphics, images[22], 23, 30 + n2 * 23, 0, 0, 7, 8);
            GameDisplay.drawClipImage(graphics, images[22], 30, 30 + n2 * 23, (n + 1) * 7, 0, 7, 8);
            GameDisplay.resetClip(graphics);
        }
        if (this.game.play_action_state == 2) {
            GameDisplay.drawImage(graphics, images[9], 71 + this.res.attack_chess_col * 36, 1 + this.res.attack_chess_row * 32, 20);
        }
        GameDisplay.drawImage(graphics, images[27], 51 + this.res.game_col * 36, 1 + this.res.game_row * 32, 20);
    }

    private byte getChessNumber(int n, byte by) {
        switch (n) {
            case 0: {
                return (byte)(1 - by);
            }
            case 6: {
                return (byte)(5 - by);
            }
        }
        return (byte)(2 - by);
    }

    private void drawChessUnit(Graphics graphics, int n, int n2, byte by) {
        if (this.res.display_chess_map[by] == 0) {
            return;
        }
        int n3 = 72 + n2 * 36;
        int n4 = 2 + n * 32;
        if (this.res.display_chess_map[by] != 10) {
            byte by2 = this.res.display_chess_map[by];
            if (this.res.lastChess != null && this.res.lastChess.row == n && this.res.lastChess.col == n2 && this.game.runTick % 10 > 6) {
                return;
            }
            if (by2 > 0) {
                GameDisplay.drawClipImage(graphics, images[5], n3, n4, (by2 - 1) * 30, 0, 30, 30);
            } else {
                GameDisplay.drawClipImage(graphics, images[5], n3, n4, (Math.abs(by2) - 1) * 30, 30, 30, 30);
            }
            GameDisplay.resetClip(graphics);
        } else {
            GameDisplay.drawImage(graphics, images[7], n3, n4, 20);
        }
    }

    private void drawBalance(Graphics graphics) {
        int n;
        this.fillImageBG(graphics, 2);
        this.drawImageTitle(graphics, 5);
        GameDisplay.drawString(graphics, GameRes.gameText[15], 120, 50, 17, 0xFFFFFF);
        GameDisplay.drawString(graphics, GameRes.gameText[16], 190, 50, 17, 0xFFFFFF);
        for (n = 0; n < this.res.winner_count.length; ++n) {
            GameDisplay.drawString(graphics, GameRes.gameText[this.game.menuTextIdx[n]], 50, 50 + 30 * (n + 1), 17, 0xFFFFFF);
            GameDisplay.drawString(graphics, "" + (this.res.winner_count[n] + this.res.loser_count[n]), 120, 50 + 30 * (n + 1), 17, 0xFFFFFF);
            GameDisplay.drawString(graphics, "" + this.res.winner_count[n], 190, 50 + 30 * (n + 1), 17, 0xFFFFFF);
        }
        GameDisplay.drawString(graphics, GameRes.gameText[26], 50, 200, 17, 0xFFFFFF);
        n = GameDisplay.getStringHeight(graphics.getFont());
        if (this.res.delete_store) {
            GameDisplay.fillRect(graphics, 120, 200, GameDisplay.getStringWidth(GameRes.gameText[27], graphics.getFont()), n, 9363538);
        } else {
            GameDisplay.fillRect(graphics, 190, 200, GameDisplay.getStringWidth(GameRes.gameText[28], graphics.getFont()), n, 9363538);
        }
        GameDisplay.drawString(graphics, GameRes.gameText[27], 120, 200, 20, 0xFFFFFF);
        GameDisplay.drawString(graphics, GameRes.gameText[28], 190, 200, 20, 0xFFFFFF);
        this.drawImgButton(graphics, true, true, false);
    }

    private void drawSetting(Graphics graphics) {
        this.fillImageBG(graphics, 2);
        this.drawImageTitle(graphics, 4);
        int n = 110;
        GameDisplay.drawRoundString(graphics, GameRes.gameText[13], n, 90, 24, 0, 0xFFFFFF);
        switch (this.game.menuIdx) {
            case 5: {
                GameDisplay.fillRect(graphics, 181, 78, 12, 25, 13784064);
            }
            case 4: {
                GameDisplay.fillRect(graphics, 168, 81, 12, 22, 16150016);
            }
            case 3: {
                GameDisplay.fillRect(graphics, 155, 84, 12, 19, 16746762);
            }
            case 2: {
                GameDisplay.fillRect(graphics, 142, 87, 12, 16, 16754504);
            }
            case 1: {
                GameDisplay.fillRect(graphics, 129, 90, 12, 13, 16761472);
            }
        }
        GameDisplay.drawRect(graphics, 181, 78, 12, 25, 1, 1, 0xFFFFFF);
        GameDisplay.drawRect(graphics, 168, 81, 12, 22, 1, 1, 0xFFFFFF);
        GameDisplay.drawRect(graphics, 155, 84, 12, 19, 1, 1, 0xFFFFFF);
        GameDisplay.drawRect(graphics, 142, 87, 12, 16, 1, 1, 0xFFFFFF);
        GameDisplay.drawRect(graphics, 129, 90, 12, 13, 1, 1, 0xFFFFFF);
        this.drawImgButton(graphics, true, true, false);
    }

    public void changeState() {
        switch (this.game.gameState) {
            default: 
        }
        this.loadImage();
        this.isLoading = false;
    }

    public void canvasPaused() {
        if (MGIESoundAdvance.soundBuffer != null) {
            this.res.mgsound.stop();
        }
    }

    public void canvasResumed() {
    }

    public void drawCanvas(Graphics graphics) {
        this.drawCanvasCore(graphics);
    }

    public void loadImage() {
        try {
            int[] nArray = null;
            switch (this.game.gameState) {
                case 1: {
                    nArray = new int[]{21};
                    break;
                }
                case 6: 
                case 13: {
                    nArray = new int[]{13, 5, 7, 29, 1, 0, 12, 15, 16, 17, 27, 9, 8, 22, 6, 14, 19, 20, 2};
                    break;
                }
                case 5: 
                case 14: {
                    nArray = new int[]{19, 20, 2};
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    nArray = new int[]{11, 3, 4, 19, 20};
                    break;
                }
                case 8: 
                case 11: {
                    nArray = new int[]{29, 19, 20, 2};
                    break;
                }
                case 10: {
                    nArray = new int[]{23, 24, 25, 26, 10, 29, 28, 19, 20, 2};
                    break;
                }
                case 7: 
                case 9: {
                    nArray = new int[]{29, 2, 18};
                    break;
                }
                case 12: {
                    nArray = new int[]{2};
                }
            }
            if (nArray != null) {
                GameDisplay.loadImage(nArray);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("loadImage " + this.game.gameState + " Error");
        }
        this.game.stateChangeAction_AfterLoad();
        this.isLoading = false;
    }
}

