/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.paddings;

import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.paddings.BlockCipherPadding;

public final class PKCS7Padding
implements BlockCipherPadding {
    public final void init$18f8099d() {
    }

    public final String getPaddingName() {
        return "PKCS7";
    }

    public final int addPadding(byte[] byArray, int n2) {
        byte by = (byte)(byArray.length - n2);
        while (n2 < byArray.length) {
            byArray[n2] = by;
            ++n2;
        }
        return by;
    }

    public final int padCount(byte[] byArray) {
        int n2 = byArray[byArray.length - 1] & 0xFF;
        if (n2 > byArray.length) {
            throw new InvalidCipherTextException("pad block corrupted");
        }
        int n3 = 1;
        while (n3 <= n2) {
            if (byArray[byArray.length - n3] != n2) {
                throw new InvalidCipherTextException("pad block corrupted");
            }
            ++n3;
        }
        return n2;
    }
}

