/*
 * Decompiled with CFR 0.152.
 */
package com.sk.jclient;

import com.sk.SKML;
import com.sk.jclient.InterpreterOperation;
import com.sk.jclient.JavaScriptInterpreter;
import com.sk.jclient.Main;
import com.sk.jclient.services.IService;
import com.sk.jclient.services.MediaPlayerService;
import com.sk.jclient.ui.Page;
import com.sk.jclient.ui.SKCommand;
import com.sk.jclient.ui.UIListener;
import com.sk.jclient.ui.components.SKAbstractItem;
import com.sk.jclient.util.ResourceMgr;
import com.sk.jclient.util.UpdateManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Stack;
import java.util.TimerTask;
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

public final class ContentServer
implements UIListener,
SKML {
    private static final String PUSH_ENABLING_KEY = "pushEnabled";
    private static final String PUSH_INTERVAL_FILE = "CA/PushInterval.upd";
    private static final String PUSH_INTERVAL_FROM_STORE_KEY = "intervalStore";
    private long pushInterval;
    private static final String BEEN_LAUNCHED_KEY = "launched";
    private static final String EXPIRY_DATES_FILE = "CA/expirydates.upd";
    public static final String UPDATE_FAILURE = "update";
    public static final byte operationRunning = 2;
    public static byte flags;
    public static String busyMsg;
    private Stack pageHistory;
    public static Page currentPage;
    public static final Vector activeServices;
    public Main midlet;
    InterpreterOperation startup;
    public UpdateManager updateManager;
    static final JavaScriptInterpreter interpreter;
    private String currentUrl;
    public static ResourceMgr resource_mgr;
    public static final String BACK_INDICATOR = "b";

    public ContentServer(Main main) {
        resource_mgr = main.resMgr;
        this.midlet = main;
        this.pageHistory = new Stack();
        this.startup = new InterpreterOperation("navigator", "next", new String[]{main.START_FILE});
    }

    final void start() {
        this.updateManager = new UpdateManager(this);
        resource_mgr.incrementCounter((byte)119);
        try {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!this.midlet.handledPushRegistryWakeup(this)) {
                this.doOrangeUpdateCheck();
                return;
            }
            this.dispatch(this.startup);
            return;
        }
        catch (Exception exception) {
            this.handleUserDialog("Unrecoverable error", exception.getMessage(), null, AlertType.ERROR, null, new InterpreterOperation("navigator", "exit", null));
            return;
        }
    }

    public final void dispatch(InterpreterOperation interpreterOperation) {
        try {
            if (interpreterOperation != null) {
                if (interpreterOperation.module.equals("navigator")) {
                    this.navigate(interpreterOperation);
                } else if (interpreterOperation.module.equals("contentServer")) {
                    this.execute(interpreterOperation);
                } else if (interpreterOperation.module.equals("transient")) {
                    if (interpreterOperation.action.equals("java.download")) {
                        String string = (String)interpreterOperation.parameters[0];
                        String string2 = (String)interpreterOperation.parameters[1];
                        InterpreterOperation interpreterOperation2 = new InterpreterOperation("skapploader", "loadData", new Object[]{string, "get", null, null, null});
                        interpreterOperation2.onComplete = new InterpreterOperation("contentServer", "storeData", new String[]{string2});
                        interpreterOperation2.onComplete.onComplete = interpreterOperation.onComplete;
                        if (interpreterOperation.onError != null) {
                            interpreterOperation2.onError = interpreterOperation.onError;
                        } else {
                            interpreterOperation2.onError = new InterpreterOperation("navigator", "alert", new String[]{"Error while downloading...", "Network error", null});
                            interpreterOperation2.onError.onComplete = new InterpreterOperation("navigator", "back", null);
                        }
                        this.dispatch(interpreterOperation2);
                    }
                } else {
                    if (currentPage != null) {
                        interpreterOperation.form = ContentServer.currentPage.display_;
                    }
                    this.registerService(this.midlet.execute(interpreterOperation, this));
                }
            } else {
                this.setBusy(false, null);
            }
        }
        catch (Exception exception) {
            this.handleUserDialog("Unrecoverable error", exception.getMessage(), null, AlertType.ERROR, null, new InterpreterOperation("navigator", "exit", null));
        }
    }

    final Vector getReferences(String string) {
        Enumeration enumeration = activeServices.elements();
        Vector<IService> vector = new Vector<IService>();
        while (enumeration.hasMoreElements()) {
            IService iService = (IService)enumeration.nextElement();
            if (!string.equals(iService)) continue;
            vector.addElement(iService);
        }
        return vector;
    }

    public final synchronized void shutDown() {
        if (resource_mgr != null) {
            resource_mgr.shutdown(true);
        }
        Enumeration enumeration = activeServices.elements();
        while (enumeration.hasMoreElements()) {
            IService iService = (IService)enumeration.nextElement();
            iService.stop();
            activeServices.removeElement(iService);
        }
        if (!this.checkPush() && this.midlet != null) {
            this.midlet.destroyApp(true);
        }
    }

    private final void registerPush(String string) {
        if (string.equals("true")) {
            resource_mgr.writeValue(PUSH_ENABLING_KEY, new byte[]{121});
            InterpreterOperation interpreterOperation = new InterpreterOperation("skapploader", "registerPush", new Object[]{new Long(this.pushInterval)});
            this.dispatch(interpreterOperation);
        } else {
            resource_mgr.writeValue(PUSH_ENABLING_KEY, new byte[]{110});
            this.midlet.destroyApp(true);
        }
    }

    private final void scheduleOperation(final InterpreterOperation interpreterOperation) {
        long l = 60000L;
        try {
            l = Long.parseLong((String)interpreterOperation.parameters[0]);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        Main.appTimer.schedule(new TimerTask(){

            public void run() {
                ContentServer.this.dispatch(interpreterOperation.onComplete);
            }
        }, l);
    }

    private final void execute(InterpreterOperation interpreterOperation) {
        if (interpreterOperation.action.equals("timer")) {
            this.scheduleOperation(interpreterOperation);
        } else if (interpreterOperation.action.equals("registerPush")) {
            this.registerPush((String)interpreterOperation.parameters[0]);
        } else if (interpreterOperation.action.equals("httpPullDownload")) {
            String string = (String)interpreterOperation.parameters[0];
            InterpreterOperation interpreterOperation2 = UpdateManager.getDownloadContentOperation(new String[]{string});
            this.dispatch(interpreterOperation2);
        } else if (interpreterOperation.action.equals("doUpdate")) {
            this.updateManager.doUpdate(interpreterOperation);
        } else if (interpreterOperation.action.equals("storeData")) {
            String string = (String)interpreterOperation.parameters[0];
            InputStream inputStream = (InputStream)interpreterOperation.parameters[1];
            int n = (Integer)interpreterOperation.parameters[2];
            resource_mgr.writeValueToFS(string, inputStream, n);
            this.dispatch(interpreterOperation.onComplete);
        } else if (interpreterOperation.action.equals("refresh")) {
            String string = (String)interpreterOperation.parameters[0];
            resource_mgr.notifyConsumers(string, interpreterOperation.dataContent);
        } else if (interpreterOperation.action.equals("refreshPage")) {
            InterpreterOperation interpreterOperation3 = new InterpreterOperation("navigator", "next", new Object[]{this.currentUrl});
            this.dispatch(interpreterOperation3);
        }
    }

    private final void navigate(InterpreterOperation interpreterOperation) {
        Object object;
        if (!activeServices.isEmpty()) {
            for (int i = 0; i < activeServices.size(); ++i) {
                object = (IService)activeServices.elementAt(i);
                if (!(object instanceof MediaPlayerService)) continue;
                object.stop();
            }
        }
        if (interpreterOperation.action.equals("next")) {
            ResourceMgr.reset(false);
            if (interpreterOperation.parameters.length != 3 || interpreterOperation.parameters[2] != BACK_INDICATOR) {
                String[] stringArray = new String[2];
                stringArray[0] = this.currentUrl;
                if (currentPage != null) {
                    try {
                        stringArray[1] = ContentServer.currentPage.display_.getFocussedComponent().id;
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
                this.pageHistory.push(stringArray);
                if (this.pageHistory.size() > 20) {
                    this.pageHistory.removeElement(this.pageHistory.firstElement());
                }
            }
            byte[] byArray = null;
            this.currentUrl = (String)interpreterOperation.parameters[0];
            if (ResourceMgr.getProtocolFromUrl(this.currentUrl).equals("")) {
                this.currentUrl = ResourceMgr.completeURL(this.currentUrl);
            }
            try {
                byArray = resource_mgr.getSkml(this.currentUrl);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                byArray = this.updateManager.handleHttpPull(interpreterOperation, this.currentUrl);
                if (byArray == null) {
                    return;
                }
            }
            catch (IOException iOException) {
                this.handleUserDialog("Unrecoverable error", iOException.getMessage(), null, AlertType.ERROR, null, new InterpreterOperation("navigator", "exit", null));
                return;
            }
            byArray = ContentServer.doInclude(byArray);
            object = null;
            if (byArray != null) {
                this.setBusy(true, null);
                object = Page.realise(byArray, this);
                if (interpreterOperation != null && interpreterOperation.parameters.length > 1) {
                    ((Page)object).display_.setFocusByName((String)interpreterOperation.parameters[1]);
                }
            } else {
                this.dispatch(new InterpreterOperation("navigator", "next", new String[]{this.midlet.START_FILE}));
                return;
            }
            this.setBusy(false, null);
            currentPage = object;
            this.setBusy(false, null);
        } else {
            SKAbstractItem sKAbstractItem;
            if (interpreterOperation.action.equals("alert")) {
                String string = null;
                object = null;
                String string2 = null;
                try {
                    object = (String)interpreterOperation.parameters[0];
                    string = (String)interpreterOperation.parameters[1];
                    string2 = (String)interpreterOperation.parameters[2];
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
                this.handleUserDialog(string, (String)object, null, AlertType.INFO, string2, interpreterOperation.onComplete);
                return;
            }
            if ("back".equals(interpreterOperation.action)) {
                String[] stringArray = (String[])this.pageHistory.pop();
                this.dispatch(new InterpreterOperation("navigator", "next", new String[]{stringArray[0], stringArray[1], BACK_INDICATOR}));
                return;
            }
            if ("exit".equals(interpreterOperation.action)) {
                this.shutDown();
                return;
            }
            if ("executeFocused".equals(interpreterOperation.action) && (sKAbstractItem = ContentServer.currentPage.display_.getFocussedComponent()) != null && sKAbstractItem.onClick != null) {
                object = JavaScriptInterpreter.interprete(sKAbstractItem.onClick, currentPage);
                this.dispatch((InterpreterOperation)object);
                return;
            }
        }
        this.show();
        this.resetServices();
        this.execSKCommand(ContentServer.currentPage.cmds_);
    }

    private final void resetServices() {
        Vector vector = this.getReferences("skmultimedia");
        if (vector.size() > 0) {
            IService iService = (IService)vector.lastElement();
            iService.stop();
        }
        this.updateManager.cancelUpdate = true;
    }

    public final void execSKCommand(SKCommand[] sKCommandArray) {
        block5: {
            try {
                if (sKCommandArray == null) break block5;
                for (int i = 0; i < sKCommandArray.length; ++i) {
                    final InterpreterOperation interpreterOperation = JavaScriptInterpreter.interprete(sKCommandArray[i], currentPage);
                    if (interpreterOperation == null) continue;
                    try {
                        interpreterOperation.gauge = ContentServer.currentPage.gauge_;
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    new Thread(){

                        public void run() {
                            ContentServer.this.dispatch(interpreterOperation);
                        }
                    }.start();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private final boolean checkPush() {
        this.pushInterval = this.getPushInterval();
        if (this.pushInterval > 0L) {
            byte[] byArray = null;
            try {
                byArray = resource_mgr.getData(PUSH_ENABLING_KEY);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (byArray == null || byArray[0] == 121) {
                InterpreterOperation interpreterOperation = new InterpreterOperation("navigator", "next", new String[]{this.midlet.PUSH_REGISTER_FILE});
                this.dispatch(interpreterOperation);
                return true;
            }
        }
        return false;
    }

    private final long getPushInterval() {
        long l;
        try {
            String string = new String(resource_mgr.getData(PUSH_INTERVAL_FILE));
            l = Long.parseLong(string.substring(string.indexOf("PushInterval:") + "PushInterval".length() + 2).trim());
            byte[] byArray = null;
            try {
                byArray = resource_mgr.getData(PUSH_INTERVAL_FROM_STORE_KEY);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (byArray == null) {
                resource_mgr.writeValue(PUSH_INTERVAL_FROM_STORE_KEY, new byte[]{121});
                resource_mgr.writeValue(PUSH_ENABLING_KEY, new byte[]{121});
            }
        }
        catch (Exception exception) {
            l = Long.parseLong(this.midlet.PUSH_INTERVAL);
        }
        return l;
    }

    final void show() {
        if (currentPage != null) {
            Display display = Display.getDisplay((MIDlet)this.midlet);
            display.setCurrent((Displayable)ContentServer.currentPage.display_);
        }
    }

    public final synchronized void setBusy(boolean bl, String string) {
        if (bl) {
            flags = (byte)(flags | 2);
            busyMsg = string;
            return;
        }
        flags = (byte)(flags & 0xFFFFFFFD);
        busyMsg = null;
        if (currentPage != null) {
            ContentServer.currentPage.display_.renderflags = (byte)(ContentServer.currentPage.display_.renderflags | 0x1A);
        }
    }

    public static final byte[] doInclude(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = new String(byArray);
        int n = 0;
        int n2 = -1;
        int n3 = 0;
        byte[] byArray2 = null;
        while (true) {
            n3 = string.indexOf("#+", n2 + 1);
            n2 = string.indexOf("#", n3 + 1);
            if (n3 == -1 || n2 == -1 || n2 - n3 == 1) break;
            String string2 = string.substring(n3 + 2, n2);
            try {
                byArray2 = resource_mgr.getData(string2);
            }
            catch (NullPointerException nullPointerException) {
                byArray2 = null;
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            stringBuffer.append(string.substring(n, n3));
            if (byArray2 != null) {
                stringBuffer.append(new String(byArray2));
            }
            n = n2 + 1;
        }
        if (n == 0) {
            return byArray;
        }
        stringBuffer.append(string.substring(n, string.length()));
        return stringBuffer.toString().getBytes();
    }

    public final void onItemEvent(SKAbstractItem sKAbstractItem, byte by, Object object) {
        switch (by) {
            case 118: {
                InterpreterOperation interpreterOperation = JavaScriptInterpreter.interprete((SKCommand)((Object)object), currentPage);
                this.dispatch(interpreterOperation);
            }
        }
    }

    public final void completedOK(InterpreterOperation interpreterOperation) {
        this.dispatch(interpreterOperation);
    }

    public final void completedWithError(InterpreterOperation interpreterOperation) {
        this.dispatch(interpreterOperation);
    }

    private final synchronized void registerService(IService iService) {
        if (iService == null) {
            return;
        }
        activeServices.addElement(iService);
        activeServices.trimToSize();
    }

    public final synchronized void deregisterService(IService iService) {
        activeServices.removeElement(iService);
    }

    public final synchronized void handleUserDialog(String string, String string2, Image image, AlertType alertType, final String string3, final InterpreterOperation interpreterOperation) {
        Alert alert = new Alert(string, string2, image, alertType);
        alert.setTimeout(-2);
        alert.addCommand(Alert.DISMISS_COMMAND);
        alert.setCommandListener(new CommandListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void commandAction(Command command, Displayable displayable) {
                if (command == Alert.DISMISS_COMMAND) {
                    Object object = this;
                    synchronized (object) {
                        this.notifyAll();
                    }
                    if (string3 != null) {
                        object = JavaScriptInterpreter.getOperation(string3, currentPage);
                        ContentServer.this.dispatch((InterpreterOperation)object);
                    } else {
                        ContentServer.this.dispatch(interpreterOperation);
                    }
                    if (displayable == null) {
                        ContentServer.this.shutDown();
                    }
                }
            }
        });
        Display display = Display.getDisplay((MIDlet)this.midlet);
        display.setCurrent((Displayable)alert);
    }

    private void doOrangeUpdateCheck() {
        Object object;
        Object object2;
        byte[] byArray;
        try {
            byArray = resource_mgr.getData(UPDATE_FAILURE);
            if (byArray != null && byArray[0] == 121) {
                InterpreterOperation interpreterOperation = new InterpreterOperation("navigator", "next", new String[]{"rs:///CA/content.xml"});
                this.dispatch(interpreterOperation);
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        byArray = null;
        try {
            byArray = resource_mgr.getData(EXPIRY_DATES_FILE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (byArray != null) {
                String string = new String(byArray);
                object2 = string.substring(0, string.indexOf("catalog:"));
                object = string.substring(string.indexOf("catalog:"));
                Calendar calendar = Calendar.getInstance();
                if (object2 != null && object != null) {
                    String string2 = ((String)object2).substring("content:".length());
                    Calendar calendar2 = Calendar.getInstance();
                    calendar2.set(1, Integer.valueOf(string2.substring(4, 8)));
                    calendar2.set(2, Integer.valueOf(string2.substring(2, 4)) - 1);
                    calendar2.set(5, Integer.valueOf(string2.substring(0, 2)));
                    calendar2.set(10, Integer.valueOf(string2.substring(8, 10)));
                    calendar2.set(12, Integer.valueOf(string2.substring(10, 12)));
                    if (calendar.after(calendar2)) {
                        InterpreterOperation interpreterOperation = new InterpreterOperation("navigator", "next", new String[]{"rs:///CA/content.xml"});
                        this.dispatch(interpreterOperation);
                        return;
                    }
                    string2 = ((String)object).substring("catalog:".length());
                    calendar2 = Calendar.getInstance();
                    calendar2.set(1, Integer.valueOf(string2.substring(4, 8)));
                    calendar2.set(2, Integer.valueOf(string2.substring(2, 4)) - 1);
                    calendar2.set(5, Integer.valueOf(string2.substring(0, 2)));
                    calendar2.set(10, Integer.valueOf(string2.substring(8, 10)));
                    calendar2.set(12, Integer.valueOf(string2.substring(10, 12)));
                    if (calendar.after(calendar2)) {
                        InterpreterOperation interpreterOperation = new InterpreterOperation("navigator", "next", new String[]{"rs:///CA/catalog.xml"});
                        this.dispatch(interpreterOperation);
                        return;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        object2 = null;
        try {
            try {
                object2 = resource_mgr.getData(BEEN_LAUNCHED_KEY);
            }
            catch (Exception exception) {
                resource_mgr.writeValue(BEEN_LAUNCHED_KEY, new byte[]{121});
            }
            if (object2 != null && object2[0] == 121 && byArray == null) {
                object = new InterpreterOperation("navigator", "next", new String[]{this.midlet.HTTP_PULL_FILE});
                this.dispatch((InterpreterOperation)object);
            } else {
                if (object2 == null) {
                    resource_mgr.writeValue(BEEN_LAUNCHED_KEY, new byte[]{121});
                }
                object = new InterpreterOperation("navigator", "next", new String[]{this.midlet.START_FILE});
                this.dispatch((InterpreterOperation)object);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void repaintBG(Graphics graphics) {
        ContentServer.currentPage.display_.repaintBG(graphics);
    }

    public final void performFullReset() {
    }

    static {
        activeServices = new Vector();
        interpreter = new JavaScriptInterpreter();
    }
}

