/*
 * Decompiled with CFR 0.152.
 */
package com.sk.jclient.services;

import com.sk.SKML;
import com.sk.jclient.ContentServer;
import com.sk.jclient.InterpreterOperation;
import com.sk.jclient.services.IService;
import com.sk.jclient.util.ResourceMgr;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VideoControl;
import javax.microedition.media.control.VolumeControl;

public class MediaPlayerService
implements IService,
SKML {
    public static final String name = "skmultimedia";
    private Player player;
    private VideoControl video_;
    private boolean fullscreen;
    private int w;
    private int h;
    private int x;
    private int y;
    private static boolean playVideo;
    private static boolean abortPlayback;
    private ContentServer contentServer;
    private InterpreterOperation operation;
    private MediaPlayerService instance;
    public PlayerListener listener = new PlayerListener(){

        public void playerUpdate(Player player, String string, Object object) {
            if (string.equals("endOfMedia") || string.equals("stopped") || string.equals("stoppedAtTime")) {
                MediaPlayerService.this.closeService();
                if (((MediaPlayerService)MediaPlayerService.this).operation.onComplete != null) {
                    MediaPlayerService.this.contentServer.completedOK(((MediaPlayerService)MediaPlayerService.this).operation.onComplete);
                }
            } else if (string.equals("started")) {
                MediaPlayerService.this.contentServer.setBusy(false, null);
            } else if (string.equals("stopped")) {
                MediaPlayerService.this.closeService();
            } else if (string.equals("closed")) {
                MediaPlayerService.this.closeService();
            }
        }
    };

    public MediaPlayerService() {
        this.instance = this;
    }

    public final void invoke(final InterpreterOperation interpreterOperation, ContentServer contentServer) {
        this.contentServer = contentServer;
        this.operation = interpreterOperation;
        abortPlayback = false;
        if (interpreterOperation.action.equals("play")) {
            new Thread(){

                public void run() {
                    String string = (String)interpreterOperation.parameters[0];
                    String string2 = null;
                    try {
                        string2 = (String)interpreterOperation.parameters[2];
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        // empty catch block
                    }
                    int n = 1;
                    try {
                        n = Integer.parseInt((String)interpreterOperation.parameters[1]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        MediaPlayerService.this.contentServer.setBusy(true, "Loading audio");
                        MediaPlayerService.this.instance.player = MediaPlayerService.initPlayer(string, string2, MediaPlayerService.this.listener);
                        MediaPlayerService.this.contentServer.setBusy(false, null);
                        MediaPlayerService.this.startPlayback(MediaPlayerService.this.player, n);
                    }
                    catch (MediaException mediaException) {
                        MediaPlayerService.this.closeService();
                        MediaPlayerService.this.contentServer.completedWithError(interpreterOperation.onError);
                    }
                }
            }.start();
        } else if (interpreterOperation.action.equals("playVideo")) {
            new Thread(){

                public void run() {
                    String string = (String)interpreterOperation.parameters[0];
                    String string2 = null;
                    int n = 1;
                    try {
                        MediaPlayerService.this.x = Integer.parseInt((String)interpreterOperation.parameters[1]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    try {
                        MediaPlayerService.this.y = Integer.parseInt((String)interpreterOperation.parameters[2]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    try {
                        MediaPlayerService.this.w = Integer.parseInt((String)interpreterOperation.parameters[3]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    try {
                        MediaPlayerService.this.h = Integer.parseInt((String)interpreterOperation.parameters[4]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    try {
                        n = Integer.parseInt((String)interpreterOperation.parameters[5]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    try {
                        string2 = (String)interpreterOperation.parameters[6];
                        MediaPlayerService.this.contentServer.setBusy(true, "Loading video");
                        playVideo = true;
                        MediaPlayerService.this.instance.player = MediaPlayerService.initPlayer(string, string2, MediaPlayerService.this.listener);
                        MediaPlayerService.this.contentServer.setBusy(false, null);
                        MediaPlayerService.this.startPlayback(MediaPlayerService.this.player, n);
                    }
                    catch (MediaException mediaException) {
                        MediaPlayerService.this.closeService();
                        MediaPlayerService.this.contentServer.completedWithError(interpreterOperation.onError);
                    }
                }
            }.start();
        } else if (interpreterOperation.action.equals("toggleFullScreen") && this.video_ != null) {
            try {
                if (!this.fullscreen) {
                    this.video_.setDisplayFullScreen(true);
                    this.fullscreen = true;
                } else {
                    this.video_.setDisplayFullScreen(false);
                    this.fullscreen = false;
                }
            }
            catch (MediaException mediaException) {
                // empty catch block
            }
        }
        if (interpreterOperation.action.equals("volUp") || interpreterOperation.action.equals("volDown")) {
            if (this.player == null) {
                return;
            }
            VolumeControl volumeControl = (VolumeControl)this.player.getControl("VolumeControl");
            if (interpreterOperation.action.equals("volUp")) {
                if (volumeControl != null && volumeControl.getLevel() < 100) {
                    volumeControl.setLevel((volumeControl.getLevel() + 10) % 100);
                }
            } else if (interpreterOperation.action.equals("volDown") && volumeControl != null && volumeControl.getLevel() > 10) {
                volumeControl.setLevel(volumeControl.getLevel() - 10);
            }
            volumeControl = null;
        } else if (interpreterOperation.action.equals("togglePlayback")) {
            if (this.player == null) {
                return;
            }
            try {
                this.player.stop();
            }
            catch (Exception exception) {
                try {
                    this.player.start();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
    }

    public final void stop() {
        this.closeService();
        abortPlayback = true;
    }

    private final Player startPlayback(Player player, int n) throws MediaException {
        if (abortPlayback) {
            throw new MediaException("playback cancelled");
        }
        player.realize();
        player.prefetch();
        try {
            player.setLoopCount(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (playVideo) {
            this.operation.form.renderflags = (byte)(this.operation.form.renderflags | 1);
            this.video_ = (VideoControl)player.getControl("VideoControl");
            if (this.video_ != null) {
                this.video_.initDisplayMode(1, (Object)this.operation.form);
                if (this.x != 1 && this.y != -1) {
                    this.video_.setDisplayLocation(this.x, this.y);
                }
                if (this.w != 1 && this.h != -1) {
                    this.video_.setDisplaySize(this.w, this.h);
                } else {
                    this.video_.setDisplayFullScreen(true);
                    this.fullscreen = true;
                }
                this.video_.setVisible(true);
            }
        }
        player.start();
        return player;
    }

    private static final Player initPlayer(String string, String string2, PlayerListener playerListener) throws MediaException {
        Player player = null;
        String string3 = ResourceMgr.getProtocolFromUrl(string);
        String string4 = ResourceMgr.getContentFromUrl(string);
        String string5 = null;
        string5 = string2 != null && string2.trim().length() != 0 ? string2 : MediaPlayerService.guessContentType(string);
        try {
            if (string5.startsWith("video")) {
                playVideo = true;
            }
            if (string3.equals("http") || string3.equals("https")) {
                player = Manager.createPlayer((String)string);
            } else if (string3.equals("file")) {
                player = Manager.createPlayer((InputStream)string4.getClass().getResourceAsStream("/" + string4), (String)string5);
            } else {
                byte[] byArray = ContentServer.resource_mgr.getData(string);
                player = Manager.createPlayer((InputStream)new ByteArrayInputStream(byArray), (String)string5);
            }
        }
        catch (IOException iOException) {
            throw new MediaException("Unable to initplayer " + iOException.getMessage());
        }
        player.addPlayerListener(playerListener);
        return player;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void closeService() {
        try {
            if (this.video_ != null) {
                this.video_.setVisible(false);
                this.video_ = null;
            }
            if (this.instance.player != null) {
                this.instance.player.removePlayerListener(this.listener);
                this.instance.player.close();
                this.instance.player = null;
            }
            this.listener = null;
        }
        catch (Exception exception) {
        }
        finally {
            System.gc();
        }
        this.contentServer.setBusy(false, null);
        if (playVideo) {
            this.operation.form.renderflags = (byte)(this.operation.form.renderflags & 0xFFFFFFFE);
            this.operation.form.renderflags = (byte)(this.operation.form.renderflags | 0x1A);
        }
        this.contentServer.deregisterService(this);
    }

    private static final String guessContentType(String string) {
        if (string.endsWith(".mid") || string.endsWith(".midi")) {
            return "audio/midi";
        }
        if (string.endsWith(".mp3")) {
            return "audio/mpeg";
        }
        if (string.endsWith(".wav")) {
            return "audio/x-wav";
        }
        if (string.endsWith(".3gp")) {
            return "video/3gpp";
        }
        if (string.endsWith(".mpg") || string.endsWith(".mpeg")) {
            return "video/mpeg";
        }
        return "";
    }
}

