/*
 * Decompiled with CFR 0.152.
 */
package com.sk.jclient.ui.components;

import com.sk.jclient.ContentServer;
import com.sk.jclient.ui.Page;
import com.sk.jclient.ui.SKCommand;
import com.sk.jclient.ui.UIListener;
import com.sk.jclient.ui.components.ItemGroup;
import com.sk.jclient.ui.components.SKAbstractItem;
import com.sk.jclient.ui.components.SKItemInterface;
import com.sk.jclient.util.ResourceConsumer;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class Container
extends SKAbstractItem
implements UIListener,
ResourceConsumer,
ItemGroup {
    private int scrollSpeed;
    private static final int mask_ScrollUp = 2496;
    private static final int mask_ScrollDn = 1216;
    private String bgImageSrc;
    private String selBgImageSrc;
    public int spacing;
    private Vector components;
    private int itemsHeight;
    private int itemCount;
    private Image bgImage;
    private Image selbgImage;
    private SKAbstractItem focusItem;
    private int scrollOffset;
    private long lastTap;
    private long time;
    private static final byte ARROW_HEIGHT = 4;
    private static final byte ARROW_WIDTH = 5;
    private static final byte BAR_WIDTH = 5;
    private boolean lockScroll = false;
    int selFgColor_ = 255;
    public int scrollbarColor_ = 0;
    public int locationBarColor_ = 0;
    private Object bgImageLock = new Object();
    private Object selbgImageLock = new Object();

    public Container(String string, int n, int n2, int n3, int n4) {
        super(string, n, n2, -1, -1, null, Page.def_Font);
        this.components = new Vector();
        this.flags = 6;
        this.setSize(n4, n3);
        this.scrollSpeed = 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setBackground(String string, String string2) {
        if (string != null) {
            Image image;
            this.bgImageSrc = string;
            this.selBgImageSrc = string2;
            Object object = this.bgImageLock;
            synchronized (object) {
                image = ContentServer.resource_mgr.getImage(string, this);
                if (this.bgImage == null) {
                    this.bgImage = image;
                }
            }
            if (string2 != null) {
                object = this.selbgImageLock;
                synchronized (object) {
                    image = ContentServer.resource_mgr.getImage(string2, this);
                    if (this.selbgImage == null) {
                        this.selbgImage = image;
                    }
                }
            }
            this.flags |= 0x4000;
        }
    }

    public void setLockScroll(boolean bl) {
        this.lockScroll = bl;
        if (this.lockScroll) {
            this.flags |= 0x80;
            this.flags |= 0x10000;
        }
    }

    final void start() {
        for (int i = 0; i < this.itemCount; ++i) {
            SKAbstractItem sKAbstractItem = (SKAbstractItem)this.components.elementAt(i);
            if (this.focusItem == null && (sKAbstractItem.flags & 2) != 0) {
                this.focusItem = sKAbstractItem;
            }
            sKAbstractItem.start();
        }
    }

    final void stop() {
        for (int i = 0; i < this.itemCount; ++i) {
            SKAbstractItem sKAbstractItem = (SKAbstractItem)this.components.elementAt(i);
            sKAbstractItem.stop();
        }
    }

    public final void appendItem(SKAbstractItem sKAbstractItem) {
        sKAbstractItem.setUIListener(this);
        if ((sKAbstractItem.flags & 2) != 0 && (this.flags & 0x1000) != 0) {
            sKAbstractItem.flags |= 0x1000;
        }
        this.components.addElement(sKAbstractItem);
        this.setFirstFocussable();
        this.itemCount = this.components.size();
        this.onItemEvent(this, (byte)119, null);
        this.components.trimToSize();
    }

    public SKAbstractItem getFocussedComponent() {
        if (this.focusItem == null) {
            return this;
        }
        if (this.focusItem instanceof ItemGroup) {
            return ((ItemGroup)((Object)this.focusItem)).getFocussedComponent();
        }
        return this.focusItem;
    }

    public final SKAbstractItem getItemByName(String string) {
        for (int i = 0; i < this.itemCount; ++i) {
            SKAbstractItem sKAbstractItem;
            SKAbstractItem sKAbstractItem2 = (SKAbstractItem)this.components.elementAt(i);
            if (sKAbstractItem2.id.equals(string)) {
                return sKAbstractItem2;
            }
            if (!(sKAbstractItem2 instanceof ItemGroup) || (sKAbstractItem = ((ItemGroup)((Object)sKAbstractItem2)).getItemByName(string)) == null) continue;
            return sKAbstractItem;
        }
        return null;
    }

    public final boolean setFocusByName(String string) {
        SKAbstractItem sKAbstractItem = this.getItemByName(string);
        if (sKAbstractItem != null) {
            if (this.focusItem != null) {
                this.focusItem.setValue("focus", "false");
            }
            sKAbstractItem.setFocus(true, SKAbstractItem.DOWN);
            return true;
        }
        return false;
    }

    public final void removeItem(SKAbstractItem sKAbstractItem) {
        this.components.removeElement(sKAbstractItem);
        this.components.trimToSize();
        this.onItemEvent(this, (byte)119, null);
    }

    public final void clear() {
        this.components.removeAllElements();
        this.itemCount = this.components.size();
        this.components.trimToSize();
        this.onItemEvent(this, (byte)119, null);
    }

    public final void setFocus(boolean bl, Byte by) {
        super.setFocus(bl, by);
        if (this.focusItem == null) {
            if (by == SKAbstractItem.UP) {
                this.setFirstFocussable();
            } else {
                this.setLastFocussable();
            }
        } else {
            this.focusItem.setFocus(true, SKAbstractItem.DOWN);
        }
    }

    public final synchronized void onItemEvent(SKAbstractItem sKAbstractItem, byte by, Object object) {
        switch (by) {
            case 119: {
                this.itemsHeight = 0;
                for (int i = 0; i < this.itemCount; ++i) {
                    SKAbstractItem sKAbstractItem2 = (SKAbstractItem)this.components.elementAt(i);
                    int n = sKAbstractItem2.y_ + sKAbstractItem2.height;
                    sKAbstractItem2.flags |= 1;
                    this.itemsHeight = n > this.itemsHeight ? n : this.itemsHeight;
                }
                this.setBounds();
                break;
            }
            case 4: {
                if ((Byte)object == SKAbstractItem.DOWN) {
                    this.focusDown();
                    break;
                }
                this.focusUp();
                break;
            }
            case 3: {
                this.flags |= 8;
                this.focusItem = sKAbstractItem;
                this.notifyListener(by, object);
                break;
            }
            case 2: 
            case 118: {
                this.notifyListener(by, object);
                return;
            }
        }
        this.notifyListener((byte)121, null);
    }

    final void keyPressed(int n) {
        try {
            switch (n) {
                case -1: 
                case 50: {
                    if (this.onClick != null) {
                        if ((this.flags & 0x80) != 0) {
                            this.flags |= 0x140;
                            return;
                        }
                    } else if ((this.flags & 0x800) != 0) {
                        this.flags |= 0x1C0;
                        return;
                    }
                    if (this.focusItem != null && (this.flags & 0x2000) == 0) {
                        this.focusItem.setFocus(false, SKAbstractItem.UP);
                        break;
                    }
                    this.setFocus(false, SKAbstractItem.UP);
                    break;
                }
                case -2: 
                case 56: {
                    if (this.onClick != null) {
                        if ((this.flags & 0x80) != 0) {
                            this.flags &= 0xFFFFFEFF;
                            this.flags |= 0x40;
                            return;
                        }
                    } else if ((this.flags & 0x400) != 0) {
                        this.flags &= 0xFFFFFEFF;
                        this.flags |= 0xC0;
                        return;
                    }
                    if (this.focusItem != null && (this.flags & 0x2000) == 0) {
                        this.focusItem.setFocus(false, SKAbstractItem.DOWN);
                        break;
                    }
                    this.setFocus(false, SKAbstractItem.DOWN);
                    break;
                }
                case -3: 
                case 52: {
                    if ((this.flags & 0x2000) != 0 && this.focusItem != null) {
                        this.focusItem.setFocus(false, SKAbstractItem.UP);
                    }
                    break;
                }
                case -4: 
                case 54: {
                    if ((this.flags & 0x2000) != 0 && this.focusItem != null) {
                        this.focusItem.setFocus(false, SKAbstractItem.DOWN);
                    }
                    break;
                }
                case -5: 
                case 53: {
                    if ((this.flags & 0xC00) != 0) {
                        if (this.lockScroll) {
                            return;
                        }
                        if (this.time - this.lastTap < 400L) {
                            if (this.onClick != null) {
                                this.notifyListener((byte)118, (Object)this.onClick);
                            } else if (this.focusItem != null) {
                                this.focusItem.keyPressed(n);
                            }
                            return;
                        }
                        this.lastTap = this.time;
                        this.flags = (this.flags & 0x80) != 0 ? (this.flags &= 0xFFFFFF7F) : (this.flags |= 0x80);
                        if ((this.flags & 0x80) == 0) {
                            this.keyReleased(n);
                        }
                        return;
                    }
                    if (this.onClick != null) {
                        this.notifyListener((byte)118, (Object)this.onClick);
                        break;
                    }
                    if (this.focusItem != null) {
                        this.focusItem.keyPressed(n);
                    }
                    break;
                }
                default: {
                    if (this.focusItem != null) {
                        this.focusItem.keyPressed(n);
                    }
                    break;
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    final void keyRepeated(int n) {
        if (this.focusItem != null) {
            this.focusItem.keyRepeated(n);
        }
    }

    final void keyReleased(int n) {
        this.flags &= 0xFFFFFFBF;
        if (this.focusItem != null) {
            this.focusItem.keyReleased(n);
        }
    }

    protected final void draw(Graphics graphics, int n) {
        SKAbstractItem sKAbstractItem;
        block17: {
            int n2 = this.y_ + n;
            if ((this.flags & 0x4000) != 0) {
                try {
                    if ((this.flags & 0x8000) != 0) {
                        graphics.drawImage(this.bgImage, 0, 0, 20);
                        break block17;
                    }
                    if ((this.flags & 0x4008) == 16392 && this.selbgImage != null) {
                        graphics.drawImage(this.selbgImage, this.x_, n2, 20);
                        break block17;
                    }
                    graphics.drawImage(this.bgImage, this.x_, n2, 20);
                }
                catch (NullPointerException nullPointerException) {}
            } else if (this.bgcolor_ != -1) {
                graphics.setColor(this.bgcolor_);
                graphics.fillRect(this.x_, n2, this.width, this.height);
            }
        }
        graphics.translate(this.x_, this.y_ + n);
        for (int i = 0; i < this.itemCount; ++i) {
            sKAbstractItem = (SKAbstractItem)this.components.elementAt(i);
            sKAbstractItem.flags |= 1;
            sKAbstractItem.paint(graphics, -this.scrollOffset);
        }
        if ((this.flags & 0x800000) != 0) {
            SKAbstractItem sKAbstractItem2 = (SKAbstractItem)this.components.lastElement();
            sKAbstractItem = (SKAbstractItem)this.components.elementAt(0);
            sKAbstractItem.flags |= 1;
            sKAbstractItem.paint(graphics, sKAbstractItem2.y_ + sKAbstractItem2.height - this.scrollOffset);
        }
        graphics.translate(-graphics.getTranslateX(), -graphics.getTranslateY());
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        if ((this.flags & 0x10000) != 0 && this.itemsHeight > this.height) {
            graphics.setColor(this.bgcolor_);
            int n8 = this.x_ + this.width - 6 + 2;
            int n9 = n8 - 2;
            int n10 = this.y_ + n + 4 + 2;
            int n11 = this.height - 4 - 8;
            graphics.fillRect(n9, n10, 5, n11);
            graphics.setColor(this.fgcolor_);
            graphics.drawRect(n9 - 1, n10, 6, n11);
            graphics.setColor(this.scrollbarColor_);
            int n12 = graphics.getClipX();
            int n13 = graphics.getClipY();
            int n14 = graphics.getClipWidth();
            int n15 = graphics.getClipHeight();
            graphics.setClip(n9, n10 + 1, 5, n11 - 2);
            try {
                n3 = this.height - 9 - 8;
                n4 = this.y_ + 4 + 4;
                n5 = (this.flags & 0x800000) != 0 ? this.itemsHeight : this.itemsHeight - this.height;
                n7 = (this.flags & 0xC00) == 0 ? n11 - 4 : this.height * n3 / (this.itemsHeight + 20);
                n6 = this.scrollOffset * (n3 - n7) / n5;
            }
            catch (ArithmeticException arithmeticException) {
                n6 = this.scrollOffset * (n3 - n7) / 1;
            }
            graphics.setColor(this.locationBarColor_);
            int n16 = 3;
            graphics.fillRect(n8 - Math.max(n16 / 2, 1), n4 + n6 + n, n16, n7);
            graphics.setClip(n12, n13, n14, n15);
            graphics.setColor(this.scrollbarColor_);
            if ((this.flags & 8) != 0 && this.scrollbarColor_ != 1) {
                int n17;
                if ((this.flags & 0x800) != 0) {
                    for (n17 = 0; n17 < 5; ++n17) {
                        graphics.drawLine(this.x_ + this.width - 6 + n17, this.y_ + n + 4, this.x_ + this.width - 6 + 2, this.y_ + n);
                    }
                }
                if ((this.flags & 0x400) != 0) {
                    for (n17 = 0; n17 < 5; ++n17) {
                        graphics.drawLine(this.x_ + this.width - 6 + n17, this.y_ + n + this.height - 4, this.x_ + this.width - 6 + 2, this.y_ + this.height + n);
                    }
                }
            }
        }
    }

    protected final synchronized void tick(long l) {
        this.time = l;
        boolean bl = false;
        this.flags = this.scrollOffset > 0 ? (this.flags |= 0x800) : (this.flags &= 0xFFFFF7FF);
        if ((this.flags & 0x1C0) == 448 && (this.flags & 0x800) == 0) {
            this.flags |= 1;
            return;
        }
        if (this.scrollOffset < this.itemsHeight - this.height) {
            this.flags |= 0x400;
            bl = true;
        } else if ((this.flags & 0x400) != 0) {
            this.flags &= 0xFFFFFBFF;
            bl = true;
        }
        if ((this.flags & 0x9C0) == 2496) {
            if (this.scrollOffset > 0) {
                this.scrollOffset = this.scrollOffset < this.scrollSpeed ? 0 : (this.scrollOffset -= this.scrollSpeed);
            } else {
                this.setFocus(false, SKAbstractItem.UP);
                this.scrollOffset = this.itemsHeight;
            }
            bl = true;
        } else if ((this.flags & 0x4C0) == 1216) {
            if (this.scrollOffset < this.itemsHeight - this.height) {
                this.scrollOffset += this.scrollSpeed;
            } else {
                this.flags &= 0xFFFFFB7F;
            }
            bl = true;
        }
        for (int i = 0; i < this.itemCount; ++i) {
            ((SKAbstractItem)this.components.elementAt(i)).tick(l);
        }
        if (bl) {
            this.notifyListener((byte)121, this);
        }
    }

    private final void focusUp() {
        try {
            SKAbstractItem sKAbstractItem;
            if (this.focusItem == null) {
                throw new NullPointerException();
            }
            int n = this.components.indexOf(this.focusItem);
            while (n != 0) {
                sKAbstractItem = (SKAbstractItem)this.components.elementAt(--n);
                if ((sKAbstractItem.flags & 2) == 0) continue;
                sKAbstractItem.setFocus(true, SKAbstractItem.UP);
                return;
            }
            if ((this.flags & 0x40000) == 262144) {
                n = this.components.size() - 1;
                sKAbstractItem = (SKAbstractItem)this.components.elementAt(n);
                if ((sKAbstractItem.flags & 2) != 0) {
                    sKAbstractItem.setFocus(true, SKAbstractItem.UP);
                    return;
                }
            } else {
                this.setFocus(false, SKAbstractItem.UP);
            }
        }
        catch (NullPointerException nullPointerException) {
            for (int i = 0; i < this.itemCount; ++i) {
                SKAbstractItem sKAbstractItem = (SKAbstractItem)this.components.elementAt(i);
                if ((sKAbstractItem.flags & 2) != 0) {
                    sKAbstractItem.setFocus(true, SKAbstractItem.UP);
                    return;
                }
                if (sKAbstractItem != this.components.firstElement()) continue;
                return;
            }
        }
    }

    private final void focusDown() {
        try {
            SKAbstractItem sKAbstractItem;
            if (this.focusItem == null) {
                throw new NullPointerException();
            }
            int n = this.components.indexOf(this.focusItem);
            while (n < this.itemCount - 1) {
                ++n;
                sKAbstractItem = (SKAbstractItem)this.components.elementAt(n);
                if ((sKAbstractItem.flags & 2) == 0) continue;
                sKAbstractItem.setFocus(true, SKAbstractItem.DOWN);
                return;
            }
            if ((this.flags & 0x40000) == 262144) {
                n = 0;
                sKAbstractItem = (SKAbstractItem)this.components.elementAt(n);
                if ((sKAbstractItem.flags & 2) != 0) {
                    sKAbstractItem.setFocus(true, SKAbstractItem.DOWN);
                    return;
                }
            } else {
                this.setFocus(false, SKAbstractItem.DOWN);
            }
        }
        catch (NullPointerException nullPointerException) {
            for (int i = 0; i < this.itemCount; ++i) {
                SKAbstractItem sKAbstractItem = (SKAbstractItem)this.components.elementAt(i);
                if ((sKAbstractItem.flags & 2) != 0) {
                    sKAbstractItem.setFocus(true, SKAbstractItem.DOWN);
                    return;
                }
                if (sKAbstractItem != this.components.lastElement()) continue;
                return;
            }
        }
    }

    private final void setFirstFocussable() {
        SKAbstractItem sKAbstractItem = null;
        for (int i = this.itemCount - 1; i >= 0; --i) {
            SKAbstractItem sKAbstractItem2 = (SKAbstractItem)this.components.elementAt(i);
            if ((sKAbstractItem2.flags & 2) == 0) continue;
            sKAbstractItem = sKAbstractItem2;
        }
        if (sKAbstractItem != null) {
            sKAbstractItem.setFocus(true, SKAbstractItem.DOWN);
        }
    }

    private final void setLastFocussable() {
        SKAbstractItem sKAbstractItem = null;
        for (int i = 0; i < this.itemCount - 1; ++i) {
            SKAbstractItem sKAbstractItem2 = (SKAbstractItem)this.components.elementAt(i);
            if ((sKAbstractItem2.flags & 2) == 0) continue;
            sKAbstractItem = sKAbstractItem2;
        }
        if (sKAbstractItem != null) {
            sKAbstractItem.setFocus(true, SKAbstractItem.UP);
        }
    }

    private final void setBounds() {
        if (this.width != -1 && this.height != -1) {
            return;
        }
        int n = this.spacing;
        int n2 = -1;
        for (int i = 0; i < this.itemCount; ++i) {
            int n3;
            SKAbstractItem sKAbstractItem = (SKAbstractItem)this.components.elementAt(i);
            int n4 = sKAbstractItem.y_ + sKAbstractItem.height;
            if (n4 > n) {
                n = n4 + this.spacing;
            }
            if ((n3 = sKAbstractItem.x_ + sKAbstractItem.width) <= n2) continue;
            n2 = n3;
        }
        this.setSize(n, n2 + this.spacing * 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void resourceEventOccurred(byte by, String string, Object object) {
        switch (by) {
            case 3: {
                Image image = (Image)object;
                Object object2 = this.bgImageLock;
                synchronized (object2) {
                    if (string.equals(this.bgImageSrc)) {
                        this.bgImage = image;
                    }
                }
                object2 = this.selbgImageLock;
                synchronized (object2) {
                    if (string.equals(this.selBgImageSrc)) {
                        this.selbgImage = image;
                    }
                }
                this.setBounds();
                break;
            }
            case 4: {
                String string2 = "contentServer.httpPullDownload('" + string + "');";
                SKCommand sKCommand = new SKCommand("", 1, 0, string2, null, null);
                this.notifyListener((byte)118, (Object)sKCommand);
            }
        }
    }

    public SKItemInterface getComponent(String string) {
        for (int i = 0; i < this.itemCount; ++i) {
            SKAbstractItem sKAbstractItem = (SKAbstractItem)this.components.elementAt(i);
            if (!sKAbstractItem.id.equals(string)) continue;
            return sKAbstractItem;
        }
        return null;
    }

    public void setValue(String string, String string2) {
        if (string.equals("bgimage")) {
            this.setBackground(string2, this.selBgImageSrc);
        } else if (string.equals("selectedbgimage")) {
            this.setBackground(this.bgImageSrc, string2);
        } else if (string.equals("scrolldistance")) {
            this.scrollSpeed = Integer.parseInt(string2);
        }
        super.setValue(string, string2);
    }

    public String getValue(String string) {
        if (string.equals("bgimage")) {
            return this.bgImageSrc;
        }
        if (string.equals("selectedbgimage")) {
            return this.selBgImageSrc;
        }
        if (string.equals("scrolldistance")) {
            Integer.toString(this.scrollSpeed);
        }
        return super.getValue(string);
    }

    public void repaintBG(Graphics graphics) {
    }
}

