/*
 * Decompiled with CFR 0.152.
 */
package com.sk.jclient.ui.components;

import com.sk.jclient.util.ResourceMgr;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.Hashtable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class SKFont {
    private static final Hashtable fontCache = new Hashtable();
    private final Font derived;
    private final Image fontImage;
    private final char[] characterMap;
    private final short[] xPositions;
    private final byte[] characterWidths;
    private final byte characterSpacing;
    private final int height;
    public int colour;

    private SKFont(boolean bl, Image image, char[] cArray, byte[] byArray, short[] sArray, byte by) {
        this.derived = null;
        this.xPositions = sArray;
        this.characterMap = cArray;
        this.characterWidths = byArray;
        this.characterSpacing = by;
        this.fontImage = image;
        this.height = image.getHeight();
    }

    private SKFont(int n, int n2, int n3) {
        this.xPositions = null;
        this.characterWidths = null;
        this.fontImage = null;
        this.characterMap = null;
        this.characterSpacing = 1;
        this.colour = 0;
        this.derived = Font.getFont((int)n, (int)n3, (int)n2);
        this.height = this.derived.getHeight();
    }

    public static final SKFont getFont(int n, int n2, int n3) {
        String string = n + ":" + n3 + ":" + n2;
        SKFont sKFont = (SKFont)fontCache.get(string);
        if (sKFont != null) {
            return sKFont;
        }
        sKFont = new SKFont(n, n2, n3);
        fontCache.put(string, sKFont);
        return sKFont;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final SKFont getFont(String string, ResourceMgr resourceMgr) throws IOException {
        if (!string.endsWith(".bmf")) {
            throw new IOException("File format not supported");
        }
        if (fontCache.containsKey(string)) {
            return (SKFont)fontCache.get(string);
        }
        FilterInputStream filterInputStream = null;
        try {
            byte[] byArray = resourceMgr.getData(string);
            filterInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            boolean bl = ((DataInputStream)filterInputStream).readBoolean();
            char[] cArray = ((DataInputStream)filterInputStream).readUTF().toCharArray();
            byte[] byArray2 = new byte[cArray.length];
            short[] sArray = new short[cArray.length];
            short s = 0;
            for (int i = 0; i < cArray.length; ++i) {
                byte by;
                byArray2[i] = by = ((DataInputStream)filterInputStream).readByte();
                sArray[i] = s;
                s = (short)(s + by);
            }
            byte[] byArray3 = new byte[filterInputStream.available()];
            try {
                ((DataInputStream)filterInputStream).readFully(byArray3);
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
            Image image = Image.createImage((byte[])byArray3, (int)0, (int)byArray3.length);
            SKFont sKFont = new SKFont(bl, image, cArray, byArray2, sArray, 0);
            fontCache.put(string, sKFont);
            SKFont sKFont2 = sKFont;
            return sKFont2;
        }
        finally {
            try {
                filterInputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    public static final int stringWidth(String string, SKFont sKFont) {
        if (sKFont.derived != null) {
            return sKFont.derived.stringWidth(string);
        }
        short[] sArray = SKFont.getIndeces(string.toCharArray(), sKFont);
        int n = 0;
        for (int i = 0; i < sArray.length; ++i) {
            if (sArray[i] == -1) {
                n += 6 + sKFont.characterSpacing;
                continue;
            }
            n += sKFont.characterWidths[sArray[i]] + sKFont.characterSpacing;
        }
        return n;
    }

    public final void draw(Graphics graphics, String string, int n, int n2, int n3) {
        if (this.derived != null) {
            int n4 = graphics.getColor();
            Font font = graphics.getFont();
            graphics.setFont(this.derived);
            graphics.setColor(this.colour);
            graphics.drawString(string, n, n2, n3);
            graphics.setColor(n4);
            graphics.setFont(font);
            return;
        }
        SKFont.drawStringImage(graphics, string, n, n2, n3, this);
    }

    private static final void drawStringImage(Graphics graphics, String string, int n, int n2, int n3, SKFont sKFont) {
        int n4;
        int n5;
        int n6 = graphics.getClipX();
        int n7 = graphics.getClipY();
        int n8 = graphics.getClipWidth();
        int n9 = graphics.getClipHeight();
        int n10 = SKFont.stringWidth(string, sKFont);
        if ((n3 & 0x14) == 20) {
            n5 = 0;
            n4 = 0;
        } else if ((n3 & 0x11) == 17) {
            n5 = -(n10 / 2);
            n4 = 0;
        } else if ((n3 & 0x18) == 24) {
            n5 = -n10;
            n4 = 0;
        } else if ((n3 & 0x24) == 36) {
            n5 = 0;
            n4 = -sKFont.height;
        } else if ((n3 & 0x21) == 33) {
            n5 = -(n10 / 2);
            n4 = -sKFont.height;
        } else if ((n3 & 0x28) == 40) {
            n5 = -n10;
            n4 = -sKFont.height;
        } else {
            n5 = 0;
            n4 = 0;
        }
        short[] sArray = SKFont.getIndeces(string.toCharArray(), sKFont);
        int n11 = n + n5;
        int n12 = n2 + n4;
        for (int i = 0; i < sArray.length; ++i) {
            int n13;
            if (sArray[i] == -1) {
                n13 = graphics.getColor();
                graphics.setColor(0xFFFFFF);
                graphics.drawRect(n11, n2, 5, sKFont.getHeight());
                graphics.setColor(n13);
                n11 += 6 + sKFont.characterSpacing;
                continue;
            }
            graphics.clipRect(n11, n12, (int)sKFont.characterWidths[sArray[i]], sKFont.height);
            n13 = n11 - sKFont.xPositions[sArray[i]];
            graphics.drawImage(sKFont.fontImage, n13, n12, 20);
            n11 += sKFont.characterWidths[sArray[i]] + sKFont.characterSpacing;
            graphics.setClip(n6, n7, n8, n9);
        }
    }

    private static final short[] getIndeces(char[] cArray, SKFont sKFont) {
        short[] sArray = new short[cArray.length];
        for (int n = 0; n < cArray.length; n = (int)((short)(n + 1))) {
            int n2 = -1;
            for (int n3 = 0; n3 < sKFont.characterMap.length; n3 = (int)((short)(n3 + 1))) {
                if (cArray[n] != sKFont.characterMap[n3]) continue;
                n2 = n3;
                break;
            }
            sArray[n] = n2;
        }
        return sArray;
    }

    public final int getHeight() {
        return this.height;
    }

    public final int getColor() {
        return this.colour;
    }

    public final void setColor(int n) {
        this.colour = n;
    }
}

