/*
 * Decompiled with CFR 0.152.
 */
package com.sk.jclient.ui.components;

import com.sk.jclient.ContentServer;
import com.sk.jclient.ui.UIListener;
import com.sk.jclient.ui.components.Container;
import com.sk.jclient.ui.components.ItemGroup;
import com.sk.jclient.ui.components.SKAbstractItem;
import com.sk.jclient.ui.components.SKFont;
import com.sk.jclient.ui.components.SKForm;
import com.sk.jclient.ui.components.SKItemInterface;
import com.sk.jclient.util.ResourceConsumer;
import com.sk.jclient.util.ResourceMgr;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class SKFreeList
extends SKAbstractItem
implements UIListener,
ItemGroup,
ResourceConsumer {
    private static final byte ARROW_HEIGHT = 4;
    private static final byte ARROW_WIDTH = 5;
    private static final byte BAR_WIDTH = 5;
    public byte spacer_ = 0;
    public int elementsPerPage;
    private String tickerText_ = null;
    private short currentPage = 0;
    private int scrollBarColor_ = 5947119;
    private short maxWidth = (short)-1;
    private short maxHeight = (short)-1;
    private short scrollbarX = 0;
    private byte selectedIndex;
    private byte lastSelection;
    private Vector items_;
    private byte itemCount;
    private SKAbstractItem selected;
    private Image bgImage;
    private String bgsrc;
    private Object bgImageLock = new Object();

    public SKFreeList(String string, int n, int n2, int n3, byte by, int n4, int n5, int n6, SKForm sKForm, SKFont sKFont) {
        super(string, n, n2, n5, -1, sKForm, sKFont);
        this.items_ = new Vector(8, 2);
        this.spacer_ = by;
        if (n4 != -1) {
            this.scrollBarColor_ = n4;
            this.flags |= 0x10000;
        }
        if (n6 != -1) {
            this.selfgcol = n6;
        }
        this.elementsPerPage = 3;
        this.flags |= 2;
        if (n3 == -1) {
            this.height = sKForm.height_;
            this.width = sKForm.width_ - (n + 5);
            this.setSize(sKForm.height_, sKForm.width_ - (n + 5));
        } else {
            this.flags |= 0x200000;
            this.height = n3;
        }
    }

    public final void repaintBG(Graphics graphics) {
        if (this.bgImage != null) {
            graphics.drawImage(this.bgImage, 0, 0, 20);
        } else if (this.listener != null) {
            this.listener.repaintBG(graphics);
        }
    }

    public SKFreeList(String string, boolean bl, int n, int n2, int n3, int n4, byte by, int n5, int n6, int n7, SKForm sKForm, SKFont sKFont) {
        this(string, n2, n3, n4, by, n5, n6, n7, sKForm, sKFont);
        if (bl) {
            this.flags |= 0x40;
        }
        this.refresh = 40L;
        this.setSize(n4, n);
        this.flags &= 0xFFDFFFFF;
    }

    public void appendItem(SKAbstractItem sKAbstractItem) {
        sKAbstractItem.setUIListener(this);
        sKAbstractItem.x_ = this.x_;
        if ((sKAbstractItem.flags & 2) != 0 && (this.flags & 0x1000) != 0) {
            sKAbstractItem.flags |= 0x1000;
        }
        this.items_.addElement(sKAbstractItem);
        this.items_.trimToSize();
        this.itemCount = (byte)this.items_.size();
        this.onItemEvent(sKAbstractItem, (byte)119, null);
    }

    public void removeItem(SKAbstractItem sKAbstractItem) {
        this.items_.removeElement(sKAbstractItem);
        this.itemCount = (byte)this.items_.size();
        this.items_.trimToSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBackground(String string) {
        this.bgsrc = string;
        Object object = this.bgImageLock;
        synchronized (object) {
            Image image = ContentServer.resource_mgr.getImage(string, this);
            if (this.bgImage == null || ResourceMgr.isPlaceHolder(this.bgImage)) {
                this.bgImage = image;
            }
        }
    }

    public void keyPressed(int n) {
        if (this.selected == null) {
            return;
        }
        if ((this.flags & 0x2000) == 0) {
            switch (n) {
                case -2: 
                case 56: {
                    this.selected.setFocus(false, SKAbstractItem.DOWN);
                    return;
                }
                case -1: 
                case 50: {
                    this.selected.setFocus(false, SKAbstractItem.UP);
                    return;
                }
            }
        } else {
            switch (n) {
                case -4: 
                case 54: {
                    this.selected.setFocus(false, SKAbstractItem.RIGHT);
                    return;
                }
                case -3: 
                case 52: {
                    this.selected.setFocus(false, SKAbstractItem.LEFT);
                    return;
                }
                case -1: 
                case 50: {
                    this.setFocus(false, SKAbstractItem.UP);
                    return;
                }
                case -2: 
                case 56: {
                    this.setFocus(false, SKAbstractItem.DOWN);
                    return;
                }
            }
        }
        this.selected.keyPressed(n);
    }

    public void keyRepeated(int n) {
        this.keyPressed(n);
    }

    private void startScrollIfNeeded() {
    }

    public void setFocus(boolean bl, Byte by) {
        if (bl) {
            this.selectItemAt(this.lastSelection);
        } else {
            this.selected = null;
        }
        super.setFocus(bl, by);
    }

    private void setPage() {
        short s = this.currentPage;
        try {
            this.currentPage = (short)(this.selectedIndex / this.elementsPerPage);
            if (s != this.currentPage && this.bgsrc == null) {
                this.notifyListener((byte)121, null);
            }
        }
        catch (ArithmeticException arithmeticException) {
            this.currentPage = 0;
        }
    }

    public boolean selectItemAt(short s) {
        Byte by;
        this.stop();
        this.lastSelection = this.selectedIndex;
        Byte by2 = by = s > this.selectedIndex ? SKAbstractItem.DOWN : SKAbstractItem.UP;
        if ((this.flags & 0x40000) == 262144) {
            s = (short)((s + this.items_.size()) % this.items_.size());
        }
        if (s < 0 || s >= this.itemCount) {
            this.setFocus(false, by);
            return false;
        }
        this.selected = (SKAbstractItem)this.items_.elementAt(s);
        this.selected.setFocus(true, by);
        this.startScrollIfNeeded();
        this.notifyListener((byte)2, this.selected);
        return true;
    }

    public SKAbstractItem getFocussedComponent() {
        for (int i = 0; i < this.items_.size(); ++i) {
            SKAbstractItem sKAbstractItem = (SKAbstractItem)this.items_.elementAt(i);
            if ((sKAbstractItem.flags & 8) == 0) continue;
            if (sKAbstractItem instanceof SKFreeList) {
                return ((SKFreeList)sKAbstractItem).getFocussedComponent();
            }
            if (sKAbstractItem instanceof Container) {
                return ((Container)sKAbstractItem).getFocussedComponent();
            }
            return sKAbstractItem;
        }
        return null;
    }

    public final void setFocus(String string) {
        SKAbstractItem sKAbstractItem = this.getItemByName(string);
        if (sKAbstractItem != null) {
            this.selectItemAt((short)this.items_.indexOf(sKAbstractItem));
            super.setFocus(true, SKAbstractItem.DOWN);
        }
    }

    public final SKAbstractItem getItemByName(String string) {
        SKAbstractItem sKAbstractItem = null;
        for (int i = 0; i < this.items_.size(); ++i) {
            SKAbstractItem sKAbstractItem2;
            SKAbstractItem sKAbstractItem3 = (SKAbstractItem)this.items_.elementAt(i);
            if (sKAbstractItem3 instanceof SKFreeList) {
                sKAbstractItem2 = ((SKFreeList)sKAbstractItem3).getItemByName(string);
                if (sKAbstractItem2 == null) continue;
                sKAbstractItem2.setFocus(true, SKAbstractItem.DOWN);
                sKAbstractItem3.setFocus(true, SKAbstractItem.DOWN);
                ((SKFreeList)sKAbstractItem3).setFocus(string);
                return sKAbstractItem2;
            }
            if (sKAbstractItem3 instanceof Container) {
                sKAbstractItem2 = ((Container)sKAbstractItem3).getItemByName(string);
                if (sKAbstractItem2 == null) continue;
                sKAbstractItem2.setFocus(true, SKAbstractItem.DOWN);
                sKAbstractItem3.setFocus(true, SKAbstractItem.DOWN);
                return sKAbstractItem2;
            }
            if (sKAbstractItem3.id == null || !sKAbstractItem3.id.equals(string)) continue;
            return sKAbstractItem3;
        }
        return sKAbstractItem;
    }

    public final boolean setFocusByName(String string) {
        for (int i = 0; i < this.items_.size(); ++i) {
            SKAbstractItem sKAbstractItem;
            SKAbstractItem sKAbstractItem2 = (SKAbstractItem)this.items_.elementAt(i);
            if (sKAbstractItem2 instanceof SKFreeList) {
                sKAbstractItem = ((SKFreeList)sKAbstractItem2).getItemByName(string);
                if (sKAbstractItem == null) continue;
                ((SKFreeList)sKAbstractItem2).setFocus(string);
                return true;
            }
            if (sKAbstractItem2 instanceof Container) {
                sKAbstractItem = ((Container)sKAbstractItem2).getItemByName(string);
                if (sKAbstractItem == null) continue;
                sKAbstractItem.setFocus(true, SKAbstractItem.DOWN);
                return true;
            }
            if (sKAbstractItem2.id == null || !sKAbstractItem2.id.equals(string)) continue;
            sKAbstractItem2.setFocus(true, SKAbstractItem.DOWN);
            return true;
        }
        return false;
    }

    protected void draw(Graphics graphics, int n) {
        if (this.items_.isEmpty()) {
            return;
        }
        SKAbstractItem sKAbstractItem = null;
        if (this.selectedIndex == -1 || this.selectedIndex >= this.itemCount) {
            this.selectedIndex = this.lastSelection;
        } else {
            sKAbstractItem = (SKAbstractItem)this.items_.elementAt(this.selectedIndex);
            this.setPage();
        }
        int n2 = this.currentPage * this.elementsPerPage;
        this.flags = this.currentPage > 0 ? (this.flags |= 0x800) : (this.flags &= 0xFFFFF7FF);
        this.flags = n2 + this.elementsPerPage < this.itemCount ? (this.flags |= 0x400) : (this.flags &= 0xFFFFFBFF);
        if (this.bgImage != null) {
            graphics.drawImage(this.bgImage, 0, 0, 20);
        }
        int n3 = 0;
        for (int i = n2; i < n2 + this.elementsPerPage && i < this.itemCount; ++i) {
            sKAbstractItem = (SKAbstractItem)this.items_.elementAt(i);
            sKAbstractItem.flags |= 1;
            if ((this.flags & 0x2000) == 0) {
                sKAbstractItem.y_ = this.y_ + n3;
                sKAbstractItem.x_ = this.x_;
                sKAbstractItem.paint(graphics, n);
                n3 += sKAbstractItem.height + this.spacer_;
                continue;
            }
            sKAbstractItem.y_ = this.y_ + n;
            sKAbstractItem.x_ = this.x_ + n3;
            sKAbstractItem.paint(graphics, n);
            n3 += sKAbstractItem.width + this.spacer_;
        }
        if ((this.flags & 0x10000) != 0 && (this.flags & 0x2000) == 0) {
            this.drawScrollBar(graphics, this.scrollbarX, n3);
        }
    }

    private void drawScrollBar(Graphics graphics, int n, int n2) {
        int n3;
        if ((this.flags & 0xC00) == 0) {
            return;
        }
        graphics.setColor(this.scrollBarColor_);
        int n4 = n + 2;
        graphics.fillRect(n4 - 2, this.y_ + 4 + 2, 5, n2 - 4 - 8);
        graphics.setColor(this.bgcolor_);
        graphics.drawRect(n4 - 2 - 1, this.y_ + 4 + 2, 6, n2 - 5 - 8);
        if ((this.flags & 8) != 0) {
            graphics.setColor(this.selfgcol);
        } else {
            graphics.setColor(this.fgcolor_);
        }
        if ((this.flags & 0x800) != 0) {
            for (n3 = 0; n3 < 5; ++n3) {
                graphics.drawLine(n + n3, this.y_ + 4, n + 2, this.y_);
            }
        }
        if ((this.flags & 8) != 0) {
            graphics.setColor(this.selfgcol);
        } else {
            graphics.setColor(this.fgcolor_);
        }
        if ((this.flags & 0x400) != 0) {
            for (n3 = 0; n3 < 5; ++n3) {
                graphics.drawLine(n + n3, this.y_ + n2 - 4, n + 2, this.y_ + n2);
            }
        }
    }

    void stop() {
        this.flags &= 0xFFFFFFFB;
    }

    void start() {
        if ((this.flags & 0x40) != 0 && this.tickerText_ != null) {
            this.flags |= 4;
        }
    }

    public synchronized void onItemEvent(SKAbstractItem sKAbstractItem, byte by, Object object) {
        int n;
        switch (by) {
            case 119: {
                for (n = 0; n < this.itemCount; ++n) {
                    SKAbstractItem sKAbstractItem2 = (SKAbstractItem)this.items_.elementAt(n);
                    this.maxWidth = sKAbstractItem2.width > this.maxWidth ? (short)sKAbstractItem2.width : this.maxWidth;
                    this.maxHeight = sKAbstractItem2.height > this.maxHeight ? (short)sKAbstractItem2.height : this.maxHeight;
                    sKAbstractItem2.flags |= 1;
                }
                this.scrollbarX = (short)(this.x_ + this.maxWidth + 5);
                this.flags |= 1;
                if ((this.flags & 0x2000) != 0) {
                    this.setSize(this.maxHeight, (this.maxWidth + this.spacer_) * this.elementsPerPage);
                    break;
                }
                this.setSize((this.maxHeight + this.spacer_) * this.elementsPerPage, this.maxWidth + 20);
                break;
            }
            case 4: {
                Byte by2 = (Byte)object;
                if ((this.flags & 0x2000) != 0) {
                    if (by2 == SKAbstractItem.LEFT) {
                        if (0 >= this.selectedIndex) break;
                        this.selectedIndex = (byte)(this.selectedIndex - 1);
                        this.selectItemAt(this.selectedIndex);
                        break;
                    }
                    if (by2 == SKAbstractItem.RIGHT) {
                        if (this.itemCount - 1 <= this.selectedIndex) break;
                        this.selectedIndex = (byte)(this.selectedIndex + 1);
                        this.selectItemAt(this.selectedIndex);
                        break;
                    }
                    if (by2 == SKAbstractItem.UP) {
                        this.setFocus(false, SKAbstractItem.UP);
                        break;
                    }
                    this.setFocus(false, SKAbstractItem.DOWN);
                    break;
                }
                short s = this.selectedIndex;
                s = (Byte)object == SKAbstractItem.DOWN ? (short)(s + 1) : (short)(s - 1);
                this.selectItemAt(s);
                break;
            }
            case 3: {
                this.selected = sKAbstractItem;
                this.selectedIndex = (byte)this.items_.indexOf(sKAbstractItem);
            }
            default: {
                this.notifyListener(by, object);
            }
        }
        if (by == 119 || by == 121 || by == 4) {
            for (n = 0; n < this.itemCount; ++n) {
                ((SKAbstractItem)this.items_.elementAt((int)n)).flags |= 1;
            }
        }
    }

    protected void notifyListener(byte by, Object object) {
        if (by == 121 || by == 4) {
            for (int i = 0; i < this.itemCount; ++i) {
                SKAbstractItem sKAbstractItem = (SKAbstractItem)this.items_.elementAt(i);
                if (by == 4) {
                    sKAbstractItem.flags &= 0xFFFFFFF7;
                }
                sKAbstractItem.flags |= 1;
            }
        } else if (by == 3) {
            this.flags |= 8;
            if (this.selectedIndex < 0) {
                this.selectItemAt((short)0);
            } else if (this.selectedIndex > this.itemCount - 1) {
                this.selectItemAt((short)(this.itemCount - 1));
            }
        }
        super.notifyListener(by, object);
    }

    protected final void tick(long l) {
        for (int i = 0; i < this.itemCount; ++i) {
            ((SKAbstractItem)this.items_.elementAt(i)).tick(l);
        }
    }

    public void clear() {
        this.items_.removeAllElements();
        this.itemCount = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resourceEventOccurred(byte by, String string, Object object) {
        if (string.equals(this.bgsrc) && by == 3) {
            Object object2 = this.bgImageLock;
            synchronized (object2) {
                this.bgImage = (Image)object;
            }
            this.flags |= 1;
        }
    }

    public SKItemInterface getComponent(String string) {
        for (int i = 0; i < this.itemCount; ++i) {
            SKAbstractItem sKAbstractItem = (SKAbstractItem)this.items_.elementAt(i);
            if (!sKAbstractItem.id.equals(string)) continue;
            return sKAbstractItem;
        }
        return null;
    }
}

