/*
 * Decompiled with CFR 0.152.
 */
package com.sk.jclient.ui.components;

import com.sk.jclient.ui.Page;
import com.sk.jclient.ui.UIListener;
import com.sk.jclient.ui.components.ItemGroup;
import com.sk.jclient.ui.components.SKAbstractItem;
import com.sk.jclient.ui.components.SKForm;
import com.sk.jclient.ui.components.SKItemInterface;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public final class SKTicker
extends SKAbstractItem
implements UIListener,
ItemGroup {
    private Vector items_ = new Vector();
    private int tickerX_;
    private int tickerY_;
    private int speed_;
    private Byte direction_;
    private int mostLeftX_;
    private int mostRightX_;
    private int mostTopY_;
    private int mostBottomY_;
    private SKAbstractItem selectedItem_ = null;
    private int selectedIndex_ = 0;
    private int totalItemH;
    private int totalItemW;
    private int itemCount;

    public SKTicker(String string, int n, int n2, int n3, int n4, int n5, boolean bl, String string2, SKForm sKForm) {
        super(string, n, n2, 0, 0xFFFFFF, sKForm, Page.def_Font);
        this.setSize(n4, n3);
        this.mostRightX_ = 0;
        this.mostLeftX_ = this.width;
        this.mostTopY_ = n4;
        this.mostBottomY_ = 0;
        this.speed_ = n5;
        this.direction_ = "down".equals(string2) ? SKAbstractItem.DOWN : ("right".equals(string2) ? SKAbstractItem.RIGHT : ("up".equals(string2) ? SKAbstractItem.UP : SKAbstractItem.LEFT));
        this.flags |= 0x200000;
        this.notifyListener((byte)1, null);
    }

    public void appendItem(SKAbstractItem sKAbstractItem) {
        sKAbstractItem.setUIListener(this);
        this.items_.addElement(sKAbstractItem);
        this.itemCount = this.items_.size();
        this.flags |= 0x200000;
    }

    private void calcBorders(SKAbstractItem sKAbstractItem) {
        if (sKAbstractItem.x_ + sKAbstractItem.width > this.mostRightX_) {
            this.mostRightX_ = sKAbstractItem.x_ + sKAbstractItem.width;
        }
        if (sKAbstractItem.x_ < this.mostLeftX_) {
            this.mostLeftX_ = sKAbstractItem.x_;
        }
        if (sKAbstractItem.height + sKAbstractItem.y_ > this.mostBottomY_) {
            this.mostBottomY_ = sKAbstractItem.height + sKAbstractItem.y_;
        }
        if (sKAbstractItem.y_ < this.mostTopY_) {
            this.mostTopY_ = sKAbstractItem.y_;
        }
    }

    public void stop() {
        this.flags &= 0xFFFFFFFB;
    }

    public void start() {
        if (this.direction_ == SKAbstractItem.UP) {
            this.tickerY_ = this.height - this.mostTopY_;
            this.tickerX_ = 0;
        } else if (this.direction_ == SKAbstractItem.DOWN) {
            this.tickerY_ = 0 - (this.height - this.mostBottomY_);
            this.tickerX_ = 0;
        } else if (this.direction_ == SKAbstractItem.LEFT) {
            this.tickerX_ = this.x_ + this.width;
            this.tickerY_ = 0;
        } else if (this.direction_ == SKAbstractItem.RIGHT) {
            this.tickerX_ = -(this.mostRightX_ - this.mostLeftX_) - 10;
            this.tickerY_ = 0;
        }
        this.flags |= 4;
    }

    public final void repaintBG(Graphics graphics) {
        if (this.listener != null) {
            this.listener.repaintBG(graphics);
        }
    }

    protected void draw(Graphics graphics, int n) {
        if ((this.flags & 8) != 0) {
            graphics.setColor(this.selbgcol);
        } else {
            graphics.setColor(this.bgcolor_);
        }
        graphics.fillRect(this.x_, this.y_ + n, this.width, this.height);
        graphics.translate(this.x_, this.y_ + n);
        try {
            for (int i = 0; i < this.items_.size(); ++i) {
                SKAbstractItem sKAbstractItem = (SKAbstractItem)this.items_.elementAt(i);
                sKAbstractItem.x_ += this.tickerX_;
                sKAbstractItem.y_ += this.tickerY_;
                sKAbstractItem.draw(graphics, n);
                sKAbstractItem.x_ -= this.tickerX_;
                sKAbstractItem.y_ -= this.tickerY_;
                sKAbstractItem.flags |= 1;
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        graphics.translate(-graphics.getTranslateX(), -graphics.getTranslateY());
    }

    protected synchronized void tick(long l) {
        for (int i = 0; i < this.itemCount; ++i) {
            ((SKAbstractItem)this.items_.elementAt(i)).tick(l);
        }
        if ((this.flags & 0x200000) != 0) {
            this.setBoundingBox();
        }
        if ((this.flags & 4) == 0) {
            return;
        }
        if (l - this.lastUpdate > (long)this.speed_) {
            this.onUpdate();
            this.lastUpdate = l;
        }
    }

    protected void onUpdate() {
        if (this.direction_ == SKAbstractItem.UP) {
            this.tickerY_ = this.tickerY_ < 0 - (this.mostBottomY_ + 5) ? this.height - this.mostTopY_ : (this.tickerY_ -= this.speed_);
        } else if (this.direction_ == SKAbstractItem.DOWN) {
            this.tickerY_ = this.tickerY_ > this.height - this.mostTopY_ ? 0 - (this.height - this.mostBottomY_) : (this.tickerY_ += this.speed_);
        } else if (this.direction_ == SKAbstractItem.LEFT) {
            this.tickerX_ = this.tickerX_ + this.x_ > this.x_ - this.totalItemW ? (this.tickerX_ -= this.speed_) : this.x_ + this.width;
        } else if (this.direction_ == SKAbstractItem.RIGHT) {
            this.tickerX_ = this.tickerX_ > this.width ? -(this.mostRightX_ - this.mostLeftX_) : (this.tickerX_ += this.speed_);
        }
        this.flags |= 1;
    }

    public synchronized void onItemEvent(SKAbstractItem sKAbstractItem, byte by, Object object) {
        switch (by) {
            case 119: {
                this.calcBorders(sKAbstractItem);
                this.flags |= 0x200000;
                break;
            }
            case 4: {
                if ((Byte)object == SKAbstractItem.DOWN) {
                    this.focusDown();
                    break;
                }
                this.focusUp();
                break;
            }
            case 3: {
                this.selectedItem_ = sKAbstractItem;
                this.selectedIndex_ = this.items_.indexOf(sKAbstractItem);
                break;
            }
            default: {
                this.notifyListener(by, object);
            }
        }
    }

    public void keyPressed(int n) {
        switch (n) {
            case -1: 
            case 50: {
                if (this.selectedItem_ == null) {
                    this.setFocus(false, SKAbstractItem.UP);
                    break;
                }
                this.selectedItem_.setFocus(false, SKAbstractItem.UP);
                break;
            }
            case -2: 
            case 56: {
                if (this.selectedItem_ == null) {
                    this.setFocus(false, SKAbstractItem.DOWN);
                    break;
                }
                this.selectedItem_.setFocus(false, SKAbstractItem.DOWN);
                break;
            }
            default: {
                if (this.selectedItem_ != null) {
                    this.selectedItem_.keyPressed(n);
                }
                this.notifyListener((byte)120, null);
            }
        }
    }

    public void setFocus(boolean bl, Byte by) {
        if (this.selectedItem_ != null) {
            this.selectedItem_.setFocus(bl, by);
        }
        super.setFocus(bl, by);
    }

    private final void focusUp() {
        int n;
        if ((n = --this.selectedIndex_) > 0) {
            SKAbstractItem sKAbstractItem = (SKAbstractItem)this.items_.elementAt(n);
            if ((sKAbstractItem.flags & 2) != 0) {
                sKAbstractItem.setFocus(true, SKAbstractItem.UP);
            }
        } else {
            super.setFocus(false, SKAbstractItem.UP);
        }
    }

    private final void focusDown() {
        int n;
        if ((n = ++this.selectedIndex_) < this.itemCount) {
            SKAbstractItem sKAbstractItem = (SKAbstractItem)this.items_.elementAt(n);
            if ((sKAbstractItem.flags & 2) != 0) {
                sKAbstractItem.setFocus(true, SKAbstractItem.DOWN);
            }
        } else {
            this.setFocus(false, SKAbstractItem.DOWN);
        }
    }

    private final void setBoundingBox() {
        this.totalItemH = 0;
        this.totalItemW = 0;
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.itemCount; ++i) {
            SKAbstractItem sKAbstractItem = (SKAbstractItem)this.items_.elementAt(i);
            this.totalItemW += sKAbstractItem.width;
            this.totalItemH += sKAbstractItem.height;
            if (this.direction_ == SKAbstractItem.LEFT || this.direction_ == SKAbstractItem.RIGHT) {
                n = n > sKAbstractItem.y_ + sKAbstractItem.height ? n : sKAbstractItem.y_ + sKAbstractItem.height;
                n2 = n2 > sKAbstractItem.width ? n2 : sKAbstractItem.width;
                continue;
            }
            n = n > sKAbstractItem.height ? n : sKAbstractItem.height;
            n2 = n2 > sKAbstractItem.width ? n2 : sKAbstractItem.x_ + sKAbstractItem.width;
        }
        if (this.direction_ == SKAbstractItem.LEFT || this.direction_ == SKAbstractItem.RIGHT) {
            this.setSize(n, this.width);
        } else if (this.direction_ == SKAbstractItem.UP || this.direction_ == SKAbstractItem.DOWN) {
            this.setSize(this.height, n2);
        }
        this.flags &= 0xFFDFFFFF;
    }

    public SKAbstractItem getFocussedComponent() {
        if (this.selectedItem_ == null) {
            return null;
        }
        if (this.selectedItem_ instanceof ItemGroup) {
            return ((ItemGroup)((Object)this.selectedItem_)).getFocussedComponent();
        }
        return this.selectedItem_;
    }

    public final SKAbstractItem getItemByName(String string) {
        for (int i = 0; i < this.itemCount; ++i) {
            SKAbstractItem sKAbstractItem;
            SKAbstractItem sKAbstractItem2 = (SKAbstractItem)this.items_.elementAt(i);
            if (sKAbstractItem2.id.equals(string)) {
                return sKAbstractItem2;
            }
            if (!(sKAbstractItem2 instanceof ItemGroup) || (sKAbstractItem = ((ItemGroup)((Object)sKAbstractItem2)).getItemByName(string)) == null) continue;
            return sKAbstractItem;
        }
        return null;
    }

    public final boolean setFocusByName(String string) {
        SKAbstractItem sKAbstractItem = this.getItemByName(string);
        if (sKAbstractItem != null) {
            sKAbstractItem.setFocus(true, SKAbstractItem.DOWN);
            return true;
        }
        return false;
    }

    public void removeItem(SKAbstractItem sKAbstractItem) {
        this.items_.removeElement(sKAbstractItem);
        this.itemCount = this.items_.size();
    }

    public void clear() {
        this.items_.removeAllElements();
        this.itemCount = 0;
    }

    public SKItemInterface getComponent(String string) {
        for (int i = 0; i < this.itemCount; ++i) {
            SKAbstractItem sKAbstractItem = (SKAbstractItem)this.items_.elementAt(i);
            if (!sKAbstractItem.id.equals(string)) continue;
            return sKAbstractItem;
        }
        return null;
    }
}

