/*
 * Decompiled with CFR 0.152.
 */
package com.sk.jclient.util;

import com.sk.jclient.ContentServer;
import com.sk.jclient.InterpreterOperation;
import com.sk.jclient.Main;
import com.sk.jclient.ui.Page;
import com.sk.jclient.ui.components.SKGauge;
import com.sk.jclient.util.ResourceDescriptor;
import com.sk.jclient.util.ResourceMgr;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;

public final class UpdateManager {
    static final String SYNC_DIR_ROOT = "ca";
    static final String CHANNEL_DIR_ROOT = "ch";
    public static final String AGENT_DIR_ROOT = "aa";
    public static final String SSUID_STORE = "ssuid";
    public static int UPDATE_EVENT = 9;
    public static int CHECK_EVENT = 10;
    public static int END_EVENT = 11;
    public static final byte updateStarted = 1;
    public static boolean onlyGetUpdate = false;
    private boolean updateFail = false;
    public boolean cancelUpdate = false;
    public InterpreterOperation updateOnComplete;
    private static final String SYNC_URL = Main.instance.SK_SERVER + Main.instance.SK_SERVLET;
    private static final String BOUNDARY = "-----*******************";
    private Hashtable httpPullXmls = new Hashtable();
    private static byte[] syncList;
    private ContentServer server;
    private static String ssuid;
    Vector files = new Vector();
    Vector cmds = new Vector();

    public UpdateManager(ContentServer contentServer) {
        this.server = contentServer;
        ssuid = UpdateManager.getSSUID();
    }

    public static final InterpreterOperation getDownloadContentOperation(String[] stringArray) {
        String string = stringArray[0];
        InterpreterOperation interpreterOperation = new InterpreterOperation("skapploader", "loadData", new Object[]{string, "get", null, null, null});
        InterpreterOperation interpreterOperation2 = interpreterOperation.onComplete = new InterpreterOperation("contentServer", "refresh", new Object[]{string});
        for (int i = 1; i < stringArray.length; ++i) {
            string = stringArray[i];
            interpreterOperation2.onComplete = new InterpreterOperation("skapploader", "loadData", new Object[]{string, "get", null, null, null});
            interpreterOperation2 = interpreterOperation2.onComplete.onComplete = new InterpreterOperation("contentServer", "refresh", new Object[]{string});
        }
        return interpreterOperation;
    }

    public final void doUpdate(InterpreterOperation interpreterOperation) {
        ResourceMgr.reset(true);
        if ((ContentServer.flags & 1) == 0 && !onlyGetUpdate) {
            ContentServer.flags = (byte)(ContentServer.flags | 1);
            this.updateOnComplete = interpreterOperation.onComplete;
            this.cancelUpdate = false;
            InterpreterOperation interpreterOperation2 = UpdateManager.getCheckSumOperation(interpreterOperation);
            if (this.cancelUpdate) {
                return;
            }
            this.server.dispatch(interpreterOperation2);
        } else if (onlyGetUpdate) {
            onlyGetUpdate = false;
            ContentServer.flags = (byte)(ContentServer.flags | 1);
            this.updateOnComplete = interpreterOperation.onComplete;
            this.server.dispatch(UpdateManager.getSyncOperation(interpreterOperation));
        } else {
            int n;
            if (ssuid == null) {
                ssuid = (String)interpreterOperation.parameters[0];
                ContentServer.resource_mgr.writeValue(SSUID_STORE, ssuid.getBytes());
            }
            if ((n = ((Integer)interpreterOperation.parameters[2]).intValue()) < 4 && n > 0) {
                if (interpreterOperation.dataContent[0] == 79) {
                    if (interpreterOperation.gauge != null) {
                        interpreterOperation.gauge.setValue(interpreterOperation.gauge.maxValue);
                    }
                    ContentServer.flags = (byte)(ContentServer.flags & 0xFFFFFFFE);
                    this.server.dispatch(this.updateOnComplete);
                    this.updateOnComplete = null;
                } else if (interpreterOperation.dataContent[0] == 78) {
                    if (this.cancelUpdate) {
                        return;
                    }
                    this.server.dispatch(UpdateManager.getSyncOperation(interpreterOperation));
                }
            } else {
                try {
                    long l = ResourceMgr.getAvailableStorage();
                    if (l < (long)n) {
                        throw new IOException("Storage full");
                    }
                    this.storeSyncData(interpreterOperation);
                    this.updateFail = false;
                }
                catch (IOException iOException) {
                    if (this.updateFail) {
                        ContentServer.resource_mgr.writeValue("update", new byte[]{121});
                    }
                    this.server.completedWithError(interpreterOperation.onError);
                    ContentServer.flags = (byte)(ContentServer.flags & 0xFFFFFFFE);
                    return;
                }
                if (interpreterOperation.gauge != null) {
                    interpreterOperation.gauge.setValue(interpreterOperation.gauge.maxValue);
                }
                ContentServer.resource_mgr.deleteValue("update");
                this.server.dispatch(this.updateOnComplete);
                this.updateOnComplete = null;
                ContentServer.flags = (byte)(ContentServer.flags & 0xFFFFFFFE);
            }
        }
    }

    public final byte[] handleHttpPull(InterpreterOperation interpreterOperation, String string) {
        if (interpreterOperation.dataContent != null) {
            this.httpPullXmls.put(string, interpreterOperation.dataContent);
            return interpreterOperation.dataContent;
        }
        if (this.httpPullXmls.containsKey(string)) {
            return (byte[])this.httpPullXmls.get(string);
        }
        try {
            Page page;
            byte[] byArray = ResourceMgr.getResource(ResourceMgr.getContentFromUrl(this.server.midlet.HTTP_PULL_FILE));
            ContentServer.currentPage = page = Page.realise(byArray, this.server);
            Display.getDisplay((MIDlet)this.server.midlet).setCurrent((Displayable)page.display_);
            InterpreterOperation interpreterOperation2 = new InterpreterOperation("skapploader", "loadData", new Object[]{string, "get", null, null, null});
            interpreterOperation2.onComplete = new InterpreterOperation("navigator", "next", new Object[]{string, null, "b"});
            interpreterOperation2.onError = new InterpreterOperation("navigator", "back", null);
            if (page.gauge_ != null) {
                interpreterOperation2.gauge = page.gauge_;
                interpreterOperation2.gaugeMaxInc = interpreterOperation2.gauge.maxValue / 3;
                interpreterOperation2.onComplete.gauge = page.gauge_;
            }
            this.server.dispatch(interpreterOperation2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public final void storeSyncData(InterpreterOperation interpreterOperation) throws IOException {
        int n;
        InputStream inputStream = (InputStream)interpreterOperation.parameters[1];
        int n2 = (Integer)interpreterOperation.parameters[2];
        if (n2 == 0) {
            return;
        }
        int n3 = 0;
        syncList = null;
        inputStream.skip(9L);
        Vector<String> vector = new Vector<String>();
        Vector<Character> vector2 = new Vector<Character>();
        Vector<String> vector3 = new Vector<String>();
        while (true) {
            inputStream.skip(8L);
            n = inputStream.read();
            if (n == 10) break;
            byte[] byArray = UpdateManager.readFromStream(inputStream, 8);
            inputStream.skip(1L);
            char c = (char)inputStream.read();
            inputStream.skip(1L);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while (true) {
                int n4;
                if ((n4 = inputStream.read()) == 10) break;
                byteArrayOutputStream.write(n4);
            }
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            vector.addElement(new String(byArray));
            vector2.addElement(new Character(c));
            try {
                vector3.addElement(new String(byArray2, "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                vector3.addElement(new String(byArray2));
            }
        }
        n = 0;
        for (int i = 0; i < vector2.size(); ++i) {
            String string = (String)vector3.elementAt(i);
            string = UpdateManager.convertFromSync(string);
            int n5 = 0;
            this.updateFail = true;
            if ('a' == ((Character)vector2.elementAt(i)).charValue()) {
                n5 = Integer.parseInt((String)vector.elementAt(i));
                byte[] byArray = UpdateManager.readFromStream(inputStream, n5);
                if (!string.startsWith(AGENT_DIR_ROOT)) {
                    ContentServer.resource_mgr.writeValue(string, byArray);
                    if (n == 0) {
                        ContentServer.resource_mgr.writeValue("update", new byte[]{121});
                        n = 1;
                    }
                }
            } else {
                ContentServer.resource_mgr.deleteValue(string);
                if (n == 0) {
                    ContentServer.resource_mgr.writeValue("update", new byte[]{121});
                    n = 1;
                }
            }
            if ((n3 += n5) > 3 * n2 / 100) {
                UpdateManager.adjustGauge(n2, n3, interpreterOperation.gauge);
            }
            Thread.yield();
            if (!this.cancelUpdate) continue;
            ContentServer.resource_mgr.writeValue("update", new byte[]{121});
            this.updateOnComplete = null;
            return;
        }
        this.updateFail = false;
    }

    private static final byte[] readFromStream(InputStream inputStream, int n) throws IOException {
        int n2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);
        for (int i = 0; i < n && (n2 = inputStream.read()) != -1; ++i) {
            byteArrayOutputStream.write(n2);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private static final void adjustGauge(int n, int n2, SKGauge sKGauge) {
        if (sKGauge != null && n > 100) {
            sKGauge.setValue(n2 * sKGauge.maxValue / n);
        }
    }

    private static final String convertToSync(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.setCharAt(2, ':');
        stringBuffer.setCharAt(0, Character.toUpperCase(stringBuffer.charAt(0)));
        stringBuffer.setCharAt(1, Character.toUpperCase(stringBuffer.charAt(1)));
        return stringBuffer.toString();
    }

    private static final String convertFromSync(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.setCharAt(2, '/');
        return stringBuffer.toString();
    }

    private static final InterpreterOperation getCheckSumOperation(InterpreterOperation interpreterOperation) {
        byte[] byArray = UpdateManager.getSyncList();
        int n = ResourceMgr.hash(byArray);
        return UpdateManager.getOperation(interpreterOperation, SYNC_URL + "?activity=checkforupdate&s=" + UpdateManager.pad(Integer.toHexString(n)), null, CHECK_EVENT);
    }

    private static final InterpreterOperation getSyncOperation(InterpreterOperation interpreterOperation) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(UpdateManager.getSyncList());
            byteArrayOutputStream.write(UpdateManager.pad(Integer.toHexString(ResourceMgr.hash(UpdateManager.getSyncList()))).getBytes());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        byte[] byArray = UpdateManager.getMultiPartSyncEnvelope(byteArrayOutputStream.toByteArray(), "deployedFiles");
        return UpdateManager.getOperation(interpreterOperation, SYNC_URL + "?activity=getupdate", byArray, UPDATE_EVENT);
    }

    private static final InterpreterOperation getOperation(InterpreterOperation interpreterOperation, String string, byte[] byArray, int n) {
        String string2 = "get";
        if (byArray != null) {
            string2 = "post";
        }
        string = UpdateManager.addHeaderFields(string);
        InterpreterOperation interpreterOperation2 = new InterpreterOperation("skapploader", "loadData", new Object[]{string, string2, byArray, BOUNDARY, new Integer(n)});
        interpreterOperation2.onComplete = new InterpreterOperation("contentServer", "doUpdate", null);
        interpreterOperation2.onError = interpreterOperation.onError;
        if (interpreterOperation.gauge != null) {
            interpreterOperation2.gauge = interpreterOperation.gauge;
            interpreterOperation2.gaugeMaxInc = interpreterOperation2.gauge.maxValue - interpreterOperation2.gauge.maxValue / 5;
            interpreterOperation2.onComplete.gauge = interpreterOperation.gauge;
        }
        return interpreterOperation2;
    }

    private static final String addHeaderFields(String string) {
        string = string + "&ctype=application%2Foctet%2Dstream";
        string = string + "&application=smartsync&t=xor&c=none&ua=" + Main.instance.USER_AGENT;
        if (Main.instance.IMEI != null) {
            string = string + "&imei=" + Main.instance.IMEI;
        }
        if (Main.instance.SURF_SYNC_SEGMENT != null) {
            string = string + "&seg=" + Main.instance.SURF_SYNC_SEGMENT;
        }
        if (ssuid != null) {
            string = string + "&ssuid=" + ssuid;
        }
        return string;
    }

    private static final String getSSUID() {
        String string = null;
        try {
            string = new String(ContentServer.resource_mgr.readValue(SSUID_STORE));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    private static final byte[] getSyncList() {
        if (syncList != null) {
            return syncList;
        }
        Vector vector = ResourceDescriptor.getRecords();
        Vector<Integer> vector2 = new Vector<Integer>();
        Vector<String> vector3 = new Vector<String>();
        for (int i = 0; i < vector.size(); ++i) {
            ResourceDescriptor resourceDescriptor = (ResourceDescriptor)vector.elementAt(i);
            String string = resourceDescriptor.filename;
            System.err.println("Adding " + string);
            if (!string.startsWith(SYNC_DIR_ROOT) && !string.startsWith(CHANNEL_DIR_ROOT)) continue;
            vector2.addElement(new Integer(resourceDescriptor.hash));
            string = UpdateManager.convertToSync(string);
            vector3.addElement(string);
        }
        int[] nArray = new int[vector2.size()];
        for (int i = 0; i < vector2.size(); ++i) {
            nArray[i] = (Integer)vector2.elementAt(i);
        }
        UpdateManager.sort(nArray, vector3, 0, nArray.length - 1);
        UpdateManager.sortHex(nArray, vector3);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write("xor ".getBytes());
            byteArrayOutputStream.write("none\n".getBytes());
            for (int i = 0; i < vector3.size(); ++i) {
                byteArrayOutputStream.write(UpdateManager.pad(Integer.toHexString(nArray[i])).getBytes());
                try {
                    byteArrayOutputStream.write((" " + vector3.elementAt(i) + "\n").getBytes("UTF-8"));
                    continue;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    byteArrayOutputStream.write((" " + vector3.elementAt(i) + "\n").getBytes());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        syncList = byteArrayOutputStream.toByteArray();
        return syncList;
    }

    private static final void sort(int[] nArray, Vector vector, int n, int n2) {
        if (n < n2) {
            int n3 = n;
            int n4 = n2;
            int n5 = nArray[(n + n2) / 2];
            if (n2 - n == 1 && nArray[n2] == nArray[n]) {
                if (((String)vector.elementAt(n)).compareTo((String)vector.elementAt(n2)) > 0) {
                    UpdateManager.swap(nArray, vector, n, n2);
                }
                return;
            }
            while (n3 <= n4) {
                while (nArray[n3] < n5) {
                    ++n3;
                }
                while (nArray[n4] > n5) {
                    --n4;
                }
                if (n3 > n4) continue;
                UpdateManager.swap(nArray, vector, n3, n4);
                ++n3;
                --n4;
            }
            UpdateManager.sort(nArray, vector, n, n4);
            UpdateManager.sort(nArray, vector, n3, n2);
        }
    }

    private static final void swap(int[] nArray, Vector vector, int n, int n2) {
        int n3 = nArray[n];
        Object e = vector.elementAt(n);
        nArray[n] = nArray[n2];
        vector.setElementAt(vector.elementAt(n2), n);
        nArray[n2] = n3;
        vector.setElementAt(e, n2);
    }

    private static final void sortHex(int[] nArray, Vector vector) {
        int n;
        int n2 = 0;
        int[] nArray2 = new int[nArray.length];
        Vector vector2 = new Vector();
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n] < 0) {
                n2 = n + 1;
            }
            nArray2[n] = nArray[n];
            vector2.addElement(vector.elementAt(n));
        }
        if (n2 > 0) {
            for (n = nArray.length - n2; n < nArray.length; ++n) {
                nArray[n] = nArray2[n - nArray.length + n2];
                vector.setElementAt(vector2.elementAt(n - nArray.length + n2), n);
            }
            for (n = 0; n < nArray.length - n2; ++n) {
                nArray[n] = nArray2[n + n2];
                vector.setElementAt(vector2.elementAt(n + n2), n);
            }
        }
    }

    private static final String pad(String string) {
        int n = string.length();
        for (int i = 0; i < 8 - n; ++i) {
            string = "0" + string;
        }
        return string;
    }

    private static final StringBuffer getMultiPartHeader(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("-------*******************\r\n");
        stringBuffer.append("Content-Disposition: form-data; name=\"" + string + "\"; value=\"manifest\"\r\n");
        stringBuffer.append("Content-Type: application/octet-stream\r\n\r\n");
        return stringBuffer;
    }

    private static final byte[] getMultiPartSyncEnvelope(byte[] byArray, String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(UpdateManager.getMultiPartHeader(string).toString().getBytes());
            byteArrayOutputStream.write(byArray);
            byteArrayOutputStream.write("\r\n\r\n-------*******************--".getBytes());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byteArrayOutputStream.toByteArray();
    }

    public final void addCmdToList(String string, int n) {
        this.files.addElement(string);
        this.cmds.addElement(new Integer(n));
    }

    public void sendToServer() {
        String string = UpdateManager.addHeaderFields(SYNC_URL + "?activity=uploadfiles");
        InterpreterOperation interpreterOperation = new InterpreterOperation("skapploader", "loadData", new Object[]{string, "stream", null, BOUNDARY, null});
        interpreterOperation.onComplete = new InterpreterOperation("contentServer", "doUpdate", null);
        ContentServer.flags = (byte)(ContentServer.flags | 1);
        this.server.dispatch(interpreterOperation);
    }

    private static final byte[] convertUTF(String string) {
        try {
            return string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string.getBytes();
        }
    }

    public final void getCmdList(OutputStream outputStream) {
        int n = 0;
        boolean bl = false;
        byte[] byArray = null;
        try {
            String string;
            int n2;
            int n3;
            outputStream.write(UpdateManager.getMultiPartHeader("payload").toString().getBytes());
            outputStream.write("xor ".getBytes());
            outputStream.write("none\n".getBytes());
            for (n3 = 0; n3 < this.files.size(); ++n3) {
                n2 = (Integer)this.cmds.elementAt(n3);
                string = (String)this.files.elementAt(n3);
                String string2 = UpdateManager.convertToSync(ResourceMgr.getContentFromUrl(string));
                if (n2 == 0 || n2 == 2) {
                    byArray = ContentServer.resource_mgr.getData(string);
                    n += byArray.length;
                    outputStream.write(UpdateManager.pad(Integer.toHexString(ResourceMgr.hash(byArray))).getBytes());
                    outputStream.write((" " + UpdateManager.pad(Integer.toString(byArray.length))).getBytes());
                    if (n2 == 0) {
                        outputStream.write(UpdateManager.convertUTF(" a S:" + string2 + "\n"));
                        continue;
                    }
                    outputStream.write(UpdateManager.convertUTF(" a H:" + string2 + "\n"));
                    continue;
                }
                outputStream.write("00000000".getBytes());
                outputStream.write(" 0".getBytes());
                if (n2 == 3) {
                    outputStream.write(UpdateManager.convertUTF(" d H:" + string2 + "\n"));
                    continue;
                }
                if (n2 != 4) continue;
                outputStream.write(UpdateManager.convertUTF(" g H:" + string2 + "\n"));
            }
            outputStream.write((UpdateManager.pad("10") + "\n").getBytes());
            for (n3 = 0; n3 < this.files.size(); ++n3) {
                n2 = (Integer)this.cmds.elementAt(n3);
                string = (String)this.files.elementAt(n3);
                if (n2 != 0 && n2 != 2) continue;
                byArray = ContentServer.resource_mgr.getData(string);
                outputStream.write(byArray);
            }
            outputStream.write("\r\n\r\n-------*******************--".getBytes());
            this.files.removeAllElements();
            this.cmds.removeAllElements();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

